#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2020 BetaRays
# SPDX-FileCopyrightText: © 2024 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Q.U.B.E.
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250520.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='qube-1'
GAME_NAME='Q.U.B.E.'

ARCHIVE_BASE_0_NAME='QUBE-Linux-2015052901.sh'
ARCHIVE_BASE_0_MD5='5da6f592bad4aa71c6e2a469f7435453'
ARCHIVE_BASE_0_VERSION='2.8-humble2015052901'
ARCHIVE_BASE_0_SIZE='1269181'
ARCHIVE_BASE_0_URL='https://www.humblebundle.com/store/qube-directors-cut'

CONTENT_PATH_DEFAULT='data'
CONTENT_LIBS_BIN_RELATIVE_PATH='x86/Binaries/Linux/lib'
CONTENT_LIBS_BIN_FILES='
libPhysXCooking.so
libPhysXCore.so
libPhysXExtensions.so.1
libPhysXLoader.so.1
libtcmalloc.so.0'
## The game ships a patched SDL2_Mixer that has an additional symbol: MinorityMix_SetPosition,
## the SDL2_Mixer source code has no reference to it (only Mix_SetPosition)
## and online searching only shows similar problems with other Unreal Engine games.
CONTENT_LIBS0_BIN_RELATIVE_PATH='x86/Binaries/Linux/lib'
CONTENT_LIBS0_BIN_FILES='
libSDL2_mixer-2.0.so.0'
## The game binary is linked against libsteam_api.so, so this library can not be dropped.
CONTENT_LIBS1_BIN_RELATIVE_PATH='x86/Binaries/Linux/lib'
CONTENT_LIBS1_BIN_FILES='
libsteam_api.so'
CONTENT_GAME_BIN_RELATIVE_PATH='noarch'
CONTENT_GAME_BIN_FILES='
Engine'
CONTENT_GAME0_BIN_RELATIVE_PATH='x86'
CONTENT_GAME0_BIN_FILES='
Binaries/Linux/QUBEGame-Linux'
CONTENT_GAME_DATA_RELATIVE_PATH='noarch'
CONTENT_GAME_DATA_FILES='
QUBEGame
QUBEIcon.*'
CONTENT_DOC_DATA_RELATIVE_PATH='noarch'
CONTENT_DOC_DATA_FILES='
README.linux
BuildVersion.txt
UpdateLog.txt'

USER_PERSISTENT_FILES='
Binaries/Linux/SaveGame.bin'

APP_MAIN_EXE='Binaries/Linux/QUBEGame-Linux'
APP_MAIN_ICON='noarch/QUBEIcon.png'
## Trying to run the game with the wayland backend of SDL leads to a segmentation fault:
## #0  Scaleform::Render::RHI::HAL::CreateRenderTargetFromViewport (this=0xfb8a7e0, InRT=0xa94be44, useSceneDepth=true) at /samba/ue3builds/MINIFRIDGE/projects/UE3_QUBE/Development/Src/../../Development/Src/GFxUI/Src/Render/RHI_HALSetup.cpp:416
## #1  0x08e1e22f in FGFxSetHudRenderTarget::Execute (this=0x9d92fc0) at /samba/ue3builds/MINIFRIDGE/projects/UE3_QUBE/Development/Src/../../Development/Src/GFxUI/Src/ScaleformEngine.cpp:1298
## #2  0x0840d144 in RenderingThreadMain () at /samba/ue3builds/MINIFRIDGE/projects/UE3_QUBE/Development/Src/../../Development/Src/Engine/Src/RenderingThread.cpp:218
## #3  0x08429bf8 in FRenderingThread::Run (this=0xfa293e0) at /samba/ue3builds/MINIFRIDGE/projects/UE3_QUBE/Development/Src/../../Development/Src/Engine/Src/RenderingThread.cpp:352
## #4  0x08eba1bb in FRunnableThreadLinux::Run (this=this@entry=0xdaa3bd0) at /samba/ue3builds/MINIFRIDGE/projects/UE3_QUBE/Development/Src/../../Development/Src/Linux/Src/LinuxThreading.cpp:831
## #5  0x08eba1ff in FRunnableThreadLinux::_ThreadProc (pThis=0xdaa3bd0) at /samba/ue3builds/MINIFRIDGE/projects/UE3_QUBE/Development/Src/../../Development/Src/Linux/Src/LinuxThreading.cpp:803
## #6  0xf748e781 in start_thread (arg=<optimized out>) at ./nptl/pthread_create.c:448
## #7  0xf7524df8 in __GI___clone3 () at ../sysdeps/unix/sysv/linux/i386/clone3.S:111
APP_MAIN_PRERUN='
# Trying to run the game with the wayland backend of SDL leads to a segmentation fault.
if [ "${SDL_VIDEODRIVER:-}" = "wayland" ]; then
	unset SDL_VIDEODRIVER
fi
'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libdl.so.2
libgcc_s.so.1
libGL.so.1
libm.so.6
libogg.so.0
libopenal.so.1
libpthread.so.0
librt.so.1
libSDL2-2.0.so.0
libstdc++.so.6
libvorbisfile.so.3
libvorbis.so.0'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

## Run the game binary from its parent directory
game_exec_line() {
	cat <<- 'EOF'
	cd Binaries/Linux
	./QUBEGame-Linux "$@"
	EOF
}

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
