# --------------------------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
#
# Code generated by aaz-dev-tools
# --------------------------------------------------------------------------------------------

# pylint: skip-file
# flake8: noqa

from azure.cli.core.aaz import *


class Create(AAZCommand):
    """Create a gallery image version.
    """

    _aaz_info = {
        "version": "2019-12-01",
        "resources": [
            ["mgmt-plane", "/subscriptions/{}/resourcegroups/{}/providers/microsoft.compute/galleries/{}/images/{}/versions/{}", "2019-12-01"],
        ]
    }

    AZ_SUPPORT_NO_WAIT = True

    def _handler(self, command_args):
        super()._handler(command_args)
        return self.build_lro_poller(self._execute_operations, self._output)

    _args_schema = None

    @classmethod
    def _build_arguments_schema(cls, *args, **kwargs):
        if cls._args_schema is not None:
            return cls._args_schema
        cls._args_schema = super()._build_arguments_schema(*args, **kwargs)

        # define Arg Group ""

        _args_schema = cls._args_schema
        _args_schema.gallery_image_definition = AAZStrArg(
            options=["-i", "--gallery-image-definition"],
            help="The name of the gallery image definition in which the Image Version resides.",
            required=True,
        )
        _args_schema.gallery_image_version_name = AAZStrArg(
            options=["-e", "--gallery-image-version", "--gallery-image-version-name"],
            help="The name of the gallery image version to be deleted.",
            required=True,
        )
        _args_schema.gallery_name = AAZStrArg(
            options=["-r", "--gallery-name"],
            help="The name of the Shared Image Gallery in which the Image Definition resides.",
            required=True,
        )
        _args_schema.resource_group = AAZResourceGroupNameArg(
            required=True,
        )

        # define Arg Group "GalleryImageVersion"

        _args_schema = cls._args_schema
        _args_schema.location = AAZResourceLocationArg(
            arg_group="GalleryImageVersion",
            help="Resource location",
            required=True,
            fmt=AAZResourceLocationArgFormat(
                resource_group_arg="resource_group",
            ),
        )
        _args_schema.tags = AAZDictArg(
            options=["--tags"],
            arg_group="GalleryImageVersion",
            help="Resource tags",
        )

        tags = cls._args_schema.tags
        tags.Element = AAZStrArg()

        # define Arg Group "Properties"

        _args_schema = cls._args_schema
        _args_schema.publishing_profile = AAZObjectArg(
            options=["--publishing-profile"],
            arg_group="Properties",
            help="The publishing profile of a gallery image Version.",
        )
        _args_schema.storage_profile = AAZObjectArg(
            options=["--storage-profile"],
            arg_group="Properties",
            help="This is the storage profile of a Gallery Image Version.",
        )

        publishing_profile = cls._args_schema.publishing_profile
        publishing_profile.end_of_life_date = AAZDateTimeArg(
            options=["end-of-life-date"],
            help="The end of life date of the gallery image version. This property can be used for decommissioning purposes. This property is updatable.",
        )
        publishing_profile.exclude_from_latest = AAZBoolArg(
            options=["exclude-from-latest"],
            help="If set to true, Virtual Machines deployed from the latest version of the Image Definition won't use this Image Version.",
        )
        publishing_profile.replica_count = AAZIntArg(
            options=["replica-count"],
            help="The number of replicas of the Image Version to be created per region. This property would take effect for a region when regionalReplicaCount is not specified. This property is updatable.",
        )
        publishing_profile.storage_account_type = AAZStrArg(
            options=["storage-account-type"],
            help="Specifies the storage account type to be used to store the image. This property is not updatable.",
            enum={"Premium_LRS": "Premium_LRS", "Standard_LRS": "Standard_LRS", "Standard_ZRS": "Standard_ZRS"},
        )
        publishing_profile.target_regions = AAZListArg(
            options=["target-regions"],
            help="The target regions where the Image Version is going to be replicated to. This property is updatable.",
        )

        target_regions = cls._args_schema.publishing_profile.target_regions
        target_regions.Element = AAZObjectArg()

        _element = cls._args_schema.publishing_profile.target_regions.Element
        _element.encryption = AAZObjectArg(
            options=["encryption"],
            help="Optional. Allows users to provide customer managed keys for encrypting the OS and data disks in the gallery artifact.",
        )
        _element.name = AAZStrArg(
            options=["name"],
            help="The name of the region.",
            required=True,
        )
        _element.regional_replica_count = AAZIntArg(
            options=["regional-replica-count"],
            help="The number of replicas of the Image Version to be created per region. This property is updatable.",
        )
        _element.storage_account_type = AAZStrArg(
            options=["storage-account-type"],
            help="Specifies the storage account type to be used to store the image. This property is not updatable.",
            enum={"Premium_LRS": "Premium_LRS", "Standard_LRS": "Standard_LRS", "Standard_ZRS": "Standard_ZRS"},
        )

        encryption = cls._args_schema.publishing_profile.target_regions.Element.encryption
        encryption.data_disk_images = AAZListArg(
            options=["data-disk-images"],
            help="A list of encryption specifications for data disk images.",
        )
        encryption.os_disk_image = AAZObjectArg(
            options=["os-disk-image"],
            help="Contains encryption settings for an OS disk image.",
        )

        data_disk_images = cls._args_schema.publishing_profile.target_regions.Element.encryption.data_disk_images
        data_disk_images.Element = AAZObjectArg()

        _element = cls._args_schema.publishing_profile.target_regions.Element.encryption.data_disk_images.Element
        _element.disk_encryption_set_id = AAZStrArg(
            options=["disk-encryption-set-id"],
            help="A relative URI containing the resource ID of the disk encryption set.",
        )
        _element.lun = AAZIntArg(
            options=["lun"],
            help="This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.",
            required=True,
        )

        os_disk_image = cls._args_schema.publishing_profile.target_regions.Element.encryption.os_disk_image
        os_disk_image.disk_encryption_set_id = AAZStrArg(
            options=["disk-encryption-set-id"],
            help="A relative URI containing the resource ID of the disk encryption set.",
        )

        storage_profile = cls._args_schema.storage_profile
        storage_profile.data_disk_images = AAZListArg(
            options=["data-disk-images"],
            help="A list of data disk images.",
        )
        storage_profile.os_disk_image = AAZObjectArg(
            options=["os-disk-image"],
            help="This is the OS disk image.",
        )
        storage_profile.source = AAZObjectArg(
            options=["source"],
            help="The source of the gallery artifact version.",
        )

        data_disk_images = cls._args_schema.storage_profile.data_disk_images
        data_disk_images.Element = AAZObjectArg()

        _element = cls._args_schema.storage_profile.data_disk_images.Element
        _element.host_caching = AAZStrArg(
            options=["host-caching"],
            help="The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'",
            enum={"None": "None", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        _element.lun = AAZIntArg(
            options=["lun"],
            help="This property specifies the logical unit number of the data disk. This value is used to identify data disks within the Virtual Machine and therefore must be unique for each data disk attached to the Virtual Machine.",
            required=True,
        )
        _element.source = AAZObjectArg(
            options=["source"],
        )
        cls._build_args_gallery_artifact_version_source_create(_element.source)

        os_disk_image = cls._args_schema.storage_profile.os_disk_image
        os_disk_image.host_caching = AAZStrArg(
            options=["host-caching"],
            help="The host caching of the disk. Valid values are 'None', 'ReadOnly', and 'ReadWrite'",
            enum={"None": "None", "ReadOnly": "ReadOnly", "ReadWrite": "ReadWrite"},
        )
        os_disk_image.source = AAZObjectArg(
            options=["source"],
            help="The source for the disk image.",
        )
        cls._build_args_gallery_artifact_version_source_create(os_disk_image.source)

        source = cls._args_schema.storage_profile.source
        source.id = AAZStrArg(
            options=["id"],
            help="The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, user image or storage account resource.",
        )
        return cls._args_schema

    _args_gallery_artifact_version_source_create = None

    @classmethod
    def _build_args_gallery_artifact_version_source_create(cls, _schema):
        if cls._args_gallery_artifact_version_source_create is not None:
            _schema.id = cls._args_gallery_artifact_version_source_create.id
            return

        cls._args_gallery_artifact_version_source_create = AAZObjectArg()

        gallery_artifact_version_source_create = cls._args_gallery_artifact_version_source_create
        gallery_artifact_version_source_create.id = AAZStrArg(
            options=["id"],
            help="The id of the gallery artifact version source. Can specify a disk uri, snapshot uri, or user image.",
        )

        _schema.id = cls._args_gallery_artifact_version_source_create.id

    def _execute_operations(self):
        self.pre_operations()
        yield self.GalleryImageVersionsCreateOrUpdate(ctx=self.ctx)()
        self.post_operations()

    @register_callback
    def pre_operations(self):
        pass

    @register_callback
    def post_operations(self):
        pass

    def _output(self, *args, **kwargs):
        result = self.deserialize_output(self.ctx.vars.instance, client_flatten=True)
        return result

    class GalleryImageVersionsCreateOrUpdate(AAZHttpOperation):
        CLIENT_TYPE = "MgmtClient"

        def __call__(self, *args, **kwargs):
            request = self.make_request()
            session = self.client.send_request(request=request, stream=False, **kwargs)
            if session.http_response.status_code in [202]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )
            if session.http_response.status_code in [200, 201]:
                return self.client.build_lro_polling(
                    self.ctx.args.no_wait,
                    session,
                    self.on_200_201,
                    self.on_error,
                    lro_options={"final-state-via": "azure-async-operation"},
                    path_format_arguments=self.url_parameters,
                )

            return self.on_error(session.http_response)

        @property
        def url(self):
            return self.client.format_url(
                "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Compute/galleries/{galleryName}/images/{galleryImageName}/versions/{galleryImageVersionName}",
                **self.url_parameters
            )

        @property
        def method(self):
            return "PUT"

        @property
        def error_format(self):
            return "ODataV4Format"

        @property
        def url_parameters(self):
            parameters = {
                **self.serialize_url_param(
                    "galleryImageName", self.ctx.args.gallery_image_definition,
                    required=True,
                ),
                **self.serialize_url_param(
                    "galleryImageVersionName", self.ctx.args.gallery_image_version_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "galleryName", self.ctx.args.gallery_name,
                    required=True,
                ),
                **self.serialize_url_param(
                    "resourceGroupName", self.ctx.args.resource_group,
                    required=True,
                ),
                **self.serialize_url_param(
                    "subscriptionId", self.ctx.subscription_id,
                    required=True,
                ),
            }
            return parameters

        @property
        def query_parameters(self):
            parameters = {
                **self.serialize_query_param(
                    "api-version", "2019-12-01",
                    required=True,
                ),
            }
            return parameters

        @property
        def header_parameters(self):
            parameters = {
                **self.serialize_header_param(
                    "Content-Type", "application/json",
                ),
                **self.serialize_header_param(
                    "Accept", "application/json",
                ),
            }
            return parameters

        @property
        def content(self):
            _content_value, _builder = self.new_content_builder(
                self.ctx.args,
                typ=AAZObjectType,
                typ_kwargs={"flags": {"required": True, "client_flatten": True}}
            )
            _builder.set_prop("location", AAZStrType, ".location", typ_kwargs={"flags": {"required": True}})
            _builder.set_prop("properties", AAZObjectType, typ_kwargs={"flags": {"client_flatten": True}})
            _builder.set_prop("tags", AAZDictType, ".tags")

            properties = _builder.get(".properties")
            if properties is not None:
                properties.set_prop("publishingProfile", AAZObjectType, ".publishing_profile")
                properties.set_prop("storageProfile", AAZObjectType, ".storage_profile", typ_kwargs={"flags": {"required": True}})

            publishing_profile = _builder.get(".properties.publishingProfile")
            if publishing_profile is not None:
                publishing_profile.set_prop("endOfLifeDate", AAZStrType, ".end_of_life_date")
                publishing_profile.set_prop("excludeFromLatest", AAZBoolType, ".exclude_from_latest")
                publishing_profile.set_prop("replicaCount", AAZIntType, ".replica_count")
                publishing_profile.set_prop("storageAccountType", AAZStrType, ".storage_account_type")
                publishing_profile.set_prop("targetRegions", AAZListType, ".target_regions")

            target_regions = _builder.get(".properties.publishingProfile.targetRegions")
            if target_regions is not None:
                target_regions.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.publishingProfile.targetRegions[]")
            if _elements is not None:
                _elements.set_prop("encryption", AAZObjectType, ".encryption")
                _elements.set_prop("name", AAZStrType, ".name", typ_kwargs={"flags": {"required": True}})
                _elements.set_prop("regionalReplicaCount", AAZIntType, ".regional_replica_count")
                _elements.set_prop("storageAccountType", AAZStrType, ".storage_account_type")

            encryption = _builder.get(".properties.publishingProfile.targetRegions[].encryption")
            if encryption is not None:
                encryption.set_prop("dataDiskImages", AAZListType, ".data_disk_images")
                encryption.set_prop("osDiskImage", AAZObjectType, ".os_disk_image")

            data_disk_images = _builder.get(".properties.publishingProfile.targetRegions[].encryption.dataDiskImages")
            if data_disk_images is not None:
                data_disk_images.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.publishingProfile.targetRegions[].encryption.dataDiskImages[]")
            if _elements is not None:
                _elements.set_prop("diskEncryptionSetId", AAZStrType, ".disk_encryption_set_id")
                _elements.set_prop("lun", AAZIntType, ".lun", typ_kwargs={"flags": {"required": True}})

            os_disk_image = _builder.get(".properties.publishingProfile.targetRegions[].encryption.osDiskImage")
            if os_disk_image is not None:
                os_disk_image.set_prop("diskEncryptionSetId", AAZStrType, ".disk_encryption_set_id")

            storage_profile = _builder.get(".properties.storageProfile")
            if storage_profile is not None:
                storage_profile.set_prop("dataDiskImages", AAZListType, ".data_disk_images")
                storage_profile.set_prop("osDiskImage", AAZObjectType, ".os_disk_image")
                storage_profile.set_prop("source", AAZObjectType, ".source")

            data_disk_images = _builder.get(".properties.storageProfile.dataDiskImages")
            if data_disk_images is not None:
                data_disk_images.set_elements(AAZObjectType, ".")

            _elements = _builder.get(".properties.storageProfile.dataDiskImages[]")
            if _elements is not None:
                _elements.set_prop("hostCaching", AAZStrType, ".host_caching")
                _elements.set_prop("lun", AAZIntType, ".lun", typ_kwargs={"flags": {"required": True}})
                _CreateHelper._build_schema_gallery_artifact_version_source_create(_elements.set_prop("source", AAZObjectType, ".source"))

            os_disk_image = _builder.get(".properties.storageProfile.osDiskImage")
            if os_disk_image is not None:
                os_disk_image.set_prop("hostCaching", AAZStrType, ".host_caching")
                _CreateHelper._build_schema_gallery_artifact_version_source_create(os_disk_image.set_prop("source", AAZObjectType, ".source"))

            source = _builder.get(".properties.storageProfile.source")
            if source is not None:
                source.set_prop("id", AAZStrType, ".id")

            tags = _builder.get(".tags")
            if tags is not None:
                tags.set_elements(AAZStrType, ".")

            return self.serialize_content(_content_value)

        def on_200_201(self, session):
            data = self.deserialize_http_content(session)
            self.ctx.set_var(
                "instance",
                data,
                schema_builder=self._build_schema_on_200_201
            )

        _schema_on_200_201 = None

        @classmethod
        def _build_schema_on_200_201(cls):
            if cls._schema_on_200_201 is not None:
                return cls._schema_on_200_201

            cls._schema_on_200_201 = AAZObjectType()
            _CreateHelper._build_schema_gallery_image_version_read(cls._schema_on_200_201)

            return cls._schema_on_200_201


class _CreateHelper:
    """Helper class for Create"""

    @classmethod
    def _build_schema_gallery_artifact_version_source_create(cls, _builder):
        if _builder is None:
            return
        _builder.set_prop("id", AAZStrType, ".id")

    _schema_gallery_artifact_version_source_read = None

    @classmethod
    def _build_schema_gallery_artifact_version_source_read(cls, _schema):
        if cls._schema_gallery_artifact_version_source_read is not None:
            _schema.id = cls._schema_gallery_artifact_version_source_read.id
            return

        cls._schema_gallery_artifact_version_source_read = _schema_gallery_artifact_version_source_read = AAZObjectType()

        gallery_artifact_version_source_read = _schema_gallery_artifact_version_source_read
        gallery_artifact_version_source_read.id = AAZStrType()

        _schema.id = cls._schema_gallery_artifact_version_source_read.id

    _schema_gallery_image_version_read = None

    @classmethod
    def _build_schema_gallery_image_version_read(cls, _schema):
        if cls._schema_gallery_image_version_read is not None:
            _schema.id = cls._schema_gallery_image_version_read.id
            _schema.location = cls._schema_gallery_image_version_read.location
            _schema.name = cls._schema_gallery_image_version_read.name
            _schema.properties = cls._schema_gallery_image_version_read.properties
            _schema.tags = cls._schema_gallery_image_version_read.tags
            _schema.type = cls._schema_gallery_image_version_read.type
            return

        cls._schema_gallery_image_version_read = _schema_gallery_image_version_read = AAZObjectType()

        gallery_image_version_read = _schema_gallery_image_version_read
        gallery_image_version_read.id = AAZStrType(
            flags={"read_only": True},
        )
        gallery_image_version_read.location = AAZStrType(
            flags={"required": True},
        )
        gallery_image_version_read.name = AAZStrType(
            flags={"read_only": True},
        )
        gallery_image_version_read.properties = AAZObjectType(
            flags={"client_flatten": True},
        )
        gallery_image_version_read.tags = AAZDictType()
        gallery_image_version_read.type = AAZStrType(
            flags={"read_only": True},
        )

        properties = _schema_gallery_image_version_read.properties
        properties.provisioning_state = AAZStrType(
            serialized_name="provisioningState",
            flags={"read_only": True},
        )
        properties.publishing_profile = AAZObjectType(
            serialized_name="publishingProfile",
        )
        properties.replication_status = AAZObjectType(
            serialized_name="replicationStatus",
            flags={"read_only": True},
        )
        properties.storage_profile = AAZObjectType(
            serialized_name="storageProfile",
            flags={"required": True},
        )

        publishing_profile = _schema_gallery_image_version_read.properties.publishing_profile
        publishing_profile.end_of_life_date = AAZStrType(
            serialized_name="endOfLifeDate",
        )
        publishing_profile.exclude_from_latest = AAZBoolType(
            serialized_name="excludeFromLatest",
        )
        publishing_profile.published_date = AAZStrType(
            serialized_name="publishedDate",
            flags={"read_only": True},
        )
        publishing_profile.replica_count = AAZIntType(
            serialized_name="replicaCount",
        )
        publishing_profile.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )
        publishing_profile.target_regions = AAZListType(
            serialized_name="targetRegions",
        )

        target_regions = _schema_gallery_image_version_read.properties.publishing_profile.target_regions
        target_regions.Element = AAZObjectType()

        _element = _schema_gallery_image_version_read.properties.publishing_profile.target_regions.Element
        _element.encryption = AAZObjectType()
        _element.name = AAZStrType(
            flags={"required": True},
        )
        _element.regional_replica_count = AAZIntType(
            serialized_name="regionalReplicaCount",
        )
        _element.storage_account_type = AAZStrType(
            serialized_name="storageAccountType",
        )

        encryption = _schema_gallery_image_version_read.properties.publishing_profile.target_regions.Element.encryption
        encryption.data_disk_images = AAZListType(
            serialized_name="dataDiskImages",
        )
        encryption.os_disk_image = AAZObjectType(
            serialized_name="osDiskImage",
        )

        data_disk_images = _schema_gallery_image_version_read.properties.publishing_profile.target_regions.Element.encryption.data_disk_images
        data_disk_images.Element = AAZObjectType()

        _element = _schema_gallery_image_version_read.properties.publishing_profile.target_regions.Element.encryption.data_disk_images.Element
        _element.disk_encryption_set_id = AAZStrType(
            serialized_name="diskEncryptionSetId",
        )
        _element.lun = AAZIntType(
            flags={"required": True},
        )

        os_disk_image = _schema_gallery_image_version_read.properties.publishing_profile.target_regions.Element.encryption.os_disk_image
        os_disk_image.disk_encryption_set_id = AAZStrType(
            serialized_name="diskEncryptionSetId",
        )

        replication_status = _schema_gallery_image_version_read.properties.replication_status
        replication_status.aggregated_state = AAZStrType(
            serialized_name="aggregatedState",
            flags={"read_only": True},
        )
        replication_status.summary = AAZListType(
            flags={"read_only": True},
        )

        summary = _schema_gallery_image_version_read.properties.replication_status.summary
        summary.Element = AAZObjectType()

        _element = _schema_gallery_image_version_read.properties.replication_status.summary.Element
        _element.details = AAZStrType(
            flags={"read_only": True},
        )
        _element.progress = AAZIntType(
            flags={"read_only": True},
        )
        _element.region = AAZStrType(
            flags={"read_only": True},
        )
        _element.state = AAZStrType(
            flags={"read_only": True},
        )

        storage_profile = _schema_gallery_image_version_read.properties.storage_profile
        storage_profile.data_disk_images = AAZListType(
            serialized_name="dataDiskImages",
        )
        storage_profile.os_disk_image = AAZObjectType(
            serialized_name="osDiskImage",
        )
        storage_profile.source = AAZObjectType()
        cls._build_schema_gallery_artifact_version_source_read(storage_profile.source)

        data_disk_images = _schema_gallery_image_version_read.properties.storage_profile.data_disk_images
        data_disk_images.Element = AAZObjectType()

        _element = _schema_gallery_image_version_read.properties.storage_profile.data_disk_images.Element
        _element.host_caching = AAZStrType(
            serialized_name="hostCaching",
        )
        _element.lun = AAZIntType(
            flags={"required": True},
        )
        _element.size_in_gb = AAZIntType(
            serialized_name="sizeInGB",
            flags={"read_only": True},
        )
        _element.source = AAZObjectType()
        cls._build_schema_gallery_artifact_version_source_read(_element.source)

        os_disk_image = _schema_gallery_image_version_read.properties.storage_profile.os_disk_image
        os_disk_image.host_caching = AAZStrType(
            serialized_name="hostCaching",
        )
        os_disk_image.size_in_gb = AAZIntType(
            serialized_name="sizeInGB",
            flags={"read_only": True},
        )
        os_disk_image.source = AAZObjectType()
        cls._build_schema_gallery_artifact_version_source_read(os_disk_image.source)

        tags = _schema_gallery_image_version_read.tags
        tags.Element = AAZStrType()

        _schema.id = cls._schema_gallery_image_version_read.id
        _schema.location = cls._schema_gallery_image_version_read.location
        _schema.name = cls._schema_gallery_image_version_read.name
        _schema.properties = cls._schema_gallery_image_version_read.properties
        _schema.tags = cls._schema_gallery_image_version_read.tags
        _schema.type = cls._schema_gallery_image_version_read.type


__all__ = ["Create"]
