#!/bin/bash

usage(){
echo "
Written by Brian Bushnell
Last modified February 23, 2025

Description:  Makes vectors for QuickBin network training.

Usage: makequickbinvector.sh in=contigs.fa out=vector.txt cov=cov.txt lines=1m

Parameters:
in=<file>       Assembly input; only required parameter.
cov=<file>      Cov file generated by Quickbin from sam files.
out=<file>      Output file.
lines=1m        Lines to output.
rate=0.5        Fraction of vectors with positive results.

Java Parameters:
-Xmx            This will set Java's memory usage, overriding autodetection.
                -Xmx20g will specify 20 gigs of RAM, and -Xmx200m will
                specify 200 megs. The max is typically 85% of physical memory.
-eoom           This flag will cause the process to exit if an out-of-memory
                exception occurs.  Requires Java 8u92+.
-da             Disable assertions.

Please contact Brian Bushnell at bbushnell@lbl.gov if you encounter any problems.
"
}

#This block allows symlinked shellscripts to correctly set classpath.
pushd . > /dev/null
DIR="${BASH_SOURCE[0]}"
while [ -h "$DIR" ]; do
  cd "$(dirname "$DIR")"
  DIR="$(readlink "$(basename "$DIR")")"
done
cd "$(dirname "$DIR")"
DIR="$(pwd)/"
popd > /dev/null

#DIR="$( cd "$( dirname "${BASH_SOURCE[0]}" )" && pwd )/"
CP="$DIR""current/"

z="-Xmx4g"
z2="-Xms4g"
set=0

if [ -z "$1" ] || [[ $1 == -h ]] || [[ $1 == --help ]]; then
	usage
	exit
fi

calcXmx () {
	source "$DIR""/calcmem.sh"
	setEnvironment
	parseXmx "$@"
	if [[ $set == 1 ]]; then
		return
	fi
	freeRam 4000m 42
	z="-Xmx${RAM}m"
	z2="-Xms${RAM}m"
}
calcXmx "$@"

vector() {
	local CMD="java $EA $EOOM $z -cp $CP bin.AllToAllVectorMaker $@"
	echo $CMD >&2
	eval $CMD
}

vector "$@"
