/*
 *
 *  Copyright (C) 2022, OFFIS e.V.
 *  All rights reserved.  See COPYRIGHT file for details.
 *
 *  This software and supporting documentation were developed by
 *
 *    OFFIS e.V.
 *    R&D Division Health
 *    Escherweg 2
 *    D-26121 Oldenburg, Germany
 *
 *
 *  Module:  oficonv
 *
 *  Author:  Marco Eichelberg
 *
 *  Purpose: GB2312 related tables for oficonv unit tests
 *
 */

#ifndef TABLES_GB2312_H
#define TABLES_GB2312_H

// GB2312 (Chinese) is an EUC (Extended Unix Character set), which means that
// every characters is either a single byte < 128, or a sequence of two bytes
// where both bytes have values >= 0xA0. In this case the first byte defines the
// row and the second byte the entry within that row.

// Most rows in the GB2312 table use all byte positions from A1 to FE for the second byte
static unsigned char gb2312_row_16ff[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc, 0xfd, 0xfe    
};

static unsigned char gb2312_row_02[] = {
        0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2,             0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee,      
        0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9, 0xfa, 0xfb, 0xfc
};

static unsigned char gb2312_row_04[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1, 0xf2, 0xf3
};

static unsigned char gb2312_row_05[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6
};

static unsigned char gb2312_row_06[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8,
        0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8
};

static unsigned char gb2312_row_07[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1,
        0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1
};

static unsigned char gb2312_row_08[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 
                                0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9
};

static unsigned char gb2312_row_09[] = {
                          0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef
};

static unsigned char gb2312_row_55[] = {
        0xa1, 0xa2, 0xa3, 0xa4, 0xa5, 0xa6, 0xa7, 0xa8, 0xa9, 0xaa, 0xab, 0xac, 0xad, 0xae, 0xaf,
  0xb0, 0xb1, 0xb2, 0xb3, 0xb4, 0xb5, 0xb6, 0xb7, 0xb8, 0xb9, 0xba, 0xbb, 0xbc, 0xbd, 0xbe, 0xbf,
  0xc0, 0xc1, 0xc2, 0xc3, 0xc4, 0xc5, 0xc6, 0xc7, 0xc8, 0xc9, 0xca, 0xcb, 0xcc, 0xcd, 0xce, 0xcf,
  0xd0, 0xd1, 0xd2, 0xd3, 0xd4, 0xd5, 0xd6, 0xd7, 0xd8, 0xd9, 0xda, 0xdb, 0xdc, 0xdd, 0xde, 0xdf,
  0xe0, 0xe1, 0xe2, 0xe3, 0xe4, 0xe5, 0xe6, 0xe7, 0xe8, 0xe9, 0xea, 0xeb, 0xec, 0xed, 0xee, 0xef,
  0xf0, 0xf1, 0xf2, 0xf3, 0xf4, 0xf5, 0xf6, 0xf7, 0xf8, 0xf9   
};

unsigned char gb2312_row_01_converted_to_utf8[] = {
  0xe3, 0x80, 0x80, 0xe3, 0x80, 0x81, 0xe3, 0x80, 0x82, 0xe3, 0x83, 0xbb,
  0xcb, 0x89, 0xcb, 0x87, 0xc2, 0xa8, 0xe3, 0x80, 0x83, 0xe3, 0x80, 0x85,
  0xe2, 0x80, 0x95, 0xef, 0xbd, 0x9e, 0xe2, 0x80, 0x96, 0xe2, 0x80, 0xa6,
  0xe2, 0x80, 0x98, 0xe2, 0x80, 0x99, 0xe2, 0x80, 0x9c, 0xe2, 0x80, 0x9d,
  0xe3, 0x80, 0x94, 0xe3, 0x80, 0x95, 0xe3, 0x80, 0x88, 0xe3, 0x80, 0x89,
  0xe3, 0x80, 0x8a, 0xe3, 0x80, 0x8b, 0xe3, 0x80, 0x8c, 0xe3, 0x80, 0x8d,
  0xe3, 0x80, 0x8e, 0xe3, 0x80, 0x8f, 0xe3, 0x80, 0x96, 0xe3, 0x80, 0x97,
  0xe3, 0x80, 0x90, 0xe3, 0x80, 0x91, 0xc2, 0xb1, 0xc3, 0x97, 0xc3, 0xb7,
  0xe2, 0x88, 0xb6, 0xe2, 0x88, 0xa7, 0xe2, 0x88, 0xa8, 0xe2, 0x88, 0x91,
  0xe2, 0x88, 0x8f, 0xe2, 0x88, 0xaa, 0xe2, 0x88, 0xa9, 0xe2, 0x88, 0x88,
  0xe2, 0x88, 0xb7, 0xe2, 0x88, 0x9a, 0xe2, 0x8a, 0xa5, 0xe2, 0x88, 0xa5,
  0xe2, 0x88, 0xa0, 0xe2, 0x8c, 0x92, 0xe2, 0x8a, 0x99, 0xe2, 0x88, 0xab,
  0xe2, 0x88, 0xae, 0xe2, 0x89, 0xa1, 0xe2, 0x89, 0x8c, 0xe2, 0x89, 0x88,
  0xe2, 0x88, 0xbd, 0xe2, 0x88, 0x9d, 0xe2, 0x89, 0xa0, 0xe2, 0x89, 0xae,
  0xe2, 0x89, 0xaf, 0xe2, 0x89, 0xa4, 0xe2, 0x89, 0xa5, 0xe2, 0x88, 0x9e,
  0xe2, 0x88, 0xb5, 0xe2, 0x88, 0xb4, 0xe2, 0x99, 0x82, 0xe2, 0x99, 0x80,
  0xc2, 0xb0, 0xe2, 0x80, 0xb2, 0xe2, 0x80, 0xb3, 0xe2, 0x84, 0x83, 0xef,
  0xbc, 0x84, 0xc2, 0xa4, 0xef, 0xbf, 0xa0, 0xef, 0xbf, 0xa1, 0xe2, 0x80,
  0xb0, 0xc2, 0xa7, 0xe2, 0x84, 0x96, 0xe2, 0x98, 0x86, 0xe2, 0x98, 0x85,
  0xe2, 0x97, 0x8b, 0xe2, 0x97, 0x8f, 0xe2, 0x97, 0x8e, 0xe2, 0x97, 0x87,
  0xe2, 0x97, 0x86, 0xe2, 0x96, 0xa1, 0xe2, 0x96, 0xa0, 0xe2, 0x96, 0xb3,
  0xe2, 0x96, 0xb2, 0xe2, 0x80, 0xbb, 0xe2, 0x86, 0x92, 0xe2, 0x86, 0x90,
  0xe2, 0x86, 0x91, 0xe2, 0x86, 0x93, 0xe3, 0x80, 0x93
};

// when used as part of the GBK encoding, the mapping of character A4 
// (interpunct) is slightly different (but correct)
unsigned char gb2312_row_01_converted_to_utf8_alternate[] = {
  0xe3, 0x80, 0x80, 0xe3, 0x80, 0x81, 0xe3, 0x80, 0x82, 0xc2, 0xb7, 0xcb,
  0x89, 0xcb, 0x87, 0xc2, 0xa8, 0xe3, 0x80, 0x83, 0xe3, 0x80, 0x85, 0xe2,
  0x80, 0x94, 0xef, 0xbd, 0x9e, 0xe2, 0x80, 0x96, 0xe2, 0x80, 0xa6, 0xe2,
  0x80, 0x98, 0xe2, 0x80, 0x99, 0xe2, 0x80, 0x9c, 0xe2, 0x80, 0x9d, 0xe3,
  0x80, 0x94, 0xe3, 0x80, 0x95, 0xe3, 0x80, 0x88, 0xe3, 0x80, 0x89, 0xe3,
  0x80, 0x8a, 0xe3, 0x80, 0x8b, 0xe3, 0x80, 0x8c, 0xe3, 0x80, 0x8d, 0xe3,
  0x80, 0x8e, 0xe3, 0x80, 0x8f, 0xe3, 0x80, 0x96, 0xe3, 0x80, 0x97, 0xe3,
  0x80, 0x90, 0xe3, 0x80, 0x91, 0xc2, 0xb1, 0xc3, 0x97, 0xc3, 0xb7, 0xe2,
  0x88, 0xb6, 0xe2, 0x88, 0xa7, 0xe2, 0x88, 0xa8, 0xe2, 0x88, 0x91, 0xe2,
  0x88, 0x8f, 0xe2, 0x88, 0xaa, 0xe2, 0x88, 0xa9, 0xe2, 0x88, 0x88, 0xe2,
  0x88, 0xb7, 0xe2, 0x88, 0x9a, 0xe2, 0x8a, 0xa5, 0xe2, 0x88, 0xa5, 0xe2,
  0x88, 0xa0, 0xe2, 0x8c, 0x92, 0xe2, 0x8a, 0x99, 0xe2, 0x88, 0xab, 0xe2,
  0x88, 0xae, 0xe2, 0x89, 0xa1, 0xe2, 0x89, 0x8c, 0xe2, 0x89, 0x88, 0xe2,
  0x88, 0xbd, 0xe2, 0x88, 0x9d, 0xe2, 0x89, 0xa0, 0xe2, 0x89, 0xae, 0xe2,
  0x89, 0xaf, 0xe2, 0x89, 0xa4, 0xe2, 0x89, 0xa5, 0xe2, 0x88, 0x9e, 0xe2,
  0x88, 0xb5, 0xe2, 0x88, 0xb4, 0xe2, 0x99, 0x82, 0xe2, 0x99, 0x80, 0xc2,
  0xb0, 0xe2, 0x80, 0xb2, 0xe2, 0x80, 0xb3, 0xe2, 0x84, 0x83, 0xef, 0xbc,
  0x84, 0xc2, 0xa4, 0xef, 0xbf, 0xa0, 0xef, 0xbf, 0xa1, 0xe2, 0x80, 0xb0,
  0xc2, 0xa7, 0xe2, 0x84, 0x96, 0xe2, 0x98, 0x86, 0xe2, 0x98, 0x85, 0xe2,
  0x97, 0x8b, 0xe2, 0x97, 0x8f, 0xe2, 0x97, 0x8e, 0xe2, 0x97, 0x87, 0xe2,
  0x97, 0x86, 0xe2, 0x96, 0xa1, 0xe2, 0x96, 0xa0, 0xe2, 0x96, 0xb3, 0xe2,
  0x96, 0xb2, 0xe2, 0x80, 0xbb, 0xe2, 0x86, 0x92, 0xe2, 0x86, 0x90, 0xe2,
  0x86, 0x91, 0xe2, 0x86, 0x93, 0xe3, 0x80, 0x93
};

unsigned char gb2312_row_02_converted_to_utf8[] = {
  0xe2, 0x92, 0x88, 0xe2, 0x92, 0x89, 0xe2, 0x92, 0x8a, 0xe2, 0x92, 0x8b,
  0xe2, 0x92, 0x8c, 0xe2, 0x92, 0x8d, 0xe2, 0x92, 0x8e, 0xe2, 0x92, 0x8f,
  0xe2, 0x92, 0x90, 0xe2, 0x92, 0x91, 0xe2, 0x92, 0x92, 0xe2, 0x92, 0x93,
  0xe2, 0x92, 0x94, 0xe2, 0x92, 0x95, 0xe2, 0x92, 0x96, 0xe2, 0x92, 0x97,
  0xe2, 0x92, 0x98, 0xe2, 0x92, 0x99, 0xe2, 0x92, 0x9a, 0xe2, 0x92, 0x9b,
  0xe2, 0x91, 0xb4, 0xe2, 0x91, 0xb5, 0xe2, 0x91, 0xb6, 0xe2, 0x91, 0xb7,
  0xe2, 0x91, 0xb8, 0xe2, 0x91, 0xb9, 0xe2, 0x91, 0xba, 0xe2, 0x91, 0xbb,
  0xe2, 0x91, 0xbc, 0xe2, 0x91, 0xbd, 0xe2, 0x91, 0xbe, 0xe2, 0x91, 0xbf,
  0xe2, 0x92, 0x80, 0xe2, 0x92, 0x81, 0xe2, 0x92, 0x82, 0xe2, 0x92, 0x83,
  0xe2, 0x92, 0x84, 0xe2, 0x92, 0x85, 0xe2, 0x92, 0x86, 0xe2, 0x92, 0x87,
  0xe2, 0x91, 0xa0, 0xe2, 0x91, 0xa1, 0xe2, 0x91, 0xa2, 0xe2, 0x91, 0xa3,
  0xe2, 0x91, 0xa4, 0xe2, 0x91, 0xa5, 0xe2, 0x91, 0xa6, 0xe2, 0x91, 0xa7,
  0xe2, 0x91, 0xa8, 0xe2, 0x91, 0xa9, 0xe3, 0x88, 0xa0, 0xe3, 0x88, 0xa1,
  0xe3, 0x88, 0xa2, 0xe3, 0x88, 0xa3, 0xe3, 0x88, 0xa4, 0xe3, 0x88, 0xa5,
  0xe3, 0x88, 0xa6, 0xe3, 0x88, 0xa7, 0xe3, 0x88, 0xa8, 0xe3, 0x88, 0xa9,
  0xe2, 0x85, 0xa0, 0xe2, 0x85, 0xa1, 0xe2, 0x85, 0xa2, 0xe2, 0x85, 0xa3,
  0xe2, 0x85, 0xa4, 0xe2, 0x85, 0xa5, 0xe2, 0x85, 0xa6, 0xe2, 0x85, 0xa7,
  0xe2, 0x85, 0xa8, 0xe2, 0x85, 0xa9, 0xe2, 0x85, 0xaa, 0xe2, 0x85, 0xab
};

unsigned char gb2312_row_03_converted_to_utf8[] = {
  0xef, 0xbc, 0x81, 0xef, 0xbc, 0x82, 0xef, 0xbc, 0x83, 0xef, 0xbf, 0xa5,
  0xef, 0xbc, 0x85, 0xef, 0xbc, 0x86, 0xef, 0xbc, 0x87, 0xef, 0xbc, 0x88,
  0xef, 0xbc, 0x89, 0xef, 0xbc, 0x8a, 0xef, 0xbc, 0x8b, 0xef, 0xbc, 0x8c,
  0xef, 0xbc, 0x8d, 0xef, 0xbc, 0x8e, 0xef, 0xbc, 0x8f, 0xef, 0xbc, 0x90,
  0xef, 0xbc, 0x91, 0xef, 0xbc, 0x92, 0xef, 0xbc, 0x93, 0xef, 0xbc, 0x94,
  0xef, 0xbc, 0x95, 0xef, 0xbc, 0x96, 0xef, 0xbc, 0x97, 0xef, 0xbc, 0x98,
  0xef, 0xbc, 0x99, 0xef, 0xbc, 0x9a, 0xef, 0xbc, 0x9b, 0xef, 0xbc, 0x9c,
  0xef, 0xbc, 0x9d, 0xef, 0xbc, 0x9e, 0xef, 0xbc, 0x9f, 0xef, 0xbc, 0xa0,
  0xef, 0xbc, 0xa1, 0xef, 0xbc, 0xa2, 0xef, 0xbc, 0xa3, 0xef, 0xbc, 0xa4,
  0xef, 0xbc, 0xa5, 0xef, 0xbc, 0xa6, 0xef, 0xbc, 0xa7, 0xef, 0xbc, 0xa8,
  0xef, 0xbc, 0xa9, 0xef, 0xbc, 0xaa, 0xef, 0xbc, 0xab, 0xef, 0xbc, 0xac,
  0xef, 0xbc, 0xad, 0xef, 0xbc, 0xae, 0xef, 0xbc, 0xaf, 0xef, 0xbc, 0xb0,
  0xef, 0xbc, 0xb1, 0xef, 0xbc, 0xb2, 0xef, 0xbc, 0xb3, 0xef, 0xbc, 0xb4,
  0xef, 0xbc, 0xb5, 0xef, 0xbc, 0xb6, 0xef, 0xbc, 0xb7, 0xef, 0xbc, 0xb8,
  0xef, 0xbc, 0xb9, 0xef, 0xbc, 0xba, 0xef, 0xbc, 0xbb, 0xef, 0xbc, 0xbc,
  0xef, 0xbc, 0xbd, 0xef, 0xbc, 0xbe, 0xef, 0xbc, 0xbf, 0xef, 0xbd, 0x80,
  0xef, 0xbd, 0x81, 0xef, 0xbd, 0x82, 0xef, 0xbd, 0x83, 0xef, 0xbd, 0x84,
  0xef, 0xbd, 0x85, 0xef, 0xbd, 0x86, 0xef, 0xbd, 0x87, 0xef, 0xbd, 0x88,
  0xef, 0xbd, 0x89, 0xef, 0xbd, 0x8a, 0xef, 0xbd, 0x8b, 0xef, 0xbd, 0x8c,
  0xef, 0xbd, 0x8d, 0xef, 0xbd, 0x8e, 0xef, 0xbd, 0x8f, 0xef, 0xbd, 0x90,
  0xef, 0xbd, 0x91, 0xef, 0xbd, 0x92, 0xef, 0xbd, 0x93, 0xef, 0xbd, 0x94,
  0xef, 0xbd, 0x95, 0xef, 0xbd, 0x96, 0xef, 0xbd, 0x97, 0xef, 0xbd, 0x98,
  0xef, 0xbd, 0x99, 0xef, 0xbd, 0x9a, 0xef, 0xbd, 0x9b, 0xef, 0xbd, 0x9c,
  0xef, 0xbd, 0x9d, 0xef, 0xbf, 0xa3
};

unsigned char gb2312_row_04_converted_to_utf8[] = {
  0xe3, 0x81, 0x81, 0xe3, 0x81, 0x82, 0xe3, 0x81, 0x83, 0xe3, 0x81, 0x84,
  0xe3, 0x81, 0x85, 0xe3, 0x81, 0x86, 0xe3, 0x81, 0x87, 0xe3, 0x81, 0x88,
  0xe3, 0x81, 0x89, 0xe3, 0x81, 0x8a, 0xe3, 0x81, 0x8b, 0xe3, 0x81, 0x8c,
  0xe3, 0x81, 0x8d, 0xe3, 0x81, 0x8e, 0xe3, 0x81, 0x8f, 0xe3, 0x81, 0x90,
  0xe3, 0x81, 0x91, 0xe3, 0x81, 0x92, 0xe3, 0x81, 0x93, 0xe3, 0x81, 0x94,
  0xe3, 0x81, 0x95, 0xe3, 0x81, 0x96, 0xe3, 0x81, 0x97, 0xe3, 0x81, 0x98,
  0xe3, 0x81, 0x99, 0xe3, 0x81, 0x9a, 0xe3, 0x81, 0x9b, 0xe3, 0x81, 0x9c,
  0xe3, 0x81, 0x9d, 0xe3, 0x81, 0x9e, 0xe3, 0x81, 0x9f, 0xe3, 0x81, 0xa0,
  0xe3, 0x81, 0xa1, 0xe3, 0x81, 0xa2, 0xe3, 0x81, 0xa3, 0xe3, 0x81, 0xa4,
  0xe3, 0x81, 0xa5, 0xe3, 0x81, 0xa6, 0xe3, 0x81, 0xa7, 0xe3, 0x81, 0xa8,
  0xe3, 0x81, 0xa9, 0xe3, 0x81, 0xaa, 0xe3, 0x81, 0xab, 0xe3, 0x81, 0xac,
  0xe3, 0x81, 0xad, 0xe3, 0x81, 0xae, 0xe3, 0x81, 0xaf, 0xe3, 0x81, 0xb0,
  0xe3, 0x81, 0xb1, 0xe3, 0x81, 0xb2, 0xe3, 0x81, 0xb3, 0xe3, 0x81, 0xb4,
  0xe3, 0x81, 0xb5, 0xe3, 0x81, 0xb6, 0xe3, 0x81, 0xb7, 0xe3, 0x81, 0xb8,
  0xe3, 0x81, 0xb9, 0xe3, 0x81, 0xba, 0xe3, 0x81, 0xbb, 0xe3, 0x81, 0xbc,
  0xe3, 0x81, 0xbd, 0xe3, 0x81, 0xbe, 0xe3, 0x81, 0xbf, 0xe3, 0x82, 0x80,
  0xe3, 0x82, 0x81, 0xe3, 0x82, 0x82, 0xe3, 0x82, 0x83, 0xe3, 0x82, 0x84,
  0xe3, 0x82, 0x85, 0xe3, 0x82, 0x86, 0xe3, 0x82, 0x87, 0xe3, 0x82, 0x88,
  0xe3, 0x82, 0x89, 0xe3, 0x82, 0x8a, 0xe3, 0x82, 0x8b, 0xe3, 0x82, 0x8c,
  0xe3, 0x82, 0x8d, 0xe3, 0x82, 0x8e, 0xe3, 0x82, 0x8f, 0xe3, 0x82, 0x90,
  0xe3, 0x82, 0x91, 0xe3, 0x82, 0x92, 0xe3, 0x82, 0x93
};

unsigned char gb2312_row_05_converted_to_utf8[] = {
  0xe3, 0x82, 0xa1, 0xe3, 0x82, 0xa2, 0xe3, 0x82, 0xa3, 0xe3, 0x82, 0xa4,
  0xe3, 0x82, 0xa5, 0xe3, 0x82, 0xa6, 0xe3, 0x82, 0xa7, 0xe3, 0x82, 0xa8,
  0xe3, 0x82, 0xa9, 0xe3, 0x82, 0xaa, 0xe3, 0x82, 0xab, 0xe3, 0x82, 0xac,
  0xe3, 0x82, 0xad, 0xe3, 0x82, 0xae, 0xe3, 0x82, 0xaf, 0xe3, 0x82, 0xb0,
  0xe3, 0x82, 0xb1, 0xe3, 0x82, 0xb2, 0xe3, 0x82, 0xb3, 0xe3, 0x82, 0xb4,
  0xe3, 0x82, 0xb5, 0xe3, 0x82, 0xb6, 0xe3, 0x82, 0xb7, 0xe3, 0x82, 0xb8,
  0xe3, 0x82, 0xb9, 0xe3, 0x82, 0xba, 0xe3, 0x82, 0xbb, 0xe3, 0x82, 0xbc,
  0xe3, 0x82, 0xbd, 0xe3, 0x82, 0xbe, 0xe3, 0x82, 0xbf, 0xe3, 0x83, 0x80,
  0xe3, 0x83, 0x81, 0xe3, 0x83, 0x82, 0xe3, 0x83, 0x83, 0xe3, 0x83, 0x84,
  0xe3, 0x83, 0x85, 0xe3, 0x83, 0x86, 0xe3, 0x83, 0x87, 0xe3, 0x83, 0x88,
  0xe3, 0x83, 0x89, 0xe3, 0x83, 0x8a, 0xe3, 0x83, 0x8b, 0xe3, 0x83, 0x8c,
  0xe3, 0x83, 0x8d, 0xe3, 0x83, 0x8e, 0xe3, 0x83, 0x8f, 0xe3, 0x83, 0x90,
  0xe3, 0x83, 0x91, 0xe3, 0x83, 0x92, 0xe3, 0x83, 0x93, 0xe3, 0x83, 0x94,
  0xe3, 0x83, 0x95, 0xe3, 0x83, 0x96, 0xe3, 0x83, 0x97, 0xe3, 0x83, 0x98,
  0xe3, 0x83, 0x99, 0xe3, 0x83, 0x9a, 0xe3, 0x83, 0x9b, 0xe3, 0x83, 0x9c,
  0xe3, 0x83, 0x9d, 0xe3, 0x83, 0x9e, 0xe3, 0x83, 0x9f, 0xe3, 0x83, 0xa0,
  0xe3, 0x83, 0xa1, 0xe3, 0x83, 0xa2, 0xe3, 0x83, 0xa3, 0xe3, 0x83, 0xa4,
  0xe3, 0x83, 0xa5, 0xe3, 0x83, 0xa6, 0xe3, 0x83, 0xa7, 0xe3, 0x83, 0xa8,
  0xe3, 0x83, 0xa9, 0xe3, 0x83, 0xaa, 0xe3, 0x83, 0xab, 0xe3, 0x83, 0xac,
  0xe3, 0x83, 0xad, 0xe3, 0x83, 0xae, 0xe3, 0x83, 0xaf, 0xe3, 0x83, 0xb0,
  0xe3, 0x83, 0xb1, 0xe3, 0x83, 0xb2, 0xe3, 0x83, 0xb3, 0xe3, 0x83, 0xb4,
  0xe3, 0x83, 0xb5, 0xe3, 0x83, 0xb6
};

unsigned char gb2312_row_06_converted_to_utf8[] = {
  0xce, 0x91, 0xce, 0x92, 0xce, 0x93, 0xce, 0x94, 0xce, 0x95, 0xce, 0x96,
  0xce, 0x97, 0xce, 0x98, 0xce, 0x99, 0xce, 0x9a, 0xce, 0x9b, 0xce, 0x9c,
  0xce, 0x9d, 0xce, 0x9e, 0xce, 0x9f, 0xce, 0xa0, 0xce, 0xa1, 0xce, 0xa3,
  0xce, 0xa4, 0xce, 0xa5, 0xce, 0xa6, 0xce, 0xa7, 0xce, 0xa8, 0xce, 0xa9,
  0xce, 0xb1, 0xce, 0xb2, 0xce, 0xb3, 0xce, 0xb4, 0xce, 0xb5, 0xce, 0xb6,
  0xce, 0xb7, 0xce, 0xb8, 0xce, 0xb9, 0xce, 0xba, 0xce, 0xbb, 0xce, 0xbc,
  0xce, 0xbd, 0xce, 0xbe, 0xce, 0xbf, 0xcf, 0x80, 0xcf, 0x81, 0xcf, 0x83,
  0xcf, 0x84, 0xcf, 0x85, 0xcf, 0x86, 0xcf, 0x87, 0xcf, 0x88, 0xcf, 0x89
};

unsigned char gb2312_row_07_converted_to_utf8[] = {
  0xd0, 0x90, 0xd0, 0x91, 0xd0, 0x92, 0xd0, 0x93, 0xd0, 0x94, 0xd0, 0x95,
  0xd0, 0x81, 0xd0, 0x96, 0xd0, 0x97, 0xd0, 0x98, 0xd0, 0x99, 0xd0, 0x9a,
  0xd0, 0x9b, 0xd0, 0x9c, 0xd0, 0x9d, 0xd0, 0x9e, 0xd0, 0x9f, 0xd0, 0xa0,
  0xd0, 0xa1, 0xd0, 0xa2, 0xd0, 0xa3, 0xd0, 0xa4, 0xd0, 0xa5, 0xd0, 0xa6,
  0xd0, 0xa7, 0xd0, 0xa8, 0xd0, 0xa9, 0xd0, 0xaa, 0xd0, 0xab, 0xd0, 0xac,
  0xd0, 0xad, 0xd0, 0xae, 0xd0, 0xaf, 0xd0, 0xb0, 0xd0, 0xb1, 0xd0, 0xb2,
  0xd0, 0xb3, 0xd0, 0xb4, 0xd0, 0xb5, 0xd1, 0x91, 0xd0, 0xb6, 0xd0, 0xb7,
  0xd0, 0xb8, 0xd0, 0xb9, 0xd0, 0xba, 0xd0, 0xbb, 0xd0, 0xbc, 0xd0, 0xbd,
  0xd0, 0xbe, 0xd0, 0xbf, 0xd1, 0x80, 0xd1, 0x81, 0xd1, 0x82, 0xd1, 0x83,
  0xd1, 0x84, 0xd1, 0x85, 0xd1, 0x86, 0xd1, 0x87, 0xd1, 0x88, 0xd1, 0x89,
  0xd1, 0x8a, 0xd1, 0x8b, 0xd1, 0x8c, 0xd1, 0x8d, 0xd1, 0x8e, 0xd1, 0x8f
};

unsigned char gb2312_row_08_converted_to_utf8[] = {
  0xc4, 0x81, 0xc3, 0xa1, 0xc7, 0x8e, 0xc3, 0xa0, 0xc4, 0x93, 0xc3, 0xa9,
  0xc4, 0x9b, 0xc3, 0xa8, 0xc4, 0xab, 0xc3, 0xad, 0xc7, 0x90, 0xc3, 0xac,
  0xc5, 0x8d, 0xc3, 0xb3, 0xc7, 0x92, 0xc3, 0xb2, 0xc5, 0xab, 0xc3, 0xba,
  0xc7, 0x94, 0xc3, 0xb9, 0xc7, 0x96, 0xc7, 0x98, 0xc7, 0x9a, 0xc7, 0x9c,
  0xc3, 0xbc, 0xc3, 0xaa, 0xe3, 0x84, 0x85, 0xe3, 0x84, 0x86, 0xe3, 0x84,
  0x87, 0xe3, 0x84, 0x88, 0xe3, 0x84, 0x89, 0xe3, 0x84, 0x8a, 0xe3, 0x84,
  0x8b, 0xe3, 0x84, 0x8c, 0xe3, 0x84, 0x8d, 0xe3, 0x84, 0x8e, 0xe3, 0x84,
  0x8f, 0xe3, 0x84, 0x90, 0xe3, 0x84, 0x91, 0xe3, 0x84, 0x92, 0xe3, 0x84,
  0x93, 0xe3, 0x84, 0x94, 0xe3, 0x84, 0x95, 0xe3, 0x84, 0x96, 0xe3, 0x84,
  0x97, 0xe3, 0x84, 0x98, 0xe3, 0x84, 0x99, 0xe3, 0x84, 0x9a, 0xe3, 0x84,
  0x9b, 0xe3, 0x84, 0x9c, 0xe3, 0x84, 0x9d, 0xe3, 0x84, 0x9e, 0xe3, 0x84,
  0x9f, 0xe3, 0x84, 0xa0, 0xe3, 0x84, 0xa1, 0xe3, 0x84, 0xa2, 0xe3, 0x84,
  0xa3, 0xe3, 0x84, 0xa4, 0xe3, 0x84, 0xa5, 0xe3, 0x84, 0xa6, 0xe3, 0x84,
  0xa7, 0xe3, 0x84, 0xa8, 0xe3, 0x84, 0xa9
};

unsigned char gb2312_row_09_converted_to_utf8[] = {
  0xe2, 0x94, 0x80, 0xe2, 0x94, 0x81, 0xe2, 0x94, 0x82, 0xe2, 0x94, 0x83,
  0xe2, 0x94, 0x84, 0xe2, 0x94, 0x85, 0xe2, 0x94, 0x86, 0xe2, 0x94, 0x87,
  0xe2, 0x94, 0x88, 0xe2, 0x94, 0x89, 0xe2, 0x94, 0x8a, 0xe2, 0x94, 0x8b,
  0xe2, 0x94, 0x8c, 0xe2, 0x94, 0x8d, 0xe2, 0x94, 0x8e, 0xe2, 0x94, 0x8f,
  0xe2, 0x94, 0x90, 0xe2, 0x94, 0x91, 0xe2, 0x94, 0x92, 0xe2, 0x94, 0x93,
  0xe2, 0x94, 0x94, 0xe2, 0x94, 0x95, 0xe2, 0x94, 0x96, 0xe2, 0x94, 0x97,
  0xe2, 0x94, 0x98, 0xe2, 0x94, 0x99, 0xe2, 0x94, 0x9a, 0xe2, 0x94, 0x9b,
  0xe2, 0x94, 0x9c, 0xe2, 0x94, 0x9d, 0xe2, 0x94, 0x9e, 0xe2, 0x94, 0x9f,
  0xe2, 0x94, 0xa0, 0xe2, 0x94, 0xa1, 0xe2, 0x94, 0xa2, 0xe2, 0x94, 0xa3,
  0xe2, 0x94, 0xa4, 0xe2, 0x94, 0xa5, 0xe2, 0x94, 0xa6, 0xe2, 0x94, 0xa7,
  0xe2, 0x94, 0xa8, 0xe2, 0x94, 0xa9, 0xe2, 0x94, 0xaa, 0xe2, 0x94, 0xab,
  0xe2, 0x94, 0xac, 0xe2, 0x94, 0xad, 0xe2, 0x94, 0xae, 0xe2, 0x94, 0xaf,
  0xe2, 0x94, 0xb0, 0xe2, 0x94, 0xb1, 0xe2, 0x94, 0xb2, 0xe2, 0x94, 0xb3,
  0xe2, 0x94, 0xb4, 0xe2, 0x94, 0xb5, 0xe2, 0x94, 0xb6, 0xe2, 0x94, 0xb7,
  0xe2, 0x94, 0xb8, 0xe2, 0x94, 0xb9, 0xe2, 0x94, 0xba, 0xe2, 0x94, 0xbb,
  0xe2, 0x94, 0xbc, 0xe2, 0x94, 0xbd, 0xe2, 0x94, 0xbe, 0xe2, 0x94, 0xbf,
  0xe2, 0x95, 0x80, 0xe2, 0x95, 0x81, 0xe2, 0x95, 0x82, 0xe2, 0x95, 0x83,
  0xe2, 0x95, 0x84, 0xe2, 0x95, 0x85, 0xe2, 0x95, 0x86, 0xe2, 0x95, 0x87,
  0xe2, 0x95, 0x88, 0xe2, 0x95, 0x89, 0xe2, 0x95, 0x8a, 0xe2, 0x95, 0x8b
};

unsigned char gb2312_row_16_converted_to_utf8[] = {
  0xe5, 0x95, 0x8a, 0xe9, 0x98, 0xbf, 0xe5, 0x9f, 0x83, 0xe6, 0x8c, 0xa8,
  0xe5, 0x93, 0x8e, 0xe5, 0x94, 0x89, 0xe5, 0x93, 0x80, 0xe7, 0x9a, 0x91,
  0xe7, 0x99, 0x8c, 0xe8, 0x94, 0xbc, 0xe7, 0x9f, 0xae, 0xe8, 0x89, 0xbe,
  0xe7, 0xa2, 0x8d, 0xe7, 0x88, 0xb1, 0xe9, 0x9a, 0x98, 0xe9, 0x9e, 0x8d,
  0xe6, 0xb0, 0xa8, 0xe5, 0xae, 0x89, 0xe4, 0xbf, 0xba, 0xe6, 0x8c, 0x89,
  0xe6, 0x9a, 0x97, 0xe5, 0xb2, 0xb8, 0xe8, 0x83, 0xba, 0xe6, 0xa1, 0x88,
  0xe8, 0x82, 0xae, 0xe6, 0x98, 0x82, 0xe7, 0x9b, 0x8e, 0xe5, 0x87, 0xb9,
  0xe6, 0x95, 0x96, 0xe7, 0x86, 0xac, 0xe7, 0xbf, 0xb1, 0xe8, 0xa2, 0x84,
  0xe5, 0x82, 0xb2, 0xe5, 0xa5, 0xa5, 0xe6, 0x87, 0x8a, 0xe6, 0xbe, 0xb3,
  0xe8, 0x8a, 0xad, 0xe6, 0x8d, 0x8c, 0xe6, 0x89, 0x92, 0xe5, 0x8f, 0xad,
  0xe5, 0x90, 0xa7, 0xe7, 0xac, 0x86, 0xe5, 0x85, 0xab, 0xe7, 0x96, 0xa4,
  0xe5, 0xb7, 0xb4, 0xe6, 0x8b, 0x94, 0xe8, 0xb7, 0x8b, 0xe9, 0x9d, 0xb6,
  0xe6, 0x8a, 0x8a, 0xe8, 0x80, 0x99, 0xe5, 0x9d, 0x9d, 0xe9, 0x9c, 0xb8,
  0xe7, 0xbd, 0xa2, 0xe7, 0x88, 0xb8, 0xe7, 0x99, 0xbd, 0xe6, 0x9f, 0x8f,
  0xe7, 0x99, 0xbe, 0xe6, 0x91, 0x86, 0xe4, 0xbd, 0xb0, 0xe8, 0xb4, 0xa5,
  0xe6, 0x8b, 0x9c, 0xe7, 0xa8, 0x97, 0xe6, 0x96, 0x91, 0xe7, 0x8f, 0xad,
  0xe6, 0x90, 0xac, 0xe6, 0x89, 0xb3, 0xe8, 0x88, 0xac, 0xe9, 0xa2, 0x81,
  0xe6, 0x9d, 0xbf, 0xe7, 0x89, 0x88, 0xe6, 0x89, 0xae, 0xe6, 0x8b, 0x8c,
  0xe4, 0xbc, 0xb4, 0xe7, 0x93, 0xa3, 0xe5, 0x8d, 0x8a, 0xe5, 0x8a, 0x9e,
  0xe7, 0xbb, 0x8a, 0xe9, 0x82, 0xa6, 0xe5, 0xb8, 0xae, 0xe6, 0xa2, 0x86,
  0xe6, 0xa6, 0x9c, 0xe8, 0x86, 0x80, 0xe7, 0xbb, 0x91, 0xe6, 0xa3, 0x92,
  0xe7, 0xa3, 0x85, 0xe8, 0x9a, 0x8c, 0xe9, 0x95, 0x91, 0xe5, 0x82, 0x8d,
  0xe8, 0xb0, 0xa4, 0xe8, 0x8b, 0x9e, 0xe8, 0x83, 0x9e, 0xe5, 0x8c, 0x85,
  0xe8, 0xa4, 0x92, 0xe5, 0x89, 0xa5
};

unsigned char gb2312_row_17_converted_to_utf8[] = {
  0xe8, 0x96, 0x84, 0xe9, 0x9b, 0xb9, 0xe4, 0xbf, 0x9d, 0xe5, 0xa0, 0xa1,
  0xe9, 0xa5, 0xb1, 0xe5, 0xae, 0x9d, 0xe6, 0x8a, 0xb1, 0xe6, 0x8a, 0xa5,
  0xe6, 0x9a, 0xb4, 0xe8, 0xb1, 0xb9, 0xe9, 0xb2, 0x8d, 0xe7, 0x88, 0x86,
  0xe6, 0x9d, 0xaf, 0xe7, 0xa2, 0x91, 0xe6, 0x82, 0xb2, 0xe5, 0x8d, 0x91,
  0xe5, 0x8c, 0x97, 0xe8, 0xbe, 0x88, 0xe8, 0x83, 0x8c, 0xe8, 0xb4, 0x9d,
  0xe9, 0x92, 0xa1, 0xe5, 0x80, 0x8d, 0xe7, 0x8b, 0x88, 0xe5, 0xa4, 0x87,
  0xe6, 0x83, 0xab, 0xe7, 0x84, 0x99, 0xe8, 0xa2, 0xab, 0xe5, 0xa5, 0x94,
  0xe8, 0x8b, 0xaf, 0xe6, 0x9c, 0xac, 0xe7, 0xac, 0xa8, 0xe5, 0xb4, 0xa9,
  0xe7, 0xbb, 0xb7, 0xe7, 0x94, 0xad, 0xe6, 0xb3, 0xb5, 0xe8, 0xb9, 0xa6,
  0xe8, 0xbf, 0xb8, 0xe9, 0x80, 0xbc, 0xe9, 0xbc, 0xbb, 0xe6, 0xaf, 0x94,
  0xe9, 0x84, 0x99, 0xe7, 0xac, 0x94, 0xe5, 0xbd, 0xbc, 0xe7, 0xa2, 0xa7,
  0xe8, 0x93, 0x96, 0xe8, 0x94, 0xbd, 0xe6, 0xaf, 0x95, 0xe6, 0xaf, 0x99,
  0xe6, 0xaf, 0x96, 0xe5, 0xb8, 0x81, 0xe5, 0xba, 0x87, 0xe7, 0x97, 0xb9,
  0xe9, 0x97, 0xad, 0xe6, 0x95, 0x9d, 0xe5, 0xbc, 0x8a, 0xe5, 0xbf, 0x85,
  0xe8, 0xbe, 0x9f, 0xe5, 0xa3, 0x81, 0xe8, 0x87, 0x82, 0xe9, 0x81, 0xbf,
  0xe9, 0x99, 0x9b, 0xe9, 0x9e, 0xad, 0xe8, 0xbe, 0xb9, 0xe7, 0xbc, 0x96,
  0xe8, 0xb4, 0xac, 0xe6, 0x89, 0x81, 0xe4, 0xbe, 0xbf, 0xe5, 0x8f, 0x98,
  0xe5, 0x8d, 0x9e, 0xe8, 0xbe, 0xa8, 0xe8, 0xbe, 0xa9, 0xe8, 0xbe, 0xab,
  0xe9, 0x81, 0x8d, 0xe6, 0xa0, 0x87, 0xe5, 0xbd, 0xaa, 0xe8, 0x86, 0x98,
  0xe8, 0xa1, 0xa8, 0xe9, 0xb3, 0x96, 0xe6, 0x86, 0x8b, 0xe5, 0x88, 0xab,
  0xe7, 0x98, 0xaa, 0xe5, 0xbd, 0xac, 0xe6, 0x96, 0x8c, 0xe6, 0xbf, 0x92,
  0xe6, 0xbb, 0xa8, 0xe5, 0xae, 0xbe, 0xe6, 0x91, 0x88, 0xe5, 0x85, 0xb5,
  0xe5, 0x86, 0xb0, 0xe6, 0x9f, 0x84, 0xe4, 0xb8, 0x99, 0xe7, 0xa7, 0x89,
  0xe9, 0xa5, 0xbc, 0xe7, 0x82, 0xb3
};

unsigned char gb2312_row_18_converted_to_utf8[] = {
  0xe7, 0x97, 0x85, 0xe5, 0xb9, 0xb6, 0xe7, 0x8e, 0xbb, 0xe8, 0x8f, 0xa0,
  0xe6, 0x92, 0xad, 0xe6, 0x8b, 0xa8, 0xe9, 0x92, 0xb5, 0xe6, 0xb3, 0xa2,
  0xe5, 0x8d, 0x9a, 0xe5, 0x8b, 0x83, 0xe6, 0x90, 0x8f, 0xe9, 0x93, 0x82,
  0xe7, 0xae, 0x94, 0xe4, 0xbc, 0xaf, 0xe5, 0xb8, 0x9b, 0xe8, 0x88, 0xb6,
  0xe8, 0x84, 0x96, 0xe8, 0x86, 0x8a, 0xe6, 0xb8, 0xa4, 0xe6, 0xb3, 0x8a,
  0xe9, 0xa9, 0xb3, 0xe6, 0x8d, 0x95, 0xe5, 0x8d, 0x9c, 0xe5, 0x93, 0xba,
  0xe8, 0xa1, 0xa5, 0xe5, 0x9f, 0xa0, 0xe4, 0xb8, 0x8d, 0xe5, 0xb8, 0x83,
  0xe6, 0xad, 0xa5, 0xe7, 0xb0, 0xbf, 0xe9, 0x83, 0xa8, 0xe6, 0x80, 0x96,
  0xe6, 0x93, 0xa6, 0xe7, 0x8c, 0x9c, 0xe8, 0xa3, 0x81, 0xe6, 0x9d, 0x90,
  0xe6, 0x89, 0x8d, 0xe8, 0xb4, 0xa2, 0xe7, 0x9d, 0xac, 0xe8, 0xb8, 0xa9,
  0xe9, 0x87, 0x87, 0xe5, 0xbd, 0xa9, 0xe8, 0x8f, 0x9c, 0xe8, 0x94, 0xa1,
  0xe9, 0xa4, 0x90, 0xe5, 0x8f, 0x82, 0xe8, 0x9a, 0x95, 0xe6, 0xae, 0x8b,
  0xe6, 0x83, 0xad, 0xe6, 0x83, 0xa8, 0xe7, 0x81, 0xbf, 0xe8, 0x8b, 0x8d,
  0xe8, 0x88, 0xb1, 0xe4, 0xbb, 0x93, 0xe6, 0xb2, 0xa7, 0xe8, 0x97, 0x8f,
  0xe6, 0x93, 0x8d, 0xe7, 0xb3, 0x99, 0xe6, 0xa7, 0xbd, 0xe6, 0x9b, 0xb9,
  0xe8, 0x8d, 0x89, 0xe5, 0x8e, 0x95, 0xe7, 0xad, 0x96, 0xe4, 0xbe, 0xa7,
  0xe5, 0x86, 0x8c, 0xe6, 0xb5, 0x8b, 0xe5, 0xb1, 0x82, 0xe8, 0xb9, 0xad,
  0xe6, 0x8f, 0x92, 0xe5, 0x8f, 0x89, 0xe8, 0x8c, 0xac, 0xe8, 0x8c, 0xb6,
  0xe6, 0x9f, 0xa5, 0xe7, 0xa2, 0xb4, 0xe6, 0x90, 0xbd, 0xe5, 0xaf, 0x9f,
  0xe5, 0xb2, 0x94, 0xe5, 0xb7, 0xae, 0xe8, 0xaf, 0xa7, 0xe6, 0x8b, 0x86,
  0xe6, 0x9f, 0xb4, 0xe8, 0xb1, 0xba, 0xe6, 0x90, 0x80, 0xe6, 0x8e, 0xba,
  0xe8, 0x9d, 0x89, 0xe9, 0xa6, 0x8b, 0xe8, 0xb0, 0x97, 0xe7, 0xbc, 0xa0,
  0xe9, 0x93, 0xb2, 0xe4, 0xba, 0xa7, 0xe9, 0x98, 0x90, 0xe9, 0xa2, 0xa4,
  0xe6, 0x98, 0x8c, 0xe7, 0x8c, 0x96
};

unsigned char gb2312_row_19_converted_to_utf8[] = {
  0xe5, 0x9c, 0xba, 0xe5, 0xb0, 0x9d, 0xe5, 0xb8, 0xb8, 0xe9, 0x95, 0xbf,
  0xe5, 0x81, 0xbf, 0xe8, 0x82, 0xa0, 0xe5, 0x8e, 0x82, 0xe6, 0x95, 0x9e,
  0xe7, 0x95, 0x85, 0xe5, 0x94, 0xb1, 0xe5, 0x80, 0xa1, 0xe8, 0xb6, 0x85,
  0xe6, 0x8a, 0x84, 0xe9, 0x92, 0x9e, 0xe6, 0x9c, 0x9d, 0xe5, 0x98, 0xb2,
  0xe6, 0xbd, 0xae, 0xe5, 0xb7, 0xa2, 0xe5, 0x90, 0xb5, 0xe7, 0x82, 0x92,
  0xe8, 0xbd, 0xa6, 0xe6, 0x89, 0xaf, 0xe6, 0x92, 0xa4, 0xe6, 0x8e, 0xa3,
  0xe5, 0xbd, 0xbb, 0xe6, 0xbe, 0x88, 0xe9, 0x83, 0xb4, 0xe8, 0x87, 0xa3,
  0xe8, 0xbe, 0xb0, 0xe5, 0xb0, 0x98, 0xe6, 0x99, 0xa8, 0xe5, 0xbf, 0xb1,
  0xe6, 0xb2, 0x89, 0xe9, 0x99, 0x88, 0xe8, 0xb6, 0x81, 0xe8, 0xa1, 0xac,
  0xe6, 0x92, 0x91, 0xe7, 0xa7, 0xb0, 0xe5, 0x9f, 0x8e, 0xe6, 0xa9, 0x99,
  0xe6, 0x88, 0x90, 0xe5, 0x91, 0x88, 0xe4, 0xb9, 0x98, 0xe7, 0xa8, 0x8b,
  0xe6, 0x83, 0xa9, 0xe6, 0xbe, 0x84, 0xe8, 0xaf, 0x9a, 0xe6, 0x89, 0xbf,
  0xe9, 0x80, 0x9e, 0xe9, 0xaa, 0x8b, 0xe7, 0xa7, 0xa4, 0xe5, 0x90, 0x83,
  0xe7, 0x97, 0xb4, 0xe6, 0x8c, 0x81, 0xe5, 0x8c, 0x99, 0xe6, 0xb1, 0xa0,
  0xe8, 0xbf, 0x9f, 0xe5, 0xbc, 0x9b, 0xe9, 0xa9, 0xb0, 0xe8, 0x80, 0xbb,
  0xe9, 0xbd, 0xbf, 0xe4, 0xbe, 0x88, 0xe5, 0xb0, 0xba, 0xe8, 0xb5, 0xa4,
  0xe7, 0xbf, 0x85, 0xe6, 0x96, 0xa5, 0xe7, 0x82, 0xbd, 0xe5, 0x85, 0x85,
  0xe5, 0x86, 0xb2, 0xe8, 0x99, 0xab, 0xe5, 0xb4, 0x87, 0xe5, 0xae, 0xa0,
  0xe6, 0x8a, 0xbd, 0xe9, 0x85, 0xac, 0xe7, 0x95, 0xb4, 0xe8, 0xb8, 0x8c,
  0xe7, 0xa8, 0xa0, 0xe6, 0x84, 0x81, 0xe7, 0xad, 0xb9, 0xe4, 0xbb, 0x87,
  0xe7, 0xbb, 0xb8, 0xe7, 0x9e, 0x85, 0xe4, 0xb8, 0x91, 0xe8, 0x87, 0xad,
  0xe5, 0x88, 0x9d, 0xe5, 0x87, 0xba, 0xe6, 0xa9, 0xb1, 0xe5, 0x8e, 0xa8,
  0xe8, 0xba, 0x87, 0xe9, 0x94, 0x84, 0xe9, 0x9b, 0x8f, 0xe6, 0xbb, 0x81,
  0xe9, 0x99, 0xa4, 0xe6, 0xa5, 0x9a
};

unsigned char gb2312_row_20_converted_to_utf8[] = {
  0xe7, 0xa1, 0x80, 0xe5, 0x82, 0xa8, 0xe7, 0x9f, 0x97, 0xe6, 0x90, 0x90,
  0xe8, 0xa7, 0xa6, 0xe5, 0xa4, 0x84, 0xe6, 0x8f, 0xa3, 0xe5, 0xb7, 0x9d,
  0xe7, 0xa9, 0xbf, 0xe6, 0xa4, 0xbd, 0xe4, 0xbc, 0xa0, 0xe8, 0x88, 0xb9,
  0xe5, 0x96, 0x98, 0xe4, 0xb8, 0xb2, 0xe7, 0x96, 0xae, 0xe7, 0xaa, 0x97,
  0xe5, 0xb9, 0xa2, 0xe5, 0xba, 0x8a, 0xe9, 0x97, 0xaf, 0xe5, 0x88, 0x9b,
  0xe5, 0x90, 0xb9, 0xe7, 0x82, 0x8a, 0xe6, 0x8d, 0xb6, 0xe9, 0x94, 0xa4,
  0xe5, 0x9e, 0x82, 0xe6, 0x98, 0xa5, 0xe6, 0xa4, 0xbf, 0xe9, 0x86, 0x87,
  0xe5, 0x94, 0x87, 0xe6, 0xb7, 0xb3, 0xe7, 0xba, 0xaf, 0xe8, 0xa0, 0xa2,
  0xe6, 0x88, 0xb3, 0xe7, 0xbb, 0xb0, 0xe7, 0x96, 0xb5, 0xe8, 0x8c, 0xa8,
  0xe7, 0xa3, 0x81, 0xe9, 0x9b, 0x8c, 0xe8, 0xbe, 0x9e, 0xe6, 0x85, 0x88,
  0xe7, 0x93, 0xb7, 0xe8, 0xaf, 0x8d, 0xe6, 0xad, 0xa4, 0xe5, 0x88, 0xba,
  0xe8, 0xb5, 0x90, 0xe6, 0xac, 0xa1, 0xe8, 0x81, 0xaa, 0xe8, 0x91, 0xb1,
  0xe5, 0x9b, 0xb1, 0xe5, 0x8c, 0x86, 0xe4, 0xbb, 0x8e, 0xe4, 0xb8, 0x9b,
  0xe5, 0x87, 0x91, 0xe7, 0xb2, 0x97, 0xe9, 0x86, 0x8b, 0xe7, 0xb0, 0x87,
  0xe4, 0xbf, 0x83, 0xe8, 0xb9, 0xbf, 0xe7, 0xaf, 0xa1, 0xe7, 0xaa, 0x9c,
  0xe6, 0x91, 0xa7, 0xe5, 0xb4, 0x94, 0xe5, 0x82, 0xac, 0xe8, 0x84, 0x86,
  0xe7, 0x98, 0x81, 0xe7, 0xb2, 0xb9, 0xe6, 0xb7, 0xac, 0xe7, 0xbf, 0xa0,
  0xe6, 0x9d, 0x91, 0xe5, 0xad, 0x98, 0xe5, 0xaf, 0xb8, 0xe7, 0xa3, 0x8b,
  0xe6, 0x92, 0xae, 0xe6, 0x90, 0x93, 0xe6, 0x8e, 0xaa, 0xe6, 0x8c, 0xab,
  0xe9, 0x94, 0x99, 0xe6, 0x90, 0xad, 0xe8, 0xbe, 0xbe, 0xe7, 0xad, 0x94,
  0xe7, 0x98, 0xa9, 0xe6, 0x89, 0x93, 0xe5, 0xa4, 0xa7, 0xe5, 0x91, 0x86,
  0xe6, 0xad, 0xb9, 0xe5, 0x82, 0xa3, 0xe6, 0x88, 0xb4, 0xe5, 0xb8, 0xa6,
  0xe6, 0xae, 0x86, 0xe4, 0xbb, 0xa3, 0xe8, 0xb4, 0xb7, 0xe8, 0xa2, 0x8b,
  0xe5, 0xbe, 0x85, 0xe9, 0x80, 0xae
};

unsigned char gb2312_row_21_converted_to_utf8[] = {
  0xe6, 0x80, 0xa0, 0xe8, 0x80, 0xbd, 0xe6, 0x8b, 0x85, 0xe4, 0xb8, 0xb9,
  0xe5, 0x8d, 0x95, 0xe9, 0x83, 0xb8, 0xe6, 0x8e, 0xb8, 0xe8, 0x83, 0x86,
  0xe6, 0x97, 0xa6, 0xe6, 0xb0, 0xae, 0xe4, 0xbd, 0x86, 0xe6, 0x83, 0xae,
  0xe6, 0xb7, 0xa1, 0xe8, 0xaf, 0x9e, 0xe5, 0xbc, 0xb9, 0xe8, 0x9b, 0x8b,
  0xe5, 0xbd, 0x93, 0xe6, 0x8c, 0xa1, 0xe5, 0x85, 0x9a, 0xe8, 0x8d, 0xa1,
  0xe6, 0xa1, 0xa3, 0xe5, 0x88, 0x80, 0xe6, 0x8d, 0xa3, 0xe8, 0xb9, 0x88,
  0xe5, 0x80, 0x92, 0xe5, 0xb2, 0x9b, 0xe7, 0xa5, 0xb7, 0xe5, 0xaf, 0xbc,
  0xe5, 0x88, 0xb0, 0xe7, 0xa8, 0xbb, 0xe6, 0x82, 0xbc, 0xe9, 0x81, 0x93,
  0xe7, 0x9b, 0x97, 0xe5, 0xbe, 0xb7, 0xe5, 0xbe, 0x97, 0xe7, 0x9a, 0x84,
  0xe8, 0xb9, 0xac, 0xe7, 0x81, 0xaf, 0xe7, 0x99, 0xbb, 0xe7, 0xad, 0x89,
  0xe7, 0x9e, 0xaa, 0xe5, 0x87, 0xb3, 0xe9, 0x82, 0x93, 0xe5, 0xa0, 0xa4,
  0xe4, 0xbd, 0x8e, 0xe6, 0xbb, 0xb4, 0xe8, 0xbf, 0xaa, 0xe6, 0x95, 0x8c,
  0xe7, 0xac, 0x9b, 0xe7, 0x8b, 0x84, 0xe6, 0xb6, 0xa4, 0xe7, 0xbf, 0x9f,
  0xe5, 0xab, 0xa1, 0xe6, 0x8a, 0xb5, 0xe5, 0xba, 0x95, 0xe5, 0x9c, 0xb0,
  0xe8, 0x92, 0x82, 0xe7, 0xac, 0xac, 0xe5, 0xb8, 0x9d, 0xe5, 0xbc, 0x9f,
  0xe9, 0x80, 0x92, 0xe7, 0xbc, 0x94, 0xe9, 0xa2, 0xa0, 0xe6, 0x8e, 0x82,
  0xe6, 0xbb, 0x87, 0xe7, 0xa2, 0x98, 0xe7, 0x82, 0xb9, 0xe5, 0x85, 0xb8,
  0xe9, 0x9d, 0x9b, 0xe5, 0x9e, 0xab, 0xe7, 0x94, 0xb5, 0xe4, 0xbd, 0x83,
  0xe7, 0x94, 0xb8, 0xe5, 0xba, 0x97, 0xe6, 0x83, 0xa6, 0xe5, 0xa5, 0xa0,
  0xe6, 0xb7, 0x80, 0xe6, 0xae, 0xbf, 0xe7, 0xa2, 0x89, 0xe5, 0x8f, 0xbc,
  0xe9, 0x9b, 0x95, 0xe5, 0x87, 0x8b, 0xe5, 0x88, 0x81, 0xe6, 0x8e, 0x89,
  0xe5, 0x90, 0x8a, 0xe9, 0x92, 0x93, 0xe8, 0xb0, 0x83, 0xe8, 0xb7, 0x8c,
  0xe7, 0x88, 0xb9, 0xe7, 0xa2, 0x9f, 0xe8, 0x9d, 0xb6, 0xe8, 0xbf, 0xad,
  0xe8, 0xb0, 0x8d, 0xe5, 0x8f, 0xa0
};

unsigned char gb2312_row_22_converted_to_utf8[] = {
  0xe4, 0xb8, 0x81, 0xe7, 0x9b, 0xaf, 0xe5, 0x8f, 0xae, 0xe9, 0x92, 0x89,
  0xe9, 0xa1, 0xb6, 0xe9, 0xbc, 0x8e, 0xe9, 0x94, 0xad, 0xe5, 0xae, 0x9a,
  0xe8, 0xae, 0xa2, 0xe4, 0xb8, 0xa2, 0xe4, 0xb8, 0x9c, 0xe5, 0x86, 0xac,
  0xe8, 0x91, 0xa3, 0xe6, 0x87, 0x82, 0xe5, 0x8a, 0xa8, 0xe6, 0xa0, 0x8b,
  0xe4, 0xbe, 0x97, 0xe6, 0x81, 0xab, 0xe5, 0x86, 0xbb, 0xe6, 0xb4, 0x9e,
  0xe5, 0x85, 0x9c, 0xe6, 0x8a, 0x96, 0xe6, 0x96, 0x97, 0xe9, 0x99, 0xa1,
  0xe8, 0xb1, 0x86, 0xe9, 0x80, 0x97, 0xe7, 0x97, 0x98, 0xe9, 0x83, 0xbd,
  0xe7, 0x9d, 0xa3, 0xe6, 0xaf, 0x92, 0xe7, 0x8a, 0x8a, 0xe7, 0x8b, 0xac,
  0xe8, 0xaf, 0xbb, 0xe5, 0xa0, 0xb5, 0xe7, 0x9d, 0xb9, 0xe8, 0xb5, 0x8c,
  0xe6, 0x9d, 0x9c, 0xe9, 0x95, 0x80, 0xe8, 0x82, 0x9a, 0xe5, 0xba, 0xa6,
  0xe6, 0xb8, 0xa1, 0xe5, 0xa6, 0x92, 0xe7, 0xab, 0xaf, 0xe7, 0x9f, 0xad,
  0xe9, 0x94, 0xbb, 0xe6, 0xae, 0xb5, 0xe6, 0x96, 0xad, 0xe7, 0xbc, 0x8e,
  0xe5, 0xa0, 0x86, 0xe5, 0x85, 0x91, 0xe9, 0x98, 0x9f, 0xe5, 0xaf, 0xb9,
  0xe5, 0xa2, 0xa9, 0xe5, 0x90, 0xa8, 0xe8, 0xb9, 0xb2, 0xe6, 0x95, 0xa6,
  0xe9, 0xa1, 0xbf, 0xe5, 0x9b, 0xa4, 0xe9, 0x92, 0x9d, 0xe7, 0x9b, 0xbe,
  0xe9, 0x81, 0x81, 0xe6, 0x8e, 0x87, 0xe5, 0x93, 0x86, 0xe5, 0xa4, 0x9a,
  0xe5, 0xa4, 0xba, 0xe5, 0x9e, 0x9b, 0xe8, 0xba, 0xb2, 0xe6, 0x9c, 0xb5,
  0xe8, 0xb7, 0xba, 0xe8, 0x88, 0xb5, 0xe5, 0x89, 0x81, 0xe6, 0x83, 0xb0,
  0xe5, 0xa0, 0x95, 0xe8, 0x9b, 0xbe, 0xe5, 0xb3, 0xa8, 0xe9, 0xb9, 0x85,
  0xe4, 0xbf, 0x84, 0xe9, 0xa2, 0x9d, 0xe8, 0xae, 0xb9, 0xe5, 0xa8, 0xa5,
  0xe6, 0x81, 0xb6, 0xe5, 0x8e, 0x84, 0xe6, 0x89, 0xbc, 0xe9, 0x81, 0x8f,
  0xe9, 0x84, 0x82, 0xe9, 0xa5, 0xbf, 0xe6, 0x81, 0xa9, 0xe8, 0x80, 0x8c,
  0xe5, 0x84, 0xbf, 0xe8, 0x80, 0xb3, 0xe5, 0xb0, 0x94, 0xe9, 0xa5, 0xb5,
  0xe6, 0xb4, 0xb1, 0xe4, 0xba, 0x8c
};

unsigned char gb2312_row_23_converted_to_utf8[] = {
  0xe8, 0xb4, 0xb0, 0xe5, 0x8f, 0x91, 0xe7, 0xbd, 0x9a, 0xe7, 0xad, 0x8f,
  0xe4, 0xbc, 0x90, 0xe4, 0xb9, 0x8f, 0xe9, 0x98, 0x80, 0xe6, 0xb3, 0x95,
  0xe7, 0x8f, 0x90, 0xe8, 0x97, 0xa9, 0xe5, 0xb8, 0x86, 0xe7, 0x95, 0xaa,
  0xe7, 0xbf, 0xbb, 0xe6, 0xa8, 0x8a, 0xe7, 0x9f, 0xbe, 0xe9, 0x92, 0x92,
  0xe7, 0xb9, 0x81, 0xe5, 0x87, 0xa1, 0xe7, 0x83, 0xa6, 0xe5, 0x8f, 0x8d,
  0xe8, 0xbf, 0x94, 0xe8, 0x8c, 0x83, 0xe8, 0xb4, 0xa9, 0xe7, 0x8a, 0xaf,
  0xe9, 0xa5, 0xad, 0xe6, 0xb3, 0x9b, 0xe5, 0x9d, 0x8a, 0xe8, 0x8a, 0xb3,
  0xe6, 0x96, 0xb9, 0xe8, 0x82, 0xaa, 0xe6, 0x88, 0xbf, 0xe9, 0x98, 0xb2,
  0xe5, 0xa6, 0xa8, 0xe4, 0xbb, 0xbf, 0xe8, 0xae, 0xbf, 0xe7, 0xba, 0xba,
  0xe6, 0x94, 0xbe, 0xe8, 0x8f, 0xb2, 0xe9, 0x9d, 0x9e, 0xe5, 0x95, 0xa1,
  0xe9, 0xa3, 0x9e, 0xe8, 0x82, 0xa5, 0xe5, 0x8c, 0xaa, 0xe8, 0xaf, 0xbd,
  0xe5, 0x90, 0xa0, 0xe8, 0x82, 0xba, 0xe5, 0xba, 0x9f, 0xe6, 0xb2, 0xb8,
  0xe8, 0xb4, 0xb9, 0xe8, 0x8a, 0xac, 0xe9, 0x85, 0x9a, 0xe5, 0x90, 0xa9,
  0xe6, 0xb0, 0x9b, 0xe5, 0x88, 0x86, 0xe7, 0xba, 0xb7, 0xe5, 0x9d, 0x9f,
  0xe7, 0x84, 0x9a, 0xe6, 0xb1, 0xbe, 0xe7, 0xb2, 0x89, 0xe5, 0xa5, 0x8b,
  0xe4, 0xbb, 0xbd, 0xe5, 0xbf, 0xbf, 0xe6, 0x84, 0xa4, 0xe7, 0xb2, 0xaa,
  0xe4, 0xb8, 0xb0, 0xe5, 0xb0, 0x81, 0xe6, 0x9e, 0xab, 0xe8, 0x9c, 0x82,
  0xe5, 0xb3, 0xb0, 0xe9, 0x94, 0x8b, 0xe9, 0xa3, 0x8e, 0xe7, 0x96, 0xaf,
  0xe7, 0x83, 0xbd, 0xe9, 0x80, 0xa2, 0xe5, 0x86, 0xaf, 0xe7, 0xbc, 0x9d,
  0xe8, 0xae, 0xbd, 0xe5, 0xa5, 0x89, 0xe5, 0x87, 0xa4, 0xe4, 0xbd, 0x9b,
  0xe5, 0x90, 0xa6, 0xe5, 0xa4, 0xab, 0xe6, 0x95, 0xb7, 0xe8, 0x82, 0xa4,
  0xe5, 0xad, 0xb5, 0xe6, 0x89, 0xb6, 0xe6, 0x8b, 0x82, 0xe8, 0xbe, 0x90,
  0xe5, 0xb9, 0x85, 0xe6, 0xb0, 0x9f, 0xe7, 0xac, 0xa6, 0xe4, 0xbc, 0x8f,
  0xe4, 0xbf, 0x98, 0xe6, 0x9c, 0x8d
};

unsigned char gb2312_row_24_converted_to_utf8[] = {
  0xe6, 0xb5, 0xae, 0xe6, 0xb6, 0xaa, 0xe7, 0xa6, 0x8f, 0xe8, 0xa2, 0xb1,
  0xe5, 0xbc, 0x97, 0xe7, 0x94, 0xab, 0xe6, 0x8a, 0x9a, 0xe8, 0xbe, 0x85,
  0xe4, 0xbf, 0xaf, 0xe9, 0x87, 0x9c, 0xe6, 0x96, 0xa7, 0xe8, 0x84, 0xaf,
  0xe8, 0x85, 0x91, 0xe5, 0xba, 0x9c, 0xe8, 0x85, 0x90, 0xe8, 0xb5, 0xb4,
  0xe5, 0x89, 0xaf, 0xe8, 0xa6, 0x86, 0xe8, 0xb5, 0x8b, 0xe5, 0xa4, 0x8d,
  0xe5, 0x82, 0x85, 0xe4, 0xbb, 0x98, 0xe9, 0x98, 0x9c, 0xe7, 0x88, 0xb6,
  0xe8, 0x85, 0xb9, 0xe8, 0xb4, 0x9f, 0xe5, 0xaf, 0x8c, 0xe8, 0xae, 0xa3,
  0xe9, 0x99, 0x84, 0xe5, 0xa6, 0x87, 0xe7, 0xbc, 0x9a, 0xe5, 0x92, 0x90,
  0xe5, 0x99, 0xb6, 0xe5, 0x98, 0x8e, 0xe8, 0xaf, 0xa5, 0xe6, 0x94, 0xb9,
  0xe6, 0xa6, 0x82, 0xe9, 0x92, 0x99, 0xe7, 0x9b, 0x96, 0xe6, 0xba, 0x89,
  0xe5, 0xb9, 0xb2, 0xe7, 0x94, 0x98, 0xe6, 0x9d, 0x86, 0xe6, 0x9f, 0x91,
  0xe7, 0xab, 0xbf, 0xe8, 0x82, 0x9d, 0xe8, 0xb5, 0xb6, 0xe6, 0x84, 0x9f,
  0xe7, 0xa7, 0x86, 0xe6, 0x95, 0xa2, 0xe8, 0xb5, 0xa3, 0xe5, 0x86, 0x88,
  0xe5, 0x88, 0x9a, 0xe9, 0x92, 0xa2, 0xe7, 0xbc, 0xb8, 0xe8, 0x82, 0x9b,
  0xe7, 0xba, 0xb2, 0xe5, 0xb2, 0x97, 0xe6, 0xb8, 0xaf, 0xe6, 0x9d, 0xa0,
  0xe7, 0xaf, 0x99, 0xe7, 0x9a, 0x8b, 0xe9, 0xab, 0x98, 0xe8, 0x86, 0x8f,
  0xe7, 0xbe, 0x94, 0xe7, 0xb3, 0x95, 0xe6, 0x90, 0x9e, 0xe9, 0x95, 0x90,
  0xe7, 0xa8, 0xbf, 0xe5, 0x91, 0x8a, 0xe5, 0x93, 0xa5, 0xe6, 0xad, 0x8c,
  0xe6, 0x90, 0x81, 0xe6, 0x88, 0x88, 0xe9, 0xb8, 0xbd, 0xe8, 0x83, 0xb3,
  0xe7, 0x96, 0x99, 0xe5, 0x89, 0xb2, 0xe9, 0x9d, 0xa9, 0xe8, 0x91, 0x9b,
  0xe6, 0xa0, 0xbc, 0xe8, 0x9b, 0xa4, 0xe9, 0x98, 0x81, 0xe9, 0x9a, 0x94,
  0xe9, 0x93, 0xac, 0xe4, 0xb8, 0xaa, 0xe5, 0x90, 0x84, 0xe7, 0xbb, 0x99,
  0xe6, 0xa0, 0xb9, 0xe8, 0xb7, 0x9f, 0xe8, 0x80, 0x95, 0xe6, 0x9b, 0xb4,
  0xe5, 0xba, 0x9a, 0xe7, 0xbe, 0xb9
};

unsigned char gb2312_row_25_converted_to_utf8[] = {
  0xe5, 0x9f, 0x82, 0xe8, 0x80, 0xbf, 0xe6, 0xa2, 0x97, 0xe5, 0xb7, 0xa5,
  0xe6, 0x94, 0xbb, 0xe5, 0x8a, 0x9f, 0xe6, 0x81, 0xad, 0xe9, 0xbe, 0x9a,
  0xe4, 0xbe, 0x9b, 0xe8, 0xba, 0xac, 0xe5, 0x85, 0xac, 0xe5, 0xae, 0xab,
  0xe5, 0xbc, 0x93, 0xe5, 0xb7, 0xa9, 0xe6, 0xb1, 0x9e, 0xe6, 0x8b, 0xb1,
  0xe8, 0xb4, 0xa1, 0xe5, 0x85, 0xb1, 0xe9, 0x92, 0xa9, 0xe5, 0x8b, 0xbe,
  0xe6, 0xb2, 0x9f, 0xe8, 0x8b, 0x9f, 0xe7, 0x8b, 0x97, 0xe5, 0x9e, 0xa2,
  0xe6, 0x9e, 0x84, 0xe8, 0xb4, 0xad, 0xe5, 0xa4, 0x9f, 0xe8, 0xbe, 0x9c,
  0xe8, 0x8f, 0x87, 0xe5, 0x92, 0x95, 0xe7, 0xae, 0x8d, 0xe4, 0xbc, 0xb0,
  0xe6, 0xb2, 0xbd, 0xe5, 0xad, 0xa4, 0xe5, 0xa7, 0x91, 0xe9, 0xbc, 0x93,
  0xe5, 0x8f, 0xa4, 0xe8, 0x9b, 0x8a, 0xe9, 0xaa, 0xa8, 0xe8, 0xb0, 0xb7,
  0xe8, 0x82, 0xa1, 0xe6, 0x95, 0x85, 0xe9, 0xa1, 0xbe, 0xe5, 0x9b, 0xba,
  0xe9, 0x9b, 0x87, 0xe5, 0x88, 0xae, 0xe7, 0x93, 0x9c, 0xe5, 0x89, 0x90,
  0xe5, 0xaf, 0xa1, 0xe6, 0x8c, 0x82, 0xe8, 0xa4, 0x82, 0xe4, 0xb9, 0x96,
  0xe6, 0x8b, 0x90, 0xe6, 0x80, 0xaa, 0xe6, 0xa3, 0xba, 0xe5, 0x85, 0xb3,
  0xe5, 0xae, 0x98, 0xe5, 0x86, 0xa0, 0xe8, 0xa7, 0x82, 0xe7, 0xae, 0xa1,
  0xe9, 0xa6, 0x86, 0xe7, 0xbd, 0x90, 0xe6, 0x83, 0xaf, 0xe7, 0x81, 0x8c,
  0xe8, 0xb4, 0xaf, 0xe5, 0x85, 0x89, 0xe5, 0xb9, 0xbf, 0xe9, 0x80, 0x9b,
  0xe7, 0x91, 0xb0, 0xe8, 0xa7, 0x84, 0xe5, 0x9c, 0xad, 0xe7, 0xa1, 0x85,
  0xe5, 0xbd, 0x92, 0xe9, 0xbe, 0x9f, 0xe9, 0x97, 0xba, 0xe8, 0xbd, 0xa8,
  0xe9, 0xac, 0xbc, 0xe8, 0xaf, 0xa1, 0xe7, 0x99, 0xb8, 0xe6, 0xa1, 0x82,
  0xe6, 0x9f, 0x9c, 0xe8, 0xb7, 0xaa, 0xe8, 0xb4, 0xb5, 0xe5, 0x88, 0xbd,
  0xe8, 0xbe, 0x8a, 0xe6, 0xbb, 0x9a, 0xe6, 0xa3, 0x8d, 0xe9, 0x94, 0x85,
  0xe9, 0x83, 0xad, 0xe5, 0x9b, 0xbd, 0xe6, 0x9e, 0x9c, 0xe8, 0xa3, 0xb9,
  0xe8, 0xbf, 0x87, 0xe5, 0x93, 0x88
};

unsigned char gb2312_row_26_converted_to_utf8[] = {
  0xe9, 0xaa, 0xb8, 0xe5, 0xad, 0xa9, 0xe6, 0xb5, 0xb7, 0xe6, 0xb0, 0xa6,
  0xe4, 0xba, 0xa5, 0xe5, 0xae, 0xb3, 0xe9, 0xaa, 0x87, 0xe9, 0x85, 0xa3,
  0xe6, 0x86, 0xa8, 0xe9, 0x82, 0xaf, 0xe9, 0x9f, 0xa9, 0xe5, 0x90, 0xab,
  0xe6, 0xb6, 0xb5, 0xe5, 0xaf, 0x92, 0xe5, 0x87, 0xbd, 0xe5, 0x96, 0x8a,
  0xe7, 0xbd, 0x95, 0xe7, 0xbf, 0xb0, 0xe6, 0x92, 0xbc, 0xe6, 0x8d, 0x8d,
  0xe6, 0x97, 0xb1, 0xe6, 0x86, 0xbe, 0xe6, 0x82, 0x8d, 0xe7, 0x84, 0x8a,
  0xe6, 0xb1, 0x97, 0xe6, 0xb1, 0x89, 0xe5, 0xa4, 0xaf, 0xe6, 0x9d, 0xad,
  0xe8, 0x88, 0xaa, 0xe5, 0xa3, 0x95, 0xe5, 0x9a, 0x8e, 0xe8, 0xb1, 0xaa,
  0xe6, 0xaf, 0xab, 0xe9, 0x83, 0x9d, 0xe5, 0xa5, 0xbd, 0xe8, 0x80, 0x97,
  0xe5, 0x8f, 0xb7, 0xe6, 0xb5, 0xa9, 0xe5, 0x91, 0xb5, 0xe5, 0x96, 0x9d,
  0xe8, 0x8d, 0xb7, 0xe8, 0x8f, 0x8f, 0xe6, 0xa0, 0xb8, 0xe7, 0xa6, 0xbe,
  0xe5, 0x92, 0x8c, 0xe4, 0xbd, 0x95, 0xe5, 0x90, 0x88, 0xe7, 0x9b, 0x92,
  0xe8, 0xb2, 0x89, 0xe9, 0x98, 0x82, 0xe6, 0xb2, 0xb3, 0xe6, 0xb6, 0xb8,
  0xe8, 0xb5, 0xab, 0xe8, 0xa4, 0x90, 0xe9, 0xb9, 0xa4, 0xe8, 0xb4, 0xba,
  0xe5, 0x98, 0xbf, 0xe9, 0xbb, 0x91, 0xe7, 0x97, 0x95, 0xe5, 0xbe, 0x88,
  0xe7, 0x8b, 0xa0, 0xe6, 0x81, 0xa8, 0xe5, 0x93, 0xbc, 0xe4, 0xba, 0xa8,
  0xe6, 0xa8, 0xaa, 0xe8, 0xa1, 0xa1, 0xe6, 0x81, 0x92, 0xe8, 0xbd, 0xb0,
  0xe5, 0x93, 0x84, 0xe7, 0x83, 0x98, 0xe8, 0x99, 0xb9, 0xe9, 0xb8, 0xbf,
  0xe6, 0xb4, 0xaa, 0xe5, 0xae, 0x8f, 0xe5, 0xbc, 0x98, 0xe7, 0xba, 0xa2,
  0xe5, 0x96, 0x89, 0xe4, 0xbe, 0xaf, 0xe7, 0x8c, 0xb4, 0xe5, 0x90, 0xbc,
  0xe5, 0x8e, 0x9a, 0xe5, 0x80, 0x99, 0xe5, 0x90, 0x8e, 0xe5, 0x91, 0xbc,
  0xe4, 0xb9, 0x8e, 0xe5, 0xbf, 0xbd, 0xe7, 0x91, 0x9a, 0xe5, 0xa3, 0xb6,
  0xe8, 0x91, 0xab, 0xe8, 0x83, 0xa1, 0xe8, 0x9d, 0xb4, 0xe7, 0x8b, 0x90,
  0xe7, 0xb3, 0x8a, 0xe6, 0xb9, 0x96
};

unsigned char gb2312_row_27_converted_to_utf8[] = {
  0xe5, 0xbc, 0xa7, 0xe8, 0x99, 0x8e, 0xe5, 0x94, 0xac, 0xe6, 0x8a, 0xa4,
  0xe4, 0xba, 0x92, 0xe6, 0xb2, 0xaa, 0xe6, 0x88, 0xb7, 0xe8, 0x8a, 0xb1,
  0xe5, 0x93, 0x97, 0xe5, 0x8d, 0x8e, 0xe7, 0x8c, 0xbe, 0xe6, 0xbb, 0x91,
  0xe7, 0x94, 0xbb, 0xe5, 0x88, 0x92, 0xe5, 0x8c, 0x96, 0xe8, 0xaf, 0x9d,
  0xe6, 0xa7, 0x90, 0xe5, 0xbe, 0x8a, 0xe6, 0x80, 0x80, 0xe6, 0xb7, 0xae,
  0xe5, 0x9d, 0x8f, 0xe6, 0xac, 0xa2, 0xe7, 0x8e, 0xaf, 0xe6, 0xa1, 0x93,
  0xe8, 0xbf, 0x98, 0xe7, 0xbc, 0x93, 0xe6, 0x8d, 0xa2, 0xe6, 0x82, 0xa3,
  0xe5, 0x94, 0xa4, 0xe7, 0x97, 0xaa, 0xe8, 0xb1, 0xa2, 0xe7, 0x84, 0x95,
  0xe6, 0xb6, 0xa3, 0xe5, 0xae, 0xa6, 0xe5, 0xb9, 0xbb, 0xe8, 0x8d, 0x92,
  0xe6, 0x85, 0x8c, 0xe9, 0xbb, 0x84, 0xe7, 0xa3, 0xba, 0xe8, 0x9d, 0x97,
  0xe7, 0xb0, 0xa7, 0xe7, 0x9a, 0x87, 0xe5, 0x87, 0xb0, 0xe6, 0x83, 0xb6,
  0xe7, 0x85, 0x8c, 0xe6, 0x99, 0x83, 0xe5, 0xb9, 0x8c, 0xe6, 0x81, 0x8d,
  0xe8, 0xb0, 0x8e, 0xe7, 0x81, 0xb0, 0xe6, 0x8c, 0xa5, 0xe8, 0xbe, 0x89,
  0xe5, 0xbe, 0xbd, 0xe6, 0x81, 0xa2, 0xe8, 0x9b, 0x94, 0xe5, 0x9b, 0x9e,
  0xe6, 0xaf, 0x81, 0xe6, 0x82, 0x94, 0xe6, 0x85, 0xa7, 0xe5, 0x8d, 0x89,
  0xe6, 0x83, 0xa0, 0xe6, 0x99, 0xa6, 0xe8, 0xb4, 0xbf, 0xe7, 0xa7, 0xbd,
  0xe4, 0xbc, 0x9a, 0xe7, 0x83, 0xa9, 0xe6, 0xb1, 0x87, 0xe8, 0xae, 0xb3,
  0xe8, 0xaf, 0xb2, 0xe7, 0xbb, 0x98, 0xe8, 0x8d, 0xa4, 0xe6, 0x98, 0x8f,
  0xe5, 0xa9, 0x9a, 0xe9, 0xad, 0x82, 0xe6, 0xb5, 0x91, 0xe6, 0xb7, 0xb7,
  0xe8, 0xb1, 0x81, 0xe6, 0xb4, 0xbb, 0xe4, 0xbc, 0x99, 0xe7, 0x81, 0xab,
  0xe8, 0x8e, 0xb7, 0xe6, 0x88, 0x96, 0xe6, 0x83, 0x91, 0xe9, 0x9c, 0x8d,
  0xe8, 0xb4, 0xa7, 0xe7, 0xa5, 0xb8, 0xe5, 0x87, 0xbb, 0xe5, 0x9c, 0xbe,
  0xe5, 0x9f, 0xba, 0xe6, 0x9c, 0xba, 0xe7, 0x95, 0xb8, 0xe7, 0xa8, 0xbd,
  0xe7, 0xa7, 0xaf, 0xe7, 0xae, 0x95
};

unsigned char gb2312_row_28_converted_to_utf8[] = {
  0xe8, 0x82, 0x8c, 0xe9, 0xa5, 0xa5, 0xe8, 0xbf, 0xb9, 0xe6, 0xbf, 0x80,
  0xe8, 0xae, 0xa5, 0xe9, 0xb8, 0xa1, 0xe5, 0xa7, 0xac, 0xe7, 0xbb, 0xa9,
  0xe7, 0xbc, 0x89, 0xe5, 0x90, 0x89, 0xe6, 0x9e, 0x81, 0xe6, 0xa3, 0x98,
  0xe8, 0xbe, 0x91, 0xe7, 0xb1, 0x8d, 0xe9, 0x9b, 0x86, 0xe5, 0x8f, 0x8a,
  0xe6, 0x80, 0xa5, 0xe7, 0x96, 0xbe, 0xe6, 0xb1, 0xb2, 0xe5, 0x8d, 0xb3,
  0xe5, 0xab, 0x89, 0xe7, 0xba, 0xa7, 0xe6, 0x8c, 0xa4, 0xe5, 0x87, 0xa0,
  0xe8, 0x84, 0x8a, 0xe5, 0xb7, 0xb1, 0xe8, 0x93, 0x9f, 0xe6, 0x8a, 0x80,
  0xe5, 0x86, 0x80, 0xe5, 0xad, 0xa3, 0xe4, 0xbc, 0x8e, 0xe7, 0xa5, 0xad,
  0xe5, 0x89, 0x82, 0xe6, 0x82, 0xb8, 0xe6, 0xb5, 0x8e, 0xe5, 0xaf, 0x84,
  0xe5, 0xaf, 0x82, 0xe8, 0xae, 0xa1, 0xe8, 0xae, 0xb0, 0xe6, 0x97, 0xa2,
  0xe5, 0xbf, 0x8c, 0xe9, 0x99, 0x85, 0xe5, 0xa6, 0x93, 0xe7, 0xbb, 0xa7,
  0xe7, 0xba, 0xaa, 0xe5, 0x98, 0x89, 0xe6, 0x9e, 0xb7, 0xe5, 0xa4, 0xb9,
  0xe4, 0xbd, 0xb3, 0xe5, 0xae, 0xb6, 0xe5, 0x8a, 0xa0, 0xe8, 0x8d, 0x9a,
  0xe9, 0xa2, 0x8a, 0xe8, 0xb4, 0xbe, 0xe7, 0x94, 0xb2, 0xe9, 0x92, 0xbe,
  0xe5, 0x81, 0x87, 0xe7, 0xa8, 0xbc, 0xe4, 0xbb, 0xb7, 0xe6, 0x9e, 0xb6,
  0xe9, 0xa9, 0xbe, 0xe5, 0xab, 0x81, 0xe6, 0xad, 0xbc, 0xe7, 0x9b, 0x91,
  0xe5, 0x9d, 0x9a, 0xe5, 0xb0, 0x96, 0xe7, 0xac, 0xba, 0xe9, 0x97, 0xb4,
  0xe7, 0x85, 0x8e, 0xe5, 0x85, 0xbc, 0xe8, 0x82, 0xa9, 0xe8, 0x89, 0xb0,
  0xe5, 0xa5, 0xb8, 0xe7, 0xbc, 0x84, 0xe8, 0x8c, 0xa7, 0xe6, 0xa3, 0x80,
  0xe6, 0x9f, 0xac, 0xe7, 0xa2, 0xb1, 0xe7, 0xa1, 0xb7, 0xe6, 0x8b, 0xa3,
  0xe6, 0x8d, 0xa1, 0xe7, 0xae, 0x80, 0xe4, 0xbf, 0xad, 0xe5, 0x89, 0xaa,
  0xe5, 0x87, 0x8f, 0xe8, 0x8d, 0x90, 0xe6, 0xa7, 0x9b, 0xe9, 0x89, 0xb4,
  0xe8, 0xb7, 0xb5, 0xe8, 0xb4, 0xb1, 0xe8, 0xa7, 0x81, 0xe9, 0x94, 0xae,
  0xe7, 0xae, 0xad, 0xe4, 0xbb, 0xb6
};

unsigned char gb2312_row_29_converted_to_utf8[] = {
  0xe5, 0x81, 0xa5, 0xe8, 0x88, 0xb0, 0xe5, 0x89, 0x91, 0xe9, 0xa5, 0xaf,
  0xe6, 0xb8, 0x90, 0xe6, 0xba, 0x85, 0xe6, 0xb6, 0xa7, 0xe5, 0xbb, 0xba,
  0xe5, 0x83, 0xb5, 0xe5, 0xa7, 0x9c, 0xe5, 0xb0, 0x86, 0xe6, 0xb5, 0x86,
  0xe6, 0xb1, 0x9f, 0xe7, 0x96, 0x86, 0xe8, 0x92, 0x8b, 0xe6, 0xa1, 0xa8,
  0xe5, 0xa5, 0x96, 0xe8, 0xae, 0xb2, 0xe5, 0x8c, 0xa0, 0xe9, 0x85, 0xb1,
  0xe9, 0x99, 0x8d, 0xe8, 0x95, 0x89, 0xe6, 0xa4, 0x92, 0xe7, 0xa4, 0x81,
  0xe7, 0x84, 0xa6, 0xe8, 0x83, 0xb6, 0xe4, 0xba, 0xa4, 0xe9, 0x83, 0x8a,
  0xe6, 0xb5, 0x87, 0xe9, 0xaa, 0x84, 0xe5, 0xa8, 0x87, 0xe5, 0x9a, 0xbc,
  0xe6, 0x90, 0x85, 0xe9, 0x93, 0xb0, 0xe7, 0x9f, 0xab, 0xe4, 0xbe, 0xa5,
  0xe8, 0x84, 0x9a, 0xe7, 0x8b, 0xa1, 0xe8, 0xa7, 0x92, 0xe9, 0xa5, 0xba,
  0xe7, 0xbc, 0xb4, 0xe7, 0xbb, 0x9e, 0xe5, 0x89, 0xbf, 0xe6, 0x95, 0x99,
  0xe9, 0x85, 0xb5, 0xe8, 0xbd, 0xbf, 0xe8, 0xbe, 0x83, 0xe5, 0x8f, 0xab,
  0xe7, 0xaa, 0x96, 0xe6, 0x8f, 0xad, 0xe6, 0x8e, 0xa5, 0xe7, 0x9a, 0x86,
  0xe7, 0xa7, 0xb8, 0xe8, 0xa1, 0x97, 0xe9, 0x98, 0xb6, 0xe6, 0x88, 0xaa,
  0xe5, 0x8a, 0xab, 0xe8, 0x8a, 0x82, 0xe6, 0xa1, 0x94, 0xe6, 0x9d, 0xb0,
  0xe6, 0x8d, 0xb7, 0xe7, 0x9d, 0xab, 0xe7, 0xab, 0xad, 0xe6, 0xb4, 0x81,
  0xe7, 0xbb, 0x93, 0xe8, 0xa7, 0xa3, 0xe5, 0xa7, 0x90, 0xe6, 0x88, 0x92,
  0xe8, 0x97, 0x89, 0xe8, 0x8a, 0xa5, 0xe7, 0x95, 0x8c, 0xe5, 0x80, 0x9f,
  0xe4, 0xbb, 0x8b, 0xe7, 0x96, 0xa5, 0xe8, 0xaf, 0xab, 0xe5, 0xb1, 0x8a,
  0xe5, 0xb7, 0xbe, 0xe7, 0xad, 0x8b, 0xe6, 0x96, 0xa4, 0xe9, 0x87, 0x91,
  0xe4, 0xbb, 0x8a, 0xe6, 0xb4, 0xa5, 0xe8, 0xa5, 0x9f, 0xe7, 0xb4, 0xa7,
  0xe9, 0x94, 0xa6, 0xe4, 0xbb, 0x85, 0xe8, 0xb0, 0xa8, 0xe8, 0xbf, 0x9b,
  0xe9, 0x9d, 0xb3, 0xe6, 0x99, 0x8b, 0xe7, 0xa6, 0x81, 0xe8, 0xbf, 0x91,
  0xe7, 0x83, 0xac, 0xe6, 0xb5, 0xb8
};

unsigned char gb2312_row_30_converted_to_utf8[] = {
  0xe5, 0xb0, 0xbd, 0xe5, 0x8a, 0xb2, 0xe8, 0x8d, 0x86, 0xe5, 0x85, 0xa2,
  0xe8, 0x8c, 0x8e, 0xe7, 0x9d, 0x9b, 0xe6, 0x99, 0xb6, 0xe9, 0xb2, 0xb8,
  0xe4, 0xba, 0xac, 0xe6, 0x83, 0x8a, 0xe7, 0xb2, 0xbe, 0xe7, 0xb2, 0xb3,
  0xe7, 0xbb, 0x8f, 0xe4, 0xba, 0x95, 0xe8, 0xad, 0xa6, 0xe6, 0x99, 0xaf,
  0xe9, 0xa2, 0x88, 0xe9, 0x9d, 0x99, 0xe5, 0xa2, 0x83, 0xe6, 0x95, 0xac,
  0xe9, 0x95, 0x9c, 0xe5, 0xbe, 0x84, 0xe7, 0x97, 0x89, 0xe9, 0x9d, 0x96,
  0xe7, 0xab, 0x9f, 0xe7, 0xab, 0x9e, 0xe5, 0x87, 0x80, 0xe7, 0x82, 0xaf,
  0xe7, 0xaa, 0x98, 0xe6, 0x8f, 0xaa, 0xe7, 0xa9, 0xb6, 0xe7, 0xba, 0xa0,
  0xe7, 0x8e, 0x96, 0xe9, 0x9f, 0xad, 0xe4, 0xb9, 0x85, 0xe7, 0x81, 0xb8,
  0xe4, 0xb9, 0x9d, 0xe9, 0x85, 0x92, 0xe5, 0x8e, 0xa9, 0xe6, 0x95, 0x91,
  0xe6, 0x97, 0xa7, 0xe8, 0x87, 0xbc, 0xe8, 0x88, 0x85, 0xe5, 0x92, 0x8e,
  0xe5, 0xb0, 0xb1, 0xe7, 0x96, 0x9a, 0xe9, 0x9e, 0xa0, 0xe6, 0x8b, 0x98,
  0xe7, 0x8b, 0x99, 0xe7, 0x96, 0xbd, 0xe5, 0xb1, 0x85, 0xe9, 0xa9, 0xb9,
  0xe8, 0x8f, 0x8a, 0xe5, 0xb1, 0x80, 0xe5, 0x92, 0x80, 0xe7, 0x9f, 0xa9,
  0xe4, 0xb8, 0xbe, 0xe6, 0xb2, 0xae, 0xe8, 0x81, 0x9a, 0xe6, 0x8b, 0x92,
  0xe6, 0x8d, 0xae, 0xe5, 0xb7, 0xa8, 0xe5, 0x85, 0xb7, 0xe8, 0xb7, 0x9d,
  0xe8, 0xb8, 0x9e, 0xe9, 0x94, 0xaf, 0xe4, 0xbf, 0xb1, 0xe5, 0x8f, 0xa5,
  0xe6, 0x83, 0xa7, 0xe7, 0x82, 0xac, 0xe5, 0x89, 0xa7, 0xe6, 0x8d, 0x90,
  0xe9, 0xb9, 0x83, 0xe5, 0xa8, 0x9f, 0xe5, 0x80, 0xa6, 0xe7, 0x9c, 0xb7,
  0xe5, 0x8d, 0xb7, 0xe7, 0xbb, 0xa2, 0xe6, 0x92, 0x85, 0xe6, 0x94, 0xab,
  0xe6, 0x8a, 0x89, 0xe6, 0x8e, 0x98, 0xe5, 0x80, 0x94, 0xe7, 0x88, 0xb5,
  0xe8, 0xa7, 0x89, 0xe5, 0x86, 0xb3, 0xe8, 0xaf, 0x80, 0xe7, 0xbb, 0x9d,
  0xe5, 0x9d, 0x87, 0xe8, 0x8f, 0x8c, 0xe9, 0x92, 0xa7, 0xe5, 0x86, 0x9b,
  0xe5, 0x90, 0x9b, 0xe5, 0xb3, 0xbb
};

unsigned char gb2312_row_31_converted_to_utf8[] = {
  0xe4, 0xbf, 0x8a, 0xe7, 0xab, 0xa3, 0xe6, 0xb5, 0x9a, 0xe9, 0x83, 0xa1,
  0xe9, 0xaa, 0x8f, 0xe5, 0x96, 0x80, 0xe5, 0x92, 0x96, 0xe5, 0x8d, 0xa1,
  0xe5, 0x92, 0xaf, 0xe5, 0xbc, 0x80, 0xe6, 0x8f, 0xa9, 0xe6, 0xa5, 0xb7,
  0xe5, 0x87, 0xaf, 0xe6, 0x85, 0xa8, 0xe5, 0x88, 0x8a, 0xe5, 0xa0, 0xaa,
  0xe5, 0x8b, 0x98, 0xe5, 0x9d, 0x8e, 0xe7, 0xa0, 0x8d, 0xe7, 0x9c, 0x8b,
  0xe5, 0xba, 0xb7, 0xe6, 0x85, 0xb7, 0xe7, 0xb3, 0xa0, 0xe6, 0x89, 0x9b,
  0xe6, 0x8a, 0x97, 0xe4, 0xba, 0xa2, 0xe7, 0x82, 0x95, 0xe8, 0x80, 0x83,
  0xe6, 0x8b, 0xb7, 0xe7, 0x83, 0xa4, 0xe9, 0x9d, 0xa0, 0xe5, 0x9d, 0xb7,
  0xe8, 0x8b, 0x9b, 0xe6, 0x9f, 0xaf, 0xe6, 0xa3, 0xb5, 0xe7, 0xa3, 0x95,
  0xe9, 0xa2, 0x97, 0xe7, 0xa7, 0x91, 0xe5, 0xa3, 0xb3, 0xe5, 0x92, 0xb3,
  0xe5, 0x8f, 0xaf, 0xe6, 0xb8, 0xb4, 0xe5, 0x85, 0x8b, 0xe5, 0x88, 0xbb,
  0xe5, 0xae, 0xa2, 0xe8, 0xaf, 0xbe, 0xe8, 0x82, 0xaf, 0xe5, 0x95, 0x83,
  0xe5, 0x9e, 0xa6, 0xe6, 0x81, 0xb3, 0xe5, 0x9d, 0x91, 0xe5, 0x90, 0xad,
  0xe7, 0xa9, 0xba, 0xe6, 0x81, 0x90, 0xe5, 0xad, 0x94, 0xe6, 0x8e, 0xa7,
  0xe6, 0x8a, 0xa0, 0xe5, 0x8f, 0xa3, 0xe6, 0x89, 0xa3, 0xe5, 0xaf, 0x87,
  0xe6, 0x9e, 0xaf, 0xe5, 0x93, 0xad, 0xe7, 0xaa, 0x9f, 0xe8, 0x8b, 0xa6,
  0xe9, 0x85, 0xb7, 0xe5, 0xba, 0x93, 0xe8, 0xa3, 0xa4, 0xe5, 0xa4, 0xb8,
  0xe5, 0x9e, 0xae, 0xe6, 0x8c, 0x8e, 0xe8, 0xb7, 0xa8, 0xe8, 0x83, 0xaf,
  0xe5, 0x9d, 0x97, 0xe7, 0xad, 0xb7, 0xe4, 0xbe, 0xa9, 0xe5, 0xbf, 0xab,
  0xe5, 0xae, 0xbd, 0xe6, 0xac, 0xbe, 0xe5, 0x8c, 0xa1, 0xe7, 0xad, 0x90,
  0xe7, 0x8b, 0x82, 0xe6, 0xa1, 0x86, 0xe7, 0x9f, 0xbf, 0xe7, 0x9c, 0xb6,
  0xe6, 0x97, 0xb7, 0xe5, 0x86, 0xb5, 0xe4, 0xba, 0x8f, 0xe7, 0x9b, 0x94,
  0xe5, 0xb2, 0xbf, 0xe7, 0xaa, 0xa5, 0xe8, 0x91, 0xb5, 0xe5, 0xa5, 0x8e,
  0xe9, 0xad, 0x81, 0xe5, 0x82, 0x80
};

unsigned char gb2312_row_32_converted_to_utf8[] = {
  0xe9, 0xa6, 0x88, 0xe6, 0x84, 0xa7, 0xe6, 0xba, 0x83, 0xe5, 0x9d, 0xa4,
  0xe6, 0x98, 0x86, 0xe6, 0x8d, 0x86, 0xe5, 0x9b, 0xb0, 0xe6, 0x8b, 0xac,
  0xe6, 0x89, 0xa9, 0xe5, 0xbb, 0x93, 0xe9, 0x98, 0x94, 0xe5, 0x9e, 0x83,
  0xe6, 0x8b, 0x89, 0xe5, 0x96, 0x87, 0xe8, 0x9c, 0xa1, 0xe8, 0x85, 0x8a,
  0xe8, 0xbe, 0xa3, 0xe5, 0x95, 0xa6, 0xe8, 0x8e, 0xb1, 0xe6, 0x9d, 0xa5,
  0xe8, 0xb5, 0x96, 0xe8, 0x93, 0x9d, 0xe5, 0xa9, 0xaa, 0xe6, 0xa0, 0x8f,
  0xe6, 0x8b, 0xa6, 0xe7, 0xaf, 0xae, 0xe9, 0x98, 0x91, 0xe5, 0x85, 0xb0,
  0xe6, 0xbe, 0x9c, 0xe8, 0xb0, 0xb0, 0xe6, 0x8f, 0xbd, 0xe8, 0xa7, 0x88,
  0xe6, 0x87, 0x92, 0xe7, 0xbc, 0x86, 0xe7, 0x83, 0x82, 0xe6, 0xbb, 0xa5,
  0xe7, 0x90, 0x85, 0xe6, 0xa6, 0x94, 0xe7, 0x8b, 0xbc, 0xe5, 0xbb, 0x8a,
  0xe9, 0x83, 0x8e, 0xe6, 0x9c, 0x97, 0xe6, 0xb5, 0xaa, 0xe6, 0x8d, 0x9e,
  0xe5, 0x8a, 0xb3, 0xe7, 0x89, 0xa2, 0xe8, 0x80, 0x81, 0xe4, 0xbd, 0xac,
  0xe5, 0xa7, 0xa5, 0xe9, 0x85, 0xaa, 0xe7, 0x83, 0x99, 0xe6, 0xb6, 0x9d,
  0xe5, 0x8b, 0x92, 0xe4, 0xb9, 0x90, 0xe9, 0x9b, 0xb7, 0xe9, 0x95, 0xad,
  0xe8, 0x95, 0xbe, 0xe7, 0xa3, 0x8a, 0xe7, 0xb4, 0xaf, 0xe5, 0x84, 0xa1,
  0xe5, 0x9e, 0x92, 0xe6, 0x93, 0x82, 0xe8, 0x82, 0x8b, 0xe7, 0xb1, 0xbb,
  0xe6, 0xb3, 0xaa, 0xe6, 0xa3, 0xb1, 0xe6, 0xa5, 0x9e, 0xe5, 0x86, 0xb7,
  0xe5, 0x8e, 0x98, 0xe6, 0xa2, 0xa8, 0xe7, 0x8a, 0x81, 0xe9, 0xbb, 0x8e,
  0xe7, 0xaf, 0xb1, 0xe7, 0x8b, 0xb8, 0xe7, 0xa6, 0xbb, 0xe6, 0xbc, 0x93,
  0xe7, 0x90, 0x86, 0xe6, 0x9d, 0x8e, 0xe9, 0x87, 0x8c, 0xe9, 0xb2, 0xa4,
  0xe7, 0xa4, 0xbc, 0xe8, 0x8e, 0x89, 0xe8, 0x8d, 0x94, 0xe5, 0x90, 0x8f,
  0xe6, 0xa0, 0x97, 0xe4, 0xb8, 0xbd, 0xe5, 0x8e, 0x89, 0xe5, 0x8a, 0xb1,
  0xe7, 0xa0, 0xbe, 0xe5, 0x8e, 0x86, 0xe5, 0x88, 0xa9, 0xe5, 0x82, 0x88,
  0xe4, 0xbe, 0x8b, 0xe4, 0xbf, 0x90
};

unsigned char gb2312_row_33_converted_to_utf8[] = {
  0xe7, 0x97, 0xa2, 0xe7, 0xab, 0x8b, 0xe7, 0xb2, 0x92, 0xe6, 0xb2, 0xa5,
  0xe9, 0x9a, 0xb6, 0xe5, 0x8a, 0x9b, 0xe7, 0x92, 0x83, 0xe5, 0x93, 0xa9,
  0xe4, 0xbf, 0xa9, 0xe8, 0x81, 0x94, 0xe8, 0x8e, 0xb2, 0xe8, 0xbf, 0x9e,
  0xe9, 0x95, 0xb0, 0xe5, 0xbb, 0x89, 0xe6, 0x80, 0x9c, 0xe6, 0xb6, 0x9f,
  0xe5, 0xb8, 0x98, 0xe6, 0x95, 0x9b, 0xe8, 0x84, 0xb8, 0xe9, 0x93, 0xbe,
  0xe6, 0x81, 0x8b, 0xe7, 0x82, 0xbc, 0xe7, 0xbb, 0x83, 0xe7, 0xb2, 0xae,
  0xe5, 0x87, 0x89, 0xe6, 0xa2, 0x81, 0xe7, 0xb2, 0xb1, 0xe8, 0x89, 0xaf,
  0xe4, 0xb8, 0xa4, 0xe8, 0xbe, 0x86, 0xe9, 0x87, 0x8f, 0xe6, 0x99, 0xbe,
  0xe4, 0xba, 0xae, 0xe8, 0xb0, 0x85, 0xe6, 0x92, 0xa9, 0xe8, 0x81, 0x8a,
  0xe5, 0x83, 0x9a, 0xe7, 0x96, 0x97, 0xe7, 0x87, 0x8e, 0xe5, 0xaf, 0xa5,
  0xe8, 0xbe, 0xbd, 0xe6, 0xbd, 0xa6, 0xe4, 0xba, 0x86, 0xe6, 0x92, 0x82,
  0xe9, 0x95, 0xa3, 0xe5, 0xbb, 0x96, 0xe6, 0x96, 0x99, 0xe5, 0x88, 0x97,
  0xe8, 0xa3, 0x82, 0xe7, 0x83, 0x88, 0xe5, 0x8a, 0xa3, 0xe7, 0x8c, 0x8e,
  0xe7, 0x90, 0xb3, 0xe6, 0x9e, 0x97, 0xe7, 0xa3, 0xb7, 0xe9, 0x9c, 0x96,
  0xe4, 0xb8, 0xb4, 0xe9, 0x82, 0xbb, 0xe9, 0xb3, 0x9e, 0xe6, 0xb7, 0x8b,
  0xe5, 0x87, 0x9b, 0xe8, 0xb5, 0x81, 0xe5, 0x90, 0x9d, 0xe6, 0x8b, 0x8e,
  0xe7, 0x8e, 0xb2, 0xe8, 0x8f, 0xb1, 0xe9, 0x9b, 0xb6, 0xe9, 0xbe, 0x84,
  0xe9, 0x93, 0x83, 0xe4, 0xbc, 0xb6, 0xe7, 0xbe, 0x9a, 0xe5, 0x87, 0x8c,
  0xe7, 0x81, 0xb5, 0xe9, 0x99, 0xb5, 0xe5, 0xb2, 0xad, 0xe9, 0xa2, 0x86,
  0xe5, 0x8f, 0xa6, 0xe4, 0xbb, 0xa4, 0xe6, 0xba, 0x9c, 0xe7, 0x90, 0x89,
  0xe6, 0xa6, 0xb4, 0xe7, 0xa1, 0xab, 0xe9, 0xa6, 0x8f, 0xe7, 0x95, 0x99,
  0xe5, 0x88, 0x98, 0xe7, 0x98, 0xa4, 0xe6, 0xb5, 0x81, 0xe6, 0x9f, 0xb3,
  0xe5, 0x85, 0xad, 0xe9, 0xbe, 0x99, 0xe8, 0x81, 0x8b, 0xe5, 0x92, 0x99,
  0xe7, 0xac, 0xbc, 0xe7, 0xaa, 0xbf
};

unsigned char gb2312_row_34_converted_to_utf8[] = {
  0xe9, 0x9a, 0x86, 0xe5, 0x9e, 0x84, 0xe6, 0x8b, 0xa2, 0xe9, 0x99, 0x87,
  0xe6, 0xa5, 0xbc, 0xe5, 0xa8, 0x84, 0xe6, 0x90, 0x82, 0xe7, 0xaf, 0x93,
  0xe6, 0xbc, 0x8f, 0xe9, 0x99, 0x8b, 0xe8, 0x8a, 0xa6, 0xe5, 0x8d, 0xa2,
  0xe9, 0xa2, 0x85, 0xe5, 0xba, 0x90, 0xe7, 0x82, 0x89, 0xe6, 0x8e, 0xb3,
  0xe5, 0x8d, 0xa4, 0xe8, 0x99, 0x8f, 0xe9, 0xb2, 0x81, 0xe9, 0xba, 0x93,
  0xe7, 0xa2, 0x8c, 0xe9, 0x9c, 0xb2, 0xe8, 0xb7, 0xaf, 0xe8, 0xb5, 0x82,
  0xe9, 0xb9, 0xbf, 0xe6, 0xbd, 0x9e, 0xe7, 0xa6, 0x84, 0xe5, 0xbd, 0x95,
  0xe9, 0x99, 0x86, 0xe6, 0x88, 0xae, 0xe9, 0xa9, 0xb4, 0xe5, 0x90, 0x95,
  0xe9, 0x93, 0x9d, 0xe4, 0xbe, 0xa3, 0xe6, 0x97, 0x85, 0xe5, 0xb1, 0xa5,
  0xe5, 0xb1, 0xa1, 0xe7, 0xbc, 0x95, 0xe8, 0x99, 0x91, 0xe6, 0xb0, 0xaf,
  0xe5, 0xbe, 0x8b, 0xe7, 0x8e, 0x87, 0xe6, 0xbb, 0xa4, 0xe7, 0xbb, 0xbf,
  0xe5, 0xb3, 0xa6, 0xe6, 0x8c, 0x9b, 0xe5, 0xad, 0xaa, 0xe6, 0xbb, 0xa6,
  0xe5, 0x8d, 0xb5, 0xe4, 0xb9, 0xb1, 0xe6, 0x8e, 0xa0, 0xe7, 0x95, 0xa5,
  0xe6, 0x8a, 0xa1, 0xe8, 0xbd, 0xae, 0xe4, 0xbc, 0xa6, 0xe4, 0xbb, 0x91,
  0xe6, 0xb2, 0xa6, 0xe7, 0xba, 0xb6, 0xe8, 0xae, 0xba, 0xe8, 0x90, 0x9d,
  0xe8, 0x9e, 0xba, 0xe7, 0xbd, 0x97, 0xe9, 0x80, 0xbb, 0xe9, 0x94, 0xa3,
  0xe7, 0xae, 0xa9, 0xe9, 0xaa, 0xa1, 0xe8, 0xa3, 0xb8, 0xe8, 0x90, 0xbd,
  0xe6, 0xb4, 0x9b, 0xe9, 0xaa, 0x86, 0xe7, 0xbb, 0x9c, 0xe5, 0xa6, 0x88,
  0xe9, 0xba, 0xbb, 0xe7, 0x8e, 0x9b, 0xe7, 0xa0, 0x81, 0xe8, 0x9a, 0x82,
  0xe9, 0xa9, 0xac, 0xe9, 0xaa, 0x82, 0xe5, 0x98, 0x9b, 0xe5, 0x90, 0x97,
  0xe5, 0x9f, 0x8b, 0xe4, 0xb9, 0xb0, 0xe9, 0xba, 0xa6, 0xe5, 0x8d, 0x96,
  0xe8, 0xbf, 0x88, 0xe8, 0x84, 0x89, 0xe7, 0x9e, 0x92, 0xe9, 0xa6, 0x92,
  0xe8, 0x9b, 0xae, 0xe6, 0xbb, 0xa1, 0xe8, 0x94, 0x93, 0xe6, 0x9b, 0xbc,
  0xe6, 0x85, 0xa2, 0xe6, 0xbc, 0xab
};

unsigned char gb2312_row_35_converted_to_utf8[] = {
  0xe8, 0xb0, 0xa9, 0xe8, 0x8a, 0x92, 0xe8, 0x8c, 0xab, 0xe7, 0x9b, 0xb2,
  0xe6, 0xb0, 0x93, 0xe5, 0xbf, 0x99, 0xe8, 0x8e, 0xbd, 0xe7, 0x8c, 0xab,
  0xe8, 0x8c, 0x85, 0xe9, 0x94, 0x9a, 0xe6, 0xaf, 0x9b, 0xe7, 0x9f, 0x9b,
  0xe9, 0x93, 0x86, 0xe5, 0x8d, 0xaf, 0xe8, 0x8c, 0x82, 0xe5, 0x86, 0x92,
  0xe5, 0xb8, 0xbd, 0xe8, 0xb2, 0x8c, 0xe8, 0xb4, 0xb8, 0xe4, 0xb9, 0x88,
  0xe7, 0x8e, 0xab, 0xe6, 0x9e, 0x9a, 0xe6, 0xa2, 0x85, 0xe9, 0x85, 0xb6,
  0xe9, 0x9c, 0x89, 0xe7, 0x85, 0xa4, 0xe6, 0xb2, 0xa1, 0xe7, 0x9c, 0x89,
  0xe5, 0xaa, 0x92, 0xe9, 0x95, 0x81, 0xe6, 0xaf, 0x8f, 0xe7, 0xbe, 0x8e,
  0xe6, 0x98, 0xa7, 0xe5, 0xaf, 0x90, 0xe5, 0xa6, 0xb9, 0xe5, 0xaa, 0x9a,
  0xe9, 0x97, 0xa8, 0xe9, 0x97, 0xb7, 0xe4, 0xbb, 0xac, 0xe8, 0x90, 0x8c,
  0xe8, 0x92, 0x99, 0xe6, 0xaa, 0xac, 0xe7, 0x9b, 0x9f, 0xe9, 0x94, 0xb0,
  0xe7, 0x8c, 0x9b, 0xe6, 0xa2, 0xa6, 0xe5, 0xad, 0x9f, 0xe7, 0x9c, 0xaf,
  0xe9, 0x86, 0x9a, 0xe9, 0x9d, 0xa1, 0xe7, 0xb3, 0x9c, 0xe8, 0xbf, 0xb7,
  0xe8, 0xb0, 0x9c, 0xe5, 0xbc, 0xa5, 0xe7, 0xb1, 0xb3, 0xe7, 0xa7, 0x98,
  0xe8, 0xa7, 0x85, 0xe6, 0xb3, 0x8c, 0xe8, 0x9c, 0x9c, 0xe5, 0xaf, 0x86,
  0xe5, 0xb9, 0x82, 0xe6, 0xa3, 0x89, 0xe7, 0x9c, 0xa0, 0xe7, 0xbb, 0xb5,
  0xe5, 0x86, 0x95, 0xe5, 0x85, 0x8d, 0xe5, 0x8b, 0x89, 0xe5, 0xa8, 0xa9,
  0xe7, 0xbc, 0x85, 0xe9, 0x9d, 0xa2, 0xe8, 0x8b, 0x97, 0xe6, 0x8f, 0x8f,
  0xe7, 0x9e, 0x84, 0xe8, 0x97, 0x90, 0xe7, 0xa7, 0x92, 0xe6, 0xb8, 0xba,
  0xe5, 0xba, 0x99, 0xe5, 0xa6, 0x99, 0xe8, 0x94, 0x91, 0xe7, 0x81, 0xad,
  0xe6, 0xb0, 0x91, 0xe6, 0x8a, 0xbf, 0xe7, 0x9a, 0xbf, 0xe6, 0x95, 0x8f,
  0xe6, 0x82, 0xaf, 0xe9, 0x97, 0xbd, 0xe6, 0x98, 0x8e, 0xe8, 0x9e, 0x9f,
  0xe9, 0xb8, 0xa3, 0xe9, 0x93, 0xad, 0xe5, 0x90, 0x8d, 0xe5, 0x91, 0xbd,
  0xe8, 0xb0, 0xac, 0xe6, 0x91, 0xb8
};

unsigned char gb2312_row_36_converted_to_utf8[] = {
  0xe6, 0x91, 0xb9, 0xe8, 0x98, 0x91, 0xe6, 0xa8, 0xa1, 0xe8, 0x86, 0x9c,
  0xe7, 0xa3, 0xa8, 0xe6, 0x91, 0xa9, 0xe9, 0xad, 0x94, 0xe6, 0x8a, 0xb9,
  0xe6, 0x9c, 0xab, 0xe8, 0x8e, 0xab, 0xe5, 0xa2, 0xa8, 0xe9, 0xbb, 0x98,
  0xe6, 0xb2, 0xab, 0xe6, 0xbc, 0xa0, 0xe5, 0xaf, 0x9e, 0xe9, 0x99, 0x8c,
  0xe8, 0xb0, 0x8b, 0xe7, 0x89, 0x9f, 0xe6, 0x9f, 0x90, 0xe6, 0x8b, 0x87,
  0xe7, 0x89, 0xa1, 0xe4, 0xba, 0xa9, 0xe5, 0xa7, 0x86, 0xe6, 0xaf, 0x8d,
  0xe5, 0xa2, 0x93, 0xe6, 0x9a, 0xae, 0xe5, 0xb9, 0x95, 0xe5, 0x8b, 0x9f,
  0xe6, 0x85, 0x95, 0xe6, 0x9c, 0xa8, 0xe7, 0x9b, 0xae, 0xe7, 0x9d, 0xa6,
  0xe7, 0x89, 0xa7, 0xe7, 0xa9, 0x86, 0xe6, 0x8b, 0xbf, 0xe5, 0x93, 0xaa,
  0xe5, 0x91, 0x90, 0xe9, 0x92, 0xa0, 0xe9, 0x82, 0xa3, 0xe5, 0xa8, 0x9c,
  0xe7, 0xba, 0xb3, 0xe6, 0xb0, 0x96, 0xe4, 0xb9, 0x83, 0xe5, 0xa5, 0xb6,
  0xe8, 0x80, 0x90, 0xe5, 0xa5, 0x88, 0xe5, 0x8d, 0x97, 0xe7, 0x94, 0xb7,
  0xe9, 0x9a, 0xbe, 0xe5, 0x9b, 0x8a, 0xe6, 0x8c, 0xa0, 0xe8, 0x84, 0x91,
  0xe6, 0x81, 0xbc, 0xe9, 0x97, 0xb9, 0xe6, 0xb7, 0x96, 0xe5, 0x91, 0xa2,
  0xe9, 0xa6, 0x81, 0xe5, 0x86, 0x85, 0xe5, 0xab, 0xa9, 0xe8, 0x83, 0xbd,
  0xe5, 0xa6, 0xae, 0xe9, 0x9c, 0x93, 0xe5, 0x80, 0xaa, 0xe6, 0xb3, 0xa5,
  0xe5, 0xb0, 0xbc, 0xe6, 0x8b, 0x9f, 0xe4, 0xbd, 0xa0, 0xe5, 0x8c, 0xbf,
  0xe8, 0x85, 0xbb, 0xe9, 0x80, 0x86, 0xe6, 0xba, 0xba, 0xe8, 0x94, 0xab,
  0xe6, 0x8b, 0x88, 0xe5, 0xb9, 0xb4, 0xe7, 0xa2, 0xbe, 0xe6, 0x92, 0xb5,
  0xe6, 0x8d, 0xbb, 0xe5, 0xbf, 0xb5, 0xe5, 0xa8, 0x98, 0xe9, 0x85, 0xbf,
  0xe9, 0xb8, 0x9f, 0xe5, 0xb0, 0xbf, 0xe6, 0x8d, 0x8f, 0xe8, 0x81, 0x82,
  0xe5, 0xad, 0xbd, 0xe5, 0x95, 0xae, 0xe9, 0x95, 0x8a, 0xe9, 0x95, 0x8d,
  0xe6, 0xb6, 0x85, 0xe6, 0x82, 0xa8, 0xe6, 0x9f, 0xa0, 0xe7, 0x8b, 0x9e,
  0xe5, 0x87, 0x9d, 0xe5, 0xae, 0x81
};

unsigned char gb2312_row_37_converted_to_utf8[] = {
  0xe6, 0x8b, 0xa7, 0xe6, 0xb3, 0x9e, 0xe7, 0x89, 0x9b, 0xe6, 0x89, 0xad,
  0xe9, 0x92, 0xae, 0xe7, 0xba, 0xbd, 0xe8, 0x84, 0x93, 0xe6, 0xb5, 0x93,
  0xe5, 0x86, 0x9c, 0xe5, 0xbc, 0x84, 0xe5, 0xa5, 0xb4, 0xe5, 0x8a, 0xaa,
  0xe6, 0x80, 0x92, 0xe5, 0xa5, 0xb3, 0xe6, 0x9a, 0x96, 0xe8, 0x99, 0x90,
  0xe7, 0x96, 0x9f, 0xe6, 0x8c, 0xaa, 0xe6, 0x87, 0xa6, 0xe7, 0xb3, 0xaf,
  0xe8, 0xaf, 0xba, 0xe5, 0x93, 0xa6, 0xe6, 0xac, 0xa7, 0xe9, 0xb8, 0xa5,
  0xe6, 0xae, 0xb4, 0xe8, 0x97, 0x95, 0xe5, 0x91, 0x95, 0xe5, 0x81, 0xb6,
  0xe6, 0xb2, 0xa4, 0xe5, 0x95, 0xaa, 0xe8, 0xb6, 0xb4, 0xe7, 0x88, 0xac,
  0xe5, 0xb8, 0x95, 0xe6, 0x80, 0x95, 0xe7, 0x90, 0xb6, 0xe6, 0x8b, 0x8d,
  0xe6, 0x8e, 0x92, 0xe7, 0x89, 0x8c, 0xe5, 0xbe, 0x98, 0xe6, 0xb9, 0x83,
  0xe6, 0xb4, 0xbe, 0xe6, 0x94, 0x80, 0xe6, 0xbd, 0x98, 0xe7, 0x9b, 0x98,
  0xe7, 0xa3, 0x90, 0xe7, 0x9b, 0xbc, 0xe7, 0x95, 0x94, 0xe5, 0x88, 0xa4,
  0xe5, 0x8f, 0x9b, 0xe4, 0xb9, 0x93, 0xe5, 0xba, 0x9e, 0xe6, 0x97, 0x81,
  0xe8, 0x80, 0xaa, 0xe8, 0x83, 0x96, 0xe6, 0x8a, 0x9b, 0xe5, 0x92, 0x86,
  0xe5, 0x88, 0xa8, 0xe7, 0x82, 0xae, 0xe8, 0xa2, 0x8d, 0xe8, 0xb7, 0x91,
  0xe6, 0xb3, 0xa1, 0xe5, 0x91, 0xb8, 0xe8, 0x83, 0x9a, 0xe5, 0x9f, 0xb9,
  0xe8, 0xa3, 0xb4, 0xe8, 0xb5, 0x94, 0xe9, 0x99, 0xaa, 0xe9, 0x85, 0x8d,
  0xe4, 0xbd, 0xa9, 0xe6, 0xb2, 0x9b, 0xe5, 0x96, 0xb7, 0xe7, 0x9b, 0x86,
  0xe7, 0xa0, 0xb0, 0xe6, 0x8a, 0xa8, 0xe7, 0x83, 0xb9, 0xe6, 0xbe, 0x8e,
  0xe5, 0xbd, 0xad, 0xe8, 0x93, 0xac, 0xe6, 0xa3, 0x9a, 0xe7, 0xa1, 0xbc,
  0xe7, 0xaf, 0xb7, 0xe8, 0x86, 0xa8, 0xe6, 0x9c, 0x8b, 0xe9, 0xb9, 0x8f,
  0xe6, 0x8d, 0xa7, 0xe7, 0xa2, 0xb0, 0xe5, 0x9d, 0xaf, 0xe7, 0xa0, 0x92,
  0xe9, 0x9c, 0xb9, 0xe6, 0x89, 0xb9, 0xe6, 0x8a, 0xab, 0xe5, 0x8a, 0x88,
  0xe7, 0x90, 0xb5, 0xe6, 0xaf, 0x97
};

unsigned char gb2312_row_38_converted_to_utf8[] = {
  0xe5, 0x95, 0xa4, 0xe8, 0x84, 0xbe, 0xe7, 0x96, 0xb2, 0xe7, 0x9a, 0xae,
  0xe5, 0x8c, 0xb9, 0xe7, 0x97, 0x9e, 0xe5, 0x83, 0xbb, 0xe5, 0xb1, 0x81,
  0xe8, 0xad, 0xac, 0xe7, 0xaf, 0x87, 0xe5, 0x81, 0x8f, 0xe7, 0x89, 0x87,
  0xe9, 0xaa, 0x97, 0xe9, 0xa3, 0x98, 0xe6, 0xbc, 0x82, 0xe7, 0x93, 0xa2,
  0xe7, 0xa5, 0xa8, 0xe6, 0x92, 0x87, 0xe7, 0x9e, 0xa5, 0xe6, 0x8b, 0xbc,
  0xe9, 0xa2, 0x91, 0xe8, 0xb4, 0xab, 0xe5, 0x93, 0x81, 0xe8, 0x81, 0x98,
  0xe4, 0xb9, 0x92, 0xe5, 0x9d, 0xaa, 0xe8, 0x8b, 0xb9, 0xe8, 0x90, 0x8d,
  0xe5, 0xb9, 0xb3, 0xe5, 0x87, 0xad, 0xe7, 0x93, 0xb6, 0xe8, 0xaf, 0x84,
  0xe5, 0xb1, 0x8f, 0xe5, 0x9d, 0xa1, 0xe6, 0xb3, 0xbc, 0xe9, 0xa2, 0x87,
  0xe5, 0xa9, 0x86, 0xe7, 0xa0, 0xb4, 0xe9, 0xad, 0x84, 0xe8, 0xbf, 0xab,
  0xe7, 0xb2, 0x95, 0xe5, 0x89, 0x96, 0xe6, 0x89, 0x91, 0xe9, 0x93, 0xba,
  0xe4, 0xbb, 0x86, 0xe8, 0x8e, 0x86, 0xe8, 0x91, 0xa1, 0xe8, 0x8f, 0xa9,
  0xe8, 0x92, 0xb2, 0xe5, 0x9f, 0x94, 0xe6, 0x9c, 0xb4, 0xe5, 0x9c, 0x83,
  0xe6, 0x99, 0xae, 0xe6, 0xb5, 0xa6, 0xe8, 0xb0, 0xb1, 0xe6, 0x9b, 0x9d,
  0xe7, 0x80, 0x91, 0xe6, 0x9c, 0x9f, 0xe6, 0xac, 0xba, 0xe6, 0xa0, 0x96,
  0xe6, 0x88, 0x9a, 0xe5, 0xa6, 0xbb, 0xe4, 0xb8, 0x83, 0xe5, 0x87, 0x84,
  0xe6, 0xbc, 0x86, 0xe6, 0x9f, 0x92, 0xe6, 0xb2, 0x8f, 0xe5, 0x85, 0xb6,
  0xe6, 0xa3, 0x8b, 0xe5, 0xa5, 0x87, 0xe6, 0xad, 0xa7, 0xe7, 0x95, 0xa6,
  0xe5, 0xb4, 0x8e, 0xe8, 0x84, 0x90, 0xe9, 0xbd, 0x90, 0xe6, 0x97, 0x97,
  0xe7, 0xa5, 0x88, 0xe7, 0xa5, 0x81, 0xe9, 0xaa, 0x91, 0xe8, 0xb5, 0xb7,
  0xe5, 0xb2, 0x82, 0xe4, 0xb9, 0x9e, 0xe4, 0xbc, 0x81, 0xe5, 0x90, 0xaf,
  0xe5, 0xa5, 0x91, 0xe7, 0xa0, 0x8c, 0xe5, 0x99, 0xa8, 0xe6, 0xb0, 0x94,
  0xe8, 0xbf, 0x84, 0xe5, 0xbc, 0x83, 0xe6, 0xb1, 0xbd, 0xe6, 0xb3, 0xa3,
  0xe8, 0xae, 0xab, 0xe6, 0x8e, 0x90
};

unsigned char gb2312_row_39_converted_to_utf8[] = {
  0xe6, 0x81, 0xb0, 0xe6, 0xb4, 0xbd, 0xe7, 0x89, 0xb5, 0xe6, 0x89, 0xa6,
  0xe9, 0x92, 0x8e, 0xe9, 0x93, 0x85, 0xe5, 0x8d, 0x83, 0xe8, 0xbf, 0x81,
  0xe7, 0xad, 0xbe, 0xe4, 0xbb, 0x9f, 0xe8, 0xb0, 0xa6, 0xe4, 0xb9, 0xbe,
  0xe9, 0xbb, 0x94, 0xe9, 0x92, 0xb1, 0xe9, 0x92, 0xb3, 0xe5, 0x89, 0x8d,
  0xe6, 0xbd, 0x9c, 0xe9, 0x81, 0xa3, 0xe6, 0xb5, 0x85, 0xe8, 0xb0, 0xb4,
  0xe5, 0xa0, 0x91, 0xe5, 0xb5, 0x8c, 0xe6, 0xac, 0xa0, 0xe6, 0xad, 0x89,
  0xe6, 0x9e, 0xaa, 0xe5, 0x91, 0x9b, 0xe8, 0x85, 0x94, 0xe7, 0xbe, 0x8c,
  0xe5, 0xa2, 0x99, 0xe8, 0x94, 0xb7, 0xe5, 0xbc, 0xba, 0xe6, 0x8a, 0xa2,
  0xe6, 0xa9, 0x87, 0xe9, 0x94, 0xb9, 0xe6, 0x95, 0xb2, 0xe6, 0x82, 0x84,
  0xe6, 0xa1, 0xa5, 0xe7, 0x9e, 0xa7, 0xe4, 0xb9, 0x94, 0xe4, 0xbe, 0xa8,
  0xe5, 0xb7, 0xa7, 0xe9, 0x9e, 0x98, 0xe6, 0x92, 0xac, 0xe7, 0xbf, 0x98,
  0xe5, 0xb3, 0xad, 0xe4, 0xbf, 0x8f, 0xe7, 0xaa, 0x8d, 0xe5, 0x88, 0x87,
  0xe8, 0x8c, 0x84, 0xe4, 0xb8, 0x94, 0xe6, 0x80, 0xaf, 0xe7, 0xaa, 0x83,
  0xe9, 0x92, 0xa6, 0xe4, 0xbe, 0xb5, 0xe4, 0xba, 0xb2, 0xe7, 0xa7, 0xa6,
  0xe7, 0x90, 0xb4, 0xe5, 0x8b, 0xa4, 0xe8, 0x8a, 0xb9, 0xe6, 0x93, 0x92,
  0xe7, 0xa6, 0xbd, 0xe5, 0xaf, 0x9d, 0xe6, 0xb2, 0x81, 0xe9, 0x9d, 0x92,
  0xe8, 0xbd, 0xbb, 0xe6, 0xb0, 0xa2, 0xe5, 0x80, 0xbe, 0xe5, 0x8d, 0xbf,
  0xe6, 0xb8, 0x85, 0xe6, 0x93, 0x8e, 0xe6, 0x99, 0xb4, 0xe6, 0xb0, 0xb0,
  0xe6, 0x83, 0x85, 0xe9, 0xa1, 0xb7, 0xe8, 0xaf, 0xb7, 0xe5, 0xba, 0x86,
  0xe7, 0x90, 0xbc, 0xe7, 0xa9, 0xb7, 0xe7, 0xa7, 0x8b, 0xe4, 0xb8, 0x98,
  0xe9, 0x82, 0xb1, 0xe7, 0x90, 0x83, 0xe6, 0xb1, 0x82, 0xe5, 0x9b, 0x9a,
  0xe9, 0x85, 0x8b, 0xe6, 0xb3, 0x85, 0xe8, 0xb6, 0x8b, 0xe5, 0x8c, 0xba,
  0xe8, 0x9b, 0x86, 0xe6, 0x9b, 0xb2, 0xe8, 0xba, 0xaf, 0xe5, 0xb1, 0x88,
  0xe9, 0xa9, 0xb1, 0xe6, 0xb8, 0xa0
};

unsigned char gb2312_row_40_converted_to_utf8[] = {
  0xe5, 0x8f, 0x96, 0xe5, 0xa8, 0xb6, 0xe9, 0xbe, 0x8b, 0xe8, 0xb6, 0xa3,
  0xe5, 0x8e, 0xbb, 0xe5, 0x9c, 0x88, 0xe9, 0xa2, 0xa7, 0xe6, 0x9d, 0x83,
  0xe9, 0x86, 0x9b, 0xe6, 0xb3, 0x89, 0xe5, 0x85, 0xa8, 0xe7, 0x97, 0x8a,
  0xe6, 0x8b, 0xb3, 0xe7, 0x8a, 0xac, 0xe5, 0x88, 0xb8, 0xe5, 0x8a, 0x9d,
  0xe7, 0xbc, 0xba, 0xe7, 0x82, 0x94, 0xe7, 0x98, 0xb8, 0xe5, 0x8d, 0xb4,
  0xe9, 0xb9, 0x8a, 0xe6, 0xa6, 0xb7, 0xe7, 0xa1, 0xae, 0xe9, 0x9b, 0x80,
  0xe8, 0xa3, 0x99, 0xe7, 0xbe, 0xa4, 0xe7, 0x84, 0xb6, 0xe7, 0x87, 0x83,
  0xe5, 0x86, 0x89, 0xe6, 0x9f, 0x93, 0xe7, 0x93, 0xa4, 0xe5, 0xa3, 0xa4,
  0xe6, 0x94, 0x98, 0xe5, 0x9a, 0xb7, 0xe8, 0xae, 0xa9, 0xe9, 0xa5, 0xb6,
  0xe6, 0x89, 0xb0, 0xe7, 0xbb, 0x95, 0xe6, 0x83, 0xb9, 0xe7, 0x83, 0xad,
  0xe5, 0xa3, 0xac, 0xe4, 0xbb, 0x81, 0xe4, 0xba, 0xba, 0xe5, 0xbf, 0x8d,
  0xe9, 0x9f, 0xa7, 0xe4, 0xbb, 0xbb, 0xe8, 0xae, 0xa4, 0xe5, 0x88, 0x83,
  0xe5, 0xa6, 0x8a, 0xe7, 0xba, 0xab, 0xe6, 0x89, 0x94, 0xe4, 0xbb, 0x8d,
  0xe6, 0x97, 0xa5, 0xe6, 0x88, 0x8e, 0xe8, 0x8c, 0xb8, 0xe8, 0x93, 0x89,
  0xe8, 0x8d, 0xa3, 0xe8, 0x9e, 0x8d, 0xe7, 0x86, 0x94, 0xe6, 0xba, 0xb6,
  0xe5, 0xae, 0xb9, 0xe7, 0xbb, 0x92, 0xe5, 0x86, 0x97, 0xe6, 0x8f, 0x89,
  0xe6, 0x9f, 0x94, 0xe8, 0x82, 0x89, 0xe8, 0x8c, 0xb9, 0xe8, 0xa0, 0x95,
  0xe5, 0x84, 0x92, 0xe5, 0xad, 0xba, 0xe5, 0xa6, 0x82, 0xe8, 0xbe, 0xb1,
  0xe4, 0xb9, 0xb3, 0xe6, 0xb1, 0x9d, 0xe5, 0x85, 0xa5, 0xe8, 0xa4, 0xa5,
  0xe8, 0xbd, 0xaf, 0xe9, 0x98, 0xae, 0xe8, 0x95, 0x8a, 0xe7, 0x91, 0x9e,
  0xe9, 0x94, 0x90, 0xe9, 0x97, 0xb0, 0xe6, 0xb6, 0xa6, 0xe8, 0x8b, 0xa5,
  0xe5, 0xbc, 0xb1, 0xe6, 0x92, 0x92, 0xe6, 0xb4, 0x92, 0xe8, 0x90, 0xa8,
  0xe8, 0x85, 0xae, 0xe9, 0xb3, 0x83, 0xe5, 0xa1, 0x9e, 0xe8, 0xb5, 0x9b,
  0xe4, 0xb8, 0x89, 0xe5, 0x8f, 0x81
};

unsigned char gb2312_row_41_converted_to_utf8[] = {
  0xe4, 0xbc, 0x9e, 0xe6, 0x95, 0xa3, 0xe6, 0xa1, 0x91, 0xe5, 0x97, 0x93,
  0xe4, 0xb8, 0xa7, 0xe6, 0x90, 0x94, 0xe9, 0xaa, 0x9a, 0xe6, 0x89, 0xab,
  0xe5, 0xab, 0x82, 0xe7, 0x91, 0x9f, 0xe8, 0x89, 0xb2, 0xe6, 0xb6, 0xa9,
  0xe6, 0xa3, 0xae, 0xe5, 0x83, 0xa7, 0xe8, 0x8e, 0x8e, 0xe7, 0xa0, 0x82,
  0xe6, 0x9d, 0x80, 0xe5, 0x88, 0xb9, 0xe6, 0xb2, 0x99, 0xe7, 0xba, 0xb1,
  0xe5, 0x82, 0xbb, 0xe5, 0x95, 0xa5, 0xe7, 0x85, 0x9e, 0xe7, 0xad, 0x9b,
  0xe6, 0x99, 0x92, 0xe7, 0x8f, 0x8a, 0xe8, 0x8b, 0xab, 0xe6, 0x9d, 0x89,
  0xe5, 0xb1, 0xb1, 0xe5, 0x88, 0xa0, 0xe7, 0x85, 0xbd, 0xe8, 0xa1, 0xab,
  0xe9, 0x97, 0xaa, 0xe9, 0x99, 0x95, 0xe6, 0x93, 0x85, 0xe8, 0xb5, 0xa1,
  0xe8, 0x86, 0xb3, 0xe5, 0x96, 0x84, 0xe6, 0xb1, 0x95, 0xe6, 0x89, 0x87,
  0xe7, 0xbc, 0xae, 0xe5, 0xa2, 0x92, 0xe4, 0xbc, 0xa4, 0xe5, 0x95, 0x86,
  0xe8, 0xb5, 0x8f, 0xe6, 0x99, 0x8c, 0xe4, 0xb8, 0x8a, 0xe5, 0xb0, 0x9a,
  0xe8, 0xa3, 0xb3, 0xe6, 0xa2, 0xa2, 0xe6, 0x8d, 0x8e, 0xe7, 0xa8, 0x8d,
  0xe7, 0x83, 0xa7, 0xe8, 0x8a, 0x8d, 0xe5, 0x8b, 0xba, 0xe9, 0x9f, 0xb6,
  0xe5, 0xb0, 0x91, 0xe5, 0x93, 0xa8, 0xe9, 0x82, 0xb5, 0xe7, 0xbb, 0x8d,
  0xe5, 0xa5, 0xa2, 0xe8, 0xb5, 0x8a, 0xe8, 0x9b, 0x87, 0xe8, 0x88, 0x8c,
  0xe8, 0x88, 0x8d, 0xe8, 0xb5, 0xa6, 0xe6, 0x91, 0x84, 0xe5, 0xb0, 0x84,
  0xe6, 0x85, 0x91, 0xe6, 0xb6, 0x89, 0xe7, 0xa4, 0xbe, 0xe8, 0xae, 0xbe,
  0xe7, 0xa0, 0xb7, 0xe7, 0x94, 0xb3, 0xe5, 0x91, 0xbb, 0xe4, 0xbc, 0xb8,
  0xe8, 0xba, 0xab, 0xe6, 0xb7, 0xb1, 0xe5, 0xa8, 0xa0, 0xe7, 0xbb, 0x85,
  0xe7, 0xa5, 0x9e, 0xe6, 0xb2, 0x88, 0xe5, 0xae, 0xa1, 0xe5, 0xa9, 0xb6,
  0xe7, 0x94, 0x9a, 0xe8, 0x82, 0xbe, 0xe6, 0x85, 0x8e, 0xe6, 0xb8, 0x97,
  0xe5, 0xa3, 0xb0, 0xe7, 0x94, 0x9f, 0xe7, 0x94, 0xa5, 0xe7, 0x89, 0xb2,
  0xe5, 0x8d, 0x87, 0xe7, 0xbb, 0xb3
};

unsigned char gb2312_row_42_converted_to_utf8[] = {
  0xe7, 0x9c, 0x81, 0xe7, 0x9b, 0x9b, 0xe5, 0x89, 0xa9, 0xe8, 0x83, 0x9c,
  0xe5, 0x9c, 0xa3, 0xe5, 0xb8, 0x88, 0xe5, 0xa4, 0xb1, 0xe7, 0x8b, 0xae,
  0xe6, 0x96, 0xbd, 0xe6, 0xb9, 0xbf, 0xe8, 0xaf, 0x97, 0xe5, 0xb0, 0xb8,
  0xe8, 0x99, 0xb1, 0xe5, 0x8d, 0x81, 0xe7, 0x9f, 0xb3, 0xe6, 0x8b, 0xbe,
  0xe6, 0x97, 0xb6, 0xe4, 0xbb, 0x80, 0xe9, 0xa3, 0x9f, 0xe8, 0x9a, 0x80,
  0xe5, 0xae, 0x9e, 0xe8, 0xaf, 0x86, 0xe5, 0x8f, 0xb2, 0xe7, 0x9f, 0xa2,
  0xe4, 0xbd, 0xbf, 0xe5, 0xb1, 0x8e, 0xe9, 0xa9, 0xb6, 0xe5, 0xa7, 0x8b,
  0xe5, 0xbc, 0x8f, 0xe7, 0xa4, 0xba, 0xe5, 0xa3, 0xab, 0xe4, 0xb8, 0x96,
  0xe6, 0x9f, 0xbf, 0xe4, 0xba, 0x8b, 0xe6, 0x8b, 0xad, 0xe8, 0xaa, 0x93,
  0xe9, 0x80, 0x9d, 0xe5, 0x8a, 0xbf, 0xe6, 0x98, 0xaf, 0xe5, 0x97, 0x9c,
  0xe5, 0x99, 0xac, 0xe9, 0x80, 0x82, 0xe4, 0xbb, 0x95, 0xe4, 0xbe, 0x8d,
  0xe9, 0x87, 0x8a, 0xe9, 0xa5, 0xb0, 0xe6, 0xb0, 0x8f, 0xe5, 0xb8, 0x82,
  0xe6, 0x81, 0x83, 0xe5, 0xae, 0xa4, 0xe8, 0xa7, 0x86, 0xe8, 0xaf, 0x95,
  0xe6, 0x94, 0xb6, 0xe6, 0x89, 0x8b, 0xe9, 0xa6, 0x96, 0xe5, 0xae, 0x88,
  0xe5, 0xaf, 0xbf, 0xe6, 0x8e, 0x88, 0xe5, 0x94, 0xae, 0xe5, 0x8f, 0x97,
  0xe7, 0x98, 0xa6, 0xe5, 0x85, 0xbd, 0xe8, 0x94, 0xac, 0xe6, 0x9e, 0xa2,
  0xe6, 0xa2, 0xb3, 0xe6, 0xae, 0x8a, 0xe6, 0x8a, 0x92, 0xe8, 0xbe, 0x93,
  0xe5, 0x8f, 0x94, 0xe8, 0x88, 0x92, 0xe6, 0xb7, 0x91, 0xe7, 0x96, 0x8f,
  0xe4, 0xb9, 0xa6, 0xe8, 0xb5, 0x8e, 0xe5, 0xad, 0xb0, 0xe7, 0x86, 0x9f,
  0xe8, 0x96, 0xaf, 0xe6, 0x9a, 0x91, 0xe6, 0x9b, 0x99, 0xe7, 0xbd, 0xb2,
  0xe8, 0x9c, 0x80, 0xe9, 0xbb, 0x8d, 0xe9, 0xbc, 0xa0, 0xe5, 0xb1, 0x9e,
  0xe6, 0x9c, 0xaf, 0xe8, 0xbf, 0xb0, 0xe6, 0xa0, 0x91, 0xe6, 0x9d, 0x9f,
  0xe6, 0x88, 0x8d, 0xe7, 0xab, 0x96, 0xe5, 0xa2, 0x85, 0xe5, 0xba, 0xb6,
  0xe6, 0x95, 0xb0, 0xe6, 0xbc, 0xb1
};

unsigned char gb2312_row_43_converted_to_utf8[] = {
  0xe6, 0x81, 0x95, 0xe5, 0x88, 0xb7, 0xe8, 0x80, 0x8d, 0xe6, 0x91, 0x94,
  0xe8, 0xa1, 0xb0, 0xe7, 0x94, 0xa9, 0xe5, 0xb8, 0x85, 0xe6, 0xa0, 0x93,
  0xe6, 0x8b, 0xb4, 0xe9, 0x9c, 0x9c, 0xe5, 0x8f, 0x8c, 0xe7, 0x88, 0xbd,
  0xe8, 0xb0, 0x81, 0xe6, 0xb0, 0xb4, 0xe7, 0x9d, 0xa1, 0xe7, 0xa8, 0x8e,
  0xe5, 0x90, 0xae, 0xe7, 0x9e, 0xac, 0xe9, 0xa1, 0xba, 0xe8, 0x88, 0x9c,
  0xe8, 0xaf, 0xb4, 0xe7, 0xa1, 0x95, 0xe6, 0x9c, 0x94, 0xe7, 0x83, 0x81,
  0xe6, 0x96, 0xaf, 0xe6, 0x92, 0x95, 0xe5, 0x98, 0xb6, 0xe6, 0x80, 0x9d,
  0xe7, 0xa7, 0x81, 0xe5, 0x8f, 0xb8, 0xe4, 0xb8, 0x9d, 0xe6, 0xad, 0xbb,
  0xe8, 0x82, 0x86, 0xe5, 0xaf, 0xba, 0xe5, 0x97, 0xa3, 0xe5, 0x9b, 0x9b,
  0xe4, 0xbc, 0xba, 0xe4, 0xbc, 0xbc, 0xe9, 0xa5, 0xb2, 0xe5, 0xb7, 0xb3,
  0xe6, 0x9d, 0xbe, 0xe8, 0x80, 0xb8, 0xe6, 0x80, 0x82, 0xe9, 0xa2, 0x82,
  0xe9, 0x80, 0x81, 0xe5, 0xae, 0x8b, 0xe8, 0xae, 0xbc, 0xe8, 0xaf, 0xb5,
  0xe6, 0x90, 0x9c, 0xe8, 0x89, 0x98, 0xe6, 0x93, 0x9e, 0xe5, 0x97, 0xbd,
  0xe8, 0x8b, 0x8f, 0xe9, 0x85, 0xa5, 0xe4, 0xbf, 0x97, 0xe7, 0xb4, 0xa0,
  0xe9, 0x80, 0x9f, 0xe7, 0xb2, 0x9f, 0xe5, 0x83, 0xb3, 0xe5, 0xa1, 0x91,
  0xe6, 0xba, 0xaf, 0xe5, 0xae, 0xbf, 0xe8, 0xaf, 0x89, 0xe8, 0x82, 0x83,
  0xe9, 0x85, 0xb8, 0xe8, 0x92, 0x9c, 0xe7, 0xae, 0x97, 0xe8, 0x99, 0xbd,
  0xe9, 0x9a, 0x8b, 0xe9, 0x9a, 0x8f, 0xe7, 0xbb, 0xa5, 0xe9, 0xab, 0x93,
  0xe7, 0xa2, 0x8e, 0xe5, 0xb2, 0x81, 0xe7, 0xa9, 0x97, 0xe9, 0x81, 0x82,
  0xe9, 0x9a, 0xa7, 0xe7, 0xa5, 0x9f, 0xe5, 0xad, 0x99, 0xe6, 0x8d, 0x9f,
  0xe7, 0xac, 0x8b, 0xe8, 0x93, 0x91, 0xe6, 0xa2, 0xad, 0xe5, 0x94, 0x86,
  0xe7, 0xbc, 0xa9, 0xe7, 0x90, 0x90, 0xe7, 0xb4, 0xa2, 0xe9, 0x94, 0x81,
  0xe6, 0x89, 0x80, 0xe5, 0xa1, 0x8c, 0xe4, 0xbb, 0x96, 0xe5, 0xae, 0x83,
  0xe5, 0xa5, 0xb9, 0xe5, 0xa1, 0x94
};

unsigned char gb2312_row_44_converted_to_utf8[] = {
  0xe7, 0x8d, 0xad, 0xe6, 0x8c, 0x9e, 0xe8, 0xb9, 0x8b, 0xe8, 0xb8, 0x8f,
  0xe8, 0x83, 0x8e, 0xe8, 0x8b, 0x94, 0xe6, 0x8a, 0xac, 0xe5, 0x8f, 0xb0,
  0xe6, 0xb3, 0xb0, 0xe9, 0x85, 0x9e, 0xe5, 0xa4, 0xaa, 0xe6, 0x80, 0x81,
  0xe6, 0xb1, 0xb0, 0xe5, 0x9d, 0x8d, 0xe6, 0x91, 0x8a, 0xe8, 0xb4, 0xaa,
  0xe7, 0x98, 0xab, 0xe6, 0xbb, 0xa9, 0xe5, 0x9d, 0x9b, 0xe6, 0xaa, 0x80,
  0xe7, 0x97, 0xb0, 0xe6, 0xbd, 0xad, 0xe8, 0xb0, 0xad, 0xe8, 0xb0, 0x88,
  0xe5, 0x9d, 0xa6, 0xe6, 0xaf, 0xaf, 0xe8, 0xa2, 0x92, 0xe7, 0xa2, 0xb3,
  0xe6, 0x8e, 0xa2, 0xe5, 0x8f, 0xb9, 0xe7, 0x82, 0xad, 0xe6, 0xb1, 0xa4,
  0xe5, 0xa1, 0x98, 0xe6, 0x90, 0xaa, 0xe5, 0xa0, 0x82, 0xe6, 0xa3, 0xa0,
  0xe8, 0x86, 0x9b, 0xe5, 0x94, 0x90, 0xe7, 0xb3, 0x96, 0xe5, 0x80, 0x98,
  0xe8, 0xba, 0xba, 0xe6, 0xb7, 0x8c, 0xe8, 0xb6, 0x9f, 0xe7, 0x83, 0xab,
  0xe6, 0x8e, 0x8f, 0xe6, 0xb6, 0x9b, 0xe6, 0xbb, 0x94, 0xe7, 0xbb, 0xa6,
  0xe8, 0x90, 0x84, 0xe6, 0xa1, 0x83, 0xe9, 0x80, 0x83, 0xe6, 0xb7, 0x98,
  0xe9, 0x99, 0xb6, 0xe8, 0xae, 0xa8, 0xe5, 0xa5, 0x97, 0xe7, 0x89, 0xb9,
  0xe8, 0x97, 0xa4, 0xe8, 0x85, 0xbe, 0xe7, 0x96, 0xbc, 0xe8, 0xaa, 0x8a,
  0xe6, 0xa2, 0xaf, 0xe5, 0x89, 0x94, 0xe8, 0xb8, 0xa2, 0xe9, 0x94, 0x91,
  0xe6, 0x8f, 0x90, 0xe9, 0xa2, 0x98, 0xe8, 0xb9, 0x84, 0xe5, 0x95, 0xbc,
  0xe4, 0xbd, 0x93, 0xe6, 0x9b, 0xbf, 0xe5, 0x9a, 0x8f, 0xe6, 0x83, 0x95,
  0xe6, 0xb6, 0x95, 0xe5, 0x89, 0x83, 0xe5, 0xb1, 0x89, 0xe5, 0xa4, 0xa9,
  0xe6, 0xb7, 0xbb, 0xe5, 0xa1, 0xab, 0xe7, 0x94, 0xb0, 0xe7, 0x94, 0x9c,
  0xe6, 0x81, 0xac, 0xe8, 0x88, 0x94, 0xe8, 0x85, 0x86, 0xe6, 0x8c, 0x91,
  0xe6, 0x9d, 0xa1, 0xe8, 0xbf, 0xa2, 0xe7, 0x9c, 0xba, 0xe8, 0xb7, 0xb3,
  0xe8, 0xb4, 0xb4, 0xe9, 0x93, 0x81, 0xe5, 0xb8, 0x96, 0xe5, 0x8e, 0x85,
  0xe5, 0x90, 0xac, 0xe7, 0x83, 0x83
};

unsigned char gb2312_row_45_converted_to_utf8[] = {
  0xe6, 0xb1, 0x80, 0xe5, 0xbb, 0xb7, 0xe5, 0x81, 0x9c, 0xe4, 0xba, 0xad,
  0xe5, 0xba, 0xad, 0xe6, 0x8c, 0xba, 0xe8, 0x89, 0x87, 0xe9, 0x80, 0x9a,
  0xe6, 0xa1, 0x90, 0xe9, 0x85, 0xae, 0xe7, 0x9e, 0xb3, 0xe5, 0x90, 0x8c,
  0xe9, 0x93, 0x9c, 0xe5, 0xbd, 0xa4, 0xe7, 0xab, 0xa5, 0xe6, 0xa1, 0xb6,
  0xe6, 0x8d, 0x85, 0xe7, 0xad, 0x92, 0xe7, 0xbb, 0x9f, 0xe7, 0x97, 0x9b,
  0xe5, 0x81, 0xb7, 0xe6, 0x8a, 0x95, 0xe5, 0xa4, 0xb4, 0xe9, 0x80, 0x8f,
  0xe5, 0x87, 0xb8, 0xe7, 0xa7, 0x83, 0xe7, 0xaa, 0x81, 0xe5, 0x9b, 0xbe,
  0xe5, 0xbe, 0x92, 0xe9, 0x80, 0x94, 0xe6, 0xb6, 0x82, 0xe5, 0xb1, 0xa0,
  0xe5, 0x9c, 0x9f, 0xe5, 0x90, 0x90, 0xe5, 0x85, 0x94, 0xe6, 0xb9, 0x8d,
  0xe5, 0x9b, 0xa2, 0xe6, 0x8e, 0xa8, 0xe9, 0xa2, 0x93, 0xe8, 0x85, 0xbf,
  0xe8, 0x9c, 0x95, 0xe8, 0xa4, 0xaa, 0xe9, 0x80, 0x80, 0xe5, 0x90, 0x9e,
  0xe5, 0xb1, 0xaf, 0xe8, 0x87, 0x80, 0xe6, 0x8b, 0x96, 0xe6, 0x89, 0x98,
  0xe8, 0x84, 0xb1, 0xe9, 0xb8, 0xb5, 0xe9, 0x99, 0x80, 0xe9, 0xa9, 0xae,
  0xe9, 0xa9, 0xbc, 0xe6, 0xa4, 0xad, 0xe5, 0xa6, 0xa5, 0xe6, 0x8b, 0x93,
  0xe5, 0x94, 0xbe, 0xe6, 0x8c, 0x96, 0xe5, 0x93, 0x87, 0xe8, 0x9b, 0x99,
  0xe6, 0xb4, 0xbc, 0xe5, 0xa8, 0x83, 0xe7, 0x93, 0xa6, 0xe8, 0xa2, 0x9c,
  0xe6, 0xad, 0xaa, 0xe5, 0xa4, 0x96, 0xe8, 0xb1, 0x8c, 0xe5, 0xbc, 0xaf,
  0xe6, 0xb9, 0xbe, 0xe7, 0x8e, 0xa9, 0xe9, 0xa1, 0xbd, 0xe4, 0xb8, 0xb8,
  0xe7, 0x83, 0xb7, 0xe5, 0xae, 0x8c, 0xe7, 0xa2, 0x97, 0xe6, 0x8c, 0xbd,
  0xe6, 0x99, 0x9a, 0xe7, 0x9a, 0x96, 0xe6, 0x83, 0x8b, 0xe5, 0xae, 0x9b,
  0xe5, 0xa9, 0x89, 0xe4, 0xb8, 0x87, 0xe8, 0x85, 0x95, 0xe6, 0xb1, 0xaa,
  0xe7, 0x8e, 0x8b, 0xe4, 0xba, 0xa1, 0xe6, 0x9e, 0x89, 0xe7, 0xbd, 0x91,
  0xe5, 0xbe, 0x80, 0xe6, 0x97, 0xba, 0xe6, 0x9c, 0x9b, 0xe5, 0xbf, 0x98,
  0xe5, 0xa6, 0x84, 0xe5, 0xa8, 0x81
};

unsigned char gb2312_row_46_converted_to_utf8[] = {
  0xe5, 0xb7, 0x8d, 0xe5, 0xbe, 0xae, 0xe5, 0x8d, 0xb1, 0xe9, 0x9f, 0xa6,
  0xe8, 0xbf, 0x9d, 0xe6, 0xa1, 0x85, 0xe5, 0x9b, 0xb4, 0xe5, 0x94, 0xaf,
  0xe6, 0x83, 0x9f, 0xe4, 0xb8, 0xba, 0xe6, 0xbd, 0x8d, 0xe7, 0xbb, 0xb4,
  0xe8, 0x8b, 0x87, 0xe8, 0x90, 0x8e, 0xe5, 0xa7, 0x94, 0xe4, 0xbc, 0x9f,
  0xe4, 0xbc, 0xaa, 0xe5, 0xb0, 0xbe, 0xe7, 0xba, 0xac, 0xe6, 0x9c, 0xaa,
  0xe8, 0x94, 0x9a, 0xe5, 0x91, 0xb3, 0xe7, 0x95, 0x8f, 0xe8, 0x83, 0x83,
  0xe5, 0x96, 0x82, 0xe9, 0xad, 0x8f, 0xe4, 0xbd, 0x8d, 0xe6, 0xb8, 0xad,
  0xe8, 0xb0, 0x93, 0xe5, 0xb0, 0x89, 0xe6, 0x85, 0xb0, 0xe5, 0x8d, 0xab,
  0xe7, 0x98, 0x9f, 0xe6, 0xb8, 0xa9, 0xe8, 0x9a, 0x8a, 0xe6, 0x96, 0x87,
  0xe9, 0x97, 0xbb, 0xe7, 0xba, 0xb9, 0xe5, 0x90, 0xbb, 0xe7, 0xa8, 0xb3,
  0xe7, 0xb4, 0x8a, 0xe9, 0x97, 0xae, 0xe5, 0x97, 0xa1, 0xe7, 0xbf, 0x81,
  0xe7, 0x93, 0xae, 0xe6, 0x8c, 0x9d, 0xe8, 0x9c, 0x97, 0xe6, 0xb6, 0xa1,
  0xe7, 0xaa, 0x9d, 0xe6, 0x88, 0x91, 0xe6, 0x96, 0xa1, 0xe5, 0x8d, 0xa7,
  0xe6, 0x8f, 0xa1, 0xe6, 0xb2, 0x83, 0xe5, 0xb7, 0xab, 0xe5, 0x91, 0x9c,
  0xe9, 0x92, 0xa8, 0xe4, 0xb9, 0x8c, 0xe6, 0xb1, 0xa1, 0xe8, 0xaf, 0xac,
  0xe5, 0xb1, 0x8b, 0xe6, 0x97, 0xa0, 0xe8, 0x8a, 0x9c, 0xe6, 0xa2, 0xa7,
  0xe5, 0x90, 0xbe, 0xe5, 0x90, 0xb4, 0xe6, 0xaf, 0x8b, 0xe6, 0xad, 0xa6,
  0xe4, 0xba, 0x94, 0xe6, 0x8d, 0x82, 0xe5, 0x8d, 0x88, 0xe8, 0x88, 0x9e,
  0xe4, 0xbc, 0x8d, 0xe4, 0xbe, 0xae, 0xe5, 0x9d, 0x9e, 0xe6, 0x88, 0x8a,
  0xe9, 0x9b, 0xbe, 0xe6, 0x99, 0xa4, 0xe7, 0x89, 0xa9, 0xe5, 0x8b, 0xbf,
  0xe5, 0x8a, 0xa1, 0xe6, 0x82, 0x9f, 0xe8, 0xaf, 0xaf, 0xe6, 0x98, 0x94,
  0xe7, 0x86, 0x99, 0xe6, 0x9e, 0x90, 0xe8, 0xa5, 0xbf, 0xe7, 0xa1, 0x92,
  0xe7, 0x9f, 0xbd, 0xe6, 0x99, 0xb0, 0xe5, 0x98, 0xbb, 0xe5, 0x90, 0xb8,
  0xe9, 0x94, 0xa1, 0xe7, 0x89, 0xba
};

unsigned char gb2312_row_47_converted_to_utf8[] = {
  0xe7, 0xa8, 0x80, 0xe6, 0x81, 0xaf, 0xe5, 0xb8, 0x8c, 0xe6, 0x82, 0x89,
  0xe8, 0x86, 0x9d, 0xe5, 0xa4, 0x95, 0xe6, 0x83, 0x9c, 0xe7, 0x86, 0x84,
  0xe7, 0x83, 0xaf, 0xe6, 0xba, 0xaa, 0xe6, 0xb1, 0x90, 0xe7, 0x8a, 0x80,
  0xe6, 0xaa, 0x84, 0xe8, 0xa2, 0xad, 0xe5, 0xb8, 0xad, 0xe4, 0xb9, 0xa0,
  0xe5, 0xaa, 0xb3, 0xe5, 0x96, 0x9c, 0xe9, 0x93, 0xa3, 0xe6, 0xb4, 0x97,
  0xe7, 0xb3, 0xbb, 0xe9, 0x9a, 0x99, 0xe6, 0x88, 0x8f, 0xe7, 0xbb, 0x86,
  0xe7, 0x9e, 0x8e, 0xe8, 0x99, 0xbe, 0xe5, 0x8c, 0xa3, 0xe9, 0x9c, 0x9e,
  0xe8, 0xbe, 0x96, 0xe6, 0x9a, 0x87, 0xe5, 0xb3, 0xa1, 0xe4, 0xbe, 0xa0,
  0xe7, 0x8b, 0xad, 0xe4, 0xb8, 0x8b, 0xe5, 0x8e, 0xa6, 0xe5, 0xa4, 0x8f,
  0xe5, 0x90, 0x93, 0xe6, 0x8e, 0x80, 0xe9, 0x94, 0xa8, 0xe5, 0x85, 0x88,
  0xe4, 0xbb, 0x99, 0xe9, 0xb2, 0x9c, 0xe7, 0xba, 0xa4, 0xe5, 0x92, 0xb8,
  0xe8, 0xb4, 0xa4, 0xe8, 0xa1, 0x94, 0xe8, 0x88, 0xb7, 0xe9, 0x97, 0xb2,
  0xe6, 0xb6, 0x8e, 0xe5, 0xbc, 0xa6, 0xe5, 0xab, 0x8c, 0xe6, 0x98, 0xbe,
  0xe9, 0x99, 0xa9, 0xe7, 0x8e, 0xb0, 0xe7, 0x8c, 0xae, 0xe5, 0x8e, 0xbf,
  0xe8, 0x85, 0xba, 0xe9, 0xa6, 0x85, 0xe7, 0xbe, 0xa1, 0xe5, 0xae, 0xaa,
  0xe9, 0x99, 0xb7, 0xe9, 0x99, 0x90, 0xe7, 0xba, 0xbf, 0xe7, 0x9b, 0xb8,
  0xe5, 0x8e, 0xa2, 0xe9, 0x95, 0xb6, 0xe9, 0xa6, 0x99, 0xe7, 0xae, 0xb1,
  0xe8, 0xa5, 0x84, 0xe6, 0xb9, 0x98, 0xe4, 0xb9, 0xa1, 0xe7, 0xbf, 0x94,
  0xe7, 0xa5, 0xa5, 0xe8, 0xaf, 0xa6, 0xe6, 0x83, 0xb3, 0xe5, 0x93, 0x8d,
  0xe4, 0xba, 0xab, 0xe9, 0xa1, 0xb9, 0xe5, 0xb7, 0xb7, 0xe6, 0xa9, 0xa1,
  0xe5, 0x83, 0x8f, 0xe5, 0x90, 0x91, 0xe8, 0xb1, 0xa1, 0xe8, 0x90, 0xa7,
  0xe7, 0xa1, 0x9d, 0xe9, 0x9c, 0x84, 0xe5, 0x89, 0x8a, 0xe5, 0x93, 0xae,
  0xe5, 0x9a, 0xa3, 0xe9, 0x94, 0x80, 0xe6, 0xb6, 0x88, 0xe5, 0xae, 0xb5,
  0xe6, 0xb7, 0x86, 0xe6, 0x99, 0x93
};

unsigned char gb2312_row_48_converted_to_utf8[] = {
  0xe5, 0xb0, 0x8f, 0xe5, 0xad, 0x9d, 0xe6, 0xa0, 0xa1, 0xe8, 0x82, 0x96,
  0xe5, 0x95, 0xb8, 0xe7, 0xac, 0x91, 0xe6, 0x95, 0x88, 0xe6, 0xa5, 0x94,
  0xe4, 0xba, 0x9b, 0xe6, 0xad, 0x87, 0xe8, 0x9d, 0x8e, 0xe9, 0x9e, 0x8b,
  0xe5, 0x8d, 0x8f, 0xe6, 0x8c, 0x9f, 0xe6, 0x90, 0xba, 0xe9, 0x82, 0xaa,
  0xe6, 0x96, 0x9c, 0xe8, 0x83, 0x81, 0xe8, 0xb0, 0x90, 0xe5, 0x86, 0x99,
  0xe6, 0xa2, 0xb0, 0xe5, 0x8d, 0xb8, 0xe8, 0x9f, 0xb9, 0xe6, 0x87, 0x88,
  0xe6, 0xb3, 0x84, 0xe6, 0xb3, 0xbb, 0xe8, 0xb0, 0xa2, 0xe5, 0xb1, 0x91,
  0xe8, 0x96, 0xaa, 0xe8, 0x8a, 0xaf, 0xe9, 0x94, 0x8c, 0xe6, 0xac, 0xa3,
  0xe8, 0xbe, 0x9b, 0xe6, 0x96, 0xb0, 0xe5, 0xbf, 0xbb, 0xe5, 0xbf, 0x83,
  0xe4, 0xbf, 0xa1, 0xe8, 0xa1, 0x85, 0xe6, 0x98, 0x9f, 0xe8, 0x85, 0xa5,
  0xe7, 0x8c, 0xa9, 0xe6, 0x83, 0xba, 0xe5, 0x85, 0xb4, 0xe5, 0x88, 0x91,
  0xe5, 0x9e, 0x8b, 0xe5, 0xbd, 0xa2, 0xe9, 0x82, 0xa2, 0xe8, 0xa1, 0x8c,
  0xe9, 0x86, 0x92, 0xe5, 0xb9, 0xb8, 0xe6, 0x9d, 0x8f, 0xe6, 0x80, 0xa7,
  0xe5, 0xa7, 0x93, 0xe5, 0x85, 0x84, 0xe5, 0x87, 0xb6, 0xe8, 0x83, 0xb8,
  0xe5, 0x8c, 0x88, 0xe6, 0xb1, 0xb9, 0xe9, 0x9b, 0x84, 0xe7, 0x86, 0x8a,
  0xe4, 0xbc, 0x91, 0xe4, 0xbf, 0xae, 0xe7, 0xbe, 0x9e, 0xe6, 0x9c, 0xbd,
  0xe5, 0x97, 0x85, 0xe9, 0x94, 0x88, 0xe7, 0xa7, 0x80, 0xe8, 0xa2, 0x96,
  0xe7, 0xbb, 0xa3, 0xe5, 0xa2, 0x9f, 0xe6, 0x88, 0x8c, 0xe9, 0x9c, 0x80,
  0xe8, 0x99, 0x9a, 0xe5, 0x98, 0x98, 0xe9, 0xa1, 0xbb, 0xe5, 0xbe, 0x90,
  0xe8, 0xae, 0xb8, 0xe8, 0x93, 0x84, 0xe9, 0x85, 0x97, 0xe5, 0x8f, 0x99,
  0xe6, 0x97, 0xad, 0xe5, 0xba, 0x8f, 0xe7, 0x95, 0x9c, 0xe6, 0x81, 0xa4,
  0xe7, 0xb5, 0xae, 0xe5, 0xa9, 0xbf, 0xe7, 0xbb, 0xaa, 0xe7, 0xbb, 0xad,
  0xe8, 0xbd, 0xa9, 0xe5, 0x96, 0xa7, 0xe5, 0xae, 0xa3, 0xe6, 0x82, 0xac,
  0xe6, 0x97, 0x8b, 0xe7, 0x8e, 0x84
};

unsigned char gb2312_row_49_converted_to_utf8[] = {
  0xe9, 0x80, 0x89, 0xe7, 0x99, 0xa3, 0xe7, 0x9c, 0xa9, 0xe7, 0xbb, 0x9a,
  0xe9, 0x9d, 0xb4, 0xe8, 0x96, 0x9b, 0xe5, 0xad, 0xa6, 0xe7, 0xa9, 0xb4,
  0xe9, 0x9b, 0xaa, 0xe8, 0xa1, 0x80, 0xe5, 0x8b, 0x8b, 0xe7, 0x86, 0x8f,
  0xe5, 0xbe, 0xaa, 0xe6, 0x97, 0xac, 0xe8, 0xaf, 0xa2, 0xe5, 0xaf, 0xbb,
  0xe9, 0xa9, 0xaf, 0xe5, 0xb7, 0xa1, 0xe6, 0xae, 0x89, 0xe6, 0xb1, 0x9b,
  0xe8, 0xae, 0xad, 0xe8, 0xae, 0xaf, 0xe9, 0x80, 0x8a, 0xe8, 0xbf, 0x85,
  0xe5, 0x8e, 0x8b, 0xe6, 0x8a, 0xbc, 0xe9, 0xb8, 0xa6, 0xe9, 0xb8, 0xad,
  0xe5, 0x91, 0x80, 0xe4, 0xb8, 0xab, 0xe8, 0x8a, 0xbd, 0xe7, 0x89, 0x99,
  0xe8, 0x9a, 0x9c, 0xe5, 0xb4, 0x96, 0xe8, 0xa1, 0x99, 0xe6, 0xb6, 0xaf,
  0xe9, 0x9b, 0x85, 0xe5, 0x93, 0x91, 0xe4, 0xba, 0x9a, 0xe8, 0xae, 0xb6,
  0xe7, 0x84, 0x89, 0xe5, 0x92, 0xbd, 0xe9, 0x98, 0x89, 0xe7, 0x83, 0x9f,
  0xe6, 0xb7, 0xb9, 0xe7, 0x9b, 0x90, 0xe4, 0xb8, 0xa5, 0xe7, 0xa0, 0x94,
  0xe8, 0x9c, 0x92, 0xe5, 0xb2, 0xa9, 0xe5, 0xbb, 0xb6, 0xe8, 0xa8, 0x80,
  0xe9, 0xa2, 0x9c, 0xe9, 0x98, 0x8e, 0xe7, 0x82, 0x8e, 0xe6, 0xb2, 0xbf,
  0xe5, 0xa5, 0x84, 0xe6, 0x8e, 0xa9, 0xe7, 0x9c, 0xbc, 0xe8, 0xa1, 0x8d,
  0xe6, 0xbc, 0x94, 0xe8, 0x89, 0xb3, 0xe5, 0xa0, 0xb0, 0xe7, 0x87, 0x95,
  0xe5, 0x8e, 0x8c, 0xe7, 0xa0, 0x9a, 0xe9, 0x9b, 0x81, 0xe5, 0x94, 0x81,
  0xe5, 0xbd, 0xa6, 0xe7, 0x84, 0xb0, 0xe5, 0xae, 0xb4, 0xe8, 0xb0, 0x9a,
  0xe9, 0xaa, 0x8c, 0xe6, 0xae, 0x83, 0xe5, 0xa4, 0xae, 0xe9, 0xb8, 0xaf,
  0xe7, 0xa7, 0xa7, 0xe6, 0x9d, 0xa8, 0xe6, 0x89, 0xac, 0xe4, 0xbd, 0xaf,
  0xe7, 0x96, 0xa1, 0xe7, 0xbe, 0x8a, 0xe6, 0xb4, 0x8b, 0xe9, 0x98, 0xb3,
  0xe6, 0xb0, 0xa7, 0xe4, 0xbb, 0xb0, 0xe7, 0x97, 0x92, 0xe5, 0x85, 0xbb,
  0xe6, 0xa0, 0xb7, 0xe6, 0xbc, 0xbe, 0xe9, 0x82, 0x80, 0xe8, 0x85, 0xb0,
  0xe5, 0xa6, 0x96, 0xe7, 0x91, 0xb6
};

unsigned char gb2312_row_50_converted_to_utf8[] = {
  0xe6, 0x91, 0x87, 0xe5, 0xb0, 0xa7, 0xe9, 0x81, 0xa5, 0xe7, 0xaa, 0x91,
  0xe8, 0xb0, 0xa3, 0xe5, 0xa7, 0x9a, 0xe5, 0x92, 0xac, 0xe8, 0x88, 0x80,
  0xe8, 0x8d, 0xaf, 0xe8, 0xa6, 0x81, 0xe8, 0x80, 0x80, 0xe6, 0xa4, 0xb0,
  0xe5, 0x99, 0x8e, 0xe8, 0x80, 0xb6, 0xe7, 0x88, 0xb7, 0xe9, 0x87, 0x8e,
  0xe5, 0x86, 0xb6, 0xe4, 0xb9, 0x9f, 0xe9, 0xa1, 0xb5, 0xe6, 0x8e, 0x96,
  0xe4, 0xb8, 0x9a, 0xe5, 0x8f, 0xb6, 0xe6, 0x9b, 0xb3, 0xe8, 0x85, 0x8b,
  0xe5, 0xa4, 0x9c, 0xe6, 0xb6, 0xb2, 0xe4, 0xb8, 0x80, 0xe5, 0xa3, 0xb9,
  0xe5, 0x8c, 0xbb, 0xe6, 0x8f, 0x96, 0xe9, 0x93, 0xb1, 0xe4, 0xbe, 0x9d,
  0xe4, 0xbc, 0x8a, 0xe8, 0xa1, 0xa3, 0xe9, 0xa2, 0x90, 0xe5, 0xa4, 0xb7,
  0xe9, 0x81, 0x97, 0xe7, 0xa7, 0xbb, 0xe4, 0xbb, 0xaa, 0xe8, 0x83, 0xb0,
  0xe7, 0x96, 0x91, 0xe6, 0xb2, 0x82, 0xe5, 0xae, 0x9c, 0xe5, 0xa7, 0xa8,
  0xe5, 0xbd, 0x9d, 0xe6, 0xa4, 0x85, 0xe8, 0x9a, 0x81, 0xe5, 0x80, 0x9a,
  0xe5, 0xb7, 0xb2, 0xe4, 0xb9, 0x99, 0xe7, 0x9f, 0xa3, 0xe4, 0xbb, 0xa5,
  0xe8, 0x89, 0xba, 0xe6, 0x8a, 0x91, 0xe6, 0x98, 0x93, 0xe9, 0x82, 0x91,
  0xe5, 0xb1, 0xb9, 0xe4, 0xba, 0xbf, 0xe5, 0xbd, 0xb9, 0xe8, 0x87, 0x86,
  0xe9, 0x80, 0xb8, 0xe8, 0x82, 0x84, 0xe7, 0x96, 0xab, 0xe4, 0xba, 0xa6,
  0xe8, 0xa3, 0x94, 0xe6, 0x84, 0x8f, 0xe6, 0xaf, 0x85, 0xe5, 0xbf, 0x86,
  0xe4, 0xb9, 0x89, 0xe7, 0x9b, 0x8a, 0xe6, 0xba, 0xa2, 0xe8, 0xaf, 0xa3,
  0xe8, 0xae, 0xae, 0xe8, 0xb0, 0x8a, 0xe8, 0xaf, 0x91, 0xe5, 0xbc, 0x82,
  0xe7, 0xbf, 0xbc, 0xe7, 0xbf, 0x8c, 0xe7, 0xbb, 0x8e, 0xe8, 0x8c, 0xb5,
  0xe8, 0x8d, 0xab, 0xe5, 0x9b, 0xa0, 0xe6, 0xae, 0xb7, 0xe9, 0x9f, 0xb3,
  0xe9, 0x98, 0xb4, 0xe5, 0xa7, 0xbb, 0xe5, 0x90, 0x9f, 0xe9, 0x93, 0xb6,
  0xe6, 0xb7, 0xab, 0xe5, 0xaf, 0x85, 0xe9, 0xa5, 0xae, 0xe5, 0xb0, 0xb9,
  0xe5, 0xbc, 0x95, 0xe9, 0x9a, 0x90
};

unsigned char gb2312_row_51_converted_to_utf8[] = {
  0xe5, 0x8d, 0xb0, 0xe8, 0x8b, 0xb1, 0xe6, 0xa8, 0xb1, 0xe5, 0xa9, 0xb4,
  0xe9, 0xb9, 0xb0, 0xe5, 0xba, 0x94, 0xe7, 0xbc, 0xa8, 0xe8, 0x8e, 0xb9,
  0xe8, 0x90, 0xa4, 0xe8, 0x90, 0xa5, 0xe8, 0x8d, 0xa7, 0xe8, 0x9d, 0x87,
  0xe8, 0xbf, 0x8e, 0xe8, 0xb5, 0xa2, 0xe7, 0x9b, 0x88, 0xe5, 0xbd, 0xb1,
  0xe9, 0xa2, 0x96, 0xe7, 0xa1, 0xac, 0xe6, 0x98, 0xa0, 0xe5, 0x93, 0x9f,
  0xe6, 0x8b, 0xa5, 0xe4, 0xbd, 0xa3, 0xe8, 0x87, 0x83, 0xe7, 0x97, 0x88,
  0xe5, 0xba, 0xb8, 0xe9, 0x9b, 0x8d, 0xe8, 0xb8, 0x8a, 0xe8, 0x9b, 0xb9,
  0xe5, 0x92, 0x8f, 0xe6, 0xb3, 0xb3, 0xe6, 0xb6, 0x8c, 0xe6, 0xb0, 0xb8,
  0xe6, 0x81, 0xbf, 0xe5, 0x8b, 0x87, 0xe7, 0x94, 0xa8, 0xe5, 0xb9, 0xbd,
  0xe4, 0xbc, 0x98, 0xe6, 0x82, 0xa0, 0xe5, 0xbf, 0xa7, 0xe5, 0xb0, 0xa4,
  0xe7, 0x94, 0xb1, 0xe9, 0x82, 0xae, 0xe9, 0x93, 0x80, 0xe7, 0x8a, 0xb9,
  0xe6, 0xb2, 0xb9, 0xe6, 0xb8, 0xb8, 0xe9, 0x85, 0x89, 0xe6, 0x9c, 0x89,
  0xe5, 0x8f, 0x8b, 0xe5, 0x8f, 0xb3, 0xe4, 0xbd, 0x91, 0xe9, 0x87, 0x89,
  0xe8, 0xaf, 0xb1, 0xe5, 0x8f, 0x88, 0xe5, 0xb9, 0xbc, 0xe8, 0xbf, 0x82,
  0xe6, 0xb7, 0xa4, 0xe4, 0xba, 0x8e, 0xe7, 0x9b, 0x82, 0xe6, 0xa6, 0x86,
  0xe8, 0x99, 0x9e, 0xe6, 0x84, 0x9a, 0xe8, 0x88, 0x86, 0xe4, 0xbd, 0x99,
  0xe4, 0xbf, 0x9e, 0xe9, 0x80, 0xbe, 0xe9, 0xb1, 0xbc, 0xe6, 0x84, 0x89,
  0xe6, 0xb8, 0x9d, 0xe6, 0xb8, 0x94, 0xe9, 0x9a, 0x85, 0xe4, 0xba, 0x88,
  0xe5, 0xa8, 0xb1, 0xe9, 0x9b, 0xa8, 0xe4, 0xb8, 0x8e, 0xe5, 0xb1, 0xbf,
  0xe7, 0xa6, 0xb9, 0xe5, 0xae, 0x87, 0xe8, 0xaf, 0xad, 0xe7, 0xbe, 0xbd,
  0xe7, 0x8e, 0x89, 0xe5, 0x9f, 0x9f, 0xe8, 0x8a, 0x8b, 0xe9, 0x83, 0x81,
  0xe5, 0x90, 0x81, 0xe9, 0x81, 0x87, 0xe5, 0x96, 0xbb, 0xe5, 0xb3, 0xaa,
  0xe5, 0xbe, 0xa1, 0xe6, 0x84, 0x88, 0xe6, 0xac, 0xb2, 0xe7, 0x8b, 0xb1,
  0xe8, 0x82, 0xb2, 0xe8, 0xaa, 0x89
};

unsigned char gb2312_row_52_converted_to_utf8[] = {
  0xe6, 0xb5, 0xb4, 0xe5, 0xaf, 0x93, 0xe8, 0xa3, 0x95, 0xe9, 0xa2, 0x84,
  0xe8, 0xb1, 0xab, 0xe9, 0xa9, 0xad, 0xe9, 0xb8, 0xb3, 0xe6, 0xb8, 0x8a,
  0xe5, 0x86, 0xa4, 0xe5, 0x85, 0x83, 0xe5, 0x9e, 0xa3, 0xe8, 0xa2, 0x81,
  0xe5, 0x8e, 0x9f, 0xe6, 0x8f, 0xb4, 0xe8, 0xbe, 0x95, 0xe5, 0x9b, 0xad,
  0xe5, 0x91, 0x98, 0xe5, 0x9c, 0x86, 0xe7, 0x8c, 0xbf, 0xe6, 0xba, 0x90,
  0xe7, 0xbc, 0x98, 0xe8, 0xbf, 0x9c, 0xe8, 0x8b, 0x91, 0xe6, 0x84, 0xbf,
  0xe6, 0x80, 0xa8, 0xe9, 0x99, 0xa2, 0xe6, 0x9b, 0xb0, 0xe7, 0xba, 0xa6,
  0xe8, 0xb6, 0x8a, 0xe8, 0xb7, 0x83, 0xe9, 0x92, 0xa5, 0xe5, 0xb2, 0xb3,
  0xe7, 0xb2, 0xa4, 0xe6, 0x9c, 0x88, 0xe6, 0x82, 0xa6, 0xe9, 0x98, 0x85,
  0xe8, 0x80, 0x98, 0xe4, 0xba, 0x91, 0xe9, 0x83, 0xa7, 0xe5, 0x8c, 0x80,
  0xe9, 0x99, 0xa8, 0xe5, 0x85, 0x81, 0xe8, 0xbf, 0x90, 0xe8, 0x95, 0xb4,
  0xe9, 0x85, 0x9d, 0xe6, 0x99, 0x95, 0xe9, 0x9f, 0xb5, 0xe5, 0xad, 0x95,
  0xe5, 0x8c, 0x9d, 0xe7, 0xa0, 0xb8, 0xe6, 0x9d, 0x82, 0xe6, 0xa0, 0xbd,
  0xe5, 0x93, 0x89, 0xe7, 0x81, 0xbe, 0xe5, 0xae, 0xb0, 0xe8, 0xbd, 0xbd,
  0xe5, 0x86, 0x8d, 0xe5, 0x9c, 0xa8, 0xe5, 0x92, 0xb1, 0xe6, 0x94, 0x92,
  0xe6, 0x9a, 0x82, 0xe8, 0xb5, 0x9e, 0xe8, 0xb5, 0x83, 0xe8, 0x84, 0x8f,
  0xe8, 0x91, 0xac, 0xe9, 0x81, 0xad, 0xe7, 0xb3, 0x9f, 0xe5, 0x87, 0xbf,
  0xe8, 0x97, 0xbb, 0xe6, 0x9e, 0xa3, 0xe6, 0x97, 0xa9, 0xe6, 0xbe, 0xa1,
  0xe8, 0x9a, 0xa4, 0xe8, 0xba, 0x81, 0xe5, 0x99, 0xaa, 0xe9, 0x80, 0xa0,
  0xe7, 0x9a, 0x82, 0xe7, 0x81, 0xb6, 0xe7, 0x87, 0xa5, 0xe8, 0xb4, 0xa3,
  0xe6, 0x8b, 0xa9, 0xe5, 0x88, 0x99, 0xe6, 0xb3, 0xbd, 0xe8, 0xb4, 0xbc,
  0xe6, 0x80, 0x8e, 0xe5, 0xa2, 0x9e, 0xe6, 0x86, 0x8e, 0xe6, 0x9b, 0xbe,
  0xe8, 0xb5, 0xa0, 0xe6, 0x89, 0x8e, 0xe5, 0x96, 0xb3, 0xe6, 0xb8, 0xa3,
  0xe6, 0x9c, 0xad, 0xe8, 0xbd, 0xa7
};

unsigned char gb2312_row_53_converted_to_utf8[] = {
  0xe9, 0x93, 0xa1, 0xe9, 0x97, 0xb8, 0xe7, 0x9c, 0xa8, 0xe6, 0xa0, 0x85,
  0xe6, 0xa6, 0xa8, 0xe5, 0x92, 0x8b, 0xe4, 0xb9, 0x8d, 0xe7, 0x82, 0xb8,
  0xe8, 0xaf, 0x88, 0xe6, 0x91, 0x98, 0xe6, 0x96, 0x8b, 0xe5, 0xae, 0x85,
  0xe7, 0xaa, 0x84, 0xe5, 0x80, 0xba, 0xe5, 0xaf, 0xa8, 0xe7, 0x9e, 0xbb,
  0xe6, 0xaf, 0xa1, 0xe8, 0xa9, 0xb9, 0xe7, 0xb2, 0x98, 0xe6, 0xb2, 0xbe,
  0xe7, 0x9b, 0x8f, 0xe6, 0x96, 0xa9, 0xe8, 0xbe, 0x97, 0xe5, 0xb4, 0xad,
  0xe5, 0xb1, 0x95, 0xe8, 0x98, 0xb8, 0xe6, 0xa0, 0x88, 0xe5, 0x8d, 0xa0,
  0xe6, 0x88, 0x98, 0xe7, 0xab, 0x99, 0xe6, 0xb9, 0x9b, 0xe7, 0xbb, 0xbd,
  0xe6, 0xa8, 0x9f, 0xe7, 0xab, 0xa0, 0xe5, 0xbd, 0xb0, 0xe6, 0xbc, 0xb3,
  0xe5, 0xbc, 0xa0, 0xe6, 0x8e, 0x8c, 0xe6, 0xb6, 0xa8, 0xe6, 0x9d, 0x96,
  0xe4, 0xb8, 0x88, 0xe5, 0xb8, 0x90, 0xe8, 0xb4, 0xa6, 0xe4, 0xbb, 0x97,
  0xe8, 0x83, 0x80, 0xe7, 0x98, 0xb4, 0xe9, 0x9a, 0x9c, 0xe6, 0x8b, 0x9b,
  0xe6, 0x98, 0xad, 0xe6, 0x89, 0xbe, 0xe6, 0xb2, 0xbc, 0xe8, 0xb5, 0xb5,
  0xe7, 0x85, 0xa7, 0xe7, 0xbd, 0xa9, 0xe5, 0x85, 0x86, 0xe8, 0x82, 0x87,
  0xe5, 0x8f, 0xac, 0xe9, 0x81, 0xae, 0xe6, 0x8a, 0x98, 0xe5, 0x93, 0xb2,
  0xe8, 0x9b, 0xb0, 0xe8, 0xbe, 0x99, 0xe8, 0x80, 0x85, 0xe9, 0x94, 0x97,
  0xe8, 0x94, 0x97, 0xe8, 0xbf, 0x99, 0xe6, 0xb5, 0x99, 0xe7, 0x8f, 0x8d,
  0xe6, 0x96, 0x9f, 0xe7, 0x9c, 0x9f, 0xe7, 0x94, 0x84, 0xe7, 0xa0, 0xa7,
  0xe8, 0x87, 0xbb, 0xe8, 0xb4, 0x9e, 0xe9, 0x92, 0x88, 0xe4, 0xbe, 0xa6,
  0xe6, 0x9e, 0x95, 0xe7, 0x96, 0xb9, 0xe8, 0xaf, 0x8a, 0xe9, 0x9c, 0x87,
  0xe6, 0x8c, 0xaf, 0xe9, 0x95, 0x87, 0xe9, 0x98, 0xb5, 0xe8, 0x92, 0xb8,
  0xe6, 0x8c, 0xa3, 0xe7, 0x9d, 0x81, 0xe5, 0xbe, 0x81, 0xe7, 0x8b, 0xb0,
  0xe4, 0xba, 0x89, 0xe6, 0x80, 0x94, 0xe6, 0x95, 0xb4, 0xe6, 0x8b, 0xaf,
  0xe6, 0xad, 0xa3, 0xe6, 0x94, 0xbf
};

unsigned char gb2312_row_54_converted_to_utf8[] = {
  0xe5, 0xb8, 0xa7, 0xe7, 0x97, 0x87, 0xe9, 0x83, 0x91, 0xe8, 0xaf, 0x81,
  0xe8, 0x8a, 0x9d, 0xe6, 0x9e, 0x9d, 0xe6, 0x94, 0xaf, 0xe5, 0x90, 0xb1,
  0xe8, 0x9c, 0x98, 0xe7, 0x9f, 0xa5, 0xe8, 0x82, 0xa2, 0xe8, 0x84, 0x82,
  0xe6, 0xb1, 0x81, 0xe4, 0xb9, 0x8b, 0xe7, 0xbb, 0x87, 0xe8, 0x81, 0x8c,
  0xe7, 0x9b, 0xb4, 0xe6, 0xa4, 0x8d, 0xe6, 0xae, 0x96, 0xe6, 0x89, 0xa7,
  0xe5, 0x80, 0xbc, 0xe4, 0xbe, 0x84, 0xe5, 0x9d, 0x80, 0xe6, 0x8c, 0x87,
  0xe6, 0xad, 0xa2, 0xe8, 0xb6, 0xbe, 0xe5, 0x8f, 0xaa, 0xe6, 0x97, 0xa8,
  0xe7, 0xba, 0xb8, 0xe5, 0xbf, 0x97, 0xe6, 0x8c, 0x9a, 0xe6, 0x8e, 0xb7,
  0xe8, 0x87, 0xb3, 0xe8, 0x87, 0xb4, 0xe7, 0xbd, 0xae, 0xe5, 0xb8, 0x9c,
  0xe5, 0xb3, 0x99, 0xe5, 0x88, 0xb6, 0xe6, 0x99, 0xba, 0xe7, 0xa7, 0xa9,
  0xe7, 0xa8, 0x9a, 0xe8, 0xb4, 0xa8, 0xe7, 0x82, 0x99, 0xe7, 0x97, 0x94,
  0xe6, 0xbb, 0x9e, 0xe6, 0xb2, 0xbb, 0xe7, 0xaa, 0x92, 0xe4, 0xb8, 0xad,
  0xe7, 0x9b, 0x85, 0xe5, 0xbf, 0xa0, 0xe9, 0x92, 0x9f, 0xe8, 0xa1, 0xb7,
  0xe7, 0xbb, 0x88, 0xe7, 0xa7, 0x8d, 0xe8, 0x82, 0xbf, 0xe9, 0x87, 0x8d,
  0xe4, 0xbb, 0xb2, 0xe4, 0xbc, 0x97, 0xe8, 0x88, 0x9f, 0xe5, 0x91, 0xa8,
  0xe5, 0xb7, 0x9e, 0xe6, 0xb4, 0xb2, 0xe8, 0xaf, 0x8c, 0xe7, 0xb2, 0xa5,
  0xe8, 0xbd, 0xb4, 0xe8, 0x82, 0x98, 0xe5, 0xb8, 0x9a, 0xe5, 0x92, 0x92,
  0xe7, 0x9a, 0xb1, 0xe5, 0xae, 0x99, 0xe6, 0x98, 0xbc, 0xe9, 0xaa, 0xa4,
  0xe7, 0x8f, 0xa0, 0xe6, 0xa0, 0xaa, 0xe8, 0x9b, 0x9b, 0xe6, 0x9c, 0xb1,
  0xe7, 0x8c, 0xaa, 0xe8, 0xaf, 0xb8, 0xe8, 0xaf, 0x9b, 0xe9, 0x80, 0x90,
  0xe7, 0xab, 0xb9, 0xe7, 0x83, 0x9b, 0xe7, 0x85, 0xae, 0xe6, 0x8b, 0x84,
  0xe7, 0x9e, 0xa9, 0xe5, 0x98, 0xb1, 0xe4, 0xb8, 0xbb, 0xe8, 0x91, 0x97,
  0xe6, 0x9f, 0xb1, 0xe5, 0x8a, 0xa9, 0xe8, 0x9b, 0x80, 0xe8, 0xb4, 0xae,
  0xe9, 0x93, 0xb8, 0xe7, 0xad, 0x91
};

unsigned char gb2312_row_55_converted_to_utf8[] = {
  0xe4, 0xbd, 0x8f, 0xe6, 0xb3, 0xa8, 0xe7, 0xa5, 0x9d, 0xe9, 0xa9, 0xbb,
  0xe6, 0x8a, 0x93, 0xe7, 0x88, 0xaa, 0xe6, 0x8b, 0xbd, 0xe4, 0xb8, 0x93,
  0xe7, 0xa0, 0x96, 0xe8, 0xbd, 0xac, 0xe6, 0x92, 0xb0, 0xe8, 0xb5, 0x9a,
  0xe7, 0xaf, 0x86, 0xe6, 0xa1, 0xa9, 0xe5, 0xba, 0x84, 0xe8, 0xa3, 0x85,
  0xe5, 0xa6, 0x86, 0xe6, 0x92, 0x9e, 0xe5, 0xa3, 0xae, 0xe7, 0x8a, 0xb6,
  0xe6, 0xa4, 0x8e, 0xe9, 0x94, 0xa5, 0xe8, 0xbf, 0xbd, 0xe8, 0xb5, 0x98,
  0xe5, 0x9d, 0xa0, 0xe7, 0xbc, 0x80, 0xe8, 0xb0, 0x86, 0xe5, 0x87, 0x86,
  0xe6, 0x8d, 0x89, 0xe6, 0x8b, 0x99, 0xe5, 0x8d, 0x93, 0xe6, 0xa1, 0x8c,
  0xe7, 0x90, 0xa2, 0xe8, 0x8c, 0x81, 0xe9, 0x85, 0x8c, 0xe5, 0x95, 0x84,
  0xe7, 0x9d, 0x80, 0xe7, 0x81, 0xbc, 0xe6, 0xb5, 0x8a, 0xe5, 0x85, 0xb9,
  0xe5, 0x92, 0xa8, 0xe8, 0xb5, 0x84, 0xe5, 0xa7, 0xbf, 0xe6, 0xbb, 0x8b,
  0xe6, 0xb7, 0x84, 0xe5, 0xad, 0x9c, 0xe7, 0xb4, 0xab, 0xe4, 0xbb, 0x94,
  0xe7, 0xb1, 0xbd, 0xe6, 0xbb, 0x93, 0xe5, 0xad, 0x90, 0xe8, 0x87, 0xaa,
  0xe6, 0xb8, 0x8d, 0xe5, 0xad, 0x97, 0xe9, 0xac, 0x83, 0xe6, 0xa3, 0x95,
  0xe8, 0xb8, 0xaa, 0xe5, 0xae, 0x97, 0xe7, 0xbb, 0xbc, 0xe6, 0x80, 0xbb,
  0xe7, 0xba, 0xb5, 0xe9, 0x82, 0xb9, 0xe8, 0xb5, 0xb0, 0xe5, 0xa5, 0x8f,
  0xe6, 0x8f, 0x8d, 0xe7, 0xa7, 0x9f, 0xe8, 0xb6, 0xb3, 0xe5, 0x8d, 0x92,
  0xe6, 0x97, 0x8f, 0xe7, 0xa5, 0x96, 0xe8, 0xaf, 0x85, 0xe9, 0x98, 0xbb,
  0xe7, 0xbb, 0x84, 0xe9, 0x92, 0xbb, 0xe7, 0xba, 0x82, 0xe5, 0x98, 0xb4,
  0xe9, 0x86, 0x89, 0xe6, 0x9c, 0x80, 0xe7, 0xbd, 0xaa, 0xe5, 0xb0, 0x8a,
  0xe9, 0x81, 0xb5, 0xe6, 0x98, 0xa8, 0xe5, 0xb7, 0xa6, 0xe4, 0xbd, 0x90,
  0xe6, 0x9f, 0x9e, 0xe5, 0x81, 0x9a, 0xe4, 0xbd, 0x9c, 0xe5, 0x9d, 0x90,
  0xe5, 0xba, 0xa7
};

// level 2

unsigned char gb2312_row_56_converted_to_utf8[] = {
  0xe4, 0xba, 0x8d, 0xe4, 0xb8, 0x8c, 0xe5, 0x85, 0x80, 0xe4, 0xb8, 0x90,
  0xe5, 0xbb, 0xbf, 0xe5, 0x8d, 0x85, 0xe4, 0xb8, 0x95, 0xe4, 0xba, 0x98,
  0xe4, 0xb8, 0x9e, 0xe9, 0xac, 0xb2, 0xe5, 0xad, 0xac, 0xe5, 0x99, 0xa9,
  0xe4, 0xb8, 0xa8, 0xe7, 0xa6, 0xba, 0xe4, 0xb8, 0xbf, 0xe5, 0x8c, 0x95,
  0xe4, 0xb9, 0x87, 0xe5, 0xa4, 0xad, 0xe7, 0x88, 0xbb, 0xe5, 0x8d, 0xae,
  0xe6, 0xb0, 0x90, 0xe5, 0x9b, 0x9f, 0xe8, 0x83, 0xa4, 0xe9, 0xa6, 0x97,
  0xe6, 0xaf, 0x93, 0xe7, 0x9d, 0xbe, 0xe9, 0xbc, 0x97, 0xe4, 0xb8, 0xb6,
  0xe4, 0xba, 0x9f, 0xe9, 0xbc, 0x90, 0xe4, 0xb9, 0x9c, 0xe4, 0xb9, 0xa9,
  0xe4, 0xba, 0x93, 0xe8, 0x8a, 0x88, 0xe5, 0xad, 0x9b, 0xe5, 0x95, 0xac,
  0xe5, 0x98, 0x8f, 0xe4, 0xbb, 0x84, 0xe5, 0x8e, 0x8d, 0xe5, 0x8e, 0x9d,
  0xe5, 0x8e, 0xa3, 0xe5, 0x8e, 0xa5, 0xe5, 0x8e, 0xae, 0xe9, 0x9d, 0xa5,
  0xe8, 0xb5, 0x9d, 0xe5, 0x8c, 0x9a, 0xe5, 0x8f, 0xb5, 0xe5, 0x8c, 0xa6,
  0xe5, 0x8c, 0xae, 0xe5, 0x8c, 0xbe, 0xe8, 0xb5, 0x9c, 0xe5, 0x8d, 0xa6,
  0xe5, 0x8d, 0xa3, 0xe5, 0x88, 0x82, 0xe5, 0x88, 0x88, 0xe5, 0x88, 0x8e,
  0xe5, 0x88, 0xad, 0xe5, 0x88, 0xb3, 0xe5, 0x88, 0xbf, 0xe5, 0x89, 0x80,
  0xe5, 0x89, 0x8c, 0xe5, 0x89, 0x9e, 0xe5, 0x89, 0xa1, 0xe5, 0x89, 0x9c,
  0xe8, 0x92, 0xaf, 0xe5, 0x89, 0xbd, 0xe5, 0x8a, 0x82, 0xe5, 0x8a, 0x81,
  0xe5, 0x8a, 0x90, 0xe5, 0x8a, 0x93, 0xe5, 0x86, 0x82, 0xe7, 0xbd, 0x94,
  0xe4, 0xba, 0xbb, 0xe4, 0xbb, 0x83, 0xe4, 0xbb, 0x89, 0xe4, 0xbb, 0x82,
  0xe4, 0xbb, 0xa8, 0xe4, 0xbb, 0xa1, 0xe4, 0xbb, 0xab, 0xe4, 0xbb, 0x9e,
  0xe4, 0xbc, 0x9b, 0xe4, 0xbb, 0xb3, 0xe4, 0xbc, 0xa2, 0xe4, 0xbd, 0xa4,
  0xe4, 0xbb, 0xb5, 0xe4, 0xbc, 0xa5, 0xe4, 0xbc, 0xa7, 0xe4, 0xbc, 0x89,
  0xe4, 0xbc, 0xab, 0xe4, 0xbd, 0x9e, 0xe4, 0xbd, 0xa7, 0xe6, 0x94, 0xb8,
  0xe4, 0xbd, 0x9a, 0xe4, 0xbd, 0x9d
};

unsigned char gb2312_row_57_converted_to_utf8[] = {
  0xe4, 0xbd, 0x9f, 0xe4, 0xbd, 0x97, 0xe4, 0xbc, 0xb2, 0xe4, 0xbc, 0xbd,
  0xe4, 0xbd, 0xb6, 0xe4, 0xbd, 0xb4, 0xe4, 0xbe, 0x91, 0xe4, 0xbe, 0x89,
  0xe4, 0xbe, 0x83, 0xe4, 0xbe, 0x8f, 0xe4, 0xbd, 0xbe, 0xe4, 0xbd, 0xbb,
  0xe4, 0xbe, 0xaa, 0xe4, 0xbd, 0xbc, 0xe4, 0xbe, 0xac, 0xe4, 0xbe, 0x94,
  0xe4, 0xbf, 0xa6, 0xe4, 0xbf, 0xa8, 0xe4, 0xbf, 0xaa, 0xe4, 0xbf, 0x85,
  0xe4, 0xbf, 0x9a, 0xe4, 0xbf, 0xa3, 0xe4, 0xbf, 0x9c, 0xe4, 0xbf, 0x91,
  0xe4, 0xbf, 0x9f, 0xe4, 0xbf, 0xb8, 0xe5, 0x80, 0xa9, 0xe5, 0x81, 0x8c,
  0xe4, 0xbf, 0xb3, 0xe5, 0x80, 0xac, 0xe5, 0x80, 0x8f, 0xe5, 0x80, 0xae,
  0xe5, 0x80, 0xad, 0xe4, 0xbf, 0xbe, 0xe5, 0x80, 0x9c, 0xe5, 0x80, 0x8c,
  0xe5, 0x80, 0xa5, 0xe5, 0x80, 0xa8, 0xe5, 0x81, 0xbe, 0xe5, 0x81, 0x83,
  0xe5, 0x81, 0x95, 0xe5, 0x81, 0x88, 0xe5, 0x81, 0x8e, 0xe5, 0x81, 0xac,
  0xe5, 0x81, 0xbb, 0xe5, 0x82, 0xa5, 0xe5, 0x82, 0xa7, 0xe5, 0x82, 0xa9,
  0xe5, 0x82, 0xba, 0xe5, 0x83, 0x96, 0xe5, 0x84, 0x86, 0xe5, 0x83, 0xad,
  0xe5, 0x83, 0xac, 0xe5, 0x83, 0xa6, 0xe5, 0x83, 0xae, 0xe5, 0x84, 0x87,
  0xe5, 0x84, 0x8b, 0xe4, 0xbb, 0x9d, 0xe6, 0xb0, 0xbd, 0xe4, 0xbd, 0x98,
  0xe4, 0xbd, 0xa5, 0xe4, 0xbf, 0x8e, 0xe9, 0xbe, 0xa0, 0xe6, 0xb1, 0x86,
  0xe7, 0xb1, 0xb4, 0xe5, 0x85, 0xae, 0xe5, 0xb7, 0xbd, 0xe9, 0xbb, 0x89,
  0xe9, 0xa6, 0x98, 0xe5, 0x86, 0x81, 0xe5, 0xa4, 0x94, 0xe5, 0x8b, 0xb9,
  0xe5, 0x8c, 0x8d, 0xe8, 0xa8, 0x87, 0xe5, 0x8c, 0x90, 0xe5, 0x87, 0xab,
  0xe5, 0xa4, 0x99, 0xe5, 0x85, 0x95, 0xe4, 0xba, 0xa0, 0xe5, 0x85, 0x96,
  0xe4, 0xba, 0xb3, 0xe8, 0xa1, 0xae, 0xe8, 0xa2, 0xa4, 0xe4, 0xba, 0xb5,
  0xe8, 0x84, 0x94, 0xe8, 0xa3, 0x92, 0xe7, 0xa6, 0x80, 0xe5, 0xac, 0xb4,
  0xe8, 0xa0, 0x83, 0xe7, 0xbe, 0xb8, 0xe5, 0x86, 0xab, 0xe5, 0x86, 0xb1,
  0xe5, 0x86, 0xbd, 0xe5, 0x86, 0xbc
};

unsigned char gb2312_row_58_converted_to_utf8[] = {
  0xe5, 0x87, 0x87, 0xe5, 0x86, 0x96, 0xe5, 0x86, 0xa2, 0xe5, 0x86, 0xa5,
  0xe8, 0xae, 0xa0, 0xe8, 0xae, 0xa6, 0xe8, 0xae, 0xa7, 0xe8, 0xae, 0xaa,
  0xe8, 0xae, 0xb4, 0xe8, 0xae, 0xb5, 0xe8, 0xae, 0xb7, 0xe8, 0xaf, 0x82,
  0xe8, 0xaf, 0x83, 0xe8, 0xaf, 0x8b, 0xe8, 0xaf, 0x8f, 0xe8, 0xaf, 0x8e,
  0xe8, 0xaf, 0x92, 0xe8, 0xaf, 0x93, 0xe8, 0xaf, 0x94, 0xe8, 0xaf, 0x96,
  0xe8, 0xaf, 0x98, 0xe8, 0xaf, 0x99, 0xe8, 0xaf, 0x9c, 0xe8, 0xaf, 0x9f,
  0xe8, 0xaf, 0xa0, 0xe8, 0xaf, 0xa4, 0xe8, 0xaf, 0xa8, 0xe8, 0xaf, 0xa9,
  0xe8, 0xaf, 0xae, 0xe8, 0xaf, 0xb0, 0xe8, 0xaf, 0xb3, 0xe8, 0xaf, 0xb6,
  0xe8, 0xaf, 0xb9, 0xe8, 0xaf, 0xbc, 0xe8, 0xaf, 0xbf, 0xe8, 0xb0, 0x80,
  0xe8, 0xb0, 0x82, 0xe8, 0xb0, 0x84, 0xe8, 0xb0, 0x87, 0xe8, 0xb0, 0x8c,
  0xe8, 0xb0, 0x8f, 0xe8, 0xb0, 0x91, 0xe8, 0xb0, 0x92, 0xe8, 0xb0, 0x94,
  0xe8, 0xb0, 0x95, 0xe8, 0xb0, 0x96, 0xe8, 0xb0, 0x99, 0xe8, 0xb0, 0x9b,
  0xe8, 0xb0, 0x98, 0xe8, 0xb0, 0x9d, 0xe8, 0xb0, 0x9f, 0xe8, 0xb0, 0xa0,
  0xe8, 0xb0, 0xa1, 0xe8, 0xb0, 0xa5, 0xe8, 0xb0, 0xa7, 0xe8, 0xb0, 0xaa,
  0xe8, 0xb0, 0xab, 0xe8, 0xb0, 0xae, 0xe8, 0xb0, 0xaf, 0xe8, 0xb0, 0xb2,
  0xe8, 0xb0, 0xb3, 0xe8, 0xb0, 0xb5, 0xe8, 0xb0, 0xb6, 0xe5, 0x8d, 0xa9,
  0xe5, 0x8d, 0xba, 0xe9, 0x98, 0x9d, 0xe9, 0x98, 0xa2, 0xe9, 0x98, 0xa1,
  0xe9, 0x98, 0xb1, 0xe9, 0x98, 0xaa, 0xe9, 0x98, 0xbd, 0xe9, 0x98, 0xbc,
  0xe9, 0x99, 0x82, 0xe9, 0x99, 0x89, 0xe9, 0x99, 0x94, 0xe9, 0x99, 0x9f,
  0xe9, 0x99, 0xa7, 0xe9, 0x99, 0xac, 0xe9, 0x99, 0xb2, 0xe9, 0x99, 0xb4,
  0xe9, 0x9a, 0x88, 0xe9, 0x9a, 0x8d, 0xe9, 0x9a, 0x97, 0xe9, 0x9a, 0xb0,
  0xe9, 0x82, 0x97, 0xe9, 0x82, 0x9b, 0xe9, 0x82, 0x9d, 0xe9, 0x82, 0x99,
  0xe9, 0x82, 0xac, 0xe9, 0x82, 0xa1, 0xe9, 0x82, 0xb4, 0xe9, 0x82, 0xb3,
  0xe9, 0x82, 0xb6, 0xe9, 0x82, 0xba
};

unsigned char gb2312_row_59_converted_to_utf8[] = {
  0xe9, 0x82, 0xb8, 0xe9, 0x82, 0xb0, 0xe9, 0x83, 0x8f, 0xe9, 0x83, 0x85,
  0xe9, 0x82, 0xbe, 0xe9, 0x83, 0x90, 0xe9, 0x83, 0x84, 0xe9, 0x83, 0x87,
  0xe9, 0x83, 0x93, 0xe9, 0x83, 0xa6, 0xe9, 0x83, 0xa2, 0xe9, 0x83, 0x9c,
  0xe9, 0x83, 0x97, 0xe9, 0x83, 0x9b, 0xe9, 0x83, 0xab, 0xe9, 0x83, 0xaf,
  0xe9, 0x83, 0xbe, 0xe9, 0x84, 0x84, 0xe9, 0x84, 0xa2, 0xe9, 0x84, 0x9e,
  0xe9, 0x84, 0xa3, 0xe9, 0x84, 0xb1, 0xe9, 0x84, 0xaf, 0xe9, 0x84, 0xb9,
  0xe9, 0x85, 0x83, 0xe9, 0x85, 0x86, 0xe5, 0x88, 0x8d, 0xe5, 0xa5, 0x82,
  0xe5, 0x8a, 0xa2, 0xe5, 0x8a, 0xac, 0xe5, 0x8a, 0xad, 0xe5, 0x8a, 0xbe,
  0xe5, 0x93, 0xbf, 0xe5, 0x8b, 0x90, 0xe5, 0x8b, 0x96, 0xe5, 0x8b, 0xb0,
  0xe5, 0x8f, 0x9f, 0xe7, 0x87, 0xae, 0xe7, 0x9f, 0x8d, 0xe5, 0xbb, 0xb4,
  0xe5, 0x87, 0xb5, 0xe5, 0x87, 0xbc, 0xe9, 0xac, 0xaf, 0xe5, 0x8e, 0xb6,
  0xe5, 0xbc, 0x81, 0xe7, 0x95, 0x9a, 0xe5, 0xb7, 0xaf, 0xe5, 0x9d, 0x8c,
  0xe5, 0x9e, 0xa9, 0xe5, 0x9e, 0xa1, 0xe5, 0xa1, 0xbe, 0xe5, 0xa2, 0xbc,
  0xe5, 0xa3, 0x85, 0xe5, 0xa3, 0x91, 0xe5, 0x9c, 0xa9, 0xe5, 0x9c, 0xac,
  0xe5, 0x9c, 0xaa, 0xe5, 0x9c, 0xb3, 0xe5, 0x9c, 0xb9, 0xe5, 0x9c, 0xae,
  0xe5, 0x9c, 0xaf, 0xe5, 0x9d, 0x9c, 0xe5, 0x9c, 0xbb, 0xe5, 0x9d, 0x82,
  0xe5, 0x9d, 0xa9, 0xe5, 0x9e, 0x85, 0xe5, 0x9d, 0xab, 0xe5, 0x9e, 0x86,
  0xe5, 0x9d, 0xbc, 0xe5, 0x9d, 0xbb, 0xe5, 0x9d, 0xa8, 0xe5, 0x9d, 0xad,
  0xe5, 0x9d, 0xb6, 0xe5, 0x9d, 0xb3, 0xe5, 0x9e, 0xad, 0xe5, 0x9e, 0xa4,
  0xe5, 0x9e, 0x8c, 0xe5, 0x9e, 0xb2, 0xe5, 0x9f, 0x8f, 0xe5, 0x9e, 0xa7,
  0xe5, 0x9e, 0xb4, 0xe5, 0x9e, 0x93, 0xe5, 0x9e, 0xa0, 0xe5, 0x9f, 0x95,
  0xe5, 0x9f, 0x98, 0xe5, 0x9f, 0x9a, 0xe5, 0x9f, 0x99, 0xe5, 0x9f, 0x92,
  0xe5, 0x9e, 0xb8, 0xe5, 0x9f, 0xb4, 0xe5, 0x9f, 0xaf, 0xe5, 0x9f, 0xb8,
  0xe5, 0x9f, 0xa4, 0xe5, 0x9f, 0x9d
};

unsigned char gb2312_row_60_converted_to_utf8[] = {
  0xe5, 0xa0, 0x8b, 0xe5, 0xa0, 0x8d, 0xe5, 0x9f, 0xbd, 0xe5, 0x9f, 0xad,
  0xe5, 0xa0, 0x80, 0xe5, 0xa0, 0x9e, 0xe5, 0xa0, 0x99, 0xe5, 0xa1, 0x84,
  0xe5, 0xa0, 0xa0, 0xe5, 0xa1, 0xa5, 0xe5, 0xa1, 0xac, 0xe5, 0xa2, 0x81,
  0xe5, 0xa2, 0x89, 0xe5, 0xa2, 0x9a, 0xe5, 0xa2, 0x80, 0xe9, 0xa6, 0xa8,
  0xe9, 0xbc, 0x99, 0xe6, 0x87, 0xbf, 0xe8, 0x89, 0xb9, 0xe8, 0x89, 0xbd,
  0xe8, 0x89, 0xbf, 0xe8, 0x8a, 0x8f, 0xe8, 0x8a, 0x8a, 0xe8, 0x8a, 0xa8,
  0xe8, 0x8a, 0x84, 0xe8, 0x8a, 0x8e, 0xe8, 0x8a, 0x91, 0xe8, 0x8a, 0x97,
  0xe8, 0x8a, 0x99, 0xe8, 0x8a, 0xab, 0xe8, 0x8a, 0xb8, 0xe8, 0x8a, 0xbe,
  0xe8, 0x8a, 0xb0, 0xe8, 0x8b, 0x88, 0xe8, 0x8b, 0x8a, 0xe8, 0x8b, 0xa3,
  0xe8, 0x8a, 0x98, 0xe8, 0x8a, 0xb7, 0xe8, 0x8a, 0xae, 0xe8, 0x8b, 0x8b,
  0xe8, 0x8b, 0x8c, 0xe8, 0x8b, 0x81, 0xe8, 0x8a, 0xa9, 0xe8, 0x8a, 0xb4,
  0xe8, 0x8a, 0xa1, 0xe8, 0x8a, 0xaa, 0xe8, 0x8a, 0x9f, 0xe8, 0x8b, 0x84,
  0xe8, 0x8b, 0x8e, 0xe8, 0x8a, 0xa4, 0xe8, 0x8b, 0xa1, 0xe8, 0x8c, 0x89,
  0xe8, 0x8b, 0xb7, 0xe8, 0x8b, 0xa4, 0xe8, 0x8c, 0x8f, 0xe8, 0x8c, 0x87,
  0xe8, 0x8b, 0x9c, 0xe8, 0x8b, 0xb4, 0xe8, 0x8b, 0x92, 0xe8, 0x8b, 0x98,
  0xe8, 0x8c, 0x8c, 0xe8, 0x8b, 0xbb, 0xe8, 0x8b, 0x93, 0xe8, 0x8c, 0x91,
  0xe8, 0x8c, 0x9a, 0xe8, 0x8c, 0x86, 0xe8, 0x8c, 0x94, 0xe8, 0x8c, 0x95,
  0xe8, 0x8b, 0xa0, 0xe8, 0x8b, 0x95, 0xe8, 0x8c, 0x9c, 0xe8, 0x8d, 0x91,
  0xe8, 0x8d, 0x9b, 0xe8, 0x8d, 0x9c, 0xe8, 0x8c, 0x88, 0xe8, 0x8e, 0x92,
  0xe8, 0x8c, 0xbc, 0xe8, 0x8c, 0xb4, 0xe8, 0x8c, 0xb1, 0xe8, 0x8e, 0x9b,
  0xe8, 0x8d, 0x9e, 0xe8, 0x8c, 0xaf, 0xe8, 0x8d, 0x8f, 0xe8, 0x8d, 0x87,
  0xe8, 0x8d, 0x83, 0xe8, 0x8d, 0x9f, 0xe8, 0x8d, 0x80, 0xe8, 0x8c, 0x97,
  0xe8, 0x8d, 0xa0, 0xe8, 0x8c, 0xad, 0xe8, 0x8c, 0xba, 0xe8, 0x8c, 0xb3,
  0xe8, 0x8d, 0xa6, 0xe8, 0x8d, 0xa5
};

unsigned char gb2312_row_61_converted_to_utf8[] = {
  0xe8, 0x8d, 0xa8, 0xe8, 0x8c, 0x9b, 0xe8, 0x8d, 0xa9, 0xe8, 0x8d, 0xac,
  0xe8, 0x8d, 0xaa, 0xe8, 0x8d, 0xad, 0xe8, 0x8d, 0xae, 0xe8, 0x8e, 0xb0,
  0xe8, 0x8d, 0xb8, 0xe8, 0x8e, 0xb3, 0xe8, 0x8e, 0xb4, 0xe8, 0x8e, 0xa0,
  0xe8, 0x8e, 0xaa, 0xe8, 0x8e, 0x93, 0xe8, 0x8e, 0x9c, 0xe8, 0x8e, 0x85,
  0xe8, 0x8d, 0xbc, 0xe8, 0x8e, 0xb6, 0xe8, 0x8e, 0xa9, 0xe8, 0x8d, 0xbd,
  0xe8, 0x8e, 0xb8, 0xe8, 0x8d, 0xbb, 0xe8, 0x8e, 0x98, 0xe8, 0x8e, 0x9e,
  0xe8, 0x8e, 0xa8, 0xe8, 0x8e, 0xba, 0xe8, 0x8e, 0xbc, 0xe8, 0x8f, 0x81,
  0xe8, 0x90, 0x81, 0xe8, 0x8f, 0xa5, 0xe8, 0x8f, 0x98, 0xe5, 0xa0, 0x87,
  0xe8, 0x90, 0x98, 0xe8, 0x90, 0x8b, 0xe8, 0x8f, 0x9d, 0xe8, 0x8f, 0xbd,
  0xe8, 0x8f, 0x96, 0xe8, 0x90, 0x9c, 0xe8, 0x90, 0xb8, 0xe8, 0x90, 0x91,
  0xe8, 0x90, 0x86, 0xe8, 0x8f, 0x94, 0xe8, 0x8f, 0x9f, 0xe8, 0x90, 0x8f,
  0xe8, 0x90, 0x83, 0xe8, 0x8f, 0xb8, 0xe8, 0x8f, 0xb9, 0xe8, 0x8f, 0xaa,
  0xe8, 0x8f, 0x85, 0xe8, 0x8f, 0x80, 0xe8, 0x90, 0xa6, 0xe8, 0x8f, 0xb0,
  0xe8, 0x8f, 0xa1, 0xe8, 0x91, 0x9c, 0xe8, 0x91, 0x91, 0xe8, 0x91, 0x9a,
  0xe8, 0x91, 0x99, 0xe8, 0x91, 0xb3, 0xe8, 0x92, 0x87, 0xe8, 0x92, 0x88,
  0xe8, 0x91, 0xba, 0xe8, 0x92, 0x89, 0xe8, 0x91, 0xb8, 0xe8, 0x90, 0xbc,
  0xe8, 0x91, 0x86, 0xe8, 0x91, 0xa9, 0xe8, 0x91, 0xb6, 0xe8, 0x92, 0x8c,
  0xe8, 0x92, 0x8e, 0xe8, 0x90, 0xb1, 0xe8, 0x91, 0xad, 0xe8, 0x93, 0x81,
  0xe8, 0x93, 0x8d, 0xe8, 0x93, 0x90, 0xe8, 0x93, 0xa6, 0xe8, 0x92, 0xbd,
  0xe8, 0x93, 0x93, 0xe8, 0x93, 0x8a, 0xe8, 0x92, 0xbf, 0xe8, 0x92, 0xba,
  0xe8, 0x93, 0xa0, 0xe8, 0x92, 0xa1, 0xe8, 0x92, 0xb9, 0xe8, 0x92, 0xb4,
  0xe8, 0x92, 0x97, 0xe8, 0x93, 0xa5, 0xe8, 0x93, 0xa3, 0xe8, 0x94, 0x8c,
  0xe7, 0x94, 0x8d, 0xe8, 0x94, 0xb8, 0xe8, 0x93, 0xb0, 0xe8, 0x94, 0xb9,
  0xe8, 0x94, 0x9f, 0xe8, 0x94, 0xba
};

unsigned char gb2312_row_62_converted_to_utf8[] = {
  0xe8, 0x95, 0x96, 0xe8, 0x94, 0xbb, 0xe8, 0x93, 0xbf, 0xe8, 0x93, 0xbc,
  0xe8, 0x95, 0x99, 0xe8, 0x95, 0x88, 0xe8, 0x95, 0xa8, 0xe8, 0x95, 0xa4,
  0xe8, 0x95, 0x9e, 0xe8, 0x95, 0xba, 0xe7, 0x9e, 0xa2, 0xe8, 0x95, 0x83,
  0xe8, 0x95, 0xb2, 0xe8, 0x95, 0xbb, 0xe8, 0x96, 0xa4, 0xe8, 0x96, 0xa8,
  0xe8, 0x96, 0x87, 0xe8, 0x96, 0x8f, 0xe8, 0x95, 0xb9, 0xe8, 0x96, 0xae,
  0xe8, 0x96, 0x9c, 0xe8, 0x96, 0x85, 0xe8, 0x96, 0xb9, 0xe8, 0x96, 0xb7,
  0xe8, 0x96, 0xb0, 0xe8, 0x97, 0x93, 0xe8, 0x97, 0x81, 0xe8, 0x97, 0x9c,
  0xe8, 0x97, 0xbf, 0xe8, 0x98, 0xa7, 0xe8, 0x98, 0x85, 0xe8, 0x98, 0xa9,
  0xe8, 0x98, 0x96, 0xe8, 0x98, 0xbc, 0xe5, 0xbb, 0xbe, 0xe5, 0xbc, 0x88,
  0xe5, 0xa4, 0xbc, 0xe5, 0xa5, 0x81, 0xe8, 0x80, 0xb7, 0xe5, 0xa5, 0x95,
  0xe5, 0xa5, 0x9a, 0xe5, 0xa5, 0x98, 0xe5, 0x8c, 0x8f, 0xe5, 0xb0, 0xa2,
  0xe5, 0xb0, 0xa5, 0xe5, 0xb0, 0xac, 0xe5, 0xb0, 0xb4, 0xe6, 0x89, 0x8c,
  0xe6, 0x89, 0xaa, 0xe6, 0x8a, 0x9f, 0xe6, 0x8a, 0xbb, 0xe6, 0x8b, 0x8a,
  0xe6, 0x8b, 0x9a, 0xe6, 0x8b, 0x97, 0xe6, 0x8b, 0xae, 0xe6, 0x8c, 0xa2,
  0xe6, 0x8b, 0xb6, 0xe6, 0x8c, 0xb9, 0xe6, 0x8d, 0x8b, 0xe6, 0x8d, 0x83,
  0xe6, 0x8e, 0xad, 0xe6, 0x8f, 0xb6, 0xe6, 0x8d, 0xb1, 0xe6, 0x8d, 0xba,
  0xe6, 0x8e, 0x8e, 0xe6, 0x8e, 0xb4, 0xe6, 0x8d, 0xad, 0xe6, 0x8e, 0xac,
  0xe6, 0x8e, 0x8a, 0xe6, 0x8d, 0xa9, 0xe6, 0x8e, 0xae, 0xe6, 0x8e, 0xbc,
  0xe6, 0x8f, 0xb2, 0xe6, 0x8f, 0xb8, 0xe6, 0x8f, 0xa0, 0xe6, 0x8f, 0xbf,
  0xe6, 0x8f, 0x84, 0xe6, 0x8f, 0x9e, 0xe6, 0x8f, 0x8e, 0xe6, 0x91, 0x92,
  0xe6, 0x8f, 0x86, 0xe6, 0x8e, 0xbe, 0xe6, 0x91, 0x85, 0xe6, 0x91, 0x81,
  0xe6, 0x90, 0x8b, 0xe6, 0x90, 0x9b, 0xe6, 0x90, 0xa0, 0xe6, 0x90, 0x8c,
  0xe6, 0x90, 0xa6, 0xe6, 0x90, 0xa1, 0xe6, 0x91, 0x9e, 0xe6, 0x92, 0x84,
  0xe6, 0x91, 0xad, 0xe6, 0x92, 0x96
};

unsigned char gb2312_row_63_converted_to_utf8[] = {
  0xe6, 0x91, 0xba, 0xe6, 0x92, 0xb7, 0xe6, 0x92, 0xb8, 0xe6, 0x92, 0x99,
  0xe6, 0x92, 0xba, 0xe6, 0x93, 0x80, 0xe6, 0x93, 0x90, 0xe6, 0x93, 0x97,
  0xe6, 0x93, 0xa4, 0xe6, 0x93, 0xa2, 0xe6, 0x94, 0x89, 0xe6, 0x94, 0xa5,
  0xe6, 0x94, 0xae, 0xe5, 0xbc, 0x8b, 0xe5, 0xbf, 0x92, 0xe7, 0x94, 0x99,
  0xe5, 0xbc, 0x91, 0xe5, 0x8d, 0x9f, 0xe5, 0x8f, 0xb1, 0xe5, 0x8f, 0xbd,
  0xe5, 0x8f, 0xa9, 0xe5, 0x8f, 0xa8, 0xe5, 0x8f, 0xbb, 0xe5, 0x90, 0x92,
  0xe5, 0x90, 0x96, 0xe5, 0x90, 0x86, 0xe5, 0x91, 0x8b, 0xe5, 0x91, 0x92,
  0xe5, 0x91, 0x93, 0xe5, 0x91, 0x94, 0xe5, 0x91, 0x96, 0xe5, 0x91, 0x83,
  0xe5, 0x90, 0xa1, 0xe5, 0x91, 0x97, 0xe5, 0x91, 0x99, 0xe5, 0x90, 0xa3,
  0xe5, 0x90, 0xb2, 0xe5, 0x92, 0x82, 0xe5, 0x92, 0x94, 0xe5, 0x91, 0xb7,
  0xe5, 0x91, 0xb1, 0xe5, 0x91, 0xa4, 0xe5, 0x92, 0x9a, 0xe5, 0x92, 0x9b,
  0xe5, 0x92, 0x84, 0xe5, 0x91, 0xb6, 0xe5, 0x91, 0xa6, 0xe5, 0x92, 0x9d,
  0xe5, 0x93, 0x90, 0xe5, 0x92, 0xad, 0xe5, 0x93, 0x82, 0xe5, 0x92, 0xb4,
  0xe5, 0x93, 0x92, 0xe5, 0x92, 0xa7, 0xe5, 0x92, 0xa6, 0xe5, 0x93, 0x93,
  0xe5, 0x93, 0x94, 0xe5, 0x91, 0xb2, 0xe5, 0x92, 0xa3, 0xe5, 0x93, 0x95,
  0xe5, 0x92, 0xbb, 0xe5, 0x92, 0xbf, 0xe5, 0x93, 0x8c, 0xe5, 0x93, 0x99,
  0xe5, 0x93, 0x9a, 0xe5, 0x93, 0x9c, 0xe5, 0x92, 0xa9, 0xe5, 0x92, 0xaa,
  0xe5, 0x92, 0xa4, 0xe5, 0x93, 0x9d, 0xe5, 0x93, 0x8f, 0xe5, 0x93, 0x9e,
  0xe5, 0x94, 0x9b, 0xe5, 0x93, 0xa7, 0xe5, 0x94, 0xa0, 0xe5, 0x93, 0xbd,
  0xe5, 0x94, 0x94, 0xe5, 0x93, 0xb3, 0xe5, 0x94, 0xa2, 0xe5, 0x94, 0xa3,
  0xe5, 0x94, 0x8f, 0xe5, 0x94, 0x91, 0xe5, 0x94, 0xa7, 0xe5, 0x94, 0xaa,
  0xe5, 0x95, 0xa7, 0xe5, 0x96, 0x8f, 0xe5, 0x96, 0xb5, 0xe5, 0x95, 0x89,
  0xe5, 0x95, 0xad, 0xe5, 0x95, 0x81, 0xe5, 0x95, 0x95, 0xe5, 0x94, 0xbf,
  0xe5, 0x95, 0x90, 0xe5, 0x94, 0xbc
};

unsigned char gb2312_row_64_converted_to_utf8[] = {
  0xe5, 0x94, 0xb7, 0xe5, 0x95, 0x96, 0xe5, 0x95, 0xb5, 0xe5, 0x95, 0xb6,
  0xe5, 0x95, 0xb7, 0xe5, 0x94, 0xb3, 0xe5, 0x94, 0xb0, 0xe5, 0x95, 0x9c,
  0xe5, 0x96, 0x8b, 0xe5, 0x97, 0x92, 0xe5, 0x96, 0x83, 0xe5, 0x96, 0xb1,
  0xe5, 0x96, 0xb9, 0xe5, 0x96, 0x88, 0xe5, 0x96, 0x81, 0xe5, 0x96, 0x9f,
  0xe5, 0x95, 0xbe, 0xe5, 0x97, 0x96, 0xe5, 0x96, 0x91, 0xe5, 0x95, 0xbb,
  0xe5, 0x97, 0x9f, 0xe5, 0x96, 0xbd, 0xe5, 0x96, 0xbe, 0xe5, 0x96, 0x94,
  0xe5, 0x96, 0x99, 0xe5, 0x97, 0xaa, 0xe5, 0x97, 0xb7, 0xe5, 0x97, 0x89,
  0xe5, 0x98, 0x9f, 0xe5, 0x97, 0x91, 0xe5, 0x97, 0xab, 0xe5, 0x97, 0xac,
  0xe5, 0x97, 0x94, 0xe5, 0x97, 0xa6, 0xe5, 0x97, 0x9d, 0xe5, 0x97, 0x84,
  0xe5, 0x97, 0xaf, 0xe5, 0x97, 0xa5, 0xe5, 0x97, 0xb2, 0xe5, 0x97, 0xb3,
  0xe5, 0x97, 0x8c, 0xe5, 0x97, 0x8d, 0xe5, 0x97, 0xa8, 0xe5, 0x97, 0xb5,
  0xe5, 0x97, 0xa4, 0xe8, 0xbe, 0x94, 0xe5, 0x98, 0x9e, 0xe5, 0x98, 0x88,
  0xe5, 0x98, 0x8c, 0xe5, 0x98, 0x81, 0xe5, 0x98, 0xa4, 0xe5, 0x98, 0xa3,
  0xe5, 0x97, 0xbe, 0xe5, 0x98, 0x80, 0xe5, 0x98, 0xa7, 0xe5, 0x98, 0xad,
  0xe5, 0x99, 0x98, 0xe5, 0x98, 0xb9, 0xe5, 0x99, 0x97, 0xe5, 0x98, 0xac,
  0xe5, 0x99, 0x8d, 0xe5, 0x99, 0xa2, 0xe5, 0x99, 0x99, 0xe5, 0x99, 0x9c,
  0xe5, 0x99, 0x8c, 0xe5, 0x99, 0x94, 0xe5, 0x9a, 0x86, 0xe5, 0x99, 0xa4,
  0xe5, 0x99, 0xb1, 0xe5, 0x99, 0xab, 0xe5, 0x99, 0xbb, 0xe5, 0x99, 0xbc,
  0xe5, 0x9a, 0x85, 0xe5, 0x9a, 0x93, 0xe5, 0x9a, 0xaf, 0xe5, 0x9b, 0x94,
  0xe5, 0x9b, 0x97, 0xe5, 0x9b, 0x9d, 0xe5, 0x9b, 0xa1, 0xe5, 0x9b, 0xb5,
  0xe5, 0x9b, 0xab, 0xe5, 0x9b, 0xb9, 0xe5, 0x9b, 0xbf, 0xe5, 0x9c, 0x84,
  0xe5, 0x9c, 0x8a, 0xe5, 0x9c, 0x89, 0xe5, 0x9c, 0x9c, 0xe5, 0xb8, 0x8f,
  0xe5, 0xb8, 0x99, 0xe5, 0xb8, 0x94, 0xe5, 0xb8, 0x91, 0xe5, 0xb8, 0xb1,
  0xe5, 0xb8, 0xbb, 0xe5, 0xb8, 0xbc
};

unsigned char gb2312_row_65_converted_to_utf8[] = {
  0xe5, 0xb8, 0xb7, 0xe5, 0xb9, 0x84, 0xe5, 0xb9, 0x94, 0xe5, 0xb9, 0x9b,
  0xe5, 0xb9, 0x9e, 0xe5, 0xb9, 0xa1, 0xe5, 0xb2, 0x8c, 0xe5, 0xb1, 0xba,
  0xe5, 0xb2, 0x8d, 0xe5, 0xb2, 0x90, 0xe5, 0xb2, 0x96, 0xe5, 0xb2, 0x88,
  0xe5, 0xb2, 0x98, 0xe5, 0xb2, 0x99, 0xe5, 0xb2, 0x91, 0xe5, 0xb2, 0x9a,
  0xe5, 0xb2, 0x9c, 0xe5, 0xb2, 0xb5, 0xe5, 0xb2, 0xa2, 0xe5, 0xb2, 0xbd,
  0xe5, 0xb2, 0xac, 0xe5, 0xb2, 0xab, 0xe5, 0xb2, 0xb1, 0xe5, 0xb2, 0xa3,
  0xe5, 0xb3, 0x81, 0xe5, 0xb2, 0xb7, 0xe5, 0xb3, 0x84, 0xe5, 0xb3, 0x92,
  0xe5, 0xb3, 0xa4, 0xe5, 0xb3, 0x8b, 0xe5, 0xb3, 0xa5, 0xe5, 0xb4, 0x82,
  0xe5, 0xb4, 0x83, 0xe5, 0xb4, 0xa7, 0xe5, 0xb4, 0xa6, 0xe5, 0xb4, 0xae,
  0xe5, 0xb4, 0xa4, 0xe5, 0xb4, 0x9e, 0xe5, 0xb4, 0x86, 0xe5, 0xb4, 0x9b,
  0xe5, 0xb5, 0x98, 0xe5, 0xb4, 0xbe, 0xe5, 0xb4, 0xb4, 0xe5, 0xb4, 0xbd,
  0xe5, 0xb5, 0xac, 0xe5, 0xb5, 0x9b, 0xe5, 0xb5, 0xaf, 0xe5, 0xb5, 0x9d,
  0xe5, 0xb5, 0xab, 0xe5, 0xb5, 0x8b, 0xe5, 0xb5, 0x8a, 0xe5, 0xb5, 0xa9,
  0xe5, 0xb5, 0xb4, 0xe5, 0xb6, 0x82, 0xe5, 0xb6, 0x99, 0xe5, 0xb6, 0x9d,
  0xe8, 0xb1, 0xb3, 0xe5, 0xb6, 0xb7, 0xe5, 0xb7, 0x85, 0xe5, 0xbd, 0xb3,
  0xe5, 0xbd, 0xb7, 0xe5, 0xbe, 0x82, 0xe5, 0xbe, 0x87, 0xe5, 0xbe, 0x89,
  0xe5, 0xbe, 0x8c, 0xe5, 0xbe, 0x95, 0xe5, 0xbe, 0x99, 0xe5, 0xbe, 0x9c,
  0xe5, 0xbe, 0xa8, 0xe5, 0xbe, 0xad, 0xe5, 0xbe, 0xb5, 0xe5, 0xbe, 0xbc,
  0xe8, 0xa1, 0xa2, 0xe5, 0xbd, 0xa1, 0xe7, 0x8a, 0xad, 0xe7, 0x8a, 0xb0,
  0xe7, 0x8a, 0xb4, 0xe7, 0x8a, 0xb7, 0xe7, 0x8a, 0xb8, 0xe7, 0x8b, 0x83,
  0xe7, 0x8b, 0x81, 0xe7, 0x8b, 0x8e, 0xe7, 0x8b, 0x8d, 0xe7, 0x8b, 0x92,
  0xe7, 0x8b, 0xa8, 0xe7, 0x8b, 0xaf, 0xe7, 0x8b, 0xa9, 0xe7, 0x8b, 0xb2,
  0xe7, 0x8b, 0xb4, 0xe7, 0x8b, 0xb7, 0xe7, 0x8c, 0x81, 0xe7, 0x8b, 0xb3,
  0xe7, 0x8c, 0x83, 0xe7, 0x8b, 0xba
};

unsigned char gb2312_row_66_converted_to_utf8[] = {
  0xe7, 0x8b, 0xbb, 0xe7, 0x8c, 0x97, 0xe7, 0x8c, 0x93, 0xe7, 0x8c, 0xa1,
  0xe7, 0x8c, 0x8a, 0xe7, 0x8c, 0x9e, 0xe7, 0x8c, 0x9d, 0xe7, 0x8c, 0x95,
  0xe7, 0x8c, 0xa2, 0xe7, 0x8c, 0xb9, 0xe7, 0x8c, 0xa5, 0xe7, 0x8c, 0xac,
  0xe7, 0x8c, 0xb8, 0xe7, 0x8c, 0xb1, 0xe7, 0x8d, 0x90, 0xe7, 0x8d, 0x8d,
  0xe7, 0x8d, 0x97, 0xe7, 0x8d, 0xa0, 0xe7, 0x8d, 0xac, 0xe7, 0x8d, 0xaf,
  0xe7, 0x8d, 0xbe, 0xe8, 0x88, 0x9b, 0xe5, 0xa4, 0xa5, 0xe9, 0xa3, 0xa7,
  0xe5, 0xa4, 0xa4, 0xe5, 0xa4, 0x82, 0xe9, 0xa5, 0xa3, 0xe9, 0xa5, 0xa7,
  0xe9, 0xa5, 0xa8, 0xe9, 0xa5, 0xa9, 0xe9, 0xa5, 0xaa, 0xe9, 0xa5, 0xab,
  0xe9, 0xa5, 0xac, 0xe9, 0xa5, 0xb4, 0xe9, 0xa5, 0xb7, 0xe9, 0xa5, 0xbd,
  0xe9, 0xa6, 0x80, 0xe9, 0xa6, 0x84, 0xe9, 0xa6, 0x87, 0xe9, 0xa6, 0x8a,
  0xe9, 0xa6, 0x8d, 0xe9, 0xa6, 0x90, 0xe9, 0xa6, 0x91, 0xe9, 0xa6, 0x93,
  0xe9, 0xa6, 0x94, 0xe9, 0xa6, 0x95, 0xe5, 0xba, 0x80, 0xe5, 0xba, 0x91,
  0xe5, 0xba, 0x8b, 0xe5, 0xba, 0x96, 0xe5, 0xba, 0xa5, 0xe5, 0xba, 0xa0,
  0xe5, 0xba, 0xb9, 0xe5, 0xba, 0xb5, 0xe5, 0xba, 0xbe, 0xe5, 0xba, 0xb3,
  0xe8, 0xb5, 0x93, 0xe5, 0xbb, 0x92, 0xe5, 0xbb, 0x91, 0xe5, 0xbb, 0x9b,
  0xe5, 0xbb, 0xa8, 0xe5, 0xbb, 0xaa, 0xe8, 0x86, 0xba, 0xe5, 0xbf, 0x84,
  0xe5, 0xbf, 0x89, 0xe5, 0xbf, 0x96, 0xe5, 0xbf, 0x8f, 0xe6, 0x80, 0x83,
  0xe5, 0xbf, 0xae, 0xe6, 0x80, 0x84, 0xe5, 0xbf, 0xa1, 0xe5, 0xbf, 0xa4,
  0xe5, 0xbf, 0xbe, 0xe6, 0x80, 0x85, 0xe6, 0x80, 0x86, 0xe5, 0xbf, 0xaa,
  0xe5, 0xbf, 0xad, 0xe5, 0xbf, 0xb8, 0xe6, 0x80, 0x99, 0xe6, 0x80, 0xb5,
  0xe6, 0x80, 0xa6, 0xe6, 0x80, 0x9b, 0xe6, 0x80, 0x8f, 0xe6, 0x80, 0x8d,
  0xe6, 0x80, 0xa9, 0xe6, 0x80, 0xab, 0xe6, 0x80, 0x8a, 0xe6, 0x80, 0xbf,
  0xe6, 0x80, 0xa1, 0xe6, 0x81, 0xb8, 0xe6, 0x81, 0xb9, 0xe6, 0x81, 0xbb,
  0xe6, 0x81, 0xba, 0xe6, 0x81, 0x82
};

unsigned char gb2312_row_67_converted_to_utf8[] = {
  0xe6, 0x81, 0xaa, 0xe6, 0x81, 0xbd, 0xe6, 0x82, 0x96, 0xe6, 0x82, 0x9a,
  0xe6, 0x82, 0xad, 0xe6, 0x82, 0x9d, 0xe6, 0x82, 0x83, 0xe6, 0x82, 0x92,
  0xe6, 0x82, 0x8c, 0xe6, 0x82, 0x9b, 0xe6, 0x83, 0xac, 0xe6, 0x82, 0xbb,
  0xe6, 0x82, 0xb1, 0xe6, 0x83, 0x9d, 0xe6, 0x83, 0x98, 0xe6, 0x83, 0x86,
  0xe6, 0x83, 0x9a, 0xe6, 0x82, 0xb4, 0xe6, 0x84, 0xa0, 0xe6, 0x84, 0xa6,
  0xe6, 0x84, 0x95, 0xe6, 0x84, 0xa3, 0xe6, 0x83, 0xb4, 0xe6, 0x84, 0x80,
  0xe6, 0x84, 0x8e, 0xe6, 0x84, 0xab, 0xe6, 0x85, 0x8a, 0xe6, 0x85, 0xb5,
  0xe6, 0x86, 0xac, 0xe6, 0x86, 0x94, 0xe6, 0x86, 0xa7, 0xe6, 0x86, 0xb7,
  0xe6, 0x87, 0x94, 0xe6, 0x87, 0xb5, 0xe5, 0xbf, 0x9d, 0xe9, 0x9a, 0xb3,
  0xe9, 0x97, 0xa9, 0xe9, 0x97, 0xab, 0xe9, 0x97, 0xb1, 0xe9, 0x97, 0xb3,
  0xe9, 0x97, 0xb5, 0xe9, 0x97, 0xb6, 0xe9, 0x97, 0xbc, 0xe9, 0x97, 0xbe,
  0xe9, 0x98, 0x83, 0xe9, 0x98, 0x84, 0xe9, 0x98, 0x86, 0xe9, 0x98, 0x88,
  0xe9, 0x98, 0x8a, 0xe9, 0x98, 0x8b, 0xe9, 0x98, 0x8c, 0xe9, 0x98, 0x8d,
  0xe9, 0x98, 0x8f, 0xe9, 0x98, 0x92, 0xe9, 0x98, 0x95, 0xe9, 0x98, 0x96,
  0xe9, 0x98, 0x97, 0xe9, 0x98, 0x99, 0xe9, 0x98, 0x9a, 0xe4, 0xb8, 0xac,
  0xe7, 0x88, 0xbf, 0xe6, 0x88, 0x95, 0xe6, 0xb0, 0xb5, 0xe6, 0xb1, 0x94,
  0xe6, 0xb1, 0x9c, 0xe6, 0xb1, 0x8a, 0xe6, 0xb2, 0xa3, 0xe6, 0xb2, 0x85,
  0xe6, 0xb2, 0x90, 0xe6, 0xb2, 0x94, 0xe6, 0xb2, 0x8c, 0xe6, 0xb1, 0xa8,
  0xe6, 0xb1, 0xa9, 0xe6, 0xb1, 0xb4, 0xe6, 0xb1, 0xb6, 0xe6, 0xb2, 0x86,
  0xe6, 0xb2, 0xa9, 0xe6, 0xb3, 0x90, 0xe6, 0xb3, 0x94, 0xe6, 0xb2, 0xad,
  0xe6, 0xb3, 0xb7, 0xe6, 0xb3, 0xb8, 0xe6, 0xb3, 0xb1, 0xe6, 0xb3, 0x97,
  0xe6, 0xb2, 0xb2, 0xe6, 0xb3, 0xa0, 0xe6, 0xb3, 0x96, 0xe6, 0xb3, 0xba,
  0xe6, 0xb3, 0xab, 0xe6, 0xb3, 0xae, 0xe6, 0xb2, 0xb1, 0xe6, 0xb3, 0x93,
  0xe6, 0xb3, 0xaf, 0xe6, 0xb3, 0xbe
};

unsigned char gb2312_row_68_converted_to_utf8[] = {
  0xe6, 0xb4, 0xb9, 0xe6, 0xb4, 0xa7, 0xe6, 0xb4, 0x8c, 0xe6, 0xb5, 0x83,
  0xe6, 0xb5, 0x88, 0xe6, 0xb4, 0x87, 0xe6, 0xb4, 0x84, 0xe6, 0xb4, 0x99,
  0xe6, 0xb4, 0x8e, 0xe6, 0xb4, 0xab, 0xe6, 0xb5, 0x8d, 0xe6, 0xb4, 0xae,
  0xe6, 0xb4, 0xb5, 0xe6, 0xb4, 0x9a, 0xe6, 0xb5, 0x8f, 0xe6, 0xb5, 0x92,
  0xe6, 0xb5, 0x94, 0xe6, 0xb4, 0xb3, 0xe6, 0xb6, 0x91, 0xe6, 0xb5, 0xaf,
  0xe6, 0xb6, 0x9e, 0xe6, 0xb6, 0xa0, 0xe6, 0xb5, 0x9e, 0xe6, 0xb6, 0x93,
  0xe6, 0xb6, 0x94, 0xe6, 0xb5, 0x9c, 0xe6, 0xb5, 0xa0, 0xe6, 0xb5, 0xbc,
  0xe6, 0xb5, 0xa3, 0xe6, 0xb8, 0x9a, 0xe6, 0xb7, 0x87, 0xe6, 0xb7, 0x85,
  0xe6, 0xb7, 0x9e, 0xe6, 0xb8, 0x8e, 0xe6, 0xb6, 0xbf, 0xe6, 0xb7, 0xa0,
  0xe6, 0xb8, 0x91, 0xe6, 0xb7, 0xa6, 0xe6, 0xb7, 0x9d, 0xe6, 0xb7, 0x99,
  0xe6, 0xb8, 0x96, 0xe6, 0xb6, 0xab, 0xe6, 0xb8, 0x8c, 0xe6, 0xb6, 0xae,
  0xe6, 0xb8, 0xab, 0xe6, 0xb9, 0xae, 0xe6, 0xb9, 0x8e, 0xe6, 0xb9, 0xab,
  0xe6, 0xba, 0xb2, 0xe6, 0xb9, 0x9f, 0xe6, 0xba, 0x86, 0xe6, 0xb9, 0x93,
  0xe6, 0xb9, 0x94, 0xe6, 0xb8, 0xb2, 0xe6, 0xb8, 0xa5, 0xe6, 0xb9, 0x84,
  0xe6, 0xbb, 0x9f, 0xe6, 0xba, 0xb1, 0xe6, 0xba, 0x98, 0xe6, 0xbb, 0xa0,
  0xe6, 0xbc, 0xad, 0xe6, 0xbb, 0xa2, 0xe6, 0xba, 0xa5, 0xe6, 0xba, 0xa7,
  0xe6, 0xba, 0xbd, 0xe6, 0xba, 0xbb, 0xe6, 0xba, 0xb7, 0xe6, 0xbb, 0x97,
  0xe6, 0xba, 0xb4, 0xe6, 0xbb, 0x8f, 0xe6, 0xba, 0x8f, 0xe6, 0xbb, 0x82,
  0xe6, 0xba, 0x9f, 0xe6, 0xbd, 0xa2, 0xe6, 0xbd, 0x86, 0xe6, 0xbd, 0x87,
  0xe6, 0xbc, 0xa4, 0xe6, 0xbc, 0x95, 0xe6, 0xbb, 0xb9, 0xe6, 0xbc, 0xaf,
  0xe6, 0xbc, 0xb6, 0xe6, 0xbd, 0x8b, 0xe6, 0xbd, 0xb4, 0xe6, 0xbc, 0xaa,
  0xe6, 0xbc, 0x89, 0xe6, 0xbc, 0xa9, 0xe6, 0xbe, 0x89, 0xe6, 0xbe, 0x8d,
  0xe6, 0xbe, 0x8c, 0xe6, 0xbd, 0xb8, 0xe6, 0xbd, 0xb2, 0xe6, 0xbd, 0xbc,
  0xe6, 0xbd, 0xba, 0xe6, 0xbf, 0x91
};

unsigned char gb2312_row_69_converted_to_utf8[] = {
  0xe6, 0xbf, 0x89, 0xe6, 0xbe, 0xa7, 0xe6, 0xbe, 0xb9, 0xe6, 0xbe, 0xb6,
  0xe6, 0xbf, 0x82, 0xe6, 0xbf, 0xa1, 0xe6, 0xbf, 0xae, 0xe6, 0xbf, 0x9e,
  0xe6, 0xbf, 0xa0, 0xe6, 0xbf, 0xaf, 0xe7, 0x80, 0x9a, 0xe7, 0x80, 0xa3,
  0xe7, 0x80, 0x9b, 0xe7, 0x80, 0xb9, 0xe7, 0x80, 0xb5, 0xe7, 0x81, 0x8f,
  0xe7, 0x81, 0x9e, 0xe5, 0xae, 0x80, 0xe5, 0xae, 0x84, 0xe5, 0xae, 0x95,
  0xe5, 0xae, 0x93, 0xe5, 0xae, 0xa5, 0xe5, 0xae, 0xb8, 0xe7, 0x94, 0xaf,
  0xe9, 0xaa, 0x9e, 0xe6, 0x90, 0xb4, 0xe5, 0xaf, 0xa4, 0xe5, 0xaf, 0xae,
  0xe8, 0xa4, 0xb0, 0xe5, 0xaf, 0xb0, 0xe8, 0xb9, 0x87, 0xe8, 0xac, 0x87,
  0xe8, 0xbe, 0xb6, 0xe8, 0xbf, 0x93, 0xe8, 0xbf, 0x95, 0xe8, 0xbf, 0xa5,
  0xe8, 0xbf, 0xae, 0xe8, 0xbf, 0xa4, 0xe8, 0xbf, 0xa9, 0xe8, 0xbf, 0xa6,
  0xe8, 0xbf, 0xb3, 0xe8, 0xbf, 0xa8, 0xe9, 0x80, 0x85, 0xe9, 0x80, 0x84,
  0xe9, 0x80, 0x8b, 0xe9, 0x80, 0xa6, 0xe9, 0x80, 0x91, 0xe9, 0x80, 0x8d,
  0xe9, 0x80, 0x96, 0xe9, 0x80, 0xa1, 0xe9, 0x80, 0xb5, 0xe9, 0x80, 0xb6,
  0xe9, 0x80, 0xad, 0xe9, 0x80, 0xaf, 0xe9, 0x81, 0x84, 0xe9, 0x81, 0x91,
  0xe9, 0x81, 0x92, 0xe9, 0x81, 0x90, 0xe9, 0x81, 0xa8, 0xe9, 0x81, 0x98,
  0xe9, 0x81, 0xa2, 0xe9, 0x81, 0x9b, 0xe6, 0x9a, 0xb9, 0xe9, 0x81, 0xb4,
  0xe9, 0x81, 0xbd, 0xe9, 0x82, 0x82, 0xe9, 0x82, 0x88, 0xe9, 0x82, 0x83,
  0xe9, 0x82, 0x8b, 0xe5, 0xbd, 0x90, 0xe5, 0xbd, 0x97, 0xe5, 0xbd, 0x96,
  0xe5, 0xbd, 0x98, 0xe5, 0xb0, 0xbb, 0xe5, 0x92, 0xab, 0xe5, 0xb1, 0x90,
  0xe5, 0xb1, 0x99, 0xe5, 0xad, 0xb1, 0xe5, 0xb1, 0xa3, 0xe5, 0xb1, 0xa6,
  0xe7, 0xbe, 0xbc, 0xe5, 0xbc, 0xaa, 0xe5, 0xbc, 0xa9, 0xe5, 0xbc, 0xad,
  0xe8, 0x89, 0xb4, 0xe5, 0xbc, 0xbc, 0xe9, 0xac, 0xbb, 0xe5, 0xb1, 0xae,
  0xe5, 0xa6, 0x81, 0xe5, 0xa6, 0x83, 0xe5, 0xa6, 0x8d, 0xe5, 0xa6, 0xa9,
  0xe5, 0xa6, 0xaa, 0xe5, 0xa6, 0xa3
};

unsigned char gb2312_row_70_converted_to_utf8[] = {
  0xe5, 0xa6, 0x97, 0xe5, 0xa7, 0x8a, 0xe5, 0xa6, 0xab, 0xe5, 0xa6, 0x9e,
  0xe5, 0xa6, 0xa4, 0xe5, 0xa7, 0x92, 0xe5, 0xa6, 0xb2, 0xe5, 0xa6, 0xaf,
  0xe5, 0xa7, 0x97, 0xe5, 0xa6, 0xbe, 0xe5, 0xa8, 0x85, 0xe5, 0xa8, 0x86,
  0xe5, 0xa7, 0x9d, 0xe5, 0xa8, 0x88, 0xe5, 0xa7, 0xa3, 0xe5, 0xa7, 0x98,
  0xe5, 0xa7, 0xb9, 0xe5, 0xa8, 0x8c, 0xe5, 0xa8, 0x89, 0xe5, 0xa8, 0xb2,
  0xe5, 0xa8, 0xb4, 0xe5, 0xa8, 0x91, 0xe5, 0xa8, 0xa3, 0xe5, 0xa8, 0x93,
  0xe5, 0xa9, 0x80, 0xe5, 0xa9, 0xa7, 0xe5, 0xa9, 0x8a, 0xe5, 0xa9, 0x95,
  0xe5, 0xa8, 0xbc, 0xe5, 0xa9, 0xa2, 0xe5, 0xa9, 0xb5, 0xe8, 0x83, 0xac,
  0xe5, 0xaa, 0xaa, 0xe5, 0xaa, 0x9b, 0xe5, 0xa9, 0xb7, 0xe5, 0xa9, 0xba,
  0xe5, 0xaa, 0xbe, 0xe5, 0xab, 0xab, 0xe5, 0xaa, 0xb2, 0xe5, 0xab, 0x92,
  0xe5, 0xab, 0x94, 0xe5, 0xaa, 0xb8, 0xe5, 0xab, 0xa0, 0xe5, 0xab, 0xa3,
  0xe5, 0xab, 0xb1, 0xe5, 0xab, 0x96, 0xe5, 0xab, 0xa6, 0xe5, 0xab, 0x98,
  0xe5, 0xab, 0x9c, 0xe5, 0xac, 0x89, 0xe5, 0xac, 0x97, 0xe5, 0xac, 0x96,
  0xe5, 0xac, 0xb2, 0xe5, 0xac, 0xb7, 0xe5, 0xad, 0x80, 0xe5, 0xb0, 0x95,
  0xe5, 0xb0, 0x9c, 0xe5, 0xad, 0x9a, 0xe5, 0xad, 0xa5, 0xe5, 0xad, 0xb3,
  0xe5, 0xad, 0x91, 0xe5, 0xad, 0x93, 0xe5, 0xad, 0xa2, 0xe9, 0xa9, 0xb5,
  0xe9, 0xa9, 0xb7, 0xe9, 0xa9, 0xb8, 0xe9, 0xa9, 0xba, 0xe9, 0xa9, 0xbf,
  0xe9, 0xa9, 0xbd, 0xe9, 0xaa, 0x80, 0xe9, 0xaa, 0x81, 0xe9, 0xaa, 0x85,
  0xe9, 0xaa, 0x88, 0xe9, 0xaa, 0x8a, 0xe9, 0xaa, 0x90, 0xe9, 0xaa, 0x92,
  0xe9, 0xaa, 0x93, 0xe9, 0xaa, 0x96, 0xe9, 0xaa, 0x98, 0xe9, 0xaa, 0x9b,
  0xe9, 0xaa, 0x9c, 0xe9, 0xaa, 0x9d, 0xe9, 0xaa, 0x9f, 0xe9, 0xaa, 0xa0,
  0xe9, 0xaa, 0xa2, 0xe9, 0xaa, 0xa3, 0xe9, 0xaa, 0xa5, 0xe9, 0xaa, 0xa7,
  0xe7, 0xba, 0x9f, 0xe7, 0xba, 0xa1, 0xe7, 0xba, 0xa3, 0xe7, 0xba, 0xa5,
  0xe7, 0xba, 0xa8, 0xe7, 0xba, 0xa9
};

unsigned char gb2312_row_71_converted_to_utf8[] = {
  0xe7, 0xba, 0xad, 0xe7, 0xba, 0xb0, 0xe7, 0xba, 0xbe, 0xe7, 0xbb, 0x80,
  0xe7, 0xbb, 0x81, 0xe7, 0xbb, 0x82, 0xe7, 0xbb, 0x89, 0xe7, 0xbb, 0x8b,
  0xe7, 0xbb, 0x8c, 0xe7, 0xbb, 0x90, 0xe7, 0xbb, 0x94, 0xe7, 0xbb, 0x97,
  0xe7, 0xbb, 0x9b, 0xe7, 0xbb, 0xa0, 0xe7, 0xbb, 0xa1, 0xe7, 0xbb, 0xa8,
  0xe7, 0xbb, 0xab, 0xe7, 0xbb, 0xae, 0xe7, 0xbb, 0xaf, 0xe7, 0xbb, 0xb1,
  0xe7, 0xbb, 0xb2, 0xe7, 0xbc, 0x8d, 0xe7, 0xbb, 0xb6, 0xe7, 0xbb, 0xba,
  0xe7, 0xbb, 0xbb, 0xe7, 0xbb, 0xbe, 0xe7, 0xbc, 0x81, 0xe7, 0xbc, 0x82,
  0xe7, 0xbc, 0x83, 0xe7, 0xbc, 0x87, 0xe7, 0xbc, 0x88, 0xe7, 0xbc, 0x8b,
  0xe7, 0xbc, 0x8c, 0xe7, 0xbc, 0x8f, 0xe7, 0xbc, 0x91, 0xe7, 0xbc, 0x92,
  0xe7, 0xbc, 0x97, 0xe7, 0xbc, 0x99, 0xe7, 0xbc, 0x9c, 0xe7, 0xbc, 0x9b,
  0xe7, 0xbc, 0x9f, 0xe7, 0xbc, 0xa1, 0xe7, 0xbc, 0xa2, 0xe7, 0xbc, 0xa3,
  0xe7, 0xbc, 0xa4, 0xe7, 0xbc, 0xa5, 0xe7, 0xbc, 0xa6, 0xe7, 0xbc, 0xa7,
  0xe7, 0xbc, 0xaa, 0xe7, 0xbc, 0xab, 0xe7, 0xbc, 0xac, 0xe7, 0xbc, 0xad,
  0xe7, 0xbc, 0xaf, 0xe7, 0xbc, 0xb0, 0xe7, 0xbc, 0xb1, 0xe7, 0xbc, 0xb2,
  0xe7, 0xbc, 0xb3, 0xe7, 0xbc, 0xb5, 0xe5, 0xb9, 0xba, 0xe7, 0x95, 0xbf,
  0xe5, 0xb7, 0x9b, 0xe7, 0x94, 0xbe, 0xe9, 0x82, 0x95, 0xe7, 0x8e, 0x8e,
  0xe7, 0x8e, 0x91, 0xe7, 0x8e, 0xae, 0xe7, 0x8e, 0xa2, 0xe7, 0x8e, 0x9f,
  0xe7, 0x8f, 0x8f, 0xe7, 0x8f, 0x82, 0xe7, 0x8f, 0x91, 0xe7, 0x8e, 0xb7,
  0xe7, 0x8e, 0xb3, 0xe7, 0x8f, 0x80, 0xe7, 0x8f, 0x89, 0xe7, 0x8f, 0x88,
  0xe7, 0x8f, 0xa5, 0xe7, 0x8f, 0x99, 0xe9, 0xa1, 0xbc, 0xe7, 0x90, 0x8a,
  0xe7, 0x8f, 0xa9, 0xe7, 0x8f, 0xa7, 0xe7, 0x8f, 0x9e, 0xe7, 0x8e, 0xba,
  0xe7, 0x8f, 0xb2, 0xe7, 0x90, 0x8f, 0xe7, 0x90, 0xaa, 0xe7, 0x91, 0x9b,
  0xe7, 0x90, 0xa6, 0xe7, 0x90, 0xa5, 0xe7, 0x90, 0xa8, 0xe7, 0x90, 0xb0,
  0xe7, 0x90, 0xae, 0xe7, 0x90, 0xac
};

unsigned char gb2312_row_72_converted_to_utf8[] = {
  0xe7, 0x90, 0x9b, 0xe7, 0x90, 0x9a, 0xe7, 0x91, 0x81, 0xe7, 0x91, 0x9c,
  0xe7, 0x91, 0x97, 0xe7, 0x91, 0x95, 0xe7, 0x91, 0x99, 0xe7, 0x91, 0xb7,
  0xe7, 0x91, 0xad, 0xe7, 0x91, 0xbe, 0xe7, 0x92, 0x9c, 0xe7, 0x92, 0x8e,
  0xe7, 0x92, 0x80, 0xe7, 0x92, 0x81, 0xe7, 0x92, 0x87, 0xe7, 0x92, 0x8b,
  0xe7, 0x92, 0x9e, 0xe7, 0x92, 0xa8, 0xe7, 0x92, 0xa9, 0xe7, 0x92, 0x90,
  0xe7, 0x92, 0xa7, 0xe7, 0x93, 0x92, 0xe7, 0x92, 0xba, 0xe9, 0x9f, 0xaa,
  0xe9, 0x9f, 0xab, 0xe9, 0x9f, 0xac, 0xe6, 0x9d, 0x8c, 0xe6, 0x9d, 0x93,
  0xe6, 0x9d, 0x9e, 0xe6, 0x9d, 0x88, 0xe6, 0x9d, 0xa9, 0xe6, 0x9e, 0xa5,
  0xe6, 0x9e, 0x87, 0xe6, 0x9d, 0xaa, 0xe6, 0x9d, 0xb3, 0xe6, 0x9e, 0x98,
  0xe6, 0x9e, 0xa7, 0xe6, 0x9d, 0xb5, 0xe6, 0x9e, 0xa8, 0xe6, 0x9e, 0x9e,
  0xe6, 0x9e, 0xad, 0xe6, 0x9e, 0x8b, 0xe6, 0x9d, 0xb7, 0xe6, 0x9d, 0xbc,
  0xe6, 0x9f, 0xb0, 0xe6, 0xa0, 0x89, 0xe6, 0x9f, 0x98, 0xe6, 0xa0, 0x8a,
  0xe6, 0x9f, 0xa9, 0xe6, 0x9e, 0xb0, 0xe6, 0xa0, 0x8c, 0xe6, 0x9f, 0x99,
  0xe6, 0x9e, 0xb5, 0xe6, 0x9f, 0x9a, 0xe6, 0x9e, 0xb3, 0xe6, 0x9f, 0x9d,
  0xe6, 0xa0, 0x80, 0xe6, 0x9f, 0x83, 0xe6, 0x9e, 0xb8, 0xe6, 0x9f, 0xa2,
  0xe6, 0xa0, 0x8e, 0xe6, 0x9f, 0x81, 0xe6, 0x9f, 0xbd, 0xe6, 0xa0, 0xb2,
  0xe6, 0xa0, 0xb3, 0xe6, 0xa1, 0xa0, 0xe6, 0xa1, 0xa1, 0xe6, 0xa1, 0x8e,
  0xe6, 0xa1, 0xa2, 0xe6, 0xa1, 0x84, 0xe6, 0xa1, 0xa4, 0xe6, 0xa2, 0x83,
  0xe6, 0xa0, 0x9d, 0xe6, 0xa1, 0x95, 0xe6, 0xa1, 0xa6, 0xe6, 0xa1, 0x81,
  0xe6, 0xa1, 0xa7, 0xe6, 0xa1, 0x80, 0xe6, 0xa0, 0xbe, 0xe6, 0xa1, 0x8a,
  0xe6, 0xa1, 0x89, 0xe6, 0xa0, 0xa9, 0xe6, 0xa2, 0xb5, 0xe6, 0xa2, 0x8f,
  0xe6, 0xa1, 0xb4, 0xe6, 0xa1, 0xb7, 0xe6, 0xa2, 0x93, 0xe6, 0xa1, 0xab,
  0xe6, 0xa3, 0x82, 0xe6, 0xa5, 0xae, 0xe6, 0xa3, 0xbc, 0xe6, 0xa4, 0x9f,
  0xe6, 0xa4, 0xa0, 0xe6, 0xa3, 0xb9
};

unsigned char gb2312_row_73_converted_to_utf8[] = {
  0xe6, 0xa4, 0xa4, 0xe6, 0xa3, 0xb0, 0xe6, 0xa4, 0x8b, 0xe6, 0xa4, 0x81,
  0xe6, 0xa5, 0x97, 0xe6, 0xa3, 0xa3, 0xe6, 0xa4, 0x90, 0xe6, 0xa5, 0xb1,
  0xe6, 0xa4, 0xb9, 0xe6, 0xa5, 0xa0, 0xe6, 0xa5, 0x82, 0xe6, 0xa5, 0x9d,
  0xe6, 0xa6, 0x84, 0xe6, 0xa5, 0xab, 0xe6, 0xa6, 0x80, 0xe6, 0xa6, 0x98,
  0xe6, 0xa5, 0xb8, 0xe6, 0xa4, 0xb4, 0xe6, 0xa7, 0x8c, 0xe6, 0xa6, 0x87,
  0xe6, 0xa6, 0x88, 0xe6, 0xa7, 0x8e, 0xe6, 0xa6, 0x89, 0xe6, 0xa5, 0xa6,
  0xe6, 0xa5, 0xa3, 0xe6, 0xa5, 0xb9, 0xe6, 0xa6, 0x9b, 0xe6, 0xa6, 0xa7,
  0xe6, 0xa6, 0xbb, 0xe6, 0xa6, 0xab, 0xe6, 0xa6, 0xad, 0xe6, 0xa7, 0x94,
  0xe6, 0xa6, 0xb1, 0xe6, 0xa7, 0x81, 0xe6, 0xa7, 0x8a, 0xe6, 0xa7, 0x9f,
  0xe6, 0xa6, 0x95, 0xe6, 0xa7, 0xa0, 0xe6, 0xa6, 0x8d, 0xe6, 0xa7, 0xbf,
  0xe6, 0xa8, 0xaf, 0xe6, 0xa7, 0xad, 0xe6, 0xa8, 0x97, 0xe6, 0xa8, 0x98,
  0xe6, 0xa9, 0xa5, 0xe6, 0xa7, 0xb2, 0xe6, 0xa9, 0x84, 0xe6, 0xa8, 0xbe,
  0xe6, 0xaa, 0xa0, 0xe6, 0xa9, 0x90, 0xe6, 0xa9, 0x9b, 0xe6, 0xa8, 0xb5,
  0xe6, 0xaa, 0x8e, 0xe6, 0xa9, 0xb9, 0xe6, 0xa8, 0xbd, 0xe6, 0xa8, 0xa8,
  0xe6, 0xa9, 0x98, 0xe6, 0xa9, 0xbc, 0xe6, 0xaa, 0x91, 0xe6, 0xaa, 0x90,
  0xe6, 0xaa, 0xa9, 0xe6, 0xaa, 0x97, 0xe6, 0xaa, 0xab, 0xe7, 0x8c, 0xb7,
  0xe7, 0x8d, 0x92, 0xe6, 0xae, 0x81, 0xe6, 0xae, 0x82, 0xe6, 0xae, 0x87,
  0xe6, 0xae, 0x84, 0xe6, 0xae, 0x92, 0xe6, 0xae, 0x93, 0xe6, 0xae, 0x8d,
  0xe6, 0xae, 0x9a, 0xe6, 0xae, 0x9b, 0xe6, 0xae, 0xa1, 0xe6, 0xae, 0xaa,
  0xe8, 0xbd, 0xab, 0xe8, 0xbd, 0xad, 0xe8, 0xbd, 0xb1, 0xe8, 0xbd, 0xb2,
  0xe8, 0xbd, 0xb3, 0xe8, 0xbd, 0xb5, 0xe8, 0xbd, 0xb6, 0xe8, 0xbd, 0xb8,
  0xe8, 0xbd, 0xb7, 0xe8, 0xbd, 0xb9, 0xe8, 0xbd, 0xba, 0xe8, 0xbd, 0xbc,
  0xe8, 0xbd, 0xbe, 0xe8, 0xbe, 0x81, 0xe8, 0xbe, 0x82, 0xe8, 0xbe, 0x84,
  0xe8, 0xbe, 0x87, 0xe8, 0xbe, 0x8b
};

unsigned char gb2312_row_74_converted_to_utf8[] = {
  0xe8, 0xbe, 0x8d, 0xe8, 0xbe, 0x8e, 0xe8, 0xbe, 0x8f, 0xe8, 0xbe, 0x98,
  0xe8, 0xbe, 0x9a, 0xe8, 0xbb, 0x8e, 0xe6, 0x88, 0x8b, 0xe6, 0x88, 0x97,
  0xe6, 0x88, 0x9b, 0xe6, 0x88, 0x9f, 0xe6, 0x88, 0xa2, 0xe6, 0x88, 0xa1,
  0xe6, 0x88, 0xa5, 0xe6, 0x88, 0xa4, 0xe6, 0x88, 0xac, 0xe8, 0x87, 0xa7,
  0xe7, 0x93, 0xaf, 0xe7, 0x93, 0xb4, 0xe7, 0x93, 0xbf, 0xe7, 0x94, 0x8f,
  0xe7, 0x94, 0x91, 0xe7, 0x94, 0x93, 0xe6, 0x94, 0xb4, 0xe6, 0x97, 0xae,
  0xe6, 0x97, 0xaf, 0xe6, 0x97, 0xb0, 0xe6, 0x98, 0x8a, 0xe6, 0x98, 0x99,
  0xe6, 0x9d, 0xb2, 0xe6, 0x98, 0x83, 0xe6, 0x98, 0x95, 0xe6, 0x98, 0x80,
  0xe7, 0x82, 0x85, 0xe6, 0x9b, 0xb7, 0xe6, 0x98, 0x9d, 0xe6, 0x98, 0xb4,
  0xe6, 0x98, 0xb1, 0xe6, 0x98, 0xb6, 0xe6, 0x98, 0xb5, 0xe8, 0x80, 0x86,
  0xe6, 0x99, 0x9f, 0xe6, 0x99, 0x94, 0xe6, 0x99, 0x81, 0xe6, 0x99, 0x8f,
  0xe6, 0x99, 0x96, 0xe6, 0x99, 0xa1, 0xe6, 0x99, 0x97, 0xe6, 0x99, 0xb7,
  0xe6, 0x9a, 0x84, 0xe6, 0x9a, 0x8c, 0xe6, 0x9a, 0xa7, 0xe6, 0x9a, 0x9d,
  0xe6, 0x9a, 0xbe, 0xe6, 0x9b, 0x9b, 0xe6, 0x9b, 0x9c, 0xe6, 0x9b, 0xa6,
  0xe6, 0x9b, 0xa9, 0xe8, 0xb4, 0xb2, 0xe8, 0xb4, 0xb3, 0xe8, 0xb4, 0xb6,
  0xe8, 0xb4, 0xbb, 0xe8, 0xb4, 0xbd, 0xe8, 0xb5, 0x80, 0xe8, 0xb5, 0x85,
  0xe8, 0xb5, 0x86, 0xe8, 0xb5, 0x88, 0xe8, 0xb5, 0x89, 0xe8, 0xb5, 0x87,
  0xe8, 0xb5, 0x8d, 0xe8, 0xb5, 0x95, 0xe8, 0xb5, 0x99, 0xe8, 0xa7, 0x87,
  0xe8, 0xa7, 0x8a, 0xe8, 0xa7, 0x8b, 0xe8, 0xa7, 0x8c, 0xe8, 0xa7, 0x8e,
  0xe8, 0xa7, 0x8f, 0xe8, 0xa7, 0x90, 0xe8, 0xa7, 0x91, 0xe7, 0x89, 0xae,
  0xe7, 0x8a, 0x9f, 0xe7, 0x89, 0x9d, 0xe7, 0x89, 0xa6, 0xe7, 0x89, 0xaf,
  0xe7, 0x89, 0xbe, 0xe7, 0x89, 0xbf, 0xe7, 0x8a, 0x84, 0xe7, 0x8a, 0x8b,
  0xe7, 0x8a, 0x8d, 0xe7, 0x8a, 0x8f, 0xe7, 0x8a, 0x92, 0xe6, 0x8c, 0x88,
  0xe6, 0x8c, 0xb2, 0xe6, 0x8e, 0xb0
};

unsigned char gb2312_row_75_converted_to_utf8[] = {
  0xe6, 0x90, 0xbf, 0xe6, 0x93, 0x98, 0xe8, 0x80, 0x84, 0xe6, 0xaf, 0xaa,
  0xe6, 0xaf, 0xb3, 0xe6, 0xaf, 0xbd, 0xe6, 0xaf, 0xb5, 0xe6, 0xaf, 0xb9,
  0xe6, 0xb0, 0x85, 0xe6, 0xb0, 0x87, 0xe6, 0xb0, 0x86, 0xe6, 0xb0, 0x8d,
  0xe6, 0xb0, 0x95, 0xe6, 0xb0, 0x98, 0xe6, 0xb0, 0x99, 0xe6, 0xb0, 0x9a,
  0xe6, 0xb0, 0xa1, 0xe6, 0xb0, 0xa9, 0xe6, 0xb0, 0xa4, 0xe6, 0xb0, 0xaa,
  0xe6, 0xb0, 0xb2, 0xe6, 0x94, 0xb5, 0xe6, 0x95, 0x95, 0xe6, 0x95, 0xab,
  0xe7, 0x89, 0x8d, 0xe7, 0x89, 0x92, 0xe7, 0x89, 0x96, 0xe7, 0x88, 0xb0,
  0xe8, 0x99, 0xa2, 0xe5, 0x88, 0x96, 0xe8, 0x82, 0x9f, 0xe8, 0x82, 0x9c,
  0xe8, 0x82, 0x93, 0xe8, 0x82, 0xbc, 0xe6, 0x9c, 0x8a, 0xe8, 0x82, 0xbd,
  0xe8, 0x82, 0xb1, 0xe8, 0x82, 0xab, 0xe8, 0x82, 0xad, 0xe8, 0x82, 0xb4,
  0xe8, 0x82, 0xb7, 0xe8, 0x83, 0xa7, 0xe8, 0x83, 0xa8, 0xe8, 0x83, 0xa9,
  0xe8, 0x83, 0xaa, 0xe8, 0x83, 0x9b, 0xe8, 0x83, 0x82, 0xe8, 0x83, 0x84,
  0xe8, 0x83, 0x99, 0xe8, 0x83, 0x8d, 0xe8, 0x83, 0x97, 0xe6, 0x9c, 0x90,
  0xe8, 0x83, 0x9d, 0xe8, 0x83, 0xab, 0xe8, 0x83, 0xb1, 0xe8, 0x83, 0xb4,
  0xe8, 0x83, 0xad, 0xe8, 0x84, 0x8d, 0xe8, 0x84, 0x8e, 0xe8, 0x83, 0xb2,
  0xe8, 0x83, 0xbc, 0xe6, 0x9c, 0x95, 0xe8, 0x84, 0x92, 0xe8, 0xb1, 0x9a,
  0xe8, 0x84, 0xb6, 0xe8, 0x84, 0x9e, 0xe8, 0x84, 0xac, 0xe8, 0x84, 0x98,
  0xe8, 0x84, 0xb2, 0xe8, 0x85, 0x88, 0xe8, 0x85, 0x8c, 0xe8, 0x85, 0x93,
  0xe8, 0x85, 0xb4, 0xe8, 0x85, 0x99, 0xe8, 0x85, 0x9a, 0xe8, 0x85, 0xb1,
  0xe8, 0x85, 0xa0, 0xe8, 0x85, 0xa9, 0xe8, 0x85, 0xbc, 0xe8, 0x85, 0xbd,
  0xe8, 0x85, 0xad, 0xe8, 0x85, 0xa7, 0xe5, 0xa1, 0x8d, 0xe5, 0xaa, 0xb5,
  0xe8, 0x86, 0x88, 0xe8, 0x86, 0x82, 0xe8, 0x86, 0x91, 0xe6, 0xbb, 0x95,
  0xe8, 0x86, 0xa3, 0xe8, 0x86, 0xaa, 0xe8, 0x87, 0x8c, 0xe6, 0x9c, 0xa6,
  0xe8, 0x87, 0x8a, 0xe8, 0x86, 0xbb
};

unsigned char gb2312_row_76_converted_to_utf8[] = {
  0xe8, 0x87, 0x81, 0xe8, 0x86, 0xa6, 0xe6, 0xac, 0xa4, 0xe6, 0xac, 0xb7,
  0xe6, 0xac, 0xb9, 0xe6, 0xad, 0x83, 0xe6, 0xad, 0x86, 0xe6, 0xad, 0x99,
  0xe9, 0xa3, 0x91, 0xe9, 0xa3, 0x92, 0xe9, 0xa3, 0x93, 0xe9, 0xa3, 0x95,
  0xe9, 0xa3, 0x99, 0xe9, 0xa3, 0x9a, 0xe6, 0xae, 0xb3, 0xe5, 0xbd, 0x80,
  0xe6, 0xaf, 0x82, 0xe8, 0xa7, 0xb3, 0xe6, 0x96, 0x90, 0xe9, 0xbd, 0x91,
  0xe6, 0x96, 0x93, 0xe6, 0x96, 0xbc, 0xe6, 0x97, 0x86, 0xe6, 0x97, 0x84,
  0xe6, 0x97, 0x83, 0xe6, 0x97, 0x8c, 0xe6, 0x97, 0x8e, 0xe6, 0x97, 0x92,
  0xe6, 0x97, 0x96, 0xe7, 0x82, 0x80, 0xe7, 0x82, 0x9c, 0xe7, 0x82, 0x96,
  0xe7, 0x82, 0x9d, 0xe7, 0x82, 0xbb, 0xe7, 0x83, 0x80, 0xe7, 0x82, 0xb7,
  0xe7, 0x82, 0xab, 0xe7, 0x82, 0xb1, 0xe7, 0x83, 0xa8, 0xe7, 0x83, 0x8a,
  0xe7, 0x84, 0x90, 0xe7, 0x84, 0x93, 0xe7, 0x84, 0x96, 0xe7, 0x84, 0xaf,
  0xe7, 0x84, 0xb1, 0xe7, 0x85, 0xb3, 0xe7, 0x85, 0x9c, 0xe7, 0x85, 0xa8,
  0xe7, 0x85, 0x85, 0xe7, 0x85, 0xb2, 0xe7, 0x85, 0x8a, 0xe7, 0x85, 0xb8,
  0xe7, 0x85, 0xba, 0xe7, 0x86, 0x98, 0xe7, 0x86, 0xb3, 0xe7, 0x86, 0xb5,
  0xe7, 0x86, 0xa8, 0xe7, 0x86, 0xa0, 0xe7, 0x87, 0xa0, 0xe7, 0x87, 0x94,
  0xe7, 0x87, 0xa7, 0xe7, 0x87, 0xb9, 0xe7, 0x88, 0x9d, 0xe7, 0x88, 0xa8,
  0xe7, 0x81, 0xac, 0xe7, 0x84, 0x98, 0xe7, 0x85, 0xa6, 0xe7, 0x86, 0xb9,
  0xe6, 0x88, 0xbe, 0xe6, 0x88, 0xbd, 0xe6, 0x89, 0x83, 0xe6, 0x89, 0x88,
  0xe6, 0x89, 0x89, 0xe7, 0xa4, 0xbb, 0xe7, 0xa5, 0x80, 0xe7, 0xa5, 0x86,
  0xe7, 0xa5, 0x89, 0xe7, 0xa5, 0x9b, 0xe7, 0xa5, 0x9c, 0xe7, 0xa5, 0x93,
  0xe7, 0xa5, 0x9a, 0xe7, 0xa5, 0xa2, 0xe7, 0xa5, 0x97, 0xe7, 0xa5, 0xa0,
  0xe7, 0xa5, 0xaf, 0xe7, 0xa5, 0xa7, 0xe7, 0xa5, 0xba, 0xe7, 0xa6, 0x85,
  0xe7, 0xa6, 0x8a, 0xe7, 0xa6, 0x9a, 0xe7, 0xa6, 0xa7, 0xe7, 0xa6, 0xb3,
  0xe5, 0xbf, 0x91, 0xe5, 0xbf, 0x90
};

unsigned char gb2312_row_77_converted_to_utf8[] = {
  0xe6, 0x80, 0xbc, 0xe6, 0x81, 0x9d, 0xe6, 0x81, 0x9a, 0xe6, 0x81, 0xa7,
  0xe6, 0x81, 0x81, 0xe6, 0x81, 0x99, 0xe6, 0x81, 0xa3, 0xe6, 0x82, 0xab,
  0xe6, 0x84, 0x86, 0xe6, 0x84, 0x8d, 0xe6, 0x85, 0x9d, 0xe6, 0x86, 0xa9,
  0xe6, 0x86, 0x9d, 0xe6, 0x87, 0x8b, 0xe6, 0x87, 0x91, 0xe6, 0x88, 0x86,
  0xe8, 0x82, 0x80, 0xe8, 0x81, 0xbf, 0xe6, 0xb2, 0x93, 0xe6, 0xb3, 0xb6,
  0xe6, 0xb7, 0xbc, 0xe7, 0x9f, 0xb6, 0xe7, 0x9f, 0xb8, 0xe7, 0xa0, 0x80,
  0xe7, 0xa0, 0x89, 0xe7, 0xa0, 0x97, 0xe7, 0xa0, 0x98, 0xe7, 0xa0, 0x91,
  0xe6, 0x96, 0xab, 0xe7, 0xa0, 0xad, 0xe7, 0xa0, 0x9c, 0xe7, 0xa0, 0x9d,
  0xe7, 0xa0, 0xb9, 0xe7, 0xa0, 0xba, 0xe7, 0xa0, 0xbb, 0xe7, 0xa0, 0x9f,
  0xe7, 0xa0, 0xbc, 0xe7, 0xa0, 0xa5, 0xe7, 0xa0, 0xac, 0xe7, 0xa0, 0xa3,
  0xe7, 0xa0, 0xa9, 0xe7, 0xa1, 0x8e, 0xe7, 0xa1, 0xad, 0xe7, 0xa1, 0x96,
  0xe7, 0xa1, 0x97, 0xe7, 0xa0, 0xa6, 0xe7, 0xa1, 0x90, 0xe7, 0xa1, 0x87,
  0xe7, 0xa1, 0x8c, 0xe7, 0xa1, 0xaa, 0xe7, 0xa2, 0x9b, 0xe7, 0xa2, 0x93,
  0xe7, 0xa2, 0x9a, 0xe7, 0xa2, 0x87, 0xe7, 0xa2, 0x9c, 0xe7, 0xa2, 0xa1,
  0xe7, 0xa2, 0xa3, 0xe7, 0xa2, 0xb2, 0xe7, 0xa2, 0xb9, 0xe7, 0xa2, 0xa5,
  0xe7, 0xa3, 0x94, 0xe7, 0xa3, 0x99, 0xe7, 0xa3, 0x89, 0xe7, 0xa3, 0xac,
  0xe7, 0xa3, 0xb2, 0xe7, 0xa4, 0x85, 0xe7, 0xa3, 0xb4, 0xe7, 0xa4, 0x93,
  0xe7, 0xa4, 0xa4, 0xe7, 0xa4, 0x9e, 0xe7, 0xa4, 0xb4, 0xe9, 0xbe, 0x9b,
  0xe9, 0xbb, 0xb9, 0xe9, 0xbb, 0xbb, 0xe9, 0xbb, 0xbc, 0xe7, 0x9b, 0xb1,
  0xe7, 0x9c, 0x84, 0xe7, 0x9c, 0x8d, 0xe7, 0x9b, 0xb9, 0xe7, 0x9c, 0x87,
  0xe7, 0x9c, 0x88, 0xe7, 0x9c, 0x9a, 0xe7, 0x9c, 0xa2, 0xe7, 0x9c, 0x99,
  0xe7, 0x9c, 0xad, 0xe7, 0x9c, 0xa6, 0xe7, 0x9c, 0xb5, 0xe7, 0x9c, 0xb8,
  0xe7, 0x9d, 0x90, 0xe7, 0x9d, 0x91, 0xe7, 0x9d, 0x87, 0xe7, 0x9d, 0x83,
  0xe7, 0x9d, 0x9a, 0xe7, 0x9d, 0xa8
};

unsigned char gb2312_row_78_converted_to_utf8[] = {
  0xe7, 0x9d, 0xa2, 0xe7, 0x9d, 0xa5, 0xe7, 0x9d, 0xbf, 0xe7, 0x9e, 0x8d,
  0xe7, 0x9d, 0xbd, 0xe7, 0x9e, 0x80, 0xe7, 0x9e, 0x8c, 0xe7, 0x9e, 0x91,
  0xe7, 0x9e, 0x9f, 0xe7, 0x9e, 0xa0, 0xe7, 0x9e, 0xb0, 0xe7, 0x9e, 0xb5,
  0xe7, 0x9e, 0xbd, 0xe7, 0x94, 0xba, 0xe7, 0x95, 0x80, 0xe7, 0x95, 0x8e,
  0xe7, 0x95, 0x8b, 0xe7, 0x95, 0x88, 0xe7, 0x95, 0x9b, 0xe7, 0x95, 0xb2,
  0xe7, 0x95, 0xb9, 0xe7, 0x96, 0x83, 0xe7, 0xbd, 0x98, 0xe7, 0xbd, 0xa1,
  0xe7, 0xbd, 0x9f, 0xe8, 0xa9, 0x88, 0xe7, 0xbd, 0xa8, 0xe7, 0xbd, 0xb4,
  0xe7, 0xbd, 0xb1, 0xe7, 0xbd, 0xb9, 0xe7, 0xbe, 0x81, 0xe7, 0xbd, 0xbe,
  0xe7, 0x9b, 0x8d, 0xe7, 0x9b, 0xa5, 0xe8, 0xa0, 0xb2, 0xe9, 0x92, 0x85,
  0xe9, 0x92, 0x86, 0xe9, 0x92, 0x87, 0xe9, 0x92, 0x8b, 0xe9, 0x92, 0x8a,
  0xe9, 0x92, 0x8c, 0xe9, 0x92, 0x8d, 0xe9, 0x92, 0x8f, 0xe9, 0x92, 0x90,
  0xe9, 0x92, 0x94, 0xe9, 0x92, 0x97, 0xe9, 0x92, 0x95, 0xe9, 0x92, 0x9a,
  0xe9, 0x92, 0x9b, 0xe9, 0x92, 0x9c, 0xe9, 0x92, 0xa3, 0xe9, 0x92, 0xa4,
  0xe9, 0x92, 0xab, 0xe9, 0x92, 0xaa, 0xe9, 0x92, 0xad, 0xe9, 0x92, 0xac,
  0xe9, 0x92, 0xaf, 0xe9, 0x92, 0xb0, 0xe9, 0x92, 0xb2, 0xe9, 0x92, 0xb4,
  0xe9, 0x92, 0xb6, 0xe9, 0x92, 0xb7, 0xe9, 0x92, 0xb8, 0xe9, 0x92, 0xb9,
  0xe9, 0x92, 0xba, 0xe9, 0x92, 0xbc, 0xe9, 0x92, 0xbd, 0xe9, 0x92, 0xbf,
  0xe9, 0x93, 0x84, 0xe9, 0x93, 0x88, 0xe9, 0x93, 0x89, 0xe9, 0x93, 0x8a,
  0xe9, 0x93, 0x8b, 0xe9, 0x93, 0x8c, 0xe9, 0x93, 0x8d, 0xe9, 0x93, 0x8e,
  0xe9, 0x93, 0x90, 0xe9, 0x93, 0x91, 0xe9, 0x93, 0x92, 0xe9, 0x93, 0x95,
  0xe9, 0x93, 0x96, 0xe9, 0x93, 0x97, 0xe9, 0x93, 0x99, 0xe9, 0x93, 0x98,
  0xe9, 0x93, 0x9b, 0xe9, 0x93, 0x9e, 0xe9, 0x93, 0x9f, 0xe9, 0x93, 0xa0,
  0xe9, 0x93, 0xa2, 0xe9, 0x93, 0xa4, 0xe9, 0x93, 0xa5, 0xe9, 0x93, 0xa7,
  0xe9, 0x93, 0xa8, 0xe9, 0x93, 0xaa
};

unsigned char gb2312_row_79_converted_to_utf8[] = {
  0xe9, 0x93, 0xa9, 0xe9, 0x93, 0xab, 0xe9, 0x93, 0xae, 0xe9, 0x93, 0xaf,
  0xe9, 0x93, 0xb3, 0xe9, 0x93, 0xb4, 0xe9, 0x93, 0xb5, 0xe9, 0x93, 0xb7,
  0xe9, 0x93, 0xb9, 0xe9, 0x93, 0xbc, 0xe9, 0x93, 0xbd, 0xe9, 0x93, 0xbf,
  0xe9, 0x94, 0x83, 0xe9, 0x94, 0x82, 0xe9, 0x94, 0x86, 0xe9, 0x94, 0x87,
  0xe9, 0x94, 0x89, 0xe9, 0x94, 0x8a, 0xe9, 0x94, 0x8d, 0xe9, 0x94, 0x8e,
  0xe9, 0x94, 0x8f, 0xe9, 0x94, 0x92, 0xe9, 0x94, 0x93, 0xe9, 0x94, 0x94,
  0xe9, 0x94, 0x95, 0xe9, 0x94, 0x96, 0xe9, 0x94, 0x98, 0xe9, 0x94, 0x9b,
  0xe9, 0x94, 0x9d, 0xe9, 0x94, 0x9e, 0xe9, 0x94, 0x9f, 0xe9, 0x94, 0xa2,
  0xe9, 0x94, 0xaa, 0xe9, 0x94, 0xab, 0xe9, 0x94, 0xa9, 0xe9, 0x94, 0xac,
  0xe9, 0x94, 0xb1, 0xe9, 0x94, 0xb2, 0xe9, 0x94, 0xb4, 0xe9, 0x94, 0xb6,
  0xe9, 0x94, 0xb7, 0xe9, 0x94, 0xb8, 0xe9, 0x94, 0xbc, 0xe9, 0x94, 0xbe,
  0xe9, 0x94, 0xbf, 0xe9, 0x95, 0x82, 0xe9, 0x94, 0xb5, 0xe9, 0x95, 0x84,
  0xe9, 0x95, 0x85, 0xe9, 0x95, 0x86, 0xe9, 0x95, 0x89, 0xe9, 0x95, 0x8c,
  0xe9, 0x95, 0x8e, 0xe9, 0x95, 0x8f, 0xe9, 0x95, 0x92, 0xe9, 0x95, 0x93,
  0xe9, 0x95, 0x94, 0xe9, 0x95, 0x96, 0xe9, 0x95, 0x97, 0xe9, 0x95, 0x98,
  0xe9, 0x95, 0x99, 0xe9, 0x95, 0x9b, 0xe9, 0x95, 0x9e, 0xe9, 0x95, 0x9f,
  0xe9, 0x95, 0x9d, 0xe9, 0x95, 0xa1, 0xe9, 0x95, 0xa2, 0xe9, 0x95, 0xa4,
  0xe9, 0x95, 0xa5, 0xe9, 0x95, 0xa6, 0xe9, 0x95, 0xa7, 0xe9, 0x95, 0xa8,
  0xe9, 0x95, 0xa9, 0xe9, 0x95, 0xaa, 0xe9, 0x95, 0xab, 0xe9, 0x95, 0xac,
  0xe9, 0x95, 0xaf, 0xe9, 0x95, 0xb1, 0xe9, 0x95, 0xb2, 0xe9, 0x95, 0xb3,
  0xe9, 0x94, 0xba, 0xe7, 0x9f, 0xa7, 0xe7, 0x9f, 0xac, 0xe9, 0x9b, 0x89,
  0xe7, 0xa7, 0x95, 0xe7, 0xa7, 0xad, 0xe7, 0xa7, 0xa3, 0xe7, 0xa7, 0xab,
  0xe7, 0xa8, 0x86, 0xe5, 0xb5, 0x87, 0xe7, 0xa8, 0x83, 0xe7, 0xa8, 0x82,
  0xe7, 0xa8, 0x9e, 0xe7, 0xa8, 0x94
};

unsigned char gb2312_row_80_converted_to_utf8[] = {
  0xe7, 0xa8, 0xb9, 0xe7, 0xa8, 0xb7, 0xe7, 0xa9, 0x91, 0xe9, 0xbb, 0x8f,
  0xe9, 0xa6, 0xa5, 0xe7, 0xa9, 0xb0, 0xe7, 0x9a, 0x88, 0xe7, 0x9a, 0x8e,
  0xe7, 0x9a, 0x93, 0xe7, 0x9a, 0x99, 0xe7, 0x9a, 0xa4, 0xe7, 0x93, 0x9e,
  0xe7, 0x93, 0xa0, 0xe7, 0x94, 0xac, 0xe9, 0xb8, 0xa0, 0xe9, 0xb8, 0xa2,
  0xe9, 0xb8, 0xa8, 0xe9, 0xb8, 0xa9, 0xe9, 0xb8, 0xaa, 0xe9, 0xb8, 0xab,
  0xe9, 0xb8, 0xac, 0xe9, 0xb8, 0xb2, 0xe9, 0xb8, 0xb1, 0xe9, 0xb8, 0xb6,
  0xe9, 0xb8, 0xb8, 0xe9, 0xb8, 0xb7, 0xe9, 0xb8, 0xb9, 0xe9, 0xb8, 0xba,
  0xe9, 0xb8, 0xbe, 0xe9, 0xb9, 0x81, 0xe9, 0xb9, 0x82, 0xe9, 0xb9, 0x84,
  0xe9, 0xb9, 0x86, 0xe9, 0xb9, 0x87, 0xe9, 0xb9, 0x88, 0xe9, 0xb9, 0x89,
  0xe9, 0xb9, 0x8b, 0xe9, 0xb9, 0x8c, 0xe9, 0xb9, 0x8e, 0xe9, 0xb9, 0x91,
  0xe9, 0xb9, 0x95, 0xe9, 0xb9, 0x97, 0xe9, 0xb9, 0x9a, 0xe9, 0xb9, 0x9b,
  0xe9, 0xb9, 0x9c, 0xe9, 0xb9, 0x9e, 0xe9, 0xb9, 0xa3, 0xe9, 0xb9, 0xa6,
  0xe9, 0xb9, 0xa7, 0xe9, 0xb9, 0xa8, 0xe9, 0xb9, 0xa9, 0xe9, 0xb9, 0xaa,
  0xe9, 0xb9, 0xab, 0xe9, 0xb9, 0xac, 0xe9, 0xb9, 0xb1, 0xe9, 0xb9, 0xad,
  0xe9, 0xb9, 0xb3, 0xe7, 0x96, 0x92, 0xe7, 0x96, 0x94, 0xe7, 0x96, 0x96,
  0xe7, 0x96, 0xa0, 0xe7, 0x96, 0x9d, 0xe7, 0x96, 0xac, 0xe7, 0x96, 0xa3,
  0xe7, 0x96, 0xb3, 0xe7, 0x96, 0xb4, 0xe7, 0x96, 0xb8, 0xe7, 0x97, 0x84,
  0xe7, 0x96, 0xb1, 0xe7, 0x96, 0xb0, 0xe7, 0x97, 0x83, 0xe7, 0x97, 0x82,
  0xe7, 0x97, 0x96, 0xe7, 0x97, 0x8d, 0xe7, 0x97, 0xa3, 0xe7, 0x97, 0xa8,
  0xe7, 0x97, 0xa6, 0xe7, 0x97, 0xa4, 0xe7, 0x97, 0xab, 0xe7, 0x97, 0xa7,
  0xe7, 0x98, 0x83, 0xe7, 0x97, 0xb1, 0xe7, 0x97, 0xbc, 0xe7, 0x97, 0xbf,
  0xe7, 0x98, 0x90, 0xe7, 0x98, 0x80, 0xe7, 0x98, 0x85, 0xe7, 0x98, 0x8c,
  0xe7, 0x98, 0x97, 0xe7, 0x98, 0x8a, 0xe7, 0x98, 0xa5, 0xe7, 0x98, 0x98,
  0xe7, 0x98, 0x95, 0xe7, 0x98, 0x99
};

unsigned char gb2312_row_81_converted_to_utf8[] = {
  0xe7, 0x98, 0x9b, 0xe7, 0x98, 0xbc, 0xe7, 0x98, 0xa2, 0xe7, 0x98, 0xa0,
  0xe7, 0x99, 0x80, 0xe7, 0x98, 0xad, 0xe7, 0x98, 0xb0, 0xe7, 0x98, 0xbf,
  0xe7, 0x98, 0xb5, 0xe7, 0x99, 0x83, 0xe7, 0x98, 0xbe, 0xe7, 0x98, 0xb3,
  0xe7, 0x99, 0x8d, 0xe7, 0x99, 0x9e, 0xe7, 0x99, 0x94, 0xe7, 0x99, 0x9c,
  0xe7, 0x99, 0x96, 0xe7, 0x99, 0xab, 0xe7, 0x99, 0xaf, 0xe7, 0xbf, 0x8a,
  0xe7, 0xab, 0xa6, 0xe7, 0xa9, 0xb8, 0xe7, 0xa9, 0xb9, 0xe7, 0xaa, 0x80,
  0xe7, 0xaa, 0x86, 0xe7, 0xaa, 0x88, 0xe7, 0xaa, 0x95, 0xe7, 0xaa, 0xa6,
  0xe7, 0xaa, 0xa0, 0xe7, 0xaa, 0xac, 0xe7, 0xaa, 0xa8, 0xe7, 0xaa, 0xad,
  0xe7, 0xaa, 0xb3, 0xe8, 0xa1, 0xa4, 0xe8, 0xa1, 0xa9, 0xe8, 0xa1, 0xb2,
  0xe8, 0xa1, 0xbd, 0xe8, 0xa1, 0xbf, 0xe8, 0xa2, 0x82, 0xe8, 0xa2, 0xa2,
  0xe8, 0xa3, 0x86, 0xe8, 0xa2, 0xb7, 0xe8, 0xa2, 0xbc, 0xe8, 0xa3, 0x89,
  0xe8, 0xa3, 0xa2, 0xe8, 0xa3, 0x8e, 0xe8, 0xa3, 0xa3, 0xe8, 0xa3, 0xa5,
  0xe8, 0xa3, 0xb1, 0xe8, 0xa4, 0x9a, 0xe8, 0xa3, 0xbc, 0xe8, 0xa3, 0xa8,
  0xe8, 0xa3, 0xbe, 0xe8, 0xa3, 0xb0, 0xe8, 0xa4, 0xa1, 0xe8, 0xa4, 0x99,
  0xe8, 0xa4, 0x93, 0xe8, 0xa4, 0x9b, 0xe8, 0xa4, 0x8a, 0xe8, 0xa4, 0xb4,
  0xe8, 0xa4, 0xab, 0xe8, 0xa4, 0xb6, 0xe8, 0xa5, 0x81, 0xe8, 0xa5, 0xa6,
  0xe8, 0xa5, 0xbb, 0xe7, 0x96, 0x8b, 0xe8, 0x83, 0xa5, 0xe7, 0x9a, 0xb2,
  0xe7, 0x9a, 0xb4, 0xe7, 0x9f, 0x9c, 0xe8, 0x80, 0x92, 0xe8, 0x80, 0x94,
  0xe8, 0x80, 0x96, 0xe8, 0x80, 0x9c, 0xe8, 0x80, 0xa0, 0xe8, 0x80, 0xa2,
  0xe8, 0x80, 0xa5, 0xe8, 0x80, 0xa6, 0xe8, 0x80, 0xa7, 0xe8, 0x80, 0xa9,
  0xe8, 0x80, 0xa8, 0xe8, 0x80, 0xb1, 0xe8, 0x80, 0x8b, 0xe8, 0x80, 0xb5,
  0xe8, 0x81, 0x83, 0xe8, 0x81, 0x86, 0xe8, 0x81, 0x8d, 0xe8, 0x81, 0x92,
  0xe8, 0x81, 0xa9, 0xe8, 0x81, 0xb1, 0xe8, 0xa6, 0x83, 0xe9, 0xa1, 0xb8,
  0xe9, 0xa2, 0x80, 0xe9, 0xa2, 0x83
};

unsigned char gb2312_row_82_converted_to_utf8[] = {
  0xe9, 0xa2, 0x89, 0xe9, 0xa2, 0x8c, 0xe9, 0xa2, 0x8d, 0xe9, 0xa2, 0x8f,
  0xe9, 0xa2, 0x94, 0xe9, 0xa2, 0x9a, 0xe9, 0xa2, 0x9b, 0xe9, 0xa2, 0x9e,
  0xe9, 0xa2, 0x9f, 0xe9, 0xa2, 0xa1, 0xe9, 0xa2, 0xa2, 0xe9, 0xa2, 0xa5,
  0xe9, 0xa2, 0xa6, 0xe8, 0x99, 0x8d, 0xe8, 0x99, 0x94, 0xe8, 0x99, 0xac,
  0xe8, 0x99, 0xae, 0xe8, 0x99, 0xbf, 0xe8, 0x99, 0xba, 0xe8, 0x99, 0xbc,
  0xe8, 0x99, 0xbb, 0xe8, 0x9a, 0xa8, 0xe8, 0x9a, 0x8d, 0xe8, 0x9a, 0x8b,
  0xe8, 0x9a, 0xac, 0xe8, 0x9a, 0x9d, 0xe8, 0x9a, 0xa7, 0xe8, 0x9a, 0xa3,
  0xe8, 0x9a, 0xaa, 0xe8, 0x9a, 0x93, 0xe8, 0x9a, 0xa9, 0xe8, 0x9a, 0xb6,
  0xe8, 0x9b, 0x84, 0xe8, 0x9a, 0xb5, 0xe8, 0x9b, 0x8e, 0xe8, 0x9a, 0xb0,
  0xe8, 0x9a, 0xba, 0xe8, 0x9a, 0xb1, 0xe8, 0x9a, 0xaf, 0xe8, 0x9b, 0x89,
  0xe8, 0x9b, 0x8f, 0xe8, 0x9a, 0xb4, 0xe8, 0x9b, 0xa9, 0xe8, 0x9b, 0xb1,
  0xe8, 0x9b, 0xb2, 0xe8, 0x9b, 0xad, 0xe8, 0x9b, 0xb3, 0xe8, 0x9b, 0x90,
  0xe8, 0x9c, 0x93, 0xe8, 0x9b, 0x9e, 0xe8, 0x9b, 0xb4, 0xe8, 0x9b, 0x9f,
  0xe8, 0x9b, 0x98, 0xe8, 0x9b, 0x91, 0xe8, 0x9c, 0x83, 0xe8, 0x9c, 0x87,
  0xe8, 0x9b, 0xb8, 0xe8, 0x9c, 0x88, 0xe8, 0x9c, 0x8a, 0xe8, 0x9c, 0x8d,
  0xe8, 0x9c, 0x89, 0xe8, 0x9c, 0xa3, 0xe8, 0x9c, 0xbb, 0xe8, 0x9c, 0x9e,
  0xe8, 0x9c, 0xa5, 0xe8, 0x9c, 0xae, 0xe8, 0x9c, 0x9a, 0xe8, 0x9c, 0xbe,
  0xe8, 0x9d, 0x88, 0xe8, 0x9c, 0xb4, 0xe8, 0x9c, 0xb1, 0xe8, 0x9c, 0xa9,
  0xe8, 0x9c, 0xb7, 0xe8, 0x9c, 0xbf, 0xe8, 0x9e, 0x82, 0xe8, 0x9c, 0xa2,
  0xe8, 0x9d, 0xbd, 0xe8, 0x9d, 0xbe, 0xe8, 0x9d, 0xbb, 0xe8, 0x9d, 0xa0,
  0xe8, 0x9d, 0xb0, 0xe8, 0x9d, 0x8c, 0xe8, 0x9d, 0xae, 0xe8, 0x9e, 0x8b,
  0xe8, 0x9d, 0x93, 0xe8, 0x9d, 0xa3, 0xe8, 0x9d, 0xbc, 0xe8, 0x9d, 0xa4,
  0xe8, 0x9d, 0x99, 0xe8, 0x9d, 0xa5, 0xe8, 0x9e, 0x93, 0xe8, 0x9e, 0xaf,
  0xe8, 0x9e, 0xa8, 0xe8, 0x9f, 0x92
};

unsigned char gb2312_row_83_converted_to_utf8[] = {
  0xe8, 0x9f, 0x86, 0xe8, 0x9e, 0x88, 0xe8, 0x9e, 0x85, 0xe8, 0x9e, 0xad,
  0xe8, 0x9e, 0x97, 0xe8, 0x9e, 0x83, 0xe8, 0x9e, 0xab, 0xe8, 0x9f, 0xa5,
  0xe8, 0x9e, 0xac, 0xe8, 0x9e, 0xb5, 0xe8, 0x9e, 0xb3, 0xe8, 0x9f, 0x8b,
  0xe8, 0x9f, 0x93, 0xe8, 0x9e, 0xbd, 0xe8, 0x9f, 0x91, 0xe8, 0x9f, 0x80,
  0xe8, 0x9f, 0x8a, 0xe8, 0x9f, 0x9b, 0xe8, 0x9f, 0xaa, 0xe8, 0x9f, 0xa0,
  0xe8, 0x9f, 0xae, 0xe8, 0xa0, 0x96, 0xe8, 0xa0, 0x93, 0xe8, 0x9f, 0xbe,
  0xe8, 0xa0, 0x8a, 0xe8, 0xa0, 0x9b, 0xe8, 0xa0, 0xa1, 0xe8, 0xa0, 0xb9,
  0xe8, 0xa0, 0xbc, 0xe7, 0xbc, 0xb6, 0xe7, 0xbd, 0x82, 0xe7, 0xbd, 0x84,
  0xe7, 0xbd, 0x85, 0xe8, 0x88, 0x90, 0xe7, 0xab, 0xba, 0xe7, 0xab, 0xbd,
  0xe7, 0xac, 0x88, 0xe7, 0xac, 0x83, 0xe7, 0xac, 0x84, 0xe7, 0xac, 0x95,
  0xe7, 0xac, 0x8a, 0xe7, 0xac, 0xab, 0xe7, 0xac, 0x8f, 0xe7, 0xad, 0x87,
  0xe7, 0xac, 0xb8, 0xe7, 0xac, 0xaa, 0xe7, 0xac, 0x99, 0xe7, 0xac, 0xae,
  0xe7, 0xac, 0xb1, 0xe7, 0xac, 0xa0, 0xe7, 0xac, 0xa5, 0xe7, 0xac, 0xa4,
  0xe7, 0xac, 0xb3, 0xe7, 0xac, 0xbe, 0xe7, 0xac, 0x9e, 0xe7, 0xad, 0x98,
  0xe7, 0xad, 0x9a, 0xe7, 0xad, 0x85, 0xe7, 0xad, 0xb5, 0xe7, 0xad, 0x8c,
  0xe7, 0xad, 0x9d, 0xe7, 0xad, 0xa0, 0xe7, 0xad, 0xae, 0xe7, 0xad, 0xbb,
  0xe7, 0xad, 0xa2, 0xe7, 0xad, 0xb2, 0xe7, 0xad, 0xb1, 0xe7, 0xae, 0x90,
  0xe7, 0xae, 0xa6, 0xe7, 0xae, 0xa7, 0xe7, 0xae, 0xb8, 0xe7, 0xae, 0xac,
  0xe7, 0xae, 0x9d, 0xe7, 0xae, 0xa8, 0xe7, 0xae, 0x85, 0xe7, 0xae, 0xaa,
  0xe7, 0xae, 0x9c, 0xe7, 0xae, 0xa2, 0xe7, 0xae, 0xab, 0xe7, 0xae, 0xb4,
  0xe7, 0xaf, 0x91, 0xe7, 0xaf, 0x81, 0xe7, 0xaf, 0x8c, 0xe7, 0xaf, 0x9d,
  0xe7, 0xaf, 0x9a, 0xe7, 0xaf, 0xa5, 0xe7, 0xaf, 0xa6, 0xe7, 0xaf, 0xaa,
  0xe7, 0xb0, 0x8c, 0xe7, 0xaf, 0xbe, 0xe7, 0xaf, 0xbc, 0xe7, 0xb0, 0x8f,
  0xe7, 0xb0, 0x96, 0xe7, 0xb0, 0x8b
};

unsigned char gb2312_row_84_converted_to_utf8[] = {
  0xe7, 0xb0, 0x9f, 0xe7, 0xb0, 0xaa, 0xe7, 0xb0, 0xa6, 0xe7, 0xb0, 0xb8,
  0xe7, 0xb1, 0x81, 0xe7, 0xb1, 0x80, 0xe8, 0x87, 0xbe, 0xe8, 0x88, 0x81,
  0xe8, 0x88, 0x82, 0xe8, 0x88, 0x84, 0xe8, 0x87, 0xac, 0xe8, 0xa1, 0x84,
  0xe8, 0x88, 0xa1, 0xe8, 0x88, 0xa2, 0xe8, 0x88, 0xa3, 0xe8, 0x88, 0xad,
  0xe8, 0x88, 0xaf, 0xe8, 0x88, 0xa8, 0xe8, 0x88, 0xab, 0xe8, 0x88, 0xb8,
  0xe8, 0x88, 0xbb, 0xe8, 0x88, 0xb3, 0xe8, 0x88, 0xb4, 0xe8, 0x88, 0xbe,
  0xe8, 0x89, 0x84, 0xe8, 0x89, 0x89, 0xe8, 0x89, 0x8b, 0xe8, 0x89, 0x8f,
  0xe8, 0x89, 0x9a, 0xe8, 0x89, 0x9f, 0xe8, 0x89, 0xa8, 0xe8, 0xa1, 0xbe,
  0xe8, 0xa2, 0x85, 0xe8, 0xa2, 0x88, 0xe8, 0xa3, 0x98, 0xe8, 0xa3, 0x9f,
  0xe8, 0xa5, 0x9e, 0xe7, 0xbe, 0x9d, 0xe7, 0xbe, 0x9f, 0xe7, 0xbe, 0xa7,
  0xe7, 0xbe, 0xaf, 0xe7, 0xbe, 0xb0, 0xe7, 0xbe, 0xb2, 0xe7, 0xb1, 0xbc,
  0xe6, 0x95, 0x89, 0xe7, 0xb2, 0x91, 0xe7, 0xb2, 0x9d, 0xe7, 0xb2, 0x9c,
  0xe7, 0xb2, 0x9e, 0xe7, 0xb2, 0xa2, 0xe7, 0xb2, 0xb2, 0xe7, 0xb2, 0xbc,
  0xe7, 0xb2, 0xbd, 0xe7, 0xb3, 0x81, 0xe7, 0xb3, 0x87, 0xe7, 0xb3, 0x8c,
  0xe7, 0xb3, 0x8d, 0xe7, 0xb3, 0x88, 0xe7, 0xb3, 0x85, 0xe7, 0xb3, 0x97,
  0xe7, 0xb3, 0xa8, 0xe8, 0x89, 0xae, 0xe6, 0x9a, 0xa8, 0xe7, 0xbe, 0xbf,
  0xe7, 0xbf, 0x8e, 0xe7, 0xbf, 0x95, 0xe7, 0xbf, 0xa5, 0xe7, 0xbf, 0xa1,
  0xe7, 0xbf, 0xa6, 0xe7, 0xbf, 0xa9, 0xe7, 0xbf, 0xae, 0xe7, 0xbf, 0xb3,
  0xe7, 0xb3, 0xb8, 0xe7, 0xb5, 0xb7, 0xe7, 0xb6, 0xa6, 0xe7, 0xb6, 0xae,
  0xe7, 0xb9, 0x87, 0xe7, 0xba, 0x9b, 0xe9, 0xba, 0xb8, 0xe9, 0xba, 0xb4,
  0xe8, 0xb5, 0xb3, 0xe8, 0xb6, 0x84, 0xe8, 0xb6, 0x94, 0xe8, 0xb6, 0x91,
  0xe8, 0xb6, 0xb1, 0xe8, 0xb5, 0xa7, 0xe8, 0xb5, 0xad, 0xe8, 0xb1, 0x87,
  0xe8, 0xb1, 0x89, 0xe9, 0x85, 0x8a, 0xe9, 0x85, 0x90, 0xe9, 0x85, 0x8e,
  0xe9, 0x85, 0x8f, 0xe9, 0x85, 0xa4
};

unsigned char gb2312_row_85_converted_to_utf8[] = {
  0xe9, 0x85, 0xa2, 0xe9, 0x85, 0xa1, 0xe9, 0x85, 0xb0, 0xe9, 0x85, 0xa9,
  0xe9, 0x85, 0xaf, 0xe9, 0x85, 0xbd, 0xe9, 0x85, 0xbe, 0xe9, 0x85, 0xb2,
  0xe9, 0x85, 0xb4, 0xe9, 0x85, 0xb9, 0xe9, 0x86, 0x8c, 0xe9, 0x86, 0x85,
  0xe9, 0x86, 0x90, 0xe9, 0x86, 0x8d, 0xe9, 0x86, 0x91, 0xe9, 0x86, 0xa2,
  0xe9, 0x86, 0xa3, 0xe9, 0x86, 0xaa, 0xe9, 0x86, 0xad, 0xe9, 0x86, 0xae,
  0xe9, 0x86, 0xaf, 0xe9, 0x86, 0xb5, 0xe9, 0x86, 0xb4, 0xe9, 0x86, 0xba,
  0xe8, 0xb1, 0x95, 0xe9, 0xb9, 0xbe, 0xe8, 0xb6, 0xb8, 0xe8, 0xb7, 0xab,
  0xe8, 0xb8, 0x85, 0xe8, 0xb9, 0x99, 0xe8, 0xb9, 0xa9, 0xe8, 0xb6, 0xb5,
  0xe8, 0xb6, 0xbf, 0xe8, 0xb6, 0xbc, 0xe8, 0xb6, 0xba, 0xe8, 0xb7, 0x84,
  0xe8, 0xb7, 0x96, 0xe8, 0xb7, 0x97, 0xe8, 0xb7, 0x9a, 0xe8, 0xb7, 0x9e,
  0xe8, 0xb7, 0x8e, 0xe8, 0xb7, 0x8f, 0xe8, 0xb7, 0x9b, 0xe8, 0xb7, 0x86,
  0xe8, 0xb7, 0xac, 0xe8, 0xb7, 0xb7, 0xe8, 0xb7, 0xb8, 0xe8, 0xb7, 0xa3,
  0xe8, 0xb7, 0xb9, 0xe8, 0xb7, 0xbb, 0xe8, 0xb7, 0xa4, 0xe8, 0xb8, 0x89,
  0xe8, 0xb7, 0xbd, 0xe8, 0xb8, 0x94, 0xe8, 0xb8, 0x9d, 0xe8, 0xb8, 0x9f,
  0xe8, 0xb8, 0xac, 0xe8, 0xb8, 0xae, 0xe8, 0xb8, 0xa3, 0xe8, 0xb8, 0xaf,
  0xe8, 0xb8, 0xba, 0xe8, 0xb9, 0x80, 0xe8, 0xb8, 0xb9, 0xe8, 0xb8, 0xb5,
  0xe8, 0xb8, 0xbd, 0xe8, 0xb8, 0xb1, 0xe8, 0xb9, 0x89, 0xe8, 0xb9, 0x81,
  0xe8, 0xb9, 0x82, 0xe8, 0xb9, 0x91, 0xe8, 0xb9, 0x92, 0xe8, 0xb9, 0x8a,
  0xe8, 0xb9, 0xb0, 0xe8, 0xb9, 0xb6, 0xe8, 0xb9, 0xbc, 0xe8, 0xb9, 0xaf,
  0xe8, 0xb9, 0xb4, 0xe8, 0xba, 0x85, 0xe8, 0xba, 0x8f, 0xe8, 0xba, 0x94,
  0xe8, 0xba, 0x90, 0xe8, 0xba, 0x9c, 0xe8, 0xba, 0x9e, 0xe8, 0xb1, 0xb8,
  0xe8, 0xb2, 0x82, 0xe8, 0xb2, 0x8a, 0xe8, 0xb2, 0x85, 0xe8, 0xb2, 0x98,
  0xe8, 0xb2, 0x94, 0xe6, 0x96, 0x9b, 0xe8, 0xa7, 0x96, 0xe8, 0xa7, 0x9e,
  0xe8, 0xa7, 0x9a, 0xe8, 0xa7, 0x9c
};

unsigned char gb2312_row_86_converted_to_utf8[] = {
  0xe8, 0xa7, 0xa5, 0xe8, 0xa7, 0xab, 0xe8, 0xa7, 0xaf, 0xe8, 0xa8, 0xbe,
  0xe8, 0xac, 0xa6, 0xe9, 0x9d, 0x93, 0xe9, 0x9b, 0xa9, 0xe9, 0x9b, 0xb3,
  0xe9, 0x9b, 0xaf, 0xe9, 0x9c, 0x86, 0xe9, 0x9c, 0x81, 0xe9, 0x9c, 0x88,
  0xe9, 0x9c, 0x8f, 0xe9, 0x9c, 0x8e, 0xe9, 0x9c, 0xaa, 0xe9, 0x9c, 0xad,
  0xe9, 0x9c, 0xb0, 0xe9, 0x9c, 0xbe, 0xe9, 0xbe, 0x80, 0xe9, 0xbe, 0x83,
  0xe9, 0xbe, 0x85, 0xe9, 0xbe, 0x86, 0xe9, 0xbe, 0x87, 0xe9, 0xbe, 0x88,
  0xe9, 0xbe, 0x89, 0xe9, 0xbe, 0x8a, 0xe9, 0xbe, 0x8c, 0xe9, 0xbb, 0xbe,
  0xe9, 0xbc, 0x8b, 0xe9, 0xbc, 0x8d, 0xe9, 0x9a, 0xb9, 0xe9, 0x9a, 0xbc,
  0xe9, 0x9a, 0xbd, 0xe9, 0x9b, 0x8e, 0xe9, 0x9b, 0x92, 0xe7, 0x9e, 0xbf,
  0xe9, 0x9b, 0xa0, 0xe9, 0x8a, 0x8e, 0xe9, 0x8a, 0xae, 0xe9, 0x8b, 0x88,
  0xe9, 0x8c, 0xbe, 0xe9, 0x8d, 0xaa, 0xe9, 0x8f, 0x8a, 0xe9, 0x8e, 0x8f,
  0xe9, 0x90, 0xbe, 0xe9, 0x91, 0xab, 0xe9, 0xb1, 0xbf, 0xe9, 0xb2, 0x82,
  0xe9, 0xb2, 0x85, 0xe9, 0xb2, 0x86, 0xe9, 0xb2, 0x87, 0xe9, 0xb2, 0x88,
  0xe7, 0xa8, 0xa3, 0xe9, 0xb2, 0x8b, 0xe9, 0xb2, 0x8e, 0xe9, 0xb2, 0x90,
  0xe9, 0xb2, 0x91, 0xe9, 0xb2, 0x92, 0xe9, 0xb2, 0x94, 0xe9, 0xb2, 0x95,
  0xe9, 0xb2, 0x9a, 0xe9, 0xb2, 0x9b, 0xe9, 0xb2, 0x9e, 0xe9, 0xb2, 0x9f,
  0xe9, 0xb2, 0xa0, 0xe9, 0xb2, 0xa1, 0xe9, 0xb2, 0xa2, 0xe9, 0xb2, 0xa3,
  0xe9, 0xb2, 0xa5, 0xe9, 0xb2, 0xa6, 0xe9, 0xb2, 0xa7, 0xe9, 0xb2, 0xa8,
  0xe9, 0xb2, 0xa9, 0xe9, 0xb2, 0xab, 0xe9, 0xb2, 0xad, 0xe9, 0xb2, 0xae,
  0xe9, 0xb2, 0xb0, 0xe9, 0xb2, 0xb1, 0xe9, 0xb2, 0xb2, 0xe9, 0xb2, 0xb3,
  0xe9, 0xb2, 0xb4, 0xe9, 0xb2, 0xb5, 0xe9, 0xb2, 0xb6, 0xe9, 0xb2, 0xb7,
  0xe9, 0xb2, 0xba, 0xe9, 0xb2, 0xbb, 0xe9, 0xb2, 0xbc, 0xe9, 0xb2, 0xbd,
  0xe9, 0xb3, 0x84, 0xe9, 0xb3, 0x85, 0xe9, 0xb3, 0x86, 0xe9, 0xb3, 0x87,
  0xe9, 0xb3, 0x8a, 0xe9, 0xb3, 0x8b
};

unsigned char gb2312_row_87_converted_to_utf8[] = {
  0xe9, 0xb3, 0x8c, 0xe9, 0xb3, 0x8d, 0xe9, 0xb3, 0x8e, 0xe9, 0xb3, 0x8f,
  0xe9, 0xb3, 0x90, 0xe9, 0xb3, 0x93, 0xe9, 0xb3, 0x94, 0xe9, 0xb3, 0x95,
  0xe9, 0xb3, 0x97, 0xe9, 0xb3, 0x98, 0xe9, 0xb3, 0x99, 0xe9, 0xb3, 0x9c,
  0xe9, 0xb3, 0x9d, 0xe9, 0xb3, 0x9f, 0xe9, 0xb3, 0xa2, 0xe9, 0x9d, 0xbc,
  0xe9, 0x9e, 0x85, 0xe9, 0x9e, 0x91, 0xe9, 0x9e, 0x92, 0xe9, 0x9e, 0x94,
  0xe9, 0x9e, 0xaf, 0xe9, 0x9e, 0xab, 0xe9, 0x9e, 0xa3, 0xe9, 0x9e, 0xb2,
  0xe9, 0x9e, 0xb4, 0xe9, 0xaa, 0xb1, 0xe9, 0xaa, 0xb0, 0xe9, 0xaa, 0xb7,
  0xe9, 0xb9, 0x98, 0xe9, 0xaa, 0xb6, 0xe9, 0xaa, 0xba, 0xe9, 0xaa, 0xbc,
  0xe9, 0xab, 0x81, 0xe9, 0xab, 0x80, 0xe9, 0xab, 0x85, 0xe9, 0xab, 0x82,
  0xe9, 0xab, 0x8b, 0xe9, 0xab, 0x8c, 0xe9, 0xab, 0x91, 0xe9, 0xad, 0x85,
  0xe9, 0xad, 0x83, 0xe9, 0xad, 0x87, 0xe9, 0xad, 0x89, 0xe9, 0xad, 0x88,
  0xe9, 0xad, 0x8d, 0xe9, 0xad, 0x91, 0xe9, 0xa3, 0xa8, 0xe9, 0xa4, 0x8d,
  0xe9, 0xa4, 0xae, 0xe9, 0xa5, 0x95, 0xe9, 0xa5, 0x94, 0xe9, 0xab, 0x9f,
  0xe9, 0xab, 0xa1, 0xe9, 0xab, 0xa6, 0xe9, 0xab, 0xaf, 0xe9, 0xab, 0xab,
  0xe9, 0xab, 0xbb, 0xe9, 0xab, 0xad, 0xe9, 0xab, 0xb9, 0xe9, 0xac, 0x88,
  0xe9, 0xac, 0x8f, 0xe9, 0xac, 0x93, 0xe9, 0xac, 0x9f, 0xe9, 0xac, 0xa3,
  0xe9, 0xba, 0xbd, 0xe9, 0xba, 0xbe, 0xe7, 0xb8, 0xbb, 0xe9, 0xba, 0x82,
  0xe9, 0xba, 0x87, 0xe9, 0xba, 0x88, 0xe9, 0xba, 0x8b, 0xe9, 0xba, 0x92,
  0xe9, 0x8f, 0x96, 0xe9, 0xba, 0x9d, 0xe9, 0xba, 0x9f, 0xe9, 0xbb, 0x9b,
  0xe9, 0xbb, 0x9c, 0xe9, 0xbb, 0x9d, 0xe9, 0xbb, 0xa0, 0xe9, 0xbb, 0x9f,
  0xe9, 0xbb, 0xa2, 0xe9, 0xbb, 0xa9, 0xe9, 0xbb, 0xa7, 0xe9, 0xbb, 0xa5,
  0xe9, 0xbb, 0xaa, 0xe9, 0xbb, 0xaf, 0xe9, 0xbc, 0xa2, 0xe9, 0xbc, 0xac,
  0xe9, 0xbc, 0xaf, 0xe9, 0xbc, 0xb9, 0xe9, 0xbc, 0xb7, 0xe9, 0xbc, 0xbd,
  0xe9, 0xbc, 0xbe, 0xe9, 0xbd, 0x84
};

#endif
