# 🔆 🎉

👆 💪 🔬 ⚛ (📟) 👈 🔜 🛠️ ⏭ 🈸 **▶️ 🆙**. 👉 ⛓ 👈 👉 📟 🔜 🛠️ **🕐**, **⏭** 🈸 **▶️ 📨 📨**.

🎏 🌌, 👆 💪 🔬 ⚛ (📟) 👈 🔜 🛠️ 🕐❔ 🈸 **🤫 🔽**. 👉 💼, 👉 📟 🔜 🛠️ **🕐**, **⏮️** ✔️ 🍵 🎲 **📚 📨**.

↩️ 👉 📟 🛠️ ⏭ 🈸 **▶️** ✊ 📨, &amp; ▶️️ ⏮️ ⚫️ **🏁** 🚚 📨, ⚫️ 📔 🎂 🈸 **🔆** (🔤 "🔆" 🔜 ⚠ 🥈 👶).

👉 💪 📶 ⚠ ⚒ 🆙 **ℹ** 👈 👆 💪 ⚙️ 🎂 📱, &amp; 👈 **💰** 👪 📨, &amp;/⚖️ 👈 👆 💪 **🧹 🆙** ⏮️. 🖼, 💽 🔗 🎱, ⚖️ 🚚 🔗 🎰 🏫 🏷.

## ⚙️ 💼

➡️ ▶️ ⏮️ 🖼 **⚙️ 💼** &amp; ⤴️ 👀 ❔ ❎ ⚫️ ⏮️ 👉.

➡️ 🌈 👈 👆 ✔️ **🎰 🏫 🏷** 👈 👆 💚 ⚙️ 🍵 📨. 👶

🎏 🏷 🔗 👪 📨,, ⚫️ 🚫 1️⃣ 🏷 📍 📨, ⚖️ 1️⃣ 📍 👩‍💻 ⚖️ 🕳 🎏.

➡️ 🌈 👈 🚚 🏷 💪 **✊ 🕰**, ↩️ ⚫️ ✔️ ✍ 📚 **💽 ⚪️➡️ 💾**. 👆 🚫 💚 ⚫️ 🔠 📨.

👆 💪 📐 ⚫️ 🔝 🎚 🕹/📁, ✋️ 👈 🔜 ⛓ 👈 ⚫️ 🔜 **📐 🏷** 🚥 👆 🏃‍♂ 🙅 🏧 💯, ⤴️ 👈 💯 🔜 **🐌** ↩️ ⚫️ 🔜 ✔️ ⌛ 🏷 📐 ⏭ 💆‍♂ 💪 🏃 🔬 🍕 📟.

👈 ⚫️❔ 👥 🔜 ❎, ➡️ 📐 🏷 ⏭ 📨 🍵, ✋️ 🕴 ▶️️ ⏭ 🈸 ▶️ 📨 📨, 🚫 ⏪ 📟 ➖ 📐.

## 🔆

👆 💪 🔬 👉 *🕴* &amp; *🤫* ⚛ ⚙️ `lifespan` 🔢 `FastAPI` 📱, &amp; "🔑 👨‍💼" (👤 🔜 🎦 👆 ⚫️❔ 👈 🥈).

➡️ ▶️ ⏮️ 🖼 &amp; ⤴️ 👀 ⚫️ ℹ.

👥 ✍ 🔁 🔢 `lifespan()` ⏮️ `yield` 💖 👉:

```Python hl_lines="16  19"
{!../../docs_src/events/tutorial003.py!}
```

📥 👥 ⚖ 😥 *🕴* 🛠️ 🚚 🏷 🚮 (❌) 🏷 🔢 📖 ⏮️ 🎰 🏫 🏷 ⏭ `yield`. 👉 📟 🔜 🛠️ **⏭** 🈸 **▶️ ✊ 📨**, ⏮️ *🕴*.

&amp; ⤴️, ▶️️ ⏮️ `yield`, 👥 🚚 🏷. 👉 📟 🔜 🛠️ **⏮️** 🈸 **🏁 🚚 📨**, ▶️️ ⏭ *🤫*. 👉 💪, 🖼, 🚀 ℹ 💖 💾 ⚖️ 💻.

/// tip

`shutdown` 🔜 🔨 🕐❔ 👆 **⛔️** 🈸.

🎲 👆 💪 ▶️ 🆕 ⏬, ⚖️ 👆 🤚 🎡 🏃 ⚫️. 🤷

///

### 🔆 🔢

🥇 👜 👀, 👈 👥 ⚖ 🔁 🔢 ⏮️ `yield`. 👉 📶 🎏 🔗 ⏮️ `yield`.

```Python hl_lines="14-19"
{!../../docs_src/events/tutorial003.py!}
```

🥇 🍕 🔢, ⏭ `yield`, 🔜 🛠️ **⏭** 🈸 ▶️.

&amp; 🍕 ⏮️ `yield` 🔜 🛠️ **⏮️** 🈸 ✔️ 🏁.

### 🔁 🔑 👨‍💼

🚥 👆 ✅, 🔢 🎀 ⏮️ `@asynccontextmanager`.

👈 🗜 🔢 🔘 🕳 🤙 "**🔁 🔑 👨‍💼**".

```Python hl_lines="1  13"
{!../../docs_src/events/tutorial003.py!}
```

**🔑 👨‍💼** 🐍 🕳 👈 👆 💪 ⚙️ `with` 📄, 🖼, `open()` 💪 ⚙️ 🔑 👨‍💼:

```Python
with open("file.txt") as file:
    file.read()
```

⏮️ ⏬ 🐍, 📤 **🔁 🔑 👨‍💼**. 👆 🔜 ⚙️ ⚫️ ⏮️ `async with`:

```Python
async with lifespan(app):
    await do_stuff()
```

🕐❔ 👆 ✍ 🔑 👨‍💼 ⚖️ 🔁 🔑 👨‍💼 💖 🔛, ⚫️❔ ⚫️ 🔨 👈, ⏭ 🛬 `with` 🍫, ⚫️ 🔜 🛠️ 📟 ⏭ `yield`, &amp; ⏮️ ❎ `with` 🍫, ⚫️ 🔜 🛠️ 📟 ⏮️ `yield`.

👆 📟 🖼 🔛, 👥 🚫 ⚙️ ⚫️ 🔗, ✋️ 👥 🚶‍♀️ ⚫️ FastAPI ⚫️ ⚙️ ⚫️.

`lifespan` 🔢 `FastAPI` 📱 ✊ **🔁 🔑 👨‍💼**, 👥 💪 🚶‍♀️ 👆 🆕 `lifespan` 🔁 🔑 👨‍💼 ⚫️.

```Python hl_lines="22"
{!../../docs_src/events/tutorial003.py!}
```

## 🎛 🎉 (😢)

/// warning

👍 🌌 🍵 *🕴* &amp; *🤫* ⚙️ `lifespan` 🔢 `FastAPI` 📱 🔬 🔛.

👆 💪 🎲 🚶 👉 🍕.

///

📤 🎛 🌌 🔬 👉 ⚛ 🛠️ ⏮️ *🕴* &amp; ⏮️ *🤫*.

👆 💪 🔬 🎉 🐕‍🦺 (🔢) 👈 💪 🛠️ ⏭ 🈸 ▶️ 🆙, ⚖️ 🕐❔ 🈸 🤫 🔽.

👫 🔢 💪 📣 ⏮️ `async def` ⚖️ 😐 `def`.

### `startup` 🎉

🚮 🔢 👈 🔜 🏃 ⏭ 🈸 ▶️, 📣 ⚫️ ⏮️ 🎉 `"startup"`:

```Python hl_lines="8"
{!../../docs_src/events/tutorial001.py!}
```

👉 💼, `startup` 🎉 🐕‍🦺 🔢 🔜 🔢 🏬 "💽" ( `dict`) ⏮️ 💲.

👆 💪 🚮 🌅 🌘 1️⃣ 🎉 🐕‍🦺 🔢.

&amp; 👆 🈸 🏆 🚫 ▶️ 📨 📨 ⏭ 🌐 `startup` 🎉 🐕‍🦺 ✔️ 🏁.

### `shutdown` 🎉

🚮 🔢 👈 🔜 🏃 🕐❔ 🈸 🤫 🔽, 📣 ⚫️ ⏮️ 🎉 `"shutdown"`:

```Python hl_lines="6"
{!../../docs_src/events/tutorial002.py!}
```

📥, `shutdown` 🎉 🐕‍🦺 🔢 🔜 ✍ ✍ ⏸ `"Application shutdown"` 📁 `log.txt`.

/// info

`open()` 🔢, `mode="a"` ⛓ "🎻",, ⏸ 🔜 🚮 ⏮️ ⚫️❔ 🔛 👈 📁, 🍵 📁 ⏮️ 🎚.

///

/// tip

👀 👈 👉 💼 👥 ⚙️ 🐩 🐍 `open()` 🔢 👈 🔗 ⏮️ 📁.

, ⚫️ 🔌 👤/🅾 (🔢/🔢), 👈 🚚 "⌛" 👜 ✍ 💾.

✋️ `open()` 🚫 ⚙️ `async` &amp; `await`.

, 👥 📣 🎉 🐕‍🦺 🔢 ⏮️ 🐩 `def` ↩️ `async def`.

///

/// info

👆 💪 ✍ 🌅 🔃 👫 🎉 🐕‍🦺 <a href="https://www.starlette.io/events/" class="external-link" target="_blank">💃 🎉' 🩺</a>.

///

### `startup` &amp; `shutdown` 👯‍♂️

📤 ↕ 🤞 👈 ⚛ 👆 *🕴* &amp; *🤫* 🔗, 👆 💪 💚 ▶️ 🕳 &amp; ⤴️ 🏁 ⚫️, 📎 ℹ &amp; ⤴️ 🚀 ⚫️, ♒️.

🔨 👈 👽 🔢 👈 🚫 💰 ⚛ ⚖️ 🔢 👯‍♂️ 🌅 ⚠ 👆 🔜 💪 🏪 💲 🌐 🔢 ⚖️ 🎏 🎱.

↩️ 👈, ⚫️ 🔜 👍 ↩️ ⚙️ `lifespan` 🔬 🔛.

## 📡 ℹ

📡 ℹ 😟 🤓. 👶

🔘, 🔫 📡 🔧, 👉 🍕 <a href="https://asgi.readthedocs.io/en/latest/specs/lifespan.html" class="external-link" target="_blank">🔆 🛠️</a>, &amp; ⚫️ 🔬 🎉 🤙 `startup` &amp; `shutdown`.

## 🎧 🈸

👶 ✔️ 🤯 👈 👫 🔆 🎉 (🕴 &amp; 🤫) 🔜 🕴 🛠️ 👑 🈸, 🚫 [🎧 🈸 - 🗻](sub-applications.md){.internal-link target=_blank}.
