#define XERR
#include "compiler.ih"

// cstdlib:
//     std::cout << getenv("ICMAKE_CPPSTD") << '\n';
// returns, e.g., --std=c++26
//
// d_std is set in compiler1.cc

void Compiler::compile(Process &proc, Path const &dir, 
                       string const &source, string const &objFile)
{
    string cmd = "/bin/g++ " + d_std + d_colors + s_compileCmd + 
                                                objFile + ' ' + source;
    if (not d_quiet)
        cout << "   " << dir.string() << ": " << cmd <<'\n';

    proc = cmd;
    proc.start();

    if (proc.waitForChild() != 0)
    {
        emsg << cmd << " failed\n";
        throw 1;
    }
}
