#ifndef INCLUDED_COMPILER_
#define INCLUDED_COMPILER_

#include <vector>
#include <fstream>
#include <string>
#include <filesystem>

#include "../support/support.h"
#include "../moddata/moddata.h"

namespace FBB
{
    class Arg;
    class Process;
}

class Scan;

class Compiler: private Support
{
    using Path          = std::filesystem::path;
    using Vect          = std::vector<ModData>;

    std::string d_std;          // used by the compiler
    std::string d_colors;
    std::string d_objDir;       // the location of compiled files

    bool d_quiet;               // quiet compilations

    std::string d_filename;
    std::ofstream d_file;       // file used when option --file is spcecified
    std::ostream *d_filePtr;    // ptr to the actually used output file
    void (Compiler::*d_handler)(Scan const &scan);

    static std::string s_compileCmd;

    public:
        Compiler();             // requests ICMAKE_CPPSTD

        void run(Scan const &scan);

    private:
        void compileMods(Scan const &scan);
        void compile(FBB::Process &proc, Path const &dir,
                     std::string const &source, std::string const &objFile);
        void fileOption(FBB::Arg const &arg);
        void toFile(Scan const &scan);

        static std::string parents(std::string const &source);
};    

inline void Compiler::run(Scan const &scan)
{
    (this->*d_handler)(scan);
}
        
#endif






