#ifndef INCLUDED_MODULES_
#define INCLUDED_MODULES_

#include <vector>
#include <unordered_set>
#include <unordered_map>
#include <string>
#include <filesystem>

#include "../support/support.h"
#include "../classes/classes.h"
#include "../moddata/moddata.h"
#include "../scan/scan.h"
#include "../compiler/compiler.h"

namespace FBB
{
    class Arg;
    class Process;
}

class Modules: private Support
{
    using Path          = std::filesystem::path;
    using Set           = std::unordered_set<size_t>;

    using ModMap        = std::unordered_map<std::string, size_t>;
    using ModMapIter    = ModMap::iterator;
    using ModMapInsert  = std::pair<ModMapIter, bool>;

    using DirIter       = std::filesystem::directory_iterator;

    using StrVect       = std::vector<std::string>;
    using Vect          = std::vector<ModData>;
    using VectIter      = Vect::iterator;

    Classes d_classes;          // get the classes dir-names (0 = project)
    bool d_clean;

    Scan d_scan;

    StrVect d_external;         // vector of dirs containing external module
                                // .gcm files

    Set d_unknowns;             // indices of UNKNOWN modules
    bool d_compile;
    bool d_verbose;
    bool d_dependencies;
    std::string d_extension;    // the extension of the files to inspect

    public:
        Modules();
        void fill();            // fill d_modVect
        bool clean();           // remove gcm.cache entries
        bool circular();        // true: circular dependencies
        void compile();         // compile the module.cc files

    private:
        bool addRequiredBy(Path const &extModgcm);

        void connect(Path const &extModgcm);

        bool inExternal(std::string const &dir);

        void inspect(Classes::Info const &info);
        void inspectSubdirs();

        void inspectVerbose(FBB::Arg const &arg);

        bool linked(Path const &eternalModgcm, size_t unknownIdx);

        void addExtern(Path const &extModgcm);

        bool externalDirs();

        bool requiredExternal(Path const &extModGcm);

        void setExtension(FBB::Arg const &arg);

        void solveUnknown();            // UNKNOWN modules must be at d_extern

        bool unknowns();                // fill d_unknowns, true: found

        VectIter removeImports(VectIter from, VectIter const &next);
        void removeModule(std::string const &modName, VectIter next);

        bool unkownExternals();         // true: unkown externals remain

        static bool needsGcm(std::string &ntbs);
        static bool setLocalType(ModData &data, Path const &source);

        static bool symlink(std::string const &destination, 
                             std::string const &symLink);
};

#endif
