#define XERR
#include "modules.ih"

//  verbose     dependencies
//      T           T           compile
//      T           F           compile
//      F           T           don't compile
//      F           T           compile

Modules::Modules()
{
    Arg const &arg = Arg::instance();

    inspectVerbose(arg);                    // also sets d_dependencies

    if (arg.nArgs() == 0)
        d_clean = false;
    else
    {
        if (arg[0] != "clean"s)
            throw Exception{} << "argument " << arg[0] << " not supported";
        d_clean = true;
        return;                             // action 'clean' requested
    }

    setExtension(arg);
                                            // if already exist, false but
    fs::create_directory("gcm.cache", s_errorCode);     // error_code == 0

    fs::create_directories("tmp/o", s_errorCode);       // same

    createSymlink("/usr", "gcm.cache/usr");
}

