#define XERR
#include "scan.ih"

    // called by modules/inspect.cc

    // sourcePath the path to reach filename fm d_cwd

void Scan::process(std::string const &subdir, string const &filename)
{
    (d_sourcePath = subdir) /= filename;

    d_exportNeeded = false;         // set to true by defineModule
    d_currentIdx = ~0L;             // reset the idx: no module defined yet
                                    // by this source

    imsg << "   scanning " << filename << endl;
    d_scanner.switchStreams(filename, "-");

    while (true)
    {
        switch (d_scanner.lex())
        {
            case 0:
            return;

            case Scanner::MODDEF:               // export module Name;
                defineModule();
            continue;

            case Scanner::PARTDEF:              // export module Name:Part;
                definePartition();
            continue;

            case Scanner::MODDECL:              // [export] import Other; 
                declareModule();
            continue;

            case Scanner::MODSRC:               // module Name;
                source();
            continue;

            case Scanner::PARTDECL:             // export import :Part;
                declarePartition();
            continue;
        }
    }
}    
