#ifndef INCLUDED_SCAN_
#define INCLUDED_SCAN_

#include <vector>
#include <unordered_set>
#include <unordered_map>
#include <string>
#include <filesystem>

#include "../support/support.h"
#include "../moddata/moddata.h"
#include "../scanner/scanner.h"

class Scan: private Support
{
    using Path          = std::filesystem::path;
    using Set           = std::unordered_set<size_t>;

    using ModMap        = std::unordered_map<std::string, size_t>;
    using ModMapIter    = ModMap::iterator;
    using ModMapInsert  = std::pair<ModMapIter, bool>;

    using Vect          = std::vector<ModData>;
    using VectIter      = Vect::iterator;

    Path d_cwd;
    Path d_sourcePath;          // path to process (relative to the cwd)
    Scanner d_scanner;
    size_t d_currentIdx;        // the index in d_modVect of the currerntly
                                // defining module; ~0UL if not defining 
                                // a module
    size_t d_nr;                // the prefix before the .o filenames
    bool d_exportNeeded;

    Vect d_modVect;             // modules used in a project
    ModMap d_moduleNameIdx;     // from module name to d_modVect idx.

    public:
        Scan();

        Path const &cwd() const;                                        // .f
                                                                       
        std::string gcmName(size_t idx) const;  // modName as .gcm name // .f

        Vect &modVect();                                                // .f
        Vect const &modVect() const;                                    // .f
        size_t modVectSize() const;                                     // .f
        ModData const &modVect(size_t idx) const;                       // .f
        ModMap &moduleNameIdx();                                        // .f

        void process(std::string const &source, std::string const &filename);

        void rmImport(ModData &data, std::string const &modName);       // .f
        void setExtern(size_t idx);                                     // .f
        void setNr(size_t nr);                                          // .f

        void showDeps() const;

    private:
        size_t declare(std::string const &name);    // index of entry name:
                                                    // UNKNOWN if new.

        size_t define(std::string const &name);     // UNKNOWN -> LOCAL


        void defineModule();            // MODDEF   export module Name;
        void declareModule();           // MODDECL  [export] import Name; 
        void source();                  // MODSRC   module Name;

        void definePartition();         // PARTDEF  export module Name:Part;
        void declarePartition();        // PARTDECL export import :Part;

        static std::string col2hyphen(std::string const &name);
        static size_t idxOf(ModMapInsert const &inserted);              // .ih
        static void showMod(ModData const &data);                       // .ih
};

#include "scan.f"

#endif



