#include "main.ih"

namespace {
char const info[] = R"_( [options] [arg]
Where:
    [options] - optional arguments (short options between parentheses):
       --colors (-c)        - the compiler uses diagnostic colors 
                              (default: no colors).
       --dependencies (-d)  - no compilation, merely show the dependencies
       --extension (-x) ext - ext: source file extension. By default .cc
       --extern (-e) file   - the currrent project's .gcm files may depend on
                              .gcm files defined by other (external)
                              projects. Those external .gcm files are located
                              below the directories specified (relative to the
                              current project's base directory) in separate
                              lines of 'file'. Those external .gcm files (and
                              the .gcm files they depend on) are soft-linked
                              to the project's gcm.cache directory.
                              Empty lines and lines starting with // are
                              skipped.
       --file (-f) name     - the module/partition source files are not
                              compiled, but their names (beyond the current
                              working directory) are written to 'name'. Use 
                              name '-' (no quotes) to write the namesn to the
                              stdandard output stream.
       --help (-h)          - provide this help and end the program
       --ignore (-i) list   - all subdirs except for those listed in 'list'
                              are visited, CLASSES is not used. 
                              Use --ignore '' to visit all subdirs.
       --quiet (-q)         - don't echo compiler calls (suppressed by
                              --verbose) 
       --subdir (-s)        - the compiled module/partition files (.o files)
                              are located in in their source file directories.
                              By default in the project's tmp/o sub-directory.
                              Each .o file is prefixed by a unique number
                              (e.g., 1module.o, 2module.o, ...).
       --version (-v)       - show version information and end the program.
       --verbose (-V)       - show details of performed steps.

    arg - the action to perform:
        no argument - perform the default cconfigured module-mapping according
            to the specified options (no options: using CLASSES and performing
            compilations). 
            
        clean - remove the gcm.cache directories in the current working
                directory and in the project's subdirectories
        
    Files are compiled using the standard specified bu the ICMAKE_CPPSTD
    environment variable. If ICMAKE_CPPSTD isn't defined the compiler's
    default C++ standard is used.
)_";

/*
        --clean (-C)        - recursively remove all gcm.cache files in 
                              the CLASSES (or non-ignore) subdirs and
                              in the 'arg' direcory.
        --module (-m) file  - file: source file name defining the module's
                              interface (default: module.cc).

*/

}

void usage(std::string const &progname)
{
    Tools::usageTop(progname) << info;
}




