/* 
 * Motif
 *
 * Copyright (c) 1987-2012, The Open Group. All rights reserved.
 *
 * These libraries and programs are free software; you can
 * redistribute them and/or modify them under the terms of the GNU
 * Lesser General Public License as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option)
 * any later version.
 *
 * These libraries and programs are distributed in the hope that
 * they will be useful, but WITHOUT ANY WARRANTY; without even the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 * PURPOSE. See the GNU Lesser General Public License for more
 * details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with these librararies and programs; if not, write
 * to the Free Software Foundation, Inc., 51 Franklin Street, Fifth
 * Floor, Boston, MA 02110-1301 USA
*/ 

/*************************************<+>*************************************
 *****************************************************************************
 **
 **   File:        BitmapsI.h
 **
 **   Description: This file contains a set of predefines bitmaps
 **		   which are used by the image caching functions.
 **
 ****************************************************************************
 ************************************<+>*************************************/

#ifndef _XmBitmapsI_h
#define _XmBitmapsI_h

#include <Xm/XmP.h>

#ifdef __cplusplus
extern "C" {
#endif

static XmConst unsigned char bitmaps [20][32] =
{
   {  0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  Solid Background  */
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  },

   {  0x88, 0x88, 0x22, 0x22, 0x88, 0x88, 0x22, 0x22,	/*  25 percent  */
      0x88, 0x88, 0x22, 0x22, 0x88, 0x88, 0x22, 0x22,
      0x88, 0x88, 0x22, 0x22, 0x88, 0x88, 0x22, 0x22,
      0x88, 0x88, 0x22, 0x22, 0x88, 0x88, 0x22, 0x22  },

   {  0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA,	/*  50 percent  */
      0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA,
      0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA,
      0x55, 0x55, 0xAA, 0xAA, 0x55, 0x55, 0xAA, 0xAA  },

   {  0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF,	/*  75 percent  */
      0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF,
      0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF,
      0x55, 0x55, 0xFF, 0xFF, 0xAA, 0xAA, 0xFF, 0xFF  },

   {  0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,	/*  Vertical tile  */
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55  },

   {  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,	/*  Horizontal tile */ 
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00  },

   {  0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,	/*  Vertical  */
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
      0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55  },

   {  0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00,	/*  Horizontal  */ 
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00, 
      0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x00, 0x00  },

   {  0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee,	/*  Slant Left  */
      0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee, 
      0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee, 
      0x77, 0x77, 0xbb, 0xbb, 0xdd, 0xdd, 0xee, 0xee  },

   {  0xee, 0xee, 0xdd, 0xdd, 0xbb, 0xbb, 0x77, 0x77,	/*  Slant Right  */
      0xee, 0xee, 0xdd, 0xdd, 0xbb, 0xbb, 0x77, 0x77, 
      0xee, 0xee, 0xdd, 0xdd, 0xbb, 0xbb, 0x77, 0x77, 
      0xee, 0xee, 0xdd, 0xdd, 0xbb, 0xbb, 0x77, 0x77  },

   {  						
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /*  Default Cascade  */ 
     0x00, 0x03, 0x00, 0x06, 0x00, 0x0c, 0x00, 0x18,  
     0xff, 0x3f, 0x00, 0x18, 0x00, 0x0c, 0x00, 0x06,  
     0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   },

   {  						
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /* Default RtoL Cascade*/ 
     0xc0, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 0x00,
     0xfc, 0xff, 0x18, 0x00, 0x30, 0x00, 0x60, 0x00,
     0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   },

   {
      0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /* Default CheckMark */
      0x00, 0x00, 0x00, 0x60, 0x00, 0x30, 0x00, 0x18, 
      0x00, 0x0c, 0x08, 0x06, 0x18, 0x03, 0xb0, 0x01, 
      0xe0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00  }, 
   {  						
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  /*  Default menu dash */ 
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  
     0xff, 0x3f, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,  
     0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00   },
   {
     0x00, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x3c, 0x00,  /* collapsed */  
     0xfc, 0x00, 0xfc, 0x03, 0xfc, 0x0f, 0xfc, 0x3f, 
     0xfc, 0x3f, 0xfc, 0x0f, 0xfc, 0x03, 0xfc, 0x00,
     0x3c, 0x00, 0x0c, 0x00, 0x00, 0x00, 0x00, 0x00   },
   {
     0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x00, 0x3c,  /* collapsed_rtol */  
     0x00, 0x3f, 0xc0, 0x3f, 0xf0, 0x3f, 0xfc, 0x3f, 
     0xfc, 0x3f, 0xf0, 0x3f, 0xc0, 0x3f, 0x00, 0x3f,
     0x00, 0x3c, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00   },
   {
     0x00, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0xfc, 0x3f,  /* expanded */ 
     0xf8, 0x1f, 0xf8, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f, 
     0xe0, 0x07, 0xe0, 0x07, 0xc0, 0x03, 0xc0, 0x03,
     0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00   }
};


static XmConst char *XmConst bitmap_name_set[] =
{
   "background",
   "25_foreground",
   XmS50_foreground,
   "75_foreground",
   "vertical_tile",
   "horizontal_tile",
   /* for bc reason with 1.2.2, we have to put back the old names,
      but we also need to keep the new ones, for 1.2.3 users */
   "vertical",
   "horizontal",
   "slant_right",
   "slant_left",
   "menu_cascade",
   "menu_cascade_rtol",
   "menu_checkmark",
   "menu_dash",
   "collapsed",
   "collapsed_rtol",
   "expanded",
};

#define MAX_BUILTIN_IMAGES	17

#ifdef __cplusplus
}  /* Close scope of 'extern "C"' declaration which encloses file. */
#endif

#endif /* _XmBitmapsI_h */
/* DON'T ADD STUFF AFTER THIS #endif */
