/*
Copyright (C) by Dmitry E. Oboukhov 2006, 2007

  This package is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This package is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this package; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
*/
#ifndef __SIM__H__
#define __SIM__H__

#include <time.h>

#include "units_info.h"

#define MAX_ROUNDS    6     // количество раундов в битве

// нормализует ресурсы (делает их кратными 100)
#define NORMALIZE_DEBRIS(__x)  (((__x)/100)*100)

// структура описывающая игрока
typedef struct
{ 
    int armory,               // броня
        shield,               // щиты
        attack,               // атака
        unit[UNITS_COUNT],    // юниты
        count;                // общее число юнитов
} gamer_info;

// ресурсы
typedef struct
{
  int metal, crystal, deut;
} resource;

// структура описывающая задание для симулятора
typedef struct
{ 
  gamer_info attacker;  // инфа о первом игроке
  gamer_info defender;  // инфа о втором игроке

  int simulations;      // количество симуляций
  time_t work_time;     // время которое можно считать
  int forks_count;      // количество параллельных процессов для расчета

  resource defender_resource;
} sim_info;

// ресурсы в потерях
typedef struct 
{
  long long metal, crystal, deut, structure, total;
} debris_resources;

// потери
typedef struct
{
  debris_resources fleet, ground, all;
} debris_info;

// потери сведенные в одну структуру
typedef struct
{
  long long ldata_begin[0];
  debris_info attacker, defender, both;
  
  struct 
  { 
    long long  fleet, all; 
  } recyclers;        // переработчики

  long long ldata_end[0];
  
  int idata_begin[0];
  struct 
  {
    int fleet, all;
  } moon;              // шанс луны
  int idata_end[0];
} debris;

// результат симуляции
typedef struct
{
  struct
  {
    int unit[UNITS_COUNT];            // по сколько юнитов выжило
    int count;                        // всего юнитов
    long long capacity;               // вместимость
  } attacker, defender;
  
  debris debris;                      // общие потери


  int who_win;                        // кто выиграл
  int rounds;                         // количество раундов

  resource attacker_plunder;          // сколько ресов забрал атакер

  struct
  {
    int small, large;
  } chargo;                           // сколько транспортов треба


} sim_result, * psim_result;

// результат многих симуляций
typedef struct
{
  int sim_count;                  // количество симуляций
  
  sim_info task;                  // начальное задание симуляции
  
  struct                          // 
  {                               // среднее количество
    double unit[UNITS_COUNT];     // флотов и обломков
    long long capacity;           // и средняя вместимость
  } attacker, defender;           //
                                  //
  debris debris;                  // 

  struct                          //
  {                               //
    int min, max;                 //
    double average;               //
  } rounds;                       // количество раундов

  struct
  {
    int attacker, defender;
  } wins;                         // количество побед
  
  resource attacker_plunder;      // среднее количество забранных ресов
 
  struct
  {
    int small, large;
  } chargo;                       // количество транспортов
  
  sim_result best_attacker,       // лучшая симуляция для атакующего
             worst_attacker,      // худшая симуляция для атакующего
             best_defender,       // лучшая симуляция для защитника
             worst_defender,      // худшая симуляция для защитника
             max_debris,          // симуляция с максимальными обломками
             min_debris;          // симуляция с минимальными обломками
} sims_result;

enum { NO_WIN, ATTACKER_WIN, DEFENDER_WIN };

sims_result * simulator(const sim_info * sim);



#endif // __SIM__H__
