% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot-nested.R
\name{nested_data_plot}
\alias{nested_data_plot}
\title{Create a plot of nested sources of variation}
\usage{
nested_data_plot(
  dat,
  x,
  groups = c(),
  stat = "mean",
  ...,
  y_gap = 1,
  divider_color = "grey50",
  point_args = list(),
  dline_args = list(),
  vline_args = list(),
  hline_args = list(),
  label_args = list(),
  connector_args = list()
)
}
\arguments{
\item{dat}{a \code{data.frame} or similar object}

\item{x}{the variable within \code{dat} to plot. Most often this would be a
strength or modulus variable.}

\item{groups}{a vector of variables to group the data by}

\item{stat}{a function for computing the central location for each group.
This is normally "mean" but could be "median" or another
function.}

\item{...}{extra options. See Details.}

\item{y_gap}{the vertical gap between grouping variables}

\item{divider_color}{the color of the lines between grouping variables.
Or \code{NULL} to omit these lines.}

\item{point_args}{arguments to pass to \link[ggplot2:geom_point]{ggplot2::geom_point} when plotting
individual data points.}

\item{dline_args}{arguments to pass to \link[ggplot2:geom_segment]{ggplot2::geom_segment} when plotting
the horizontal lines between data points.}

\item{vline_args}{arguments to pass to \link[ggplot2:geom_segment]{ggplot2::geom_segment} when plotting
vertical lines}

\item{hline_args}{arguments to pass to \link[ggplot2:geom_segment]{ggplot2::geom_segment} when plotting
horizontal lines connecting levels in groups}

\item{label_args}{arguments to pass to \link[ggplot2:geom_text]{ggplot2::geom_label} when plotting
labels}

\item{connector_args}{arguments to pass to \link[ggplot2:geom_point]{ggplot2::geom_point} when
plotting the connection between the vertical lines
and the horizontal lines connecting levels in groups}
}
\description{
Creates a plot showing the breakdown of variation within a sample. This
function uses \code{ggplot2} internally.
}
\details{
Extra options can be included to control aesthetic options. The following
options are supported. Any (or all) can be set to a single variable
in the data set.
\itemize{
\item \code{color}: Controls the color of the data points.
\item \code{fill}: Controls the fill color of the labels. When a particular label
is associated with data points with more than one level of the supplied
variable, the fill is omitted.
}
}
\examples{
library(dplyr)
carbon.fabric.2 \%>\%
  filter(test == "WT" & condition == "RTD") \%>\%
  nested_data_plot(strength,
                   groups = c(batch, panel))

# Labels can be filled too
carbon.fabric.2 \%>\%
  filter(test == "WT" & condition == "RTD") \%>\%
  nested_data_plot(strength,
                   groups = c(batch, panel),
                   fill = batch)

}
