% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformulas.R
\name{sub_specials}
\alias{sub_specials}
\title{Substitute safe chars (+) for specials (for use in \code{model.frame})
(Generalized from \code{lme4}'s \code{subbars} function.)}
\usage{
sub_specials(
  term,
  specials = c("|", "||", "s"),
  keep_args = c(2L, 2L, NA_integer_)
)
}
\arguments{
\item{term}{formula or term in a formula}

\item{specials}{names of specials to process}

\item{keep_args}{number of arguments to retain (matching \code{specials})}
}
\value{
a term or formula with specials replaced by \code{+} (and extra arguments dropped)
}
\description{
Substitute safe chars (+) for specials (for use in \code{model.frame})
(Generalized from \code{lme4}'s \code{subbars} function.)
}
\examples{
sub_specials( ~ s(a, k=4))
sub_specials( ~ (1|x) + (a + b || y) + s(a, k=4))
sub_specials(Reaction ~ s(Days) + (1 + Subject))
sub_specials(~ s(cos((y^2*3)/2), bs = "tp"))
}
\keyword{internal}
