% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmSeries.R
\name{glmSeries}
\alias{glmSeries}
\title{Run a series of generalized linear regression analyses}
\usage{
glmSeries(formula, data, vars, ...)
}
\arguments{
\item{formula}{The fixed part of the regression formula. For
univariate analyses this is simply \code{y~1} where \code{y} is
the outcome variable. When the aim is to control the effect of
\code{vars} in each element of the series by a fixed set of
variables it is \code{y~x1+x2} where again y is the outcome and x1
and x2 are confounders.}

\item{data}{A \code{data.frame} in which we evaluate the formula.}

\item{vars}{A list of variable names, the changing part of the
regression formula.}

\item{...}{passed to glm}
}
\value{
Matrix with regression coefficients, one for each element of \code{vars}.
}
\description{
Run a series of generalized linear regression analyses for a list of predictor variables
and summarize the results in a table.
The regression models can be adjusted for a fixed set of covariates.
}
\examples{

data(Diabetes)
Diabetes$hyper1 <- factor(1*(Diabetes$bp.1s>140))
## collect odds ratios from three univariate logistic regression analyses
uni.odds <- glmSeries(hyper1~1,vars=c("chol","hdl","location"),data=Diabetes,family=binomial)
uni.odds
## control the logistic regression analyses for age and gender
## but collect only information on the variables in `vars'.
controlled.odds <- glmSeries(hyper1~age+gender,
                             vars=c("chol","hdl","location"),
                             data=Diabetes, family=binomial)
controlled.odds
}
\author{
Thomas Alexander Gerds
}
