/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.fillingcurve;

import cds.healpix.fillingcurve.FillingCurve2D;

public final class ZOrderCurve2DImpls {
    public static final FillingCurve2D EMPTY = new FillingCurve2D(){

        @Override
        public long xy2hash(double x, double y) {
            return 0L;
        }

        @Override
        public long ij2hash(int i, int j) {
            return 0L;
        }

        @Override
        public long i02hash(int i) {
            return 0L;
        }

        @Override
        public long hash2ij(long hash) {
            return 0L;
        }

        @Override
        public long hash2i0(long hash) {
            return 0L;
        }

        @Override
        public int ij2i(long ij) {
            return 0;
        }

        @Override
        public int ij2j(long ij) {
            return 0;
        }
    };
    public static final FillingCurve2D ZOC_VMSB_OR_BYTE = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            assert (i == -1 && j == -1 || (i & 0xFFFFFF00) == 0 && (j & 0xFFFFFF00) == 0);
            i |= j << 8;
            i = (0xF0 & i) << 4 | (0xF00 & i) >>> 4 | 0xF00F & i;
            i = (0xC0C & i) << 2 | (0x3030 & i) >>> 2 | 0xC3C3 & i;
            i = (0x2222 & i) << 1 | (0x4444 & i) >>> 1 | 0x9999 & i;
            return i;
        }

        @Override
        public final long i02hash(int i) {
            assert ((i & 0xFFFFFF00) == 0);
            i = (i << 4 | i) & 0xF0F;
            i = (i << 2 | i) & 0x3333;
            i = (i << 1 | i) & 0x5555;
            return i;
        }

        @Override
        public final long hash2ij(long hash) {
            assert ((0xFFFFFFFFFFFF0000L & hash) == 0L);
            int h = (int)hash;
            h = (0x22222222 & h) << 1 | (0x44444444 & h) >>> 1 | 0x99999999 & h;
            h = (0xC0C0C0C & h) << 2 | (0x30303030 & h) >>> 2 | 0xC3C3C3C3 & h;
            h = (0xF000F0 & h) << 4 | (0xF000F00 & h) >>> 4 | 0xF00FF00F & h;
            return h;
        }

        @Override
        public final long hash2i0(long hash) {
            assert ((0xFFFFFFFFFFFF3333L & hash) == 0L);
            int h = (int)hash;
            h = (h >> 1 | h) & 0x3333;
            h = (h >> 2 | h) & 0xF0F;
            h = (h >> 4 | h) & 0xFF;
            return h;
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij & 0xFF;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)ij >>> 8;
        }
    };
    public static final FillingCurve2D ZOC_VMSB_OR_SHORT = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            assert (i == -1 && j == -1 || (i & 0xFFFF0000) == 0 && (j & 0xFFFF0000) == 0);
            long h = (long)i | (long)j << 16;
            h = (0xFF00L & h) << 8 | (0xFF0000L & h) >>> 8 | 0xFF0000FFL & h;
            h = (0xF000F0L & h) << 4 | (0xF000F00L & h) >>> 4 | 0xF00FF00FL & h;
            h = (0xC0C0C0CL & h) << 2 | (0x30303030L & h) >>> 2 | 0xC3C3C3C3L & h;
            h = (0x22222222L & h) << 1 | (0x44444444L & h) >>> 1 | 0x99999999L & h;
            return h;
        }

        @Override
        public final long i02hash(int i) {
            assert ((i & 0xFFFF0000) == 0);
            i = (i << 8 | i) & 0xFF00FF;
            i = (i << 4 | i) & 0xF0F0F0F;
            i = (i << 2 | i) & 0x33333333;
            i = (i << 1 | i) & 0x55555555;
            return i;
        }

        @Override
        public final long hash2ij(long hash) {
            assert ((0xFFFFFFFF00000000L & hash) == 0L);
            int h = (int)hash;
            h = (0x22222222 & h) << 1 | (0x44444444 & h) >>> 1 | 0x99999999 & h;
            h = (0xC0C0C0C & h) << 2 | (0x30303030 & h) >>> 2 | 0xC3C3C3C3 & h;
            h = (0xF000F0 & h) << 4 | (0xF000F00 & h) >>> 4 | 0xF00FF00F & h;
            h = (0xFF00 & h) << 8 | (0xFF0000 & h) >>> 8 | 0xFF0000FF & h;
            return h;
        }

        @Override
        public final long hash2i0(long hash) {
            assert ((0xFFFFFFFF33333333L & hash) == 0L);
            int h = (int)hash;
            h = (h >> 1 | h) & 0x33333333;
            h = (h >> 2 | h) & 0xF0F0F0F;
            h = (h >> 4 | h) & 0xFF00FF;
            h = (h >> 8 | h) & 0xFFFF;
            return h;
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij & 0xFFFF;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)ij >>> 16;
        }
    };
    public static final FillingCurve2D ZOC_VMSB_OR_INT = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            long h = (long)j << 32;
            h |= (long)i;
            h = (0xFFFF0000L & h) << 16 | (0xFFFF00000000L & h) >>> 16 | 0xFFFF00000000FFFFL & h;
            h = (0xFF000000FF00L & h) << 8 | (0xFF000000FF0000L & h) >>> 8 | 0xFF0000FFFF0000FFL & h;
            h = (0xF000F000F000F0L & h) << 4 | (0xF000F000F000F00L & h) >>> 4 | 0xF00FF00FF00FF00FL & h;
            h = (0xC0C0C0C0C0C0C0CL & h) << 2 | (0x3030303030303030L & h) >>> 2 | 0xC3C3C3C3C3C3C3C3L & h;
            h = (0x2222222222222222L & h) << 1 | (0x4444444444444444L & h) >>> 1 | 0x9999999999999999L & h;
            return h;
        }

        @Override
        public final long i02hash(int i) {
            long h = i;
            h = (h << 16 | h) & 0xFFFF0000FFFFL;
            h = (h << 8 | h) & 0xFF00FF00FF00FFL;
            h = (h << 4 | h) & 0xF0F0F0F0F0F0F0FL;
            h = (h << 2 | h) & 0x3333333333333333L;
            h = (h << 1 | h) & 0x5555555555555555L;
            return h;
        }

        @Override
        public final long hash2ij(long h) {
            h = (0x2222222222222222L & h) << 1 | (0x4444444444444444L & h) >>> 1 | 0x9999999999999999L & h;
            h = (0xC0C0C0C0C0C0C0CL & h) << 2 | (0x3030303030303030L & h) >>> 2 | 0xC3C3C3C3C3C3C3C3L & h;
            h = (0xF000F000F000F0L & h) << 4 | (0xF000F000F000F00L & h) >>> 4 | 0xF00FF00FF00FF00FL & h;
            h = (0xFF000000FF00L & h) << 8 | (0xFF000000FF0000L & h) >>> 8 | 0xFF0000FFFF0000FFL & h;
            h = (0xFFFF0000L & h) << 16 | (0xFFFF00000000L & h) >>> 16 | 0xFFFF00000000FFFFL & h;
            return h;
        }

        @Override
        public final long hash2i0(long h) {
            assert ((0x3333333333333333L & h) == 0L);
            h = (h >> 1 | h) & 0x3333333333333333L;
            h = (h >> 2 | h) & 0xF0F0F0F0F0F0F0FL;
            h = (h >> 4 | h) & 0xFF00FF00FF00FFL;
            h = (h >> 8 | h) & 0xFFFF0000FFFFL;
            h = (h >> 16 | h) & 0xFFFFFFFFL;
            return h;
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)(ij >>> 32);
        }
    };
    public static final FillingCurve2D ZOC_VMSB_XOR_BYTE = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            assert (i == -1 && j == -1 || (i & 0xFFFFFF00) == 0 && (j & 0xFFFFFF00) == 0);
            i |= j << 8;
            j = (i ^ i >>> 4) & 0xF0;
            i = i ^ j ^ j << 4;
            j = (i ^ i >>> 2) & 0xC0C;
            i = i ^ j ^ j << 2;
            j = (i ^ i >>> 1) & 0x2222;
            i = i ^ j ^ j << 1;
            return i;
        }

        @Override
        public final long hash2ij(long hash) {
            assert ((0xFFFFFFFFFFFF0000L & hash) == 0L);
            int h = (int)hash;
            int t = (h ^ h >>> 1) & 0x2222;
            h = h ^ t ^ t << 1;
            t = (h ^ h >>> 2) & 0xC0C;
            h = h ^ t ^ t << 2;
            t = (h ^ h >>> 4) & 0xF0;
            h = h ^ t ^ t << 4;
            return h;
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij & 0xFF;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)ij >>> 8;
        }

        @Override
        public final long i02hash(int i) {
            return ZOC_VMSB_OR_BYTE.i02hash(i);
        }

        @Override
        public final long hash2i0(long hash) {
            return ZOC_VMSB_OR_BYTE.hash2i0(hash);
        }
    };
    public static final FillingCurve2D ZOC_VMSB_XOR_SHORT = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            assert (i == -1 && j == -1 || (i & 0xFFFF0000) == 0 && (j & 0xFFFF0000) == 0);
            long k = j;
            long h = (long)i | k << 16;
            k = (h ^ h >>> 8) & 0xFF00L;
            h = h ^ k ^ k << 8;
            k = (h ^ h >>> 4) & 0xF000F0L;
            h = h ^ k ^ k << 4;
            k = (h ^ h >>> 2) & 0xC0C0C0CL;
            h = h ^ k ^ k << 2;
            k = (h ^ h >>> 1) & 0x22222222L;
            h = h ^ k ^ k << 1;
            return h;
        }

        @Override
        public final long hash2ij(long hash) {
            assert ((0xFFFFFFFF00000000L & hash) == 0L);
            int h = (int)hash;
            int t = (h ^ h >>> 1) & 0x22222222;
            h = h ^ t ^ t << 1;
            t = (h ^ h >>> 2) & 0xC0C0C0C;
            h = h ^ t ^ t << 2;
            t = (h ^ h >>> 4) & 0xF000F0;
            h = h ^ t ^ t << 4;
            t = (h ^ h >>> 8) & 0xFF00;
            h = h ^ t ^ t << 8;
            return h;
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij & 0xFFFF;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)ij >>> 16;
        }

        @Override
        public final long i02hash(int i) {
            return ZOC_VMSB_OR_SHORT.i02hash(i);
        }

        @Override
        public final long hash2i0(long hash) {
            return ZOC_VMSB_OR_SHORT.hash2i0(hash);
        }
    };
    public static final FillingCurve2D ZOC_VMSB_XOR_INT = new FillingCurve2D(){

        @Override
        public final long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public final long ij2hash(int i, int j) {
            long h = (long)j << 32;
            long t = ((h |= (long)i) ^ h >> 16) & 0xFFFF0000L;
            h = h ^ t ^ t << 16;
            t = (h ^ h >> 8) & 0xFF000000FF00L;
            h = h ^ t ^ t << 8;
            t = (h ^ h >> 4) & 0xF000F000F000F0L;
            h = h ^ t ^ t << 4;
            t = (h ^ h >> 2) & 0xC0C0C0C0C0C0C0CL;
            h = h ^ t ^ t << 2;
            t = (h ^ h >> 1) & 0x2222222222222222L;
            h = h ^ t ^ t << 1;
            return h;
        }

        @Override
        public final long i02hash(int i) {
            return ZOC_VMSB_OR_INT.i02hash(i);
        }

        @Override
        public final long hash2ij(long h) {
            long t = (h ^ h >>> 1) & 0x2222222222222222L;
            h = h ^ t ^ t << 1;
            t = (h ^ h >>> 2) & 0xC0C0C0C0C0C0C0CL;
            h = h ^ t ^ t << 2;
            t = (h ^ h >>> 4) & 0xF000F000F000F0L;
            h = h ^ t ^ t << 4;
            t = (h ^ h >>> 8) & 0xFF000000FF00L;
            h = h ^ t ^ t << 8;
            t = (h ^ h >>> 16) & 0xFFFF0000L;
            h = h ^ t ^ t << 16;
            return h;
        }

        @Override
        public final long hash2i0(long hash) {
            return ZOC_VMSB_OR_INT.hash2i0(hash);
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)(ij >>> 32);
        }
    };
    private static final short[] LUPT_TO_HASH = new short[]{0, 1, 4, 5, 16, 17, 20, 21, 64, 65, 68, 69, 80, 81, 84, 85, 256, 257, 260, 261, 272, 273, 276, 277, 320, 321, 324, 325, 336, 337, 340, 341, 1024, 1025, 1028, 1029, 1040, 1041, 1044, 1045, 1088, 1089, 1092, 1093, 1104, 1105, 1108, 1109, 1280, 1281, 1284, 1285, 1296, 1297, 1300, 1301, 1344, 1345, 1348, 1349, 1360, 1361, 1364, 1365, 4096, 4097, 4100, 4101, 4112, 4113, 4116, 4117, 4160, 4161, 4164, 4165, 4176, 4177, 4180, 4181, 4352, 4353, 4356, 4357, 4368, 4369, 4372, 4373, 4416, 4417, 4420, 4421, 4432, 4433, 4436, 4437, 5120, 5121, 5124, 5125, 5136, 5137, 5140, 5141, 5184, 5185, 5188, 5189, 5200, 5201, 5204, 5205, 5376, 5377, 5380, 5381, 5392, 5393, 5396, 5397, 5440, 5441, 5444, 5445, 5456, 5457, 5460, 5461, 16384, 16385, 16388, 16389, 16400, 16401, 16404, 16405, 16448, 16449, 16452, 16453, 16464, 16465, 16468, 16469, 16640, 16641, 16644, 16645, 16656, 16657, 16660, 16661, 16704, 16705, 16708, 16709, 16720, 16721, 16724, 16725, 17408, 17409, 17412, 17413, 17424, 17425, 17428, 17429, 17472, 17473, 17476, 17477, 17488, 17489, 17492, 17493, 17664, 17665, 17668, 17669, 17680, 17681, 17684, 17685, 17728, 17729, 17732, 17733, 17744, 17745, 17748, 17749, 20480, 20481, 20484, 20485, 20496, 20497, 20500, 20501, 20544, 20545, 20548, 20549, 20560, 20561, 20564, 20565, 20736, 20737, 20740, 20741, 20752, 20753, 20756, 20757, 20800, 20801, 20804, 20805, 20816, 20817, 20820, 20821, 21504, 21505, 21508, 21509, 21520, 21521, 21524, 21525, 21568, 21569, 21572, 21573, 21584, 21585, 21588, 21589, 21760, 21761, 21764, 21765, 21776, 21777, 21780, 21781, 21824, 21825, 21828, 21829, 21840, 21841, 21844, 21845};
    private static final short[] LUPT_TO_IJ_BYTE = new short[]{0, 1, 256, 257, 2, 3, 258, 259, 512, 513, 768, 769, 514, 515, 770, 771, 4, 5, 260, 261, 6, 7, 262, 263, 516, 517, 772, 773, 518, 519, 774, 775, 1024, 1025, 1280, 1281, 1026, 1027, 1282, 1283, 1536, 1537, 1792, 1793, 1538, 1539, 1794, 1795, 1028, 1029, 1284, 1285, 1030, 1031, 1286, 1287, 1540, 1541, 1796, 1797, 1542, 1543, 1798, 1799, 8, 9, 264, 265, 10, 11, 266, 267, 520, 521, 776, 777, 522, 523, 778, 779, 12, 13, 268, 269, 14, 15, 270, 271, 524, 525, 780, 781, 526, 527, 782, 783, 1032, 1033, 1288, 1289, 1034, 1035, 1290, 1291, 1544, 1545, 1800, 1801, 1546, 1547, 1802, 1803, 1036, 1037, 1292, 1293, 1038, 1039, 1294, 1295, 1548, 1549, 1804, 1805, 1550, 1551, 1806, 1807, 2048, 2049, 2304, 2305, 2050, 2051, 2306, 2307, 2560, 2561, 2816, 2817, 2562, 2563, 2818, 2819, 2052, 2053, 2308, 2309, 2054, 2055, 2310, 2311, 2564, 2565, 2820, 2821, 2566, 2567, 2822, 2823, 3072, 3073, 3328, 3329, 3074, 3075, 3330, 3331, 3584, 3585, 3840, 3841, 3586, 3587, 3842, 3843, 3076, 3077, 3332, 3333, 3078, 3079, 3334, 3335, 3588, 3589, 3844, 3845, 3590, 3591, 3846, 3847, 2056, 2057, 2312, 2313, 2058, 2059, 2314, 2315, 2568, 2569, 2824, 2825, 2570, 2571, 2826, 2827, 2060, 2061, 2316, 2317, 2062, 2063, 2318, 2319, 2572, 2573, 2828, 2829, 2574, 2575, 2830, 2831, 3080, 3081, 3336, 3337, 3082, 3083, 3338, 3339, 3592, 3593, 3848, 3849, 3594, 3595, 3850, 3851, 3084, 3085, 3340, 3341, 3086, 3087, 3342, 3343, 3596, 3597, 3852, 3853, 3598, 3599, 3854, 3855};
    private static final int[] LUPT_TO_IJ_SHORT = new int[]{0, 1, 65536, 65537, 2, 3, 65538, 65539, 131072, 131073, 196608, 196609, 131074, 131075, 196610, 196611, 4, 5, 65540, 65541, 6, 7, 65542, 65543, 131076, 131077, 196612, 196613, 131078, 131079, 196614, 196615, 262144, 262145, 327680, 327681, 262146, 262147, 327682, 327683, 393216, 393217, 458752, 458753, 393218, 393219, 458754, 458755, 262148, 262149, 327684, 327685, 262150, 262151, 327686, 327687, 393220, 393221, 458756, 458757, 393222, 393223, 458758, 458759, 8, 9, 65544, 65545, 10, 11, 65546, 65547, 131080, 131081, 196616, 196617, 131082, 131083, 196618, 196619, 12, 13, 65548, 65549, 14, 15, 65550, 65551, 131084, 131085, 196620, 196621, 131086, 131087, 196622, 196623, 262152, 262153, 327688, 327689, 262154, 262155, 327690, 327691, 393224, 393225, 458760, 458761, 393226, 393227, 458762, 458763, 262156, 262157, 327692, 327693, 262158, 262159, 327694, 327695, 393228, 393229, 458764, 458765, 393230, 393231, 458766, 458767, 524288, 524289, 589824, 589825, 524290, 524291, 589826, 589827, 655360, 655361, 720896, 720897, 655362, 655363, 720898, 720899, 524292, 524293, 589828, 589829, 524294, 524295, 589830, 589831, 655364, 655365, 720900, 720901, 655366, 655367, 720902, 720903, 786432, 786433, 851968, 851969, 786434, 786435, 851970, 851971, 917504, 917505, 983040, 983041, 917506, 917507, 983042, 983043, 786436, 786437, 851972, 851973, 786438, 786439, 851974, 851975, 917508, 917509, 983044, 983045, 917510, 917511, 983046, 983047, 524296, 524297, 589832, 589833, 524298, 524299, 589834, 589835, 655368, 655369, 720904, 720905, 655370, 655371, 720906, 720907, 524300, 524301, 589836, 589837, 524302, 524303, 589838, 589839, 655372, 655373, 720908, 720909, 655374, 655375, 720910, 720911, 786440, 786441, 851976, 851977, 786442, 786443, 851978, 851979, 917512, 917513, 983048, 983049, 917514, 917515, 983050, 983051, 786444, 786445, 851980, 851981, 786446, 786447, 851982, 851983, 917516, 917517, 983052, 983053, 917518, 917519, 983054, 983055};
    private static final long[] LUPT_TO_IJ_INT = new long[]{0L, 1L, 0x100000000L, 0x100000001L, 2L, 3L, 0x100000002L, 0x100000003L, 0x200000000L, 0x200000001L, 0x300000000L, 0x300000001L, 0x200000002L, 0x200000003L, 0x300000002L, 0x300000003L, 4L, 5L, 0x100000004L, 0x100000005L, 6L, 7L, 0x100000006L, 0x100000007L, 0x200000004L, 0x200000005L, 0x300000004L, 0x300000005L, 0x200000006L, 0x200000007L, 0x300000006L, 0x300000007L, 0x400000000L, 0x400000001L, 0x500000000L, 0x500000001L, 0x400000002L, 0x400000003L, 0x500000002L, 0x500000003L, 0x600000000L, 0x600000001L, 0x700000000L, 0x700000001L, 0x600000002L, 0x600000003L, 0x700000002L, 0x700000003L, 0x400000004L, 0x400000005L, 0x500000004L, 0x500000005L, 0x400000006L, 0x400000007L, 0x500000006L, 0x500000007L, 0x600000004L, 0x600000005L, 0x700000004L, 0x700000005L, 0x600000006L, 0x600000007L, 0x700000006L, 0x700000007L, 8L, 9L, 0x100000008L, 0x100000009L, 10L, 11L, 0x10000000AL, 0x10000000BL, 0x200000008L, 0x200000009L, 0x300000008L, 0x300000009L, 0x20000000AL, 0x20000000BL, 0x30000000AL, 0x30000000BL, 12L, 13L, 0x10000000CL, 0x10000000DL, 14L, 15L, 0x10000000EL, 0x10000000FL, 0x20000000CL, 0x20000000DL, 0x30000000CL, 0x30000000DL, 0x20000000EL, 0x20000000FL, 0x30000000EL, 0x30000000FL, 0x400000008L, 0x400000009L, 0x500000008L, 0x500000009L, 0x40000000AL, 0x40000000BL, 0x50000000AL, 0x50000000BL, 0x600000008L, 0x600000009L, 0x700000008L, 0x700000009L, 0x60000000AL, 0x60000000BL, 0x70000000AL, 0x70000000BL, 0x40000000CL, 0x40000000DL, 0x50000000CL, 0x50000000DL, 0x40000000EL, 0x40000000FL, 0x50000000EL, 0x50000000FL, 0x60000000CL, 0x60000000DL, 0x70000000CL, 0x70000000DL, 0x60000000EL, 0x60000000FL, 0x70000000EL, 0x70000000FL, 0x800000000L, 0x800000001L, 0x900000000L, 0x900000001L, 0x800000002L, 0x800000003L, 0x900000002L, 0x900000003L, 0xA00000000L, 0xA00000001L, 0xB00000000L, 0xB00000001L, 0xA00000002L, 0xA00000003L, 0xB00000002L, 0xB00000003L, 0x800000004L, 0x800000005L, 0x900000004L, 0x900000005L, 0x800000006L, 0x800000007L, 0x900000006L, 0x900000007L, 0xA00000004L, 0xA00000005L, 0xB00000004L, 0xB00000005L, 0xA00000006L, 0xA00000007L, 0xB00000006L, 0xB00000007L, 0xC00000000L, 0xC00000001L, 0xD00000000L, 0xD00000001L, 0xC00000002L, 0xC00000003L, 0xD00000002L, 0xD00000003L, 0xE00000000L, 0xE00000001L, 0xF00000000L, 0xF00000001L, 0xE00000002L, 0xE00000003L, 0xF00000002L, 0xF00000003L, 0xC00000004L, 0xC00000005L, 0xD00000004L, 0xD00000005L, 0xC00000006L, 0xC00000007L, 0xD00000006L, 0xD00000007L, 0xE00000004L, 0xE00000005L, 0xF00000004L, 0xF00000005L, 0xE00000006L, 0xE00000007L, 0xF00000006L, 0xF00000007L, 0x800000008L, 0x800000009L, 0x900000008L, 0x900000009L, 0x80000000AL, 0x80000000BL, 0x90000000AL, 0x90000000BL, 0xA00000008L, 0xA00000009L, 0xB00000008L, 0xB00000009L, 0xA0000000AL, 0xA0000000BL, 0xB0000000AL, 0xB0000000BL, 0x80000000CL, 0x80000000DL, 0x90000000CL, 0x90000000DL, 0x80000000EL, 0x80000000FL, 0x90000000EL, 0x90000000FL, 0xA0000000CL, 0xA0000000DL, 0xB0000000CL, 0xB0000000DL, 0xA0000000EL, 0xA0000000FL, 0xB0000000EL, 0xB0000000FL, 0xC00000008L, 0xC00000009L, 0xD00000008L, 0xD00000009L, 0xC0000000AL, 0xC0000000BL, 0xD0000000AL, 0xD0000000BL, 0xE00000008L, 0xE00000009L, 0xF00000008L, 0xF00000009L, 0xE0000000AL, 0xE0000000BL, 0xF0000000AL, 0xF0000000BL, 0xC0000000CL, 0xC0000000DL, 0xD0000000CL, 0xD0000000DL, 0xC0000000EL, 0xC0000000FL, 0xD0000000EL, 0xD0000000FL, 0xE0000000CL, 0xE0000000DL, 0xF0000000CL, 0xF0000000DL, 0xE0000000EL, 0xE0000000FL, 0xF0000000EL, 0xF0000000FL};
    public static final FillingCurve2D ZOC_VMSB_LOOKUP_BYTE = new FillingCurve2D(){

        @Override
        public long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public long ij2hash(int i, int j) {
            return this.i02hash(j) << 1 | this.i02hash(i);
        }

        @Override
        public long i02hash(int i) {
            assert (i == -1 || (i & 0xFFFFFF00) == 0);
            return LUPT_TO_HASH[i & 0xFF];
        }

        @Override
        public long hash2ij(long hash) {
            assert ((0xFFFFFFFFFFFF0000L & hash) == 0L);
            int h = (int)hash;
            return LUPT_TO_IJ_BYTE[h >> 8] << 4 | LUPT_TO_IJ_BYTE[h & 0xFF];
        }

        @Override
        public long hash2i0(long hash) {
            assert ((0xFFFFFFFFFFFFAAAAL & hash) == 0L);
            return this.hash2ij(hash);
        }

        @Override
        public int ij2i(long ij) {
            return (int)ij & 0xFF;
        }

        @Override
        public int ij2j(long ij) {
            return (int)ij >>> 8;
        }
    };
    public static final FillingCurve2D ZOC_VMSB_LOOKUP_SHORT = new FillingCurve2D(){

        @Override
        public long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public long ij2hash(int i, int j) {
            return this.i02hash(j) << 1 | this.i02hash(i);
        }

        @Override
        public long i02hash(int i) {
            assert (i == -1 || (i & 0xFFFF0000) == 0);
            return (long)LUPT_TO_HASH[i >>> 8 & 0xFF] << 16 | (long)LUPT_TO_HASH[i & 0xFF];
        }

        @Override
        public long hash2ij(long hash) {
            assert ((0xFFFFFFFF00000000L & hash) == 0L);
            return LUPT_TO_IJ_SHORT[(int)((hash & 0xFF000000L) >> 24)] << 12 | LUPT_TO_IJ_SHORT[(int)((hash & 0xFF0000L) >> 16)] << 8 | LUPT_TO_IJ_SHORT[(int)((hash & 0xFF00L) >> 8)] << 4 | LUPT_TO_IJ_SHORT[(int)(hash & 0xFFL)];
        }

        @Override
        public long hash2i0(long hash) {
            assert ((0xFFFFFFFFAAAAAAAAL & hash) == 0L);
            return this.hash2ij(hash);
        }

        @Override
        public int ij2i(long ij) {
            return (int)ij & 0xFFFF;
        }

        @Override
        public int ij2j(long ij) {
            return (int)ij >>> 16;
        }
    };
    public static final FillingCurve2D ZOC_VMSB_LOOKUP_INT = new FillingCurve2D(){

        @Override
        public long xy2hash(double x, double y) {
            return this.ij2hash((int)x, (int)y);
        }

        @Override
        public long ij2hash(int i, int j) {
            return this.i02hash(j) << 1 | this.i02hash(i);
        }

        @Override
        public long i02hash(int i) {
            return (long)LUPT_TO_HASH[i >>> 24] << 48 | (long)LUPT_TO_HASH[(i & 0xFF0000) >>> 16] << 32 | (long)LUPT_TO_HASH[(i & 0xFF00) >>> 8] << 16 | (long)LUPT_TO_HASH[i & 0xFF];
        }

        @Override
        public long hash2ij(long h) {
            return LUPT_TO_IJ_INT[(int)((h & 0xFF00000000000000L) >>> 56)] << 28 | LUPT_TO_IJ_INT[(int)((h & 0xFF000000000000L) >>> 48)] << 24 | LUPT_TO_IJ_INT[(int)((h & 0xFF0000000000L) >>> 40)] << 20 | LUPT_TO_IJ_INT[(int)((h & 0xFF00000000L) >>> 32)] << 16 | LUPT_TO_IJ_INT[(int)((h & 0xFF000000L) >>> 24)] << 12 | LUPT_TO_IJ_INT[(int)((h & 0xFF0000L) >>> 16)] << 8 | LUPT_TO_IJ_INT[(int)((h & 0xFF00L) >>> 8)] << 4 | LUPT_TO_IJ_INT[(int)(h & 0xFFL)];
        }

        @Override
        public long hash2i0(long hash) {
            assert ((0xFFFFFFFF33333333L & hash) == 0L);
            return this.hash2ij(hash);
        }

        @Override
        public final int ij2i(long ij) {
            return (int)ij;
        }

        @Override
        public final int ij2j(long ij) {
            return (int)(ij >>> 32);
        }
    };

    private ZOrderCurve2DImpls() {
    }
}

