#!/usr/bin/env python
# Eclipse SUMO, Simulation of Urban MObility; see https://eclipse.dev/sumo
# Copyright (C) 2009-2023 German Aerospace Center (DLR) and others.
# This program and the accompanying materials are made available under the
# terms of the Eclipse Public License 2.0 which is available at
# https://www.eclipse.org/legal/epl-2.0/
# This Source Code may also be made available under the following Secondary
# Licenses when the conditions for such availability set forth in the Eclipse
# Public License 2.0 are satisfied: GNU General Public License, version 2
# or later which is available at
# https://www.gnu.org/licenses/old-licenses/gpl-2.0-standalone.html
# SPDX-License-Identifier: EPL-2.0 OR GPL-2.0-or-later

# @file    test.py
# @author  Pablo Alvarez Lopez
# @date    2016-11-25

# import common functions for netedit tests
import os
import sys

testRoot = os.path.join(os.environ.get('SUMO_HOME', '.'), 'tests')
neteditTestRoot = os.path.join(
    os.environ.get('TEXTTEST_HOME', testRoot), 'netedit')
sys.path.append(neteditTestRoot)
import neteditTestFunctions as netedit  # noqa

# Open netedit
neteditProcess, referencePosition = netedit.setupAndStart(neteditTestRoot)

# recompute
netedit.rebuildNetwork()

# go to additional mode
netedit.additionalMode()

# select E2
netedit.changeElement("multiLaneAreaDetector")

# select lanes
netedit.leftClick(referencePosition, 426, 253)
netedit.leftClick(referencePosition, 496, 208)

# create E2 with default parameters
netedit.typeEnter()

# select lanes
netedit.leftClick(referencePosition, 426, 253)
netedit.leftClick(referencePosition, 496, 208)

# set other name
netedit.changeDefaultValue(netedit.attrs.E2Multilane.create.id, ";;;;")

# create E2 with default parameters
netedit.typeEnter()

# set other name
netedit.changeDefaultValue(netedit.attrs.E2Multilane.create.id, "e2_0")

# create E2 with default parameters
netedit.typeEnter()

# set other name
netedit.changeDefaultValue(netedit.attrs.E2Multilane.create.id, "customID")

# create E2 with default parameters
netedit.typeEnter()

# Check undo redo
netedit.undo(referencePosition, 2)
netedit.redo(referencePosition, 2)

# save netedit config
netedit.saveNeteditConfig(referencePosition)

# quit netedit
netedit.quit(neteditProcess)
