/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javax.vecmath.Point3f;
import javax.vecmath.Point3i;

public class TempArray {
    private static final int freePointsSize = 6;
    private final int[] lengthsFreePoints = new int[6];
    private final Point3f[][] freePoints = new Point3f[6][];
    private static final int freeScreensSize = 6;
    private final int[] lengthsFreeScreens = new int[6];
    private final Point3i[][] freeScreens = new Point3i[6][];
    private static final int freeBytesSize = 2;
    private final int[] lengthsFreeBytes = new int[2];
    private final byte[][] freeBytes = new byte[2][];

    public void clear() {
        this.clearTempPoints();
        this.clearTempScreens();
    }

    private static int findBestFit(int n, int[] nArray) {
        int n2 = -1;
        int n3 = Integer.MAX_VALUE;
        int n4 = nArray.length;
        while (--n4 >= 0) {
            int n5 = nArray[n4];
            if (n5 < n || n5 >= n3) continue;
            n3 = n5;
            n2 = n4;
        }
        if (n2 >= 0) {
            nArray[n2] = 0;
        }
        return n2;
    }

    private static int findShorter(int n, int[] nArray) {
        int n2 = nArray.length;
        while (--n2 >= 0) {
            if (nArray[n2] != 0) continue;
            nArray[n2] = n;
            return n2;
        }
        n2 = 0;
        int n3 = nArray[0];
        int n4 = nArray.length;
        while (--n4 > 0) {
            if (nArray[n4] >= n3) continue;
            n3 = nArray[n4];
            n2 = n4;
        }
        if (n3 < n) {
            nArray[n2] = n;
            return n2;
        }
        return -1;
    }

    private void clearTempPoints() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreePoints[i] = 0;
            this.freePoints[i] = null;
        }
    }

    public Point3f[] allocTempPoints(int n) {
        Point3f[] point3fArray;
        int n2 = TempArray.findBestFit(n, this.lengthsFreePoints);
        if (n2 > 0) {
            point3fArray = this.freePoints[n2];
        } else {
            point3fArray = new Point3f[n];
            int n3 = n;
            while (--n3 >= 0) {
                point3fArray[n3] = new Point3f();
            }
        }
        return point3fArray;
    }

    public void freeTempPoints(Point3f[] point3fArray) {
        int n;
        for (n = 0; n < this.freePoints.length; ++n) {
            if (this.freePoints[n] != point3fArray) continue;
            this.lengthsFreePoints[n] = point3fArray.length;
            return;
        }
        n = TempArray.findShorter(point3fArray.length, this.lengthsFreePoints);
        if (n >= 0) {
            this.freePoints[n] = point3fArray;
        }
    }

    private void clearTempScreens() {
        for (int i = 0; i < 6; ++i) {
            this.lengthsFreeScreens[i] = 0;
            this.freeScreens[i] = null;
        }
    }

    public Point3i[] allocTempScreens(int n) {
        Point3i[] point3iArray;
        int n2 = TempArray.findBestFit(n, this.lengthsFreeScreens);
        if (n2 > 0) {
            point3iArray = this.freeScreens[n2];
        } else {
            point3iArray = new Point3i[n];
            int n3 = n;
            while (--n3 >= 0) {
                point3iArray[n3] = new Point3i();
            }
        }
        return point3iArray;
    }

    public void freeTempScreens(Point3i[] point3iArray) {
        int n;
        for (n = 0; n < this.freeScreens.length; ++n) {
            if (this.freeScreens[n] != point3iArray) continue;
            this.lengthsFreeScreens[n] = point3iArray.length;
            return;
        }
        n = TempArray.findShorter(point3iArray.length, this.lengthsFreeScreens);
        if (n >= 0) {
            this.freeScreens[n] = point3iArray;
        }
    }

    public byte[] allocTempBytes(int n) {
        int n2 = TempArray.findBestFit(n, this.lengthsFreeBytes);
        byte[] byArray = n2 > 0 ? this.freeBytes[n2] : new byte[n];
        return byArray;
    }

    public void freeTempBytes(byte[] byArray) {
        int n;
        for (n = 0; n < this.freeBytes.length; ++n) {
            if (this.freeBytes[n] != byArray) continue;
            this.lengthsFreeBytes[n] = byArray.length;
            return;
        }
        n = TempArray.findShorter(byArray.length, this.lengthsFreeBytes);
        if (n >= 0) {
            this.freeBytes[n] = byArray;
        }
    }
}

